//͸
//  Program .....: Formatnu                              
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;
**
* Function...: Format_num()
* Syntax.....: x = Format_num(<par1>[,<par2>][,<par3>][,<par4>][,<par5>])
*
* <par1>
*
*      Number to format
*
* <par2>
*
*      Width to format within
*
* <par3>
*
*      Decimal places
*
* <par4>
*
*      T - Trim to Smallest
*      R - Allign to Right
*      L - Allign to Left
*
* <par5>
*      Character(s) to place beside number on left
*      NB Used only if par4 = 'r'
*
**

Function Format_num(f_num, f_len, f_dec, f_opt, f_chr)
local f_mlt,f_pic,ret_val

*- Param Check -*
if valtype(f_num) # 'N'                   // <par1>
  retu '0'

endif

if valtype(f_len) # 'N'                   // <par2>
  f_len := 16

endif

if valtype(f_dec) # 'N'                   // <par3>
  f_dec := 2

endif

if valtype(f_opt) = 'C'                   // <par4>
  if empty(f_opt)
    f_opt := 'T'

  endif

else
  f_opt := 'T'

endif

f_opt := upper(f_opt)

if valtype(f_chr) # 'C'                   // <par5>
  f_chr := ' '

endif


*- Picture Formulation -*
f_pic := Replicate('#',f_len)
f_pic := subs(f_pic,1,f_len-f_dec) + '.' + subs(f_pic,f_len-f_dec+1)
f_pic := subs(f_pic,2)
f_mlt := int( (f_len-f_dec-1) / 4 )
f_pic := Replicate('###,',f_mlt) + '###' + subs(f_pic,f_len-f_dec)
f_pic := if(subs(f_pic,len(f_pic),1) = '.',subs(f_pic,1,len(f_pic)-1), f_pic)
f_pic := subs(f_pic, -f_len)

*- Return Value -*
Do Case
  Case f_opt = 'T'
     ret_val := ltrim(Transform(f_num, f_pic))

  Case f_opt = 'R'
     ret_val := padl(f_chr+ltrim(Transform(f_num, f_pic)),f_len,' ')

  Case f_opt = 'L'
     ret_val := padr(ltrim(Transform(f_num, f_pic)),f_len,' ')

EndCase

ret_val := if(abs(f_num - val(strip(','+f_chr,ret_val))) > 1, replicate('*',f_len), ret_val)

Return( Ret_val )
