//͸
//  Program .....: G_Print                               
//  CopyRight ...: 1993 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

#include "inkey.ch"
#include "dbstruct.ch"

#define  BUFFER  256
#define  CRLF         chr(13)+chr(10)
#define  FF           Chr(12)
#define  PAGE_SIZE    55
#define  RECNO_SIZE   6

Function g_PrintStru()

    LOCAL screen                                                    , ;
          Destiny := subs('PRINTER'+space(BUFFER),1,BUFFER)         , ;
          sColor  := setcolor()                                     , ;
          GetList := {}                                             , ;
          sCursor := Set(_SET_CURSOR)                               , ;
          i, x, localError, bLastHandler, top


    if Empty(alias())
      Return( NIL )
    endif


    Top := int((maxrow()/2)-1)
    screen := savescreen( top,12,top+3,68 )

    SetColor( popup_color() )
    WinBox(top,12,top+2,66,0,4,.t.)
    NccMesg('[ Print Structure ]',top,'center,12,66')

    While .t.
      @top+1,15 say 'Print to' get Destiny ;
                            pict '@KS40'
      Set Cursor on
      Read
      Set( _SET_CURSOR, sCursor )

      IF ! ( lastkey() == K_ESC .or. Empty(Destiny) )

        Destiny    := uppe(ltrim(trim(Destiny)))

        IF Destiny # 'PRINTER'
          IF ! ('.' $ Destiny)
            Destiny += '.'

          END

          IF FILE(Destiny)
             NccMesg('File exists   Overwrite (Y/N)',top+2,'center,12,66',;
                   setcolor(),0,,'save_scrn')
             IF uppe(chr(lastkey())) # 'Y'
               Destiny := subs(Destiny+space(BUFFER),1,BUFFER)
               LOOP
             END
          END
        END
        scroll(top+1,13,top+1,65)
        NccMesg("Printing to <"+if(Destiny=='PRINTER',Destiny,'FILE')+">...",top+1,'center,12,66')

        bLastHandler := errorblock( { |objerr| BREAK(objerr) } )

        Begin Sequence
          SET CONSOLE OFF
          SET PRINT ON
          IF Destiny # 'PRINTER'
            SET PRINTER TO (Destiny)

          END

          qout("FILE STRUCTURE")
          qout("--------------")
          qout(WinFilename(Current_Window()))
          qout("")
          qout("Name        Type  Len  Dec")
          qout(replicate("-",26))

          for i = 1 to len(WinViewStru(Current_window()))
            x := WinViewStru(Current_window())[i]
            qout(padr(x[DBS_NAME],14,' '))
            qqout(padr(x[DBS_TYPE],4,' ') )
            qqout(padr(ltrim(str(x[DBS_LEN])),5,' '))
            qqout(ltrim(str(x[DBS_DEC])))
            if inkey() == K_ESC
              exit
            endif
          Next

          qout(replicate("-",26))
          eject

        Recover using LocalError
          SET PRINT OFF
          SET PRINTER TO
          SET CONSOLE ON

          scroll(top+1,13,top+1,65)
          NccMesg(' Output Access Error ',top+1,'center,12,66',setcolor(),0,'bell')

        End Sequence

        SET PRINT OFF
        SET PRINTER TO
        SET CONSOLE ON

      END
      exit
    enddo

    SetColor( sColor )
    Restscreen( top,12,top+3,68,screen )

Return( NIL )


Function g_PrintFile()

    LOCAL xhandle                                                , ;
          curr_Rec                                               , ;
          localerror                                             , ;
          for_block                                              , ;
          while_block                                            , ;
          bLastHandler                                           , ;
          tCount                                                 , ;
          dbfStructure                                           , ;
          lCount                                                 , ;
          dbf_list                                               , ;
          scrn       :=  savescreen(03,05,17,62)                 , ;
          curr_color := setcolor()                               , ;
          Destiny    := subs('PRINTER'+space(BUFFER),1,BUFFER)   , ;
          RecOn      := 'Y'                                      , ;
          for_cond   := space(BUFFER)                            , ;
          while_cond := space(BUFFER)                            , ;
          how_many   := 0                                        , ;
          sCursor    := SET( _SET_CURSOR )                       , ;
          GetList    := {}


    if Empty(alias())
      Return( NIL )
    endif
    setcolor(popup_color())
    WinBox(3,5,16,60,0,4,.t.)
    NccMesg('[ Print File ]',3,'center,5,60')

    WHILE .t.
      @05,06 say 'Print to' get Destiny ;
                            pict '@KS40'
      @06,06 say '     Printer or Enter File name'
      @08,06 say 'Show Record #' get RecOn ;
                                 pict '!' ;
                                 valid RecOn $ 'YN'

      @10,06 say 'FOR     ' get for_cond ;
                            pict '@S40'
      @11,06 say 'WHILE   ' get while_cond ;
                            pict '@S40'
      @12,06 say 'SCOPE   ' get how_many valid how_many >= 0
      @13,06 say '     0=All or Next # of records'

      Set Cursor on
      READ
      Set( _SET_CURSOR, sCursor )

      IF lastkey() # K_ESC

        DO CASE

           CASE .NOT. EMPTY(for_cond) .AND. TYPE(for_cond) <> "L"
              msg("FOR condition must be a Logical expression")

           CASE .NOT. EMPTY(while_cond) .AND. TYPE(while_cond) <> "L"
              msg("WHILE condition must be a Logical expression")

           OTHERWISE

              Destiny    := uppe(ltrim(trim(Destiny)))

              IF Destiny # 'PRINTER'
                IF ! ('.' $ Destiny)
                  Destiny += '.'

                END

                IF FILE(Destiny)
                   NccMesg('File exists   Overwrite (Y/N)',15,'center,5,60',;
                         setcolor(),0,,'save_scrn')
                   IF uppe(chr(lastkey())) # 'Y'
                     Destiny := subs(Destiny+space(BUFFER),1,BUFFER)
                     LOOP
                   END
                END
              END

              for_cond   := ltrim(trim(for_cond))
              while_cond := ltrim(trim(while_cond))
              curr_rec   := recno()

              IF EMPTY(for_cond)
                * literal true is the same as no FOR condition
                for_cond := ".T."

              ENDIF

              IF EMPTY(while_cond)
                * literal true is the same as no WHILE condition
                while_cond := ".T."

                IF how_many == 0
                  * unless a scope has been entered
                  GO TOP

                ENDIF

              ENDIF

              for_block   := &("{||" +  for_cond  + "}" )
              while_block := &("{||" + while_cond + '.and.inkey() # 27' + "}")

              dbfStructure := WinViewStru(Current_window())
              Dbf_List := DumpSetUp(dbfStructure)
              NccMesg("Printing to <"+if(Destiny=='PRINTER'.or. empty(Destiny), ;
                    Destiny,'FILE')+">...",15,'center,5,60')

              bLastHandler := errorblock( { |objerr| BREAK(objerr) } )

              Begin Sequence

                SET PRINT ON
                SET CONSOLE OFF
                IF Destiny # 'PRINTER'
                  SET PRINTER TO (Destiny)

                END

                HeadDump(dbfStructure, RecOn, .T. )    // Header + Line
                lCount := 1
                tCount := 1
                dbeval({ || ShowCount( tCount ), ;
                            tCount++, ;
                            DumpRecno( RecOn ) , ;
                            DumpRecord( Dbf_List ), ;
                            if(lCount >= PAGE_SIZE, HeadDump(dbfStructure   , ;
                                                             RecOn, .F.),''), ;    // Line only
                            if(lCount >= PAGE_SIZE, qqout(FF+CRLF),'')      , ;
                            if(lCount >= PAGE_SIZE, HeadDump(dbfStructure   , ;
                                                             RecOn, .T.),''), ;
                            if(lCount >= PAGE_SIZE,lCount := 1, lCount++ ) }, ;
                       for_block,   ;
                       while_block, ;
                       if(how_many#0,how_many,NIL), ;
                       , ;
                       (how_many#0) )
                HeadDump( dbfStructure, RecOn, .F. )    // Line only


                Recover using LocalError
                  SET PRINT OFF
                  SET CONSOLE ON
                  SET PRINTER TO

                  NccMesg(' Output Access Error ',16,'center,5,60',setcolor(),0,'bell')

              End Sequence

              SET PRINT OFF
              SET CONSOLE ON
              SET PRINTER TO

              errorblock(bLastHandler)

              Go curr_rec

              EXIT

        ENDCASE
      ELSE
        EXIT

      END
    END
    setcolor(curr_color)
    restscreen(03,05,17,62,scrn)

Return( NIL )


STATIC FUNCTION DumpSetUp( aArray )

    LOCAL tmp_Array
    LOCAL i, len, string, MaxLen

    tmp_Array := aArray
    len := len(aArray)

    FOR i = 1 to len
       MaxLen := max( len(aArray[i,DBS_NAME]), aArray[i,DBS_LEN] )
       Do Case
         Case aArray[i,DBS_TYPE] = 'C'
           string := aArray[i,DBS_NAME]
         Case aArray[i,DBS_TYPE] = 'N'
           string := "str(" + ;
                     aArray[i,DBS_NAME]+","+ltrim(str(aArray[i,DBS_LEN]))+","+;
                     ltrim(str(aArray[i,DBS_DEC]))+;
                     ")"

         Case aArray[i,DBS_TYPE] = 'D'
           string := "Dtoc("+;
                      aArray[i,DBS_NAME]+;
                      ")"

         Case aArray[i,DBS_TYPE] = 'M'
           string := '<  memo  >'

         Case aArray[i,DBS_TYPE] = 'L'
           string := "if("+;
                      aArray[i,DBS_NAME]+;
                      ", [.T.], [.F.] )"

       EndCase

       string := "padr(" + string + "," + ltrim(str(MaxLen)) + ",[ ])"

       string += if(i#Len, '+[ | ]', '')
       aadd(tmp_array[i],&( "{||" + string + "}" ) )

    NEXT

Return( tmp_array )



STATIC FUNCTION HeadDump( aArray, RecOn, HeadAndLine )

    LOCAL tmp_Array
    LOCAL i, len, MaxLen

    len := len(aArray)

    IF HeadAndLine
      qqout("File: "+WinFilename(Current_Window()))
      qout("")
      qout("")
      IF RecOn = 'Y'
        qqout( subs('Record' + Space(RECNO_SIZE),1,RECNO_SIZE) + "   " )

      END

      FOR i = 1 to len
         MaxLen := max( len(aArray[i,DBS_NAME]) , aArray[i,DBS_LEN] )

         qqout( padr(aArray[i,DBS_NAME],MaxLen,'-')+if(i#Len,'   ','') )

      NEXT

      qqout(CRLF)

    END

    IF RecOn = 'Y'
      qqout( subs('------' + Space(RECNO_SIZE),1,RECNO_SIZE) + " + " )

    END

    FOR i = 1 to len
      MaxLen := max( len(aArray[i,DBS_NAME]), aArray[i,DBS_LEN] )

      qqout(Replicate('-',MaxLen)+if(i#Len,' + ','') )

    NEXT

    qqout(CRLF)

Return( NIL )



STATIC FUNCTION DumpRecno( RecOn )

    IF RecOn = 'Y'
      qqout( str(recno(),RECNO_SIZE,0) + " | " )

    END

Return( NIL )


STATIC FUNCTION DumpRecord( aArray )

    LOCAL i,len

    aeval(aArray, { |x| qqout(eval(x[5])) } )
    qqout(CRLF)

Return( NIL )


STATIC FUNCTION ShowCount( nCounter )

    LOCAL nRow, nCol

    nRow := row()
    nCol := col()

    devpos( 15, 43 )
    dispout( nCounter )
    devpos( nRow, nCol )

Return( NIL )



STATIC FUNCTION msg(x)

    NccMesg(x,15,'center,5,60',setcolor(),0,,'save_scrn')

Return( NIL )
