//͸
//  Program .....: Nccview                               
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//                                                       
//  Purpose......: Tbrowse replacement. Object to        
//                 browse DBF's, Text files and arrays.  
//                                                       
//  Complie......: Clipper nccview2 /n/w/a/m             
//                                                       
//  Needs........: Class(y) library                      
//                                                       
//;


//Ŀ
//  Class NccViewit  
//


#include "class(y).ch"
#include "inkey.ch"
#include "Nccview.ch"


    create class  NccViewit                          //

      method     dvSkip                              //
      method     dvStatus                            //
      method     dvSkipblock                         //
      method     Settle                              //
      method     DisplayData                         //


    export:

      instvar    AtTop          noassign             //
      instvar    AtBottom       noassign             //

      instvar    TopRow                              //
      instvar    LeftColumn                          //
      instvar    BottomRow                           //
      instvar    RightColumn                         //
      instvar    UseStyle                            //
      instvar    Refresh                             //
      instvar    RelativeRow                         //
      instvar    LinePosition                        //
      instvar    CurrentRow                          //
      instvar    CurrentStatus                       //
      instvar    StandardColor                       //
      instvar    InverseColor                        //
      instvar    DataBlock                           //
      instvar    WhileBlock                          //
      instvar    StatusBlock                         //
      instvar    SkipBlock                           //
      instvar    GoTopBlock                          //
      instvar    GoBottomBlock                       //
      instvar    BufferedDisplay                     //
      instvar    UserSlot                            //

      method     Up                                  //
      method     Down                                //
      method     PageUp                              //
      method     PageDown                            //
      method     Home                                //
      method     End             =  dvEnd            //
      method     GoTop                               //
      method     GoBottom                            //
      method     Activate                            //
      method     Terminate                           //
      method     While                               //
      method     RefreshCurrent  =  Highlight        //
      method     RefreshAll      =  Refresh          //
      method     Stabilize                           //
      method     ForceStable                         //
      method     HighLight                           //
      method     DehighLight                         //
      method     ShowStatus                          //
      method     StandardKeys                        //

    endclass



    constructor new( nTop, nLeft, nBottom, nRight )

    local xtmp, d_start


    ::TopRow            :=   nTop
    ::LeftColumn        :=   nLeft
    ::BottomRow         :=   nBottom
    ::RightColumn       :=   nRight
    ::UseStyle          :=   .f.
    ::Refresh           :=   .t.
    ::RelativeRow       :=   0
    ::LinePosition      :=   1
    ::Currentrow        :=   nTop
    ::CurrentStatus     :=   DVIEW_IDLE
    ::AtTop             :=   .f.
    ::AtBottom          :=   .f.
    ::DataBlock         :=   NIL
    ::WhileBlock        :=   { || ! (bof() .or. eof())  }
    ::StatusBlock       :=   { |n| ::dvStatus(n)        }
    ::SkipBlock         :=   { |n| ::dvSkip(n)          }
    ::GoTopBlock        :=   { ||    DBGoTop()          }
    ::GoBottomBlock     :=   { ||    DBGoBottom()       }
    ::BufferedDisplay   :=   .f.
    ::UserSlot          :=   NIL
    ::StandardColor     :=   Setcolor()


    xtmp                :=   SetColor()
    d_start             :=   AT(',',xtmp) + 1

    ::InverseColor      :=   Subs(xtmp,d_start,AT(',',Subs(xtmp,d_start)))+;
                             Subs(xtmp,1,d_start-1)+;
                             Subs(xtmp,d_start+AT(',',Subs(xtmp,d_start)))

Return


    //Ŀ
    // After most Actions settle 
    //
    method Procedure Settle

    ::RelativeRow := ::CurrentRow - ::TopRow

    IF ::Refresh
      ::RefreshAll()

    END

    ::HighLight()
    ::CurrentStatus( DVIEW_IDLE )

Return


    //Ŀ
    // Up  
    //
    method Function Up( n )

    local cColor := Setcolor(), nCnt := 1


    n := if( n == NIL, 1, n )

    Setcolor( ::StandardColor )
    ::DisplayData()

    While nCnt <= n
      IF ::dvSkipBlock(-1) == -1
        IF ::CurrentRow == ::TopRow

          scroll( ::TopRow      ,;
                  ::LeftColumn  ,;
                  ::BottomRow   ,;
                  ::RightColumn ,;
                  -1             ;
                )

        ELSE
          ::CurrentRow--

        END
      END
      if ! ::While()
        exit
      endif
      nCnt++
    END

    ::Settle()

    if ::LinePosition >= 2
       ::LinePosition--
    else
       ::LinePosition := 1
    endif


    SetColor( cColor )

Return( (self) )


    //Ŀ
    // Down 
    //
    method Function Down( n )

    local cColor := Setcolor(), nCnt := 1

    n := if( n == NIL, 1, n )

    Setcolor( ::StandardColor )
    ::DisplayData()

    While nCnt <= n
      IF ::dvSkipBlock(1) == 1
        IF ::CurrentRow == ::BottomRow

         scroll( ::TopRow      ,;
                 ::LeftColumn  ,;
                 ::BottomRow   ,;
                 ::RightColumn ,;
                 1             ;
               )

        ELSE
          ::CurrentRow++

        END
      END
      nCnt++
      if ! ::While()
        Exit
      endif
    END

    ::Settle()

    if ::LinePosition < Lastrec()
       ::LinePosition++
    else
       ::LinePosition := Lastrec()
    endif

    SetColor( cColor )

Return( (self) )


    //Ŀ
    // PageUp 
    //
    method Function PageUp()

    local cColor := Setcolor()


    Setcolor( ::StandardColor )
    ::DisplayData()

    IF ::dvSkipBlock(-1) == -1
      IF ::dvSkipBlock( -( ::BottomRow - ::TopRow  ) ) # ;
       -( ::BottomRow - ::TopRow  )
        ::CurrentRow := ::TopRow

      END
      ::Refresh := .t.
      ::CurrentStatus := DVIEW_IDLE

    END

    ::Settle()

    if ::LinePosition >= 2
       ::LinePosition := ::LinePosition - (::BottomRow - ::TopRow)
       if ::LinePosition < 1
          ::LinePosition := 1
       endif
    else
       ::LinePosition := 1
    endif

    SetColor( cColor )

Return( (self) )


    //Ŀ
    // PageDown 
    //
    method Function PageDown()

    local cColor := Setcolor()


    Setcolor( ::StandardColor )
    ::DisplayData()

    IF ::dvSkipBlock(1) == 1
      ::dvSkipBlock( ::BottomRow - ::TopRow -1 )
      ::Refresh := .t.

    END

    ::Settle()

    if ::LinePosition < Lastrec()
       ::LinePosition := ::LinePosition + ::BottomRow - ::TopRow -1
       if ::LinePosition > Lastrec()
          ::LinePosition := Lastrec()
       endif
    else
       ::LinePosition := Lastrec()
    endif

    SetColor( cColor )

Return( (self) )


    //Ŀ
    // Home 
    //
    method Function Home()

    local cColor := Setcolor()


    Setcolor( ::StandardColor )
    ::DisplayData()

    IF  ::dvSkipBlock( - ::RelativeRow ) ==  - ::RelativeRow
      ::CurrentRow := ::TopRow

    END

    ::Settle()

    if ::LinePosition >= 2
       ::LinePosition := ::LinePosition - ::RelativeRow
       if ::LinePosition < 1
          ::LinePosition := 1
       endif
    else
       ::LinePosition := 1
    endif

    SetColor( cColor )

Return( (self) )


    //Ŀ
    // End 
    //
    method Function dvEnd()

    local d_flag := .t., d_start := 0,;
          d_stop := ::BottomRow - ::TopRow - ::RelativeRow, ;
          cColor := SetColor()


    Setcolor( ::StandardColor )
    ::DisplayData()

    WHILE d_start < d_Stop  .and. d_flag
      d_flag := ::dvSkipBlock(1) == 1
      IF d_flag
        d_start++

      END

    END

    ::CurrentRow += d_Start
    ::RelativeRow := ::CurrentRow - ::TopRow
    ::Highlight()
    ::CurrentStatus := DVIEW_IDLE

    if ::LinePosition < Lastrec()
       ::LinePosition := ::LinePosition + ::BottomRow - ::TopRow -1
       if ::LinePosition > Lastrec()
          ::LinePosition := Lastrec()
       endif
    else
       ::LinePosition := Lastrec()
    endif

    SetColor( cColor )

Return( (self) )


    //Ŀ
    // Go Top 
    //
    method Function GoTop()

    local d_flag := .t., ;
          cColor := SetColor()

    Setcolor( ::StandardColor )
    ::DisplayData()

    ::CurrentRow := ::TopRow
    IF ( ::Refresh := ( ::dvSkipBlock( -1) == -1 ) )
      ::dvSkipBlock(  1)

    END

    eval( ::GoTopBlock() )

    ::Settle()
    ::LinePosition := 1
    SetColor( cColor )

Return( (self) )


    //Ŀ
    // Go Bottom 
    //
    method Function GoBottom()

    local cColor := Setcolor()


    Setcolor( ::StandardColor )
    ::DisplayData()

    IF ( ::Refresh := ( ::dvSkipBlock( 1 ) == 1 ) )
      ::dvSkipBlock( -1)

    END

    eval( ::GoBottomBlock() )

    ::Settle()
    ::LinePosition := Lastrec()
    SetColor( cColor )

Return( (self) )


    //Ŀ
    // Default Status 
    //
    method Function dvStatus( nStatus )

    local cColor := SetColor(), nRow := row(), nCol := col()


    IF nStatus == NIL
      nStatus := ::CurrentStatus

    END

    setpos( ::TopRow-3, ::RightColumn-6 )

    setcolor( ::InverseColor )

    DO CASE
      CASE nStatus == DVIEW_IDLE
        setcolor( ::StandardColor )
        qqout( "       " )

      CASE nStatus == DVIEW_REFRESHING
        qqout( " WAIT! " )

      CASE nStatus == DVIEW_AT_TOP
        qqout( " <TOP> " )

      CASE nStatus == DVIEW_AT_END
        qqout( " <END> " )

      CASE nStatus == DVIEW_EMPTY
        qqout( " Empty " )

      CASE nStatus == DVIEW_SKIPPING_TO_TOP
        qqout( "WAIT " )

      CASE nStatus == DVIEW_SKIPPING_TO_END
        qqout( "WAIT " )

    END

    SetColor( cColor )
    setpos( nRow, nCol )

Return( (self) )


    //Ŀ
    // Default Database SKIP 
    //
    method Function dvSkip( nSkipRequest )

    local nSkipped := 0, nDir := if(nSkipRequest<0,-1,1)


    while nSkipped # nSkipRequest .and. eval( ::WhileBlock() )

      DBSkip( nDir )

      if bof()
        DBGoto( recno() )
        exit
      endif

      if eof()
        DBSkip( -1 )
        exit
      endif


      if ! eval( ::WhileBlock() )
        DBSkip( -nDir )
        exit
      endif

      nSkipped += nDir

    enddo


Return( nSkipped )


    //Ŀ
    // Refresh Screen
    //
    method Function Refresh( nOffset, lExitAvail )

    local nCurrentRow, xReference, cColor := SetColor()

    lExitAvail := if( lExitAvail == NIL .or. valtype(lExitAvail) # 'L' , ;
                      .t., ;
                      lExitAvail ;
                    )

    SetColor( ::StandardColor )

    IF nOffset = NIL
      nOffset := 0
      IF ::RelativeRow > ::BottomRow - ::TopRow .or. ::RelativeRow < 0
        ::RelativeRow := ::BottomRow - ::TopRow

      END
    ELSE

      ::RelativeRow := min( ::BottomRow - ::TopRow, ;
                             int( if( nOffset<0, ;
                                      0-nOffset, ;
                                      nOffset ;
                                    );
                                ) ;
                           )

    END

    ::ShowStatus( DVIEW_REFRESHING )
    xReference := ::dvSkipBlock( - ::RelativeRow )

    IF ! xReference == - ::RelativeRow
       ::CurrentStatus := DVIEW_IDLE
       ::RelativeRow := - xReference

    END

    IF ::BufferedDisplay
      dispbegin()

    END

    IF ! ::USEstyle
      Scroll( ::TopRow      ,;
              ::LeftColumn  ,;
              ::BottomRow   ,;
              ::RightColumn ,;
              0              ;
            )
    END

    ::CurrentRow := ::TopRow

    WHILE .t.

      ::DisplayData()
      ::CurrentRow++

      if ::CurrentRow > ::BottomRow .or. ( NextKey() # 0 .and. lExitAvail )
        ::CurrentRow--
        exit
      endif

      if ! ::dvSkipBlock( 1 ) == 1
        ::CurrentRow--
        exit

      endif

      if ! ::While()
        ::CurrentRow--
        exit

      endif

    END


    IF ::USEstyle

      IF ::CurrentRow < ::BottomRow .and. ( nextkey() == 0 .and. lExitAvail )
        nCurrentRow := ::CurrentRow

        ::CurrentRow++
        WHILE ::CurrentRow <= ::BottomRow .and. ;
            ( nextkey() == 0 .and. lExitAvail )
          ::DisplayData( .f. )                // Tell DataBlock to perform
          ::CurrentRow++                      // Empty behaviour

        END

        ::CurrentRow := nCurrentRow

      END

    END

    IF ::BufferedDisplay
      dispend()

    END

    ::dvSkipBlock( -(::CurrentRow - ::TopRow - ::RelativeRow) )
    ::CurrentRow := ::TopRow + ::RelativeRow
    if ::CurrentRow < ::TopRow
      ::CurrentRow := ::TopRow
    endif
    ::CurrentStatus := if(nextkey() == 0 .and. lExitAvail, ;
                            DVIEW_IDLE, ;
                            DVIEW_REFRESHING ;
                         )
    ::Highlight()
    ::Refresh := ! ( nextkey() == 0 .and. lExitAvail )
    SetColor( cColor )
    if ! lExitAvail
      keyboard ''
    endif

Return( (self) )


    //Ŀ
    // Highlight Current Item  
    //
    method Function Highlight( lExitAvail )

    local cColor := Setcolor()

    lExitAvail := if(lExitAvail == NIL .or. valtype(lExitAvail) # 'L', ;
                     .t., ;
                     lExitAvail ;
                    )

    IF ( nextkey() == 0 .and. lExitAvail )
      setcolor( ::InverseColor )
      ::DisplayData()
      setcolor( ::StandardColor )
      ::ShowStatus()

    END

    SetColor( cColor )
    if ! lExitAvail
      keyboard ''
    endif

Return( (self) )


    //Ŀ
    // DeHighlight Current Item  
    //
    method Function DeHighlight()

    local cColor := Setcolor()


    setcolor( ::StandardColor )
    ::DisplayData()
    setcolor( cColor )
    ::ShowStatus()

    SetColor( cColor )

Return( (self) )


    //Ŀ
    // Display Current Item  
    //
    method Function DisplayData( lDisplay )

    local nRow := row(), nCol := col()


    lDisplay := if( lDisplay == NIL, .t., lDisplay )
    setpos( ::CurrentRow, ::LeftColumn )


    IF ! ::While()

      IF ::USEstyle
        qqout( eval(::Datablock(), lDisplay ) )

      ELSE
        qqout( space( ::RightColumn - ::Leftcolumn + 1 ) )

      ENDIF

    ELSE
      qqout( eval( ::Datablock(), lDisplay ) )

    END

    setpos( nRow, nCol )

Return( (self) )


    //Ŀ
    // Process Skip Block  
    //
    method Function dvSkipBlock(x)

    local ret_val


    x := if( x == NIL, 0, x )

    ret_val := eval( ::SkipBlock(),x  )
    if ret_val # x
      if x > 0
        ::AtBottom := .t.
        ::CurrentStatus := DVIEW_AT_END

      elseif x < 0
        ::AtTop := .t.
        ::CurrentStatus := DVIEW_AT_TOP

        if ::RelativeRow # 0
          ::Refresh := .t.

        endif

      else
        ::RefreshCurrent()

      endif

    else
      ::AtTop := .f.
      ::AtBottom := .f.
      ::CurrentStatus := DVIEW_IDLE

    endif

Return( ret_val )


    //Ŀ
    // Evaluate Status Block 
    //
    method Function ShowStatus(n)

Return( eval( ::StatusBlock(), n ) )


    //Ŀ
    // Test While condition 
    //
    method Func While()

Return( eval( ::WhileBlock() ) )


    //Ŀ
    // Activate View  
    //
    method Function Activate( x )

Return( ::RefreshAll( x ) )


    //Ŀ
    // Terminate View  
    //
    method Function Terminate()

Return( NIL )


    //Ŀ
    // Stabilize View if Necessary  
    //
    method Function Stabilize(n)

Return( IF( ::Refresh, ::RefreshAll(n), NIL ) )


    //Ŀ
    // Force Stable 
    //
    method Function ForceStable(n)

    if ::Refresh
      ::RefreshAll(n, .t.)
    endif
    ::Highlight()
    keyboard ''

Return( (self) )


    //Ŀ
    // Process Standard keys 
    //
    method Function StandardKeys( nkey )

    local lProcessed := .t.

    nKey := if( valtype(nKey) # 'N', 0, nKey )

    DO CASE
      Case nKey == K_ESC;            ::Terminate()
      Case nKey == K_UP;             ::Up()
      Case nKey == K_SH_TAB;         ::Up()
      Case nKey == K_DOWN;           ::Down()
      Case nKey == K_TAB;            ::Down()
      Case nKey == K_HOME;           ::Home()
      Case nKey == K_END;            ::End()
      Case nKey == K_PGUP;           ::PageUp()
      Case nKey == K_PGDN;           ::PageDown()
      Case nKey == K_CTRL_PGUP;      ::GoTop()
      Case nKey == K_CTRL_PGDN;      ::GoBottom()
      Otherwise;                     lProcessed := .f.
    END


Return( lProcessed )
