//͸
//  Program .....: Nccmenu                               
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//                                                       
//  Complie......: Clipper nccmenu /n/w/a/m              
//                                                       
//  Needs........: NccBar.prg, NccPrompt.prg,            
//                 NccView.prg and Class(y)              
//                                                       
//  Purpose......: To create a menu object. See          
//                 G_Menu.prg, G_Menu.ch for exsample    
//                                                       
//;

//Ŀ
//  Class NccMenu 
//

#include "class(y).ch"
#include "set.ch"
#include "inkey.ch"
#include "nccview.ch"

#define D_ALT     5001

    create class NccMenu from NccViewit

      instvar      screen
      instvar      st
      instvar      sb


    export:

      instvar      active                noassign
      instvar      winHandle             noassign
      instvar      winDelay
      instvar      winExplode
      instvar      shadow
      instvar      MouseActive
      instvar      cur
      instvar      MenuReader
      instvar      Exception
      instvar      ExceptBlock
      instvar      prompts
      instvar      border
      instvar      bordercolor
      instvar      lettercolor
      instvar      grayedcolor
      instvar      MessageColor

      method       AddPrompt
      method       AddPromptLine
      method       PromptId
      method       PromptActive
      method       PromptCheck
      method       PromptMessage
      method       PromptSubMenu

      method       Activate
      method       Show
      method       Hide
      method       Terminate

      method       Up
      method       Down
      method       Highlight
      method       DeHighlight

      method       MenuChoice
      method       MenuSelection

      method       KeySeek
      method       MenuStatus
      method       MenuSkipper
      method       MenuLine
      method       FindId

      method       PageDown           =  stub
      method       PageUp             =  stub
      method       Home               =  stub
      method       End                =  stub

    endclass


    constructor new( nTop, nLeft, nBottom, nRight ), ;
                   ( nTop, nLeft, nBottom, nRight )

    local x


    ::active        := .f.
    ::MouseActive   := .f.
    ::exception     := .f.
    ::cur           := NIL
    ::winDelay      := .02
    ::winExplode    := .f.
    ::usestyle      := .t.
    ::Shadow        := .f.
    ::border        := "Ŀ "

    x               := StrToArray( SetColor() )
    ::bordercolor   := SetColor()
    ::lettercolor   := subs(x[2],1,at('/',x[2])-1)+'/'+subs(x[1],at('/',x[1])+1)
    ::lettercolor   := if( ::lettercolor == 'N/N', 'W+/N', ::lettercolor )
    ::grayedcolor   := 'N+'+ subs(x[1],at('/',x[1]))
    ::messagecolor  := x[5]

    ::DataBlock     := { |n| ::MenuLine(n) }
    ::WhileBlock    := { || .t. }
    ::GoTopBlock    := { || "" }
    ::GoBottomBlock := { || "" }
    ::StatusBlock   := { |n| ::MenuStatus(n) }
    ::SkipBlock     := { |n| ::MenuSkipper( n ) }
    ::MenuReader    := { |o| StandardReader(o) }
    ::ExceptBlock   := { || .f. }
    ::Prompts       := {}

Return


    //Ŀ
    //  Add Prompts 
    //
    method Function AddPrompt(                      ;
                               nId                , ;
                               cTitle             , ;
                               lActive            , ;
                               lChecked           , ;
                               cMessage           , ;
                               oSubMenu             ;
                             )

    aadd( ;
           ::prompts                        , ;
          NccPrompt():New(                    ;
                           nId              , ;
                           cTitle           , ;
                           lActive          , ;
                           lChecked         , ;
                           cMessage         , ;
                           oSubMenu           ;
                         )                    ;
        )


Return( (self) )


    //Ŀ
    //  Add Prompt Line 
    //
    method Function AddPromptLine()

    ::AddPrompt( 0, chr(196), .f. )

Return( (self) )


    //Ŀ
    //  Prompt Id 
    //
    method Function PromptId( nOldId, nNewId )

    local nCur


    if nOldId == NIL
      if ::cur == NIL
        nCur := len( ::prompts )
      else
        nCur := ::cur
      endif
    else
      nCur := ::FindId( nOldId )
    endif

    if nCur # 0 .and. nNewId # NIL
      ::prompts[nCur]:Id := nNewId
    endif

Return( if( nCur == 0, 0, ::prompts[nCur]:Id ) )


    //Ŀ
    //  Prompt Active 
    //
    method Function PromptActive( nId, lActive )

    local nCur


    if nId == NIL
      if ::cur == NIL
        nCur := len( ::prompts )
      else
        nCur := ::cur
      endif
    else
      nCur := ::FindId( nId )
    endif

    if nCur # 0 .and. lActive # NIL
      ::prompts[nCur]:Active := lActive
    endif

Return( if( nCur == 0, .f., ::prompts[nCur]:Active ) )


    //Ŀ
    //  Prompt Check 
    //
    method Function PromptCheck( nId, lCheck )

    local nCur


    if nId == NIL
      if ::cur == NIL
        nCur := len( ::prompts )
      else
        nCur := ::cur
      endif
    else
      nCur := ::FindId( nId )
    endif

    if nCur # 0 .and. lCheck # NIL
      ::prompts[nCur]:Checked := lCheck
    endif

Return( if( nCur == 0, .f., ::prompts[nCur]:Checked ) )


    //Ŀ
    // Prompt Message 
    //
    method Function PromptMessage( nId, cMessage )

    local nCur


    if nId == NIL
      if ::cur == NIL
        nCur := len( ::prompts )
      else
        nCur := ::cur
      endif
    else
      nCur := ::FindId( nId )
    endif

    if nCur # 0 .and. cMessage # NIL
      ::prompts[nCur]:Message := cMessage
    endif

Return( if( nCur == 0, "", ::prompts[nCur]:Message ) )


    //Ŀ
    //  Prompt Sub Menu 
    //
    method Function PromptSubMenu( nId, o )

    local nCur


    if nId == NIL
      if ::cur == NIL
        nCur := len( ::prompts )
      else
        nCur := ::cur
      endif
    else
      nCur := ::FindId( nId )
    endif

    if nCur # 0 .and. o # NIL
      ::prompts[nCur]:SubMenu := o
    endif

Return( if( nCur == 0, NIL, ::prompts[nCur]:SubMenu ) )


    //Ŀ
    // Locate Id and return Choice 
    //
    method Function FindId( nId, lSet )

    local nRet := 0, ;
          i, x, o


    lSet := if( lSet == NIL, .f., lSet )

    for i = 1 to len( ::prompts )

      o := ::prompts[i]:submenu

      if ::prompts[i]:Id == nId
        if lSet
          ::cur := i
        endif
        nRet := i
        exit
      elseif o # NIL
        if  ( x := o:FindId( nId, lSet ) ) # 0
          if lSet
            o:Cur := x
            ::cur := i
          endif
          nRet := i
          exit
        endif
      endif
    next

Return( nRet )


    //Ŀ
    //  Activate 
    //
    method Function Activate( nId, flag )

    local aItem                                    , ;
          cColor    := SetColor()                  , ;
          nMaxRight := if( ::Shadow, 3, 1 )


    flag := if(flag==nil, .t., flag )
    if nId # NIL
      ::cur := ::FindId( nId )
    elseif ::cur == NIL
      ::cur := ascan( ::prompts, { |x| x:Active == .t. } )
    endif
    if ::cur < 1
      ::cur := 1
    elseif ::cur > len( ::Prompts )
      ::cur := len( ::prompts )
    endif

    ::active      := .t.
    ::TopRow      := if( ::TopRow == NIL, 1, ::TopRow )
    ::currentrow  := ::topRow
    ::LeftColumn  := if( ::LeftColumn == NIL, 1, ::LeftColumn )
    ::RightColumn := if( ::RightColumn == NIL, 0, ::RightColumn )
    ::BottomRow   := if( ::BottomRow == NIL, ::TopRow + len(::prompts) -1, ::BottomRow )
    if ::BottomRow > maxrow() - if(::Shadow,2,1)
      ::BottomRow := maxrow() - if(::Shadow,2,1)
    endif
    ::relativerow := if( ::cur < 1, 0, min( ::bottomrow - ::toprow, ::cur -1) )
    aItem         := acomp( ::prompts, { |x,y| len( x:text ) > len( y:text ) } )
    ::RightColumn := max( ::RightColumn, ::LeftColumn + len(aItem:text) + 1 )
    if ::RightColumn >  Maxcol() - nMaxRight
      ::LeftColumn := ::LeftColumn - ( ::RightColumn - MaxCol() ) - nMaxRight
      ::RightColumn := MaxCol() - nMaxRight
    endif

    aItem         := savescreen(                                    ;
                                 ::toprow-1                       , ;
                                 ::leftcolumn-1                   , ;
                                 ::bottomrow+if(::Shadow,2,1)     , ;
                                 ::Rightcolumn+nMaxRight            ;
                               )

    ::screen := if( ::screen == NIL, aItem, ::screen )
    SetColor( ::borderColor )

      ::winHandle := WinBox(                     ;
                             ::TopRow-1        , ;
                             ::LeftColumn-1    , ;
                             ::BottomRow+1     , ;
                             ::RightColumn+1   , ;
                             ::winDelay        , ;
                             ::border          , ;
                             ::Shadow          , ;
                             ::winExplode        ;
                           )

    ::st := savescreen( ::toprow, ::rightcolumn+1, ::toprow, ::rightcolumn+1 )
    ::sb := savescreen( ::bottomrow, ::rightcolumn+1, ::bottomrow, ::rightcolumn+1 )

    SetColor( ::StandardColor )
    ::super:Activate()

    if ! ::promptActive()
      ::down()
    endif

    SetColor( cColor )

    if flag
      eval( ::MenuReader, (self) )
    endif

Return( ::MenuSelection() )


    //Ŀ
    //  Show Menu 
    //
    method Function Show( nId )

    local aItem                                 , ;
          cColor    := SetColor()               , ;
          nMaxRight := if( ::Shadow, 3, 1 )


    if ! ::Active
      ::activate(nId,.f.)
    else
      aItem         := savescreen(                                    ;
                                   ::toprow-1                       , ;
                                   ::leftcolumn-1                   , ;
                                   ::bottomrow+if(::Shadow,2,1)     , ;
                                   ::Rightcolumn+nMaxRight            ;
                                 )

      ::screen := if( ::screen == NIL, aItem, ::screen )
      SetColor( ::borderColor )
        ::winHandle := WinBox(                     ;
                               ::TopRow-1        , ;
                               ::LeftColumn-1    , ;
                               ::BottomRow+1     , ;
                               ::RightColumn+1   , ;
                               ::winDelay        , ;
                               ::border          , ;
                               ::Shadow          , ;
                               ::winExplode        ;
                             )

      ::st := savescreen( ::toprow, ::rightcolumn+1, ::toprow, ::rightcolumn+1 )
      ::sb := savescreen( ::bottomrow, ::rightcolumn+1, ::bottomrow, ::rightcolumn+1 )

      SetColor( ::StandardColor )
      if nId # NIL
        ::cur := ::FindId( nId )
      elseif ::cur == NIL
        ::cur := ascan( ::prompts, { |x| x:Active == .t. } )
      endif
      if ::cur < 1
        ::cur := 1
      elseif ::cur > len( ::Prompts )
        ::cur := len( ::prompts )
      endif
      ::relativerow := if( ::cur < 1, 0, min( ::bottomrow - ::toprow, ::cur -1) )
      ::currentrow  := ::toprow
      ::RefreshAll()
      if ! ::promptActive()
        ::down()
      endif
      ::Highlight(.t.)

    endif

    SetColor( cColor )

Return( ::MenuSelection() )


    //Ŀ
    //  Hide Menu 
    //
    method Function Hide()

    local nMaxRight := if( ::Shadow, 3, 1 )   , ;
           sColor := setColor()


    if Set(_SET_MESSAGE) # 0
      Setcolor( ::messagecolor )
      scroll( Set(_SET_MESSAGE),00, Set(_SET_MESSAGE), maxcol(), 0 )
      SetColor( sColor )
    endif

    if ::PromptSubMenu() # NIL
      ::PromptSubMenu():Hide()
    endif

    if ::screen # NIL
      if ! ::winExplode
        restscreen(                                     ;
                    ::topRow-1                        , ;
                    ::leftColumn-1                    , ;
                    ::bottomRow+if(::Shadow,2,1)      , ;
                    ::RightColumn+nMaxRight           , ;
                    ::screen                            ;
                  )
      else
        implode( ::winHandle )
      endif
      ::screen := NIL
    endif

Return( (self) )


    //Ŀ
    // Terminate 
    //
    method Function Terminate()

    ::prompt := NIL
    ::active := .f.
    ::super:terminate()

Return( NIL )


    //Ŀ
    //  Up 
    //
    method Function Up()

    local  nCur := ::cur                    , ;
           lStop   := .f.



    nCur--
    While .t.

      While nCur # 0 .and.                                ;
            ( ::prompts[nCur]:text == chr(196) .or.       ;
              ! ::prompts[nCur]:active                    ;
            )
         nCur--
      Enddo

      if nCur == 0
        if lStop
          Return( NIL )
        endif
        lStop := .t.
        if Set( _SET_WRAP )
          nCur := len( ::prompts )
        endif
      else
        exit
      endif
    enddo

    ::dehighlight()

    if ::cur < nCur
      lStop := ::bottomrow - ::toprow + 1
      if len( ::prompts ) > lStop
        ::refresh := .t.
        ::relativerow := lStop -1
      else
        ::relativerow := nCur-1
      endif

    else
      ::relativerow -= ( ::cur - nCur)
      if ::relativerow < 0
        ::relativerow := 0
        ::refresh := .t.
      endif
    endif

    ::cur         := nCur
    ::currentrow  := ::Toprow + ::relativerow
    if ::refresh
      ::refreshall()
    else
      ::highlight()
    endif

Return( (self) )


    //Ŀ
    // Down 
    //
    method Function Down()

    local  nCur := ::cur                    , ;
           lStop   := .f.



    nCur++
    While .t.

      While nCur <= len( ::prompts ) .and.             ;
            ( ::prompts[nCur]:text == chr(196) .or.    ;
              ! ::prompts[nCur]:active                 ;
            )
         nCur++
      Enddo

      if nCur > len( ::prompts )
        if lStop
          Return( NIL )
        endif
        lStop := .t.
        if Set( _SET_WRAP )
          nCur := 1
        endif
      else
        exit
      endif
    enddo

    ::dehighlight()

    if ::cur > nCur
      ::relativerow := nCur -1
      if len( ::prompts ) > ::bottomrow - ::toprow + 1
        ::Refresh := .t.
      endif
    else
      ::relativerow += ( nCur - ::cur )
      if ::relativerow > ::bottomrow - ::toprow
        ::relativerow := ::bottomrow - ::toprow
        ::refresh := .t.
      endif
    endif

    ::cur         := nCur
    ::currentrow  := ::Toprow + ::relativerow
    if ::refresh
      ::refreshall()
    else
      ::highlight()
    endif

Return( (self) )


    //Ŀ
    //  Menu Choice 
    //
    method Function MenuChoice( nCur, lNoDisplay )

    if nCur # NIL
      ::cur := nCur
      if lNoDisplay == NIL .or. lNoDisplay == .t.
        if nCur > 0 .and. nCur <= len( ::prompts )
          ::RefreshAll( min( ::BottomRow - ::TopRow, nCur - 1 ) )
        endif
      endif
    endif

Return( ::cur )


    //Ŀ
    //  Menu Selection 
    //
    method Function MenuSelection()

    local x, y


    if ( y := ::PromptSubMenu() ) # NIL
      x := y:MenuSelection()
    else
      x := ::PromptId()
    endif

Return( x )


    //Ŀ
    //  Menu Line 
    //
    method Function MenuLine( lDisplay )

    local nRow     := Row()                                            , ;
          nCol     := Col()                                            , ;
          pr       := ::prompts[::cur]                                 , ;
          current  := ::currentrow                                     , ;
          left     := ::leftcolumn                                     , ;
          right    := ::rightcolumn                                    , ;
          cColor                                                       , ;
          standard                                                     , ;
          inverse                                                      , ;
          x


    cColor   := SetColor( ::standardcolor )    //  save then set
    standard := SetColor( ::InverseColor )     //   ''   ''   ''
    SetColor( cColor )                         //   reset

    scroll( current, left, current, right, 0 )

    if ! lDisplay
      setpos( nRow, nCol )
      Return( "" )
    endif

    if pr:text == chr(196)
      SetColor( ::bordercolor )
      @ current, left say Replicate(chr(196), right - left + 1 )
      SetColor( cColor )
      setpos( nRow,nCol )
      Return( "" )
    endif

    if ! pr:active
      SetColor( ::grayedcolor )
    endif

    @ current, left say space(1) + pr:text
    scroll( current, col(), nRow, right, 0 )

    if ! pr:active
      SetColor( cColor )
      setpos( nRow,nCol )
      Return( "" )
    endif

    SetColor( if( cColor == standard, ::lettercolor, cColor ) )
    @ current, left + pr:keypos say pr:hotkey
    SetColor( cColor )

    if pr:checked
      @ current, left say chr(251)
    endif

    if pr:submenu # NIL
      @ current, right say Chr(16)
    endif

    setpos( nRow,nCol )

Return( "" )


    //Ŀ
    //  Menu Skipper 
    //
    method Function MenuSkipper( n )

    local nActual := 0, nDirection := if(n<0,-1,1)

    if n == 0
      Return( 0 )
    endif

    while nActual # n
      if n > 0
        if ::cur # len( ::prompts )
          ::cur++
        else
          exit
        endif
      else
        if ::cur # 1
          ::cur--
        else
          exit
        endif
      endif
      nActual += nDirection
    enddo

Return( nActual )


    //Ŀ
    //  Menu Status 
    //
    method Function MenuStatus(n)

    local sColor := setcolor(), nRow := row(), nCol := col()


    if n == NIL
      n := ::CurrentStatus
    endif

    if n # DVIEW_BUSY

      setcolor( ::standardColor )

      if ::cur - ( ::relativerow+1 ) # 0
        @ ::toprow, ::RightColumn + 1 say ""
      else
        restscreen( ::toprow, ::rightColumn+1, ::toprow, ::rightcolumn+1, ::st )
      endif

      if ::cur - ::relativerow + (::BottomRow - ::Toprow) < len( ::prompts )
        @ ::bottomrow, ::rightcolumn + 1 say ""
      else
        restscreen( ::bottomrow, ::rightcolumn+1, ::bottomrow, ::rightcolumn+1,::sb )
      endif

      setcolor( sColor )

    endif
    setpos( nRow,nCol )

Return( NIL )


    //Ŀ
    //  Key Seeker 
    //
    method Function KeySeek(nKey)

    local cSeekKey                           , ;
          ret_Val  := 0                      , ;
          i        := 1                      , ;
          pr       := ::prompts


    for i = 1 to len( pr )

      if ! ( pr[i]:text == "" )
        cSeekKey := pr[i]:hotKey

        if uppe(chr(nKey)) == uppe(cSeekKey) .and. pr[i]:active
          exit
        endif

      endif

    Next

    if i <= len( ::prompts )
      ret_val := i
    endif


Return( ret_val )


    //Ŀ
    //  Highlight 
    //
    method function Highlight( lVal )

    local sColor := SetColor(), nRow := row(), nCol := col()


    ::super:HighLight( lVal )

    if Set(_SET_MESSAGE) # 0
      Setcolor( ::messagecolor )
      scroll( Set(_SET_MESSAGE),00, Set(_SET_MESSAGE), maxcol(), 0 )
      if ::cur > 0 .and. ::cur <= len( ::prompts )
        if Set(_SET_MCENTER)
           @ Set(_SET_MESSAGE),0 ;
             SAY Padc(::prompts[::cur]:message, 80, ' ' )
        else
           @ Set(_SET_MESSAGE),0 SAY ::prompts[::cur]:message
        endif
      endif
      SetColor( sColor )
     endif
     setpos( nRow,nCol )

Return( (self) )


    //Ŀ
    //  Dehighlight 
    //
    method Function dehighlight( lVal )


    local sColor := SetColor(), nRow := row(), nCol := col()


    ::super:dehighlight( lVal )

    if Set(_SET_MESSAGE) # 0
      Setcolor( ::messagecolor )
      scroll( Set(_SET_MESSAGE),00, Set(_SET_MESSAGE), maxcol(), 0 )
      SetColor( sColor )
    endif
    setpos( nRow,nCol )

Return( (self) )


    //Ŀ
    //  Stub Unwanted Methods 
    //
    method procedure stub

Return


// ----------------------------------------------------------------------------

#define LEFT_BUTTON  1
#define RIGHT_BUTTON 2
#define BOTH_BUTTONS 3

static Function StandardReader(o)

    local nKey                                   , ;
          s                                      , ;
          m          := MouseSys()               , ;
          lProcessed := .f.                      , ;
          mAccept    := .f.


    m:Activate( o:MouseActive )

    While .t.
      lProcessed := .t.

      o:stabilize()

      if m:ButtonHold( LEFT_BUTTON )
        m:Show()
        m:Update()
        mAccept := .f.

      elseif m:ButtonHold( RIGHT_BUTTON )
        m:show()
        m:update()
        loop

      else
        m:Hide()
        if nextkey() == 0
          o:Highlight()
        endif
        m:MouseRead()
        mAccept := .t.
      endif

      Do Case
        Case m:Ascii == K_UP .or. m:Ascii == K_SH_TAB
          m:Hide()
          o:Up()

        Case m:Ascii == K_DOWN .or. m:Ascii == K_TAB
          m:Hide()
          o:Down()

        Case m:Ascii == K_ESC .or. m:Button == RIGHT_BUTTON .or. ;
             m:Ascii == D_ALT
          o:cur := 0
          exit

        Case m:Ascii == K_ENTER .and. o:PromptId() # 0 .and. o:PromptActive()
          if ( s := o:PromptSubMenu() ) # NIL
            s:MouseActive   := o:MouseActive
            s:Shadow        := o:Shadow
            s:TopRow        := o:CurrentRow + 2
            s:LeftColumn    := o:RightColumn - 4
            s:ExceptBlock   := o:ExceptBlock
            s:Exception     := .f.
            s:winExplode    := o:winExplode
            s:winDelay      := o:winDelay
            s:Activate()
            o:exception := s:exception
            if s:Exception
              exit
            endif
            if s:MenuSelection() == 0
              s:Hide()
            else
              exit
            endif
          else
            exit
          endif

        Case m:Button == LEFT_BUTTON .and. ;
             m:Row >= o:TopRow .and. m:Row <= o:BottomRow .and. ;
             m:Column >= o:LeftColumn .and. m:Column <= o:RightColumn

          s := .f.
          if m:Row # o:CurrentRow
            if m:Row > o:CurrentRow
              if ! o:AtBottom
                m:Hide()
                o:Dehighlight(.t.)
                o:cur += m:Row - o:CurrentRow
                if o:cur > len( o:prompts )
                  o:cur := len( o:prompts )
                endif
                s := .t.
              endif
            elseif m:Row < o:CurrentRow
              if ! o:AtTop
                m:Hide()
                o:Dehighlight(.t.)
                o:cur -= o:CurrentRow - m:Row
                if o:cur < 1
                  o:cur := 1
                endif
                s := .t.
              endif
            endif
            if s
              o:RelativeRow := o:cur -1
              o:CurrentRow := o:TopRow + o:RelativeRow
              o:highlight(.t.)
            endif
          elseif mAccept
            if o:PromptId() # 0 .and. o:PromptActive()
              if ( s := o:PromptSubMenu() ) # NIL
                s:MouseActive   := o:MouseActive
                s:Shadow        := o:Shadow
                s:TopRow        := o:CurrentRow + 2
                s:LeftColumn    := o:RightColumn - 4
                s:ExceptBlock   := o:ExceptBlock
                s:Exception     := .f.
                s:winExplode    := o:winExplode
                s:winDelay      := o:winDelay
                s:Activate()
                o:exception := s:exception
                if s:Exception
                  exit
                endif
                if s:MenuSelection() == 0
                  s:Hide()
                else
                  exit
                endif
              else
                exit
              endif
            endif
          endif

        Case m:Button == LEFT_BUTTON .and.   ;
             len( o:prompts ) > o:bottomrow - o:Toprow .and. ;
             (( m:Row == o:TopRow .and. m:Column == o:RightColumn+1 ) .or. ;
              ( m:Row == o:BottomRow .and. m:Column == o:RightColumn+1 ))

          m:Hide()
          if m:Row == o:TopRow
            o:up()
          else
            o:down()
          endif

        Case ! empty( m:Ascii )
          nKey := o:KeySeek( m:Ascii )
          if ! ( nKey == 0 )
            o:MenuChoice(nKey)
            if ! Set( _SET_CONFIRM )
              m:ClearButtons()
              keyboard chr( K_RETURN )
            endif
          else
            lProcessed := .f.
          endif

        Otherwise
          if !(m:Ascii == 0 .and. m:button == 0)
            lProcessed := .f.
          endif

      EndCase

      if ! lProcessed
        if Eval( o:ExceptBlock, o )
          o:exception := .t.
          exit
        endif
      endif

    enddo

    if ! o:exception
      m:ClearButtons()
    endif

    m:Hide()

Return( NIL )


static Function acomp( aArray, bComp, nStart, nStop )

    local value := aArray[1]

   aeval(                                                               ;
          aArray,                                                       ;
          {|x| value := IF( eval(bComp, x, value), x, value )},         ;
          nStart,                                                       ;
          nStop                                                         ;
        )

Return( value )

