/****
*   Program Name: MEMORW.PRG 
*
*   Date Created: 03/10/93          
*   Time Created: 13:29:52
*   Author      : Michael Abadjiev/Kevin S. Gallagher
*   Language    : Clipper 5.0    
*   Compile     : clipper MEMORW.PRG /n /w 
*
*   -=- NOTE:   Replacement of MemoRead() and MemoWrit()
*
*
*   KSG notes:
*   I altered method of SEQUENCE in the memoread replacement, but did not
*   do so in the memowrit replacement. You can decide which you like better.
*
*/

#include "fileio.ch"
#include "error.ch"

#ifdef TEST_ME
function main
    local x
    cls
    //
    // Place a filename into the MemoRead routine to test it out
    // Leave it blank will cause memoread to execute RECOVER USING
    // and there is no error message since parameter two isn't passed.
    //
    if len( x := MemoRead() ) > 0
        ? "Bytes read were " + ltrim(str(len(x) ) )
        ? "Press any key to view!"
        inkey(0)
        ?x
        ? "<<End of string>>"
    else
        ?"Error reading file..."
    endif
return nil
#endif

/****
*       Function: MemoRead(<cFile>,[<lDisplay>]) -->CHARACTER
*       Purpose : Replacement of MemoRead() - more control
*   Date Created: 03/10/93
*/

function MemoRead(cFile, lDisplay)
    local nError
    local cResult := ""
    local cMsg    := ""
    local nSize
    local nHandle
    local nBytes

    lDisplay := if(valtype(lDisplay) <> "L",.f.,lDisplay)

    BEGIN SEQUENCE
        if valtype(cFile) <> "C"
            cResult  := ""
            // force display on possibly for development only?
            // lDisplay := .t.

            break(" ;=======PROGRAMMERS ERROR=======;"  +               ;
                         procname()+"(cFile);"          +               ;
                  "No file was specified to read in!;"                  ;
            )
        endif

        nHandle := fopen(cFile)

        if (nError := ferror()) <> 0
            break("FAILED TO OPEN;"  + cFile +                          ;
                  "OS ERROR NUMBER " + ltrim(str(nError))               ;
            )
        endif

        if (nSize := FSize(cFile)) == 0 
            break("ERROR: File: " + upper(cFile) + " just created!;" +  ;
                  "Nothing to read!"                                    ;
            )
        endif

        if nSize >= 64000
            break(" ;ERROR: File: " + upper(cFile)    + " too big!" )
        endif

        cResult := space(nSize)
        nBytes  := len(cResult)

        if fread(nHandle,@cResult,nBytes) <> nBytes
            cResult := "" 
            BREAK(" ;ERROR: Reading file: " + upper(cFile) )
        endif
    RECOVER USING cMsg
        if lDisplay
            if valtype(cMsg) == "C"
                alert(cMsg)
            else
                //
                // Someone did something wrong or we have ourselfs
                // an object to eval possibly?
                //
            endif
        endif
    END SEQUENCE

    if(nError == 0,fclose(nHandle),nil)

RETURN cResult


/****
*       Function: MemoWrit(<cFile>,<cVar>,[<lDisplay>]) -->LOGICAL
*       Purpose : Replacement of MemoWrit() - more control
*   Date Created: 03/10/93
*/
function MemoWrit(cFile, cVar, lDisplay)
    local nError
    local lResult := .f.
    local nSize
    local nHandle
    local nBytes
    local nOpt

    lDisplay := if( valtype(lDisplay) <> "L", .f., lDisplay )

    BEGIN SEQUENCE
        if valtype(cFile) <> "C"
            alert("ERROR: Function MemoWrit(cFile)!")
            BREAK
        endif

        if valtype(cVar) <> "C"
            alert("ERROR: Function MemoWrit(,cVar)!")
            BREAK
        endif

        // File exist...
        nHandle := fopen(cFile)
        if (nError := ferror()) == 0
            if lDisplay
                nOpt := alert("WARNING: File:"   + upper(cFile) +       ;
                              " Already exist!;" + "Overwrite file?",   ;
                                    {"No","Yes"}                        ;
                )
                if nOpt <> 2
                    BREAK
                endif
            endif
        endif

        if( nError == 0, fclose(nHandle), nil )
        nHandle := fcreate(cFile)
        if (nError := ferror()) <> 0
            if( lDisplay, alert("ERROR: creating file"), nil )
            BREAK
        endif  

        // Just for speed considerations....
        nBytes := len(cVar)
        if fwrite(nHandle,@cVar,nBytes) <> nBytes
            if( lDisplay, alert("ERROR: Reading file: " + upper(cFile)),nil)
            BREAK
        endif

        // Finally evething is fine...
        lResult := .t.
    END SEQUENCE

    if(nError == 0,fclose(nHandle),nil)

return lResult

function FSize(cFile)
return directory(cFile)[1,2]

