/****************************************************************************
  FILENAME
    MSDEMO.PRG

  DESCRIPTION
    Main module for demonstrating the MultiSelect() function

  AUTHOR
    Patrick K. Spence - pkspence@conc.tdsnet.com

  DATE
    24 Jan 96

  FUNCTIONS
    BuildMenu()

  PROCEDURES
    Main()
    Demo()

  REQUIRES
    FIVEWIN.CH
    COMMON.CH
    DIRECTRY.CH
    MSELECT.PRG

  COMPILE/LINK
    rmake MSDEMO.RMK

  COMMENTS
    This was written specifically to be used with FiveWin v1.9.1. I
    have no idea if it will work with earlier versions.

    I don't have any, but if you do, please send them to the email
    address given above.

****************************************************************************/

#include 'FIVEWIN.CH'
#include 'COMMON.CH'
#include 'DIRECTRY.CH'

static oWinMain := nil
static nError   := 0


PROCEDURE Main()
  local oFntMsgBar  := nil
  local cMainTitle  := 'Multi-select picklist demo'


  // give dialogs/buttons a '3D' look
  set 3dlook on

  // define the main window
  define window oWinMain  ;
    from 5,5 to 30,85     ;
    title cMainTitle      ;
    menu BuildMenu()

  // define the font used for the message bar of <oWinMain>
  define font oFntMsgBar  ;
    name 'Arial'          ;
    size 6,14             ;
    bold

  // display keyboard indicators, clock and date on message bar
  set message of oWinMain to '' ;
    font oFntMsgBar             ;
    centered                    ;
    keyboard                    ;
    clock                       ;
    date

  // open main window, full screen
  activate window oWinMain  ;
    maximized               ;
    valid TRUE

return
// EOProc Main()


FUNCTION BuildMenu()
  local oMenu := nil

  // define the main menu object
  menu oMenu

    // add the 'File' menu item and it's options
    menuitem '&File'
    menu

      menuitem '&Demo' ;
        message 'Demonstrate MultiSelect()' ;
        action Demo()

    separator

      menuitem 'E&xit'        ;
        message 'Exit demo'   ;
        action oWinMain:End()

    endmenu

    // ditto for the 'View' menu
    menuitem '&View'
    menu

      menuitem '&Source code' ;
        message 'View MultiSelect() source code via Notepad'  ;
        action  ;
          if(WaitRun('notepad.exe mselect.prg') < 32  ,;
             MsgAlert('An error occurred spawning Notepad') ,;
             nil)

      menuitem '&Read me' ;
        message 'View README.TXT file via Notepad'  ;
        action  ;
          if(WaitRun('notepad.exe readme.txt') < 32 ,;
             MsgAlert('An error occurred spawning Notepad') ,;
             nil)
    endmenu

  endmenu

return oMenu
// EOFunc BuildMenu()


PROCEDURE Demo()
  local aDir        := directory('\*.*')
  local aFiles      := {}
  local aSelected   := {}
  local nSelects    := 0
  local cTitle      := oWinMain:cTitle
  local aPreselects := nil


  // add just the element containing the filenames to <aFiles>
  aeval(aDir,{|ele| aadd(aFiles,ele[F_NAME])})

  // flush <aDir>
  aDir := {}

  // if user wants 'selected' listbox to start off with items in it...
  if MsgYesNo("Do you want to pre-populate the 'selected' list?")

    // make it so
    aPreselects := aFiles

  endif

  // OK, let's see what this puppy can do
  aSelected := MultiSelect(aFiles,aPreselects,cTitle,,oWinMain)

  // if any files were selected...
  if (nSelects := len(aSelected)) > 0

    // say so
    MsgInfo(ltrim(str(nSelects))+' file(s)','You selected')

  else

    MsgAlert("You didn't select any files!","What's up, Doc?")

  endif

return
// EOProc Demo()



/***************************************************************************
  EOFile MSDEMO.PRG
***************************************************************************/
