#include "BOX.CH"
#include "mouseget.ch"

#define Right 2
#define Left 1

Static id1, id2 && id #'s of hot spots
Static scrollID, scrollID2, screensave
Static colors:={"RED   ","GREEN ","BLUE  ","YELLOW","PURPLE"}
Static d, color

*+
FUNCTION MAIN()
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: demonstrate changes to teh get system to use the mouse
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/21/91   LJL       Initial Version
*
* Calling parameters: none - main routine
*
* Notes: none
*-
* LOCAL variables: 
LOCAL a,b,c, nid
LOCAL GetList:={}

*
* Entry Point
*
*SETCOLOR("W/B,B/W,,,B/W")
CLEAR SCREEN

* Put up some gets
a:=b:=c:="This is a test string"
d=5.0
color=COLORS[1]

@ 19,10 SAY "Left button selects fields. Right move cursor in field."

@ 10,0 SAY "Get #1:" GET a PICTURE "@S15 XXXXXXXXXXXXXXXXXXXXX" WHEN Get_out()
@ 10,40 SAY "Get #2:" GET d PICTURE "999.99" WHEN setup_but() VALID Kill_but()
@ 15,0 SAY "Get #3:" GET b PICTURE "XXXXXXXXXXXXXXXXXXXXX" WHEN Stay_in()
@ 18,25 SAY "Get #4:" ;
	GET Color PICTURE "XXXXXXX" WHEN ScrollColor() VALID killcolor()
@ 15,40 SAY "Get #5:" GET C PICTURE "XXXXXXXXXXXXXXXXXXXXX"

@20,35,23,45 BOX B_SINGLE
@21,36 SAY "Click For"
@22,39 SAY "Help"
nid=RDHotSpot(20,35,23,45,{|| give_help()},,,.T.)

READ

RDRemHotSpot(nid)

RETURN NIL

* End of MAIN()

*+
FUNCTION setup_but
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: demonstrate the setup of the hot spots for mouse buttons
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/21/91   LJL       Initial Version
*
* Calling parameters: none
*
* Returns: .T. so that the read can continue
*
* Notes: 
*-
* LOCAL variables: None


*
* Entry Point
*
@ 3,18,9,74 BOX B_SINGLE
@ 5,35,7,40 BOX B_SINGLE
@ 6,36 SAY "10's"
@ 5,42,7,47 BOX B_SINGLE
@ 6,43 SAY "1's"
@ 4, 20 SAY "Left Button Adds the Quantity, Left Subtracts it"
@ 8, 20 SAY "The 10's waits for release, 1's repeats every .1 Sec."
id1=RDHotSpot(5,35,7,40,{|nB| Add_Ten(nB)},0,,.T.)
id2=RDHotSpot(5,42,7,47,{|nB| add_one(nB)},0,0.1)

RETURN .T.

* End of setup_but

*+
FUNCTION Kill_But
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: Kills the hot spots
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/21/91   LJL       Initial Version
*
* Calling parameters: none
*
* Returns: .T. so read can exit
*
* Notes: requires ID's to be available in a global sense
*-
* LOCAL variables: 


*
* Entry Point
*
@ 3,18 CLEAR TO 9,MAXCOL()

RDRemHotSpot(id1)
RDRemHotSpot(id2)

RETURN .T.

* End of kill_But

*+
FUNCTION Add_Ten(nButton)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: Adds ro subtracts 10 to d
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/21/91   LJL       Initial Version
*
* Calling parameters: nButton - the button number left=1 right=2
*                               left adds, right subtracts
*
* Notes: none
*-
* LOCAL variables: 

*
* Entry Point
*
* Update memory so that the following will work

GetActive():assign()

* Now add or subtract

IF nButton=Left
	d=d+10
ELSEIF nButton=Right
	d=d-10
ENDIF

RETURN NIL

* End of Add_Ten

*+
FUNCTION Add_one(nButton)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: Adds or subtracts 1 to d
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/21/91   LJL       Initial Version
*
* Calling parameters: nButton - the button number left=1 right=2
*                               left adds, right subtracts
*
* Notes: none
*-
* LOCAL variables: 

*
* Entry Point
*
* Update memory so the following will work

GetActive():assign()

* Now add or subtract

IF nButton=Left
	d=d+1
ELSEIF nButton=Right
	d=d-1
ENDIF

RETURN NIL

* End of add_one


*+
FUNCTION Get_out()
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: demonstrate a READ within a READ which one can get out of
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/21/91   LJL       Initial Version
*
* Calling parameters: None
*
* Returns .T.
*
* Notes: will exclude the first Get to show just a region of no access.
*        Completing the read removes the no-access area from the list.
*-
* LOCAL variables: 
LOCAL z, savescrn, id
LOCAL GetList:={}

*
* Entry Point
*
savescrn=SAVESCREEN(0,40,10,79)
z="Enter anything"
@0,40 CLEAR TO 10,79
@1,40,10,79 BOX B_SINGLE
@5,45 SAY "You cannot go to the Get which"
@6,45 SAY "was under here until you finish"
@7,45 SAY "this GET."
@8,45 GET z PICTURE "XXXXXXXXXXXXXX"

id=RDExclMouse(0,40,10,79)

READ

RDRemExcl(id)

RESTSCREEN(0,40,10,79,savescrn)

RETURN .T.

* End of Get_out

*+
FUNCTION stay_in()
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: demonstrate a READ within a READ which one cannot get out of
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/21/91   LJL       Initial Version
*
* Calling parameters: None
*
* Returns .T.
*
* Notes: will exclude the all Gets to show just a region of no access
*-
* LOCAL variables: 
LOCAL z, savescrn
LOCAL GetList:={}

*
* Entry Point
*
savescrn=SAVESCREEN(0,0,10,40)
z="Enter anything"
@0,0 CLEAR TO 10,40
@1,0,10,40 BOX B_SINGLE
@5,5 SAY "You cannot go to the any of the"
@6,5 SAY "GETs at the first level until you"
@7,5 SAY "finish this GET."
@8,5 GET z PICTURE "XXXXXXXXXXXXXX" WHEN get_out2()

RDMouselvl(RDCurLEVEL()+1)

READ

RDMouseLvl(1)

RESTSCREEN(0,0,10,40,savescrn)

RETURN .T.

* End of stay_in

*+
FUNCTION ScrollColor
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: Demonstrate scrolling of a GET
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/27/91   LJL       Initial Version
*
* Calling parameters: none
*
* Notes: this creates a "Hot Spot" on top of the GET so that clicking
*        the get calls the actually scroller
*-
* LOCAL variables: 
LOCAL cur_get, crow, ccol, i

*
* Entry Point
*
@ 1,9,8,75 BOX B_SINGLE
@2,10 SAY "Clicking on the current GET will cause it to scroll among values"
@3,14 SAY "Left button single click goes forward, double goes backwards"
@4,14 SAY "while right button moves cursor as usual"
@6,10 SAY "Double clicking on a color in the box will select that item"

screensave=SAVESCREEN(14,5,22,17)
@ 14,5 CLEAR TO 22,17
@ 14,5,20,17 BOX B_SINGLE
FOR i=1 TO LEN(colors)
	@ 14+i, 6 SAY colors[i]
NEXT

cur_get=GetActive()
crow=cur_get:row
ccol=cur_get:col

* Hot spot is on top of the field, only the left button and wait for
* release before continuing

scrollID=RDHotSpot(crow,ccol,crow,ccol+5,;
		{|nB,nX,nY,nTime| colorscroll(nB,nX,nY,nTime)},1,,.T.)

* Hot spot on the side with a list of colors. left button only wait for release

scrollID2=RDHotSpot( 15,6,21,16,{|nB,nX,nY,nTime| colorpick(nB,nX,nY,nTime)},;
				1,,.T.)

RETURN .T.

* End of ScrollColor

*+
FUNCTION colorScroll(nButton,nCurX,nCurY,nTime)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: scroll through the list of colors
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/27/91   LJL       Initial Version
*
* Calling parameters: nButton - The button number - Left goes forward
*                     nCurX - Current x position of cursor
*                     nCurY - Current y position of cursor
*                     nTime - Time the button was hit last
*
* Notes: none
*-
* LOCAL variables: 
LOCAL i, double:=.F.
LOCAL nX, nY, nButPrs
*
* Entry Point
*
if nButton=1

* Find the current position

	i=ASCAN(colors,UPPER(PAD(GetActive():buffer,6)))

* Check for double click - very crude

	SLEEP(0.5,nTime)
	FT_MBUTPRS(0,@nButPrs,@nX,@nY)
	double=(nButPrs>0).AND.(INT(nX/8)=nCurX).AND.(INT(nY/8)=nCurY)

	IF i=0
		color=colors[1]
	ELSEIF !double
		color=colors[IIF(i=LEN(colors),1,i+1)]
	ELSE
		color=colors[IIF(i=1,LEN(colors),i-1)]
	ENDIF	

ENDIF

RETURN NIL

* End of colorscroll

*+
FUNCTION colorpick(nButton,nCurX,nCurY,nTime)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: let the user pick from a list of colors
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/14/91   LJL       Initial Version
*
* Calling parameters: nButton - The button number - Left goes forward
*                     nCurX - Current x position of cursor
*                     nCurY - Current y position of cursor
*                     nTime - Time the button was hit last
*
* Notes: crude check for double click.
*-
* LOCAL variables: 
LOCAL select, nButPrs, nX, nY

*
* Entry Point
*
* Check for double click - very crude

	SLEEP(0.5,nTime)
	FT_MBUTPRS(0,@nButPrs,@nX,@nY)

* If we have a double click then use the color

	IF (nButPrs>0).AND.(INT(nX/8)=nCurX).AND.(INT(nY/8)=nCurY)

		color=colors[nCurX-14]

	ENDIF


RETURN NIL

* End of colorpick

*+
FUNCTION KillColor
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: kill the scrolling of colors on the Get
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/27/91   LJL       Initial Version
*
* Calling parameters: none
*
* Notes: none
*-
* LOCAL variables: none

*
* Entry Point
*

RDRemHotSpot(ScrollID)
RDRemHotSpot(ScrollID2)

@1,0 CLEAR TO 8, MAXCOL()
RESTSCREEN(14,5,22,17,screensave)

RETURN .T.

* End of killcolor

*+
FUNCTION give_help
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: give a brief explanation of what is happening
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/27/91   LJL       Initial Version
*
* Calling parameters: none
*
* Notes: NIL
*-
* LOCAL variables: 
LOCAL savescrn

*
* Entry Point
*
savescrn=SAVESCREEN(0,0,MAXROW(),MAXCOL())
CLEAR SCREEN

@5,0 SAY "This describes some of the features of the mouse interface"
@7,10 SAY "The left button is used to change the active field while the right"
@8,10 SAY "is used to move the cursor within the fields. When multiple READs"
@9,10 SAY "are active, the programmer can control whether or not the mouse can"
@10,10 SAY "be used to exit the current READ and descend back to an earlier READ."
@11,10 SAY "Portions of the screen can be used to activate other routines as"
@12,10 SAY "already know since you are reading this. One can place the active"
@13,10 SAY "screen portion over the current GET as shown be the field with colors."
@14,10 SAY "The right button moves the cursor within the field including"
@15,10 SAY "scrolled fields as show in 'GET #1.'"

@17,20 SAY "Press any key or button to continue"

* wait for button to be released

DO WHILE FT_MBUTREL(1)!=0
ENDDO

*now clear the screen and resume when requested

DO WHILE inkey()=0.AND.FT_MGETPOS()=0
ENDDO

RESTSCREEN(0,0,MAXROW(),MAXCOL(),savescrn)

RETURN NIL

* End of give_help
*+
FUNCTION Get_out2()
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: demonstrate a READ within a READ which one can get out of
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/21/91   LJL       Initial Version
*
* Calling parameters: None
*
* Returns .T.
*
* Notes: will exclude the first Get to show just a region of no access.
*        Completing the read removes the no-access area from the list.
*-
* LOCAL variables: 
LOCAL z, savescrn, id
LOCAL GetList:={}

*
* Entry Point
*
savescrn=SAVESCREEN(0,40,10,79)
z="Enter anything"
@0,40 CLEAR TO 10,79
@1,40,10,79 BOX B_SINGLE
@5,45 SAY "This was created by the GET in"
@6,45 SAY "the box to the left. You can't"
@7,45 SAY "exit without completing."
@8,45 GET z PICTURE "XXXXXXXXXXXXXX" VALID last_one()

id=RDExclMouse(0,40,10,79)

READ

RDRemExcl(id)

RESTSCREEN(0,40,10,79,savescrn)

RETURN .T.

* End of Get_out2


*+
FUNCTION last_one
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: show the effects of a Valid
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/27/91   LJL       Initial Version
*
* Calling parameters: none
*
* Notes: .T. or .F. based upon input = "A"
*-
* LOCAL variables: 
LOCAL a, savescr
LOCAL GetList:={}

*
* Entry Point
*
a='B'
savescr=SAVESCREEN(10,30,15,50)
@ 10,30 CLEAR TO 15,50
@ 11,31,14,49 BOX B_SINGLE
@ 12,32 SAY "Enter an 'A' to"
@ 13,32 SAY "get out: " GET a PICTURE "X"

READ
* Restore screen

RESTSCREEN(10,30,15,50,savescr)

RETURN a=="A"

* End of last_one
