/***
*	Getsys.prg
*	Standard Clipper 5.0 GET/READ subsystem
*	Copyright (c) 1990, 1991 Nantucket Corp.  All rights reserved.
*
*	NOTE: compile with /m/n/w
*
* Mouse modification history:
*
*   Version   Date     Who            Reason
*    V01.00   5/14/91  L J Letendre   Initial Version forClipper 5.01
*    V01.01   5/18/91  L J Letendre   Fixed exit out of WHEN clause with reads
*                                     after use of mouse to get to field. Added
*                                     RDCoolSpot and RDWarmSpot.
*    V01.02   6/30/91  L J Letendre   Fixed parameters in RDCoolSpot and
*                                     RDWarmSpot function statements
*/

#include "Set.ch"
#include "Inkey.ch"
#include "Getexit.ch"

#define K_UNDO          K_CTRL_U


// state variables for active READ
static Format
static Updated := .f.
static KillRead
static BumpTop
static BumpBot
static LastExit
static LastPos
static ActiveGet
static ReadProcName
static ReadProcLine


// format of array used to preserve state variables
#define GSV_KILLREAD		1
#define GSV_BUMPTOP			2
#define GSV_BUMPBOT			3
#define GSV_LASTEXIT		4
#define GSV_LASTPOS			5
#define GSV_ACTIVEGET		6
#define GSV_READVAR 		7
#define GSV_READPROCNAME	8
#define GSV_READPROCLINE	9

#define GSV_COUNT			9

* Start Mouse Change - Add
* additions for mouse support

static save_coord:={}   && save the coordinates of all of the gets
static ExcldMouse:={}   && regions of the screen to exclude from selection 
static Free_exclude:=0  && next free exclude location 0=none
static MouseSpot:={}    && region of screen where mouse click will cause action
static Free_spot:=0     && next free MouseSpot location 0=none
static current_level:=0 && the current nesting level of reads
static mouse_level:=1   && mouse can select gets from all levels >= mouse_level
static mouse_on:=.F.    && signals if the mouse should be turned on
static mouseinited:=.F. && mouse has been initialized
static descend_level:=0 && the level we must decend to when mouse is hit
static save_pos:=0      && save value of new for decending reads when mouse hit
static DefRelease:=.F.  && default value for waiting for release of a button
                        && when hitting a hot spot
static DefSleep:=0.2    && default value for time interval between servicing
                        && hits in a hot spot
static IgnoreMouse:=.F. && ignore mouse if present flag

#define Mouserow	1
#define Mouseleft	2
#define Mouseright	3

* End Mouse Change


/***
*	ReadModal()
*	Standard modal READ on an array of GETs.
*/
func ReadModal( GetList )

local get
local pos
local savedGetSysVars


	if ( ValType(Format) == "B" )
		Eval(Format)
	end

	if ( Empty(getList) )
		// S87 compat.
        SetPos( MaxRow()-1, 0 )
		return (.f.)			// NOTE
	end

* Start Mouse Change - Add
* Keep track of how deep we are in READs

     current_level++
* End Mouse Change

	// preserve state vars
	savedGetSysVars := ClearGetSysVars()

	// set these for use in SET KEYs
	ReadProcName := ProcName(1)
	ReadProcLine := ProcLine(1)


	// set initial GET to be read
	pos := Settle( Getlist, 0 )

	while ( pos <> 0 )

		// get next GET from list and post it as the active GET
		get := GetList[pos]
		PostActiveGet( get )


		// read the GET
		if ( ValType( get:reader ) == "B" )

* Start Mouse Change - Added pos to calls to get:reader and GetReader
* necessary to know which get we are currently in.

			Eval( get:reader, get, pos ) 		// use custom reader block
		else
			GetReader( get, pos )				// use standard reader
		end
* End Mouse Change

* Start Mouse Change - Add

		if descend_level=current_level
* We have run down to where we want to be
			pos:=save_pos
			descend_level=0

		elseif descend_level!=0
* keep running down to the next level
			pos:=0

		else

* End Mouse Change

		// move to next GET based on exit condition
			pos := Settle( GetList, pos )

* Start Mouse Change
		endif
* End Mouse Change
	end


	// restore state vars
	RestoreGetSysVars(savedGetSysVars)

	// S87 compat.
    SetPos( MaxRow()-1, 0 )

* Start Mouse Change - Add
* Exiting so decrement level counter

     current_level--

* End Mouse Change

return (Updated)



/***
*	GetReader()
*	Standard modal read of a single GET.
*/
proc GetReader( get, pos )
* Start Mouse Change - Add
local mouse_key:=0
local mouse_row:=0
local mouse_col:=0
local nKey, nTime
* End Mouse Change


	// read the GET if the WHEN condition is satisfied
* Start Mouse Change - don't enter if we are running down

	if ( GetPreValidate(get) .and. descend_level=0)

* end mouse change

		// activate the GET for reading
		get:SetFocus()

		while ( get:exitState == GE_NOEXIT )

			// check for initial typeout (no editable positions)
			if ( get:typeOut )
				get:exitState := GE_ENTER
			end

			// apply keystrokes until exit
			while ( get:exitState == GE_NOEXIT )
* Start Mouse Change
* Under normal conditions use the way it was done before

				if !mouse_on
					GetApplyKey( get, Inkey(0) )

				else
* Set up a loop and poll the mouse and keyboard
					nKey=0
					mouse_key=0
					descend_level=0  && handle VALID=.F. return

* Show and hide the cursor so that others won't have to worry
* about writing over it.
					FT_MSHOWCRS()

					DO WHILE (nKey=0).AND.(mouse_key=0)

						mouse_key=FT_MGETPOS(@mouse_row,@mouse_col)
						nKey=INKEY()

* if we have input from the mouse then convert the mouse coordinates
* Clear button press counts so call can determine double click easily

						IF mouse_key>0
							nTime=SECOND()
							IF mouse_key%2=1 && left button 
								FT_MBUTPRS(0)
							ENDIF
							IF (INT(mouse_key/2)%2)=1 && right button
								FT_MBUTPRS(1)
							ENDIF
							IF (mouse_key>=4) && middle button
								FT_MBUTPRS(2)
							ENDIF
							mouse_row=INT(mouse_row/8)
							mouse_col=INT(mouse_col/8)
						ENDIF
					ENDDO
					FT_MHIDECRS()

					IF nKey=0
* Input from the mouse so act on it

						GetMouseFunc(mouse_key,mouse_row,mouse_col,;
									pos,nTime)

					else        && we have normal input from the keyboard

						GetApplyKey( get, nKey )
					endif
				endif
			enddo

* End Mouse change
                        
                        
			// disallow exit if the VALID condition is not satisfied
			if ( !GetPostValidate(get) )
				get:exitState := GE_NOEXIT
			end

		end

		// de-activate the GET
		get:KillFocus()

	end

return


/***
*	GetApplyKey()
*	Apply a single Inkey() keystroke to a GET.
*
*	NOTE: GET must have focus.
*/
proc GetApplyKey(get, key)

local cKey
local bKeyBlock


	// check for SET KEY first
	if ( (bKeyBlock := SetKey(key)) <> NIL )

		GetDoSetKey(bKeyBlock, get)
		return									// NOTE

	end


	do case
	case ( key == K_UP )
		get:exitState := GE_UP

	case ( key == K_SH_TAB )
		get:exitState := GE_UP

	case ( key == K_DOWN )
		get:exitState := GE_DOWN

	case ( key == K_TAB )
		get:exitState := GE_DOWN

	case ( key == K_ENTER )
		get:exitState := GE_ENTER

	case ( key == K_ESC )
		if ( Set(_SET_ESCAPE) )
			get:undo()
			get:exitState := GE_ESCAPE
		end

	case ( key == K_PGUP )
		get:exitState := GE_WRITE

	case ( key == K_PGDN )
		get:exitState := GE_WRITE

	case ( key == K_CTRL_HOME )
		get:exitState := GE_TOP


#ifdef CTRL_END_SPECIAL

	// both ^W and ^End go to the last GET
	case (key == K_CTRL_END)
		get:exitState := GE_BOTTOM

#else

	// both ^W and ^End terminate the READ (the default)
	case (key == K_CTRL_W)
		get:exitState := GE_WRITE

#endif


	case (key == K_INS)
		Set( _SET_INSERT, !Set(_SET_INSERT) )
		ShowScoreboard()

	case (key == K_UNDO)
		get:Undo()

	case (key == K_HOME)
		get:Home()

	case (key == K_END)
		get:End()

	case (key == K_RIGHT)
		get:Right()

	case (key == K_LEFT)
		get:Left()

	case (key == K_CTRL_RIGHT)
		get:WordRight()

	case (key == K_CTRL_LEFT)
		get:WordLeft()

	case (key == K_BS)
		get:BackSpace()

	case (key == K_DEL)
		get:Delete()

	case (key == K_CTRL_T)
		get:DelWordRight()

	case (key == K_CTRL_Y)
		get:DelEnd()

	case (key == K_CTRL_BS)
		get:DelWordLeft()

	otherwise

		if (key >= 32 .and. key <= 255)

			cKey := Chr(key)

			if (get:type == "N" .and. (cKey == "." .or. cKey == ","))
				get:ToDecPos()

			else
				if ( Set(_SET_INSERT) )
					get:Insert(cKey)
				else
					get:Overstrike(cKey)
				end

				if (get:typeOut .and. !Set(_SET_CONFIRM) )
					if ( Set(_SET_BELL) )
						?? Chr(7)
					end

					get:exitState := GE_ENTER
				end

			end

		end

	endcase

return



/***
*	GetPreValidate()
*	Test entry condition (WHEN clause) for a GET.
*/
func GetPreValidate(get)

local saveUpdated
local when := .t.


	if ( get:preBlock <> NIL )

		saveUpdated := Updated

		when := Eval(get:preBlock, get)

		get:Display()

		ShowScoreBoard()
		Updated := saveUpdated

	end


	if ( KillRead )
		when := .f.
		get:exitState := GE_ESCAPE		// provokes ReadModal() exit

	elseif ( !when )
		get:exitState := GE_WHEN		// indicates failure

	else
		get:exitState := GE_NOEXIT		// prepares for editing

	end

return (when)



/***
*	GetPostValidate()
*	Test exit condition (VALID clause) for a GET.
*
*	NOTE: bad dates are rejected in such a way as to preserve edit buffer.
*/
func GetPostValidate(get)

local saveUpdated
local changed, valid := .t.


	if ( get:exitState == GE_ESCAPE )
		return (.t.)					// NOTE
	end

	if ( get:BadDate() )
		get:Home()
		DateMsg()
		ShowScoreboard()
		return (.f.)					// NOTE
	end


	// if editing occurred, assign the new value to the variable
	if ( get:changed )
		get:Assign()
		Updated := .t.
	end


	// reform edit buffer, set cursor to home position, redisplay
	get:Reset()


	// check VALID condition if specified
	if ( get:postBlock <> NIL )

		saveUpdated := Updated

		// S87 compat.
        SetPos( get:row, get:col + Len(get:buffer) )

		valid := Eval(get:postBlock, get)

		// reset compat. pos
		SetPos( get:row, get:col )

		ShowScoreBoard()
		get:UpdateBuffer()

		Updated := saveUpdated

		if ( KillRead )
			get:exitState := GE_ESCAPE	// provokes ReadModal() exit
			valid := .t.
		end

	end

return (valid)




/***
*	GetDoSetKey()
*	Process SET KEY during editing.
*/
proc GetDoSetKey(keyBlock, get)

local saveUpdated


	// if editing has occurred, assign variable
	if ( get:changed )
		get:Assign()
		Updated := .t.
	end


	saveUpdated := Updated

	Eval(keyBlock, ReadProcName, ReadProcLine, ReadVar())

	ShowScoreboard()
	get:UpdateBuffer()

	Updated := saveUpdated


	if ( KillRead )
		get:exitState := GE_ESCAPE		// provokes ReadModal() exit
	end

return



/**************************
*
*	READ services
*
*/



/***
*	Settle()
*
*	Returns new position in array of Get objects, based on
*
*		- current position
*		- exitState of Get object at current position
*
*	NOTE return value of 0 indicates termination of READ
*	NOTE exitState of old Get is transferred to new Get
*/
static func Settle(GetList, pos)

local exitState


	if ( pos == 0 )
		exitState := GE_DOWN
	else
		exitState := GetList[pos]:exitState
	end


	if ( exitState == GE_ESCAPE .or. exitState == GE_WRITE )
		return ( 0 )					// NOTE
	end


	if ( exitState <> GE_WHEN )
		// reset state info
		LastPos := pos
		BumpTop := .f.
		BumpBot := .f.

	else
		// re-use last exitState, do not disturb state info
		exitState := LastExit

	end


	/***
	*	move
	*/
	do case
	case ( exitState == GE_UP )
		pos --

	case ( exitState == GE_DOWN )
		pos ++

	case ( exitState == GE_TOP )
		pos := 1
		BumpTop := .T.
		exitState := GE_DOWN

	case ( exitState == GE_BOTTOM )
		pos := Len(GetList)
		BumpBot := .T.
		exitState := GE_UP

	case ( exitState == GE_ENTER )
		pos ++

* Start Mouse Change - Add

	case ( exitState == GE_MOUSE )
* we got here by hitting the mouse within the same READ so change the GET

		exitState:=IIF(pos<save_pos,GE_DOWN,GE_UP)
		pos:=save_pos

* End Mouse Change

	endcase


	/***
	*	bounce
	*/
	if ( pos == 0 ) 						// bumped top

		if ( !ReadExit() .and. !BumpBot )
			BumpTop := .T.
			pos := LastPos
			exitState := GE_DOWN
		end

	elseif ( pos == Len(GetList) + 1 )		// bumped bottom

		if ( !ReadExit() .and. exitState <> GE_ENTER .and. !BumpTop )
			BumpBot := .T.
			pos := LastPos
			exitState := GE_UP
		else
			pos := 0
		end
	end


	// record exit state
	LastExit := exitState

	if ( pos <> 0 )
		GetList[pos]:exitState := exitState
	end

return (pos)



/***
*	PostActiveGet()
*	Post active GET for ReadVar(), GetActive().
*/
static proc PostActiveGet(get)

	GetActive( get )
	ReadVar( GetReadVar(get) )

	ShowScoreBoard()

return



/***
*	ClearGetSysVars()
*	Save and clear READ state variables. Return array of saved values.
*
*	NOTE: 'Updated' status is cleared but not saved (S87 compat.).
*/
static func ClearGetSysVars()

local saved[ GSV_COUNT ]


	saved[ GSV_KILLREAD ] := KillRead
	KillRead := .f.

	saved[ GSV_BUMPTOP ] := BumpTop
	BumpTop := .f.

	saved[ GSV_BUMPBOT ] := BumpBot
	BumpBot := .f.

	saved[ GSV_LASTEXIT ] := LastExit
	LastExit := 0

	saved[ GSV_LASTPOS ] := LastPos
	LastPos := 0

	saved[ GSV_ACTIVEGET ] := GetActive( NIL )

	saved[ GSV_READVAR ] := ReadVar( "" )

	saved[ GSV_READPROCNAME ] := ReadProcName
	ReadProcName := ""

	saved[ GSV_READPROCLINE ] := ReadProcLine
	ReadProcLine := 0

	Updated := .f.

return (saved)



/***
*   RestoreGetSysVars()
*	Restore READ state variables from array of saved values.
*
*	NOTE: 'Updated' status is not restored (S87 compat.).
*/
static proc RestoreGetSysVars(saved)

	KillRead := saved[ GSV_KILLREAD ]

	BumpTop := saved[ GSV_BUMPTOP ]

	BumpBot := saved[ GSV_BUMPBOT ]

	LastExit := saved[ GSV_LASTEXIT ]

	LastPos := saved[ GSV_LASTPOS ]

	GetActive( saved[ GSV_ACTIVEGET ] )

	ReadVar( saved[ GSV_READVAR ] )

	ReadProcName := saved[ GSV_READPROCNAME ]

	ReadProcLine := saved[ GSV_READPROCLINE ]

return



/***
*	GetReadVar()
*	Set READVAR() value from a GET.
*/
static func GetReadVar(get)

local name := Upper(get:name)


//#ifdef SUBSCRIPT_IN_READVAR
local i

	/***
	*	The following code includes subscripts in the name returned by
	*	this function, if the get variable is an array element.
	*
	*	Subscripts are retrieved from the get:subscript instance variable.
	*
	*	NOTE: incompatible with Summer 87
	*/

	if ( get:subscript <> NIL )
		for i := 1 to len(get:subscript)
			name += "[" + ltrim(str(get:subscript[i])) + "]"
		next
	end

//#endif

return (name)



/**********************
*
*	system services
*
*/



/***
*   __SetFormat()
*	SET FORMAT service
*/
func __SetFormat(b)
	Format := if ( ValType(b) == "B", b, NIL )
return (NIL)


/***
*	__KillRead()
*   CLEAR GETS service
*/
proc __KillRead()
	KillRead := .t.
return


/***
*	GetActive()
*/
func GetActive(g)
local oldActive := ActiveGet
	if ( PCount() > 0 )
		ActiveGet := g
	end
return ( oldActive )


/***
*	Updated()
*/
func Updated()
return (Updated)


/***
*	ReadExit()
*/
func ReadExit(lNew)
return ( Set(_SET_EXIT, lNew) )


/***
*	ReadInsert()
*/
func ReadInsert(lNew)
return ( Set(_SET_INSERT, lNew) )



/**********************************
*
*	wacky compatibility services
*
*/


// display coordinates for SCOREBOARD
#define SCORE_ROW		0
#define SCORE_COL		60


/***
*   ShowScoreboard()
*/
static proc ShowScoreboard()

local nRow, nCol


    if ( Set(_SET_SCOREBOARD) )
        nRow := Row()
        nCol := Col()

		SetPos(SCORE_ROW, SCORE_COL)
		DispOut( if(Set(_SET_INSERT), "Ins", "   ") )
        SetPos(nRow, nCol)
	end

return



/***
*	DateMsg()
*/
static proc DateMsg()

local nRow, nCol


    if ( Set(_SET_SCOREBOARD) )
		nRow := Row()
		nCol := Col()

		SetPos(SCORE_ROW, SCORE_COL)
		DispOut("Invalid Date")
        SetPos(nRow, nCol)

		while ( Nextkey() == 0 )
		end

		SetPos(SCORE_ROW, SCORE_COL)
		DispOut("            ")
        SetPos(nRow, nCol)

	end

return



/***
*   RangeCheck()
*
*	NOTE: unused second param for 5.00 compatibility.
*/

func RangeCheck(get, junk, lo, hi)

local cMsg, nRow, nCol
local xValue


	if ( !get:changed )
		return (.t.)
	end

	xValue := get:VarGet()

	if ( xValue >= lo .and. xValue <= hi )
		return (.t.)									// NOTE
	end

    if ( Set(_SET_SCOREBOARD) )
		cMsg := "Range: " + Ltrim(Transform(lo, "")) + ;
				" - " + Ltrim(Transform(hi, ""))

		if ( Len(cMsg) > MaxCol() )
			cMsg := Substr( cMsg, 1, MaxCol() )
		end

		nRow := Row()
		nCol := Col()

		SetPos( SCORE_ROW, Min(60, MaxCol() - Len(cMsg)) )
		DispOut(cMsg)
        SetPos(nRow, nCol)

		while ( NextKey() == 0 )
		end

		SetPos( SCORE_ROW, Min(60, MaxCol() - Len(cMsg)) )
		DispOut( Space(Len(cMsg)) )
        SetPos(nRow, nCol)

	end

return (.f.)

* Start Mouse Change - Add
*
* The remainder of the routines are Copyright (c) 1991 by Leo J. Letendre.
* Permission is automatically granted to those who wish to use these
* routines in any application. Permission is not granted to anyone wishing
* to include these in any third party shareware or commercial library.
*
* For further information please contact: Leo Letendre, CIS: 73607,233
* Conventional mail: 267 Glandore Dr. Manchester, MO 63021.
*
*******
** RdMouseLvl()
*
* this procedure sets the flag which controls which levels of READS
* are accesable to the mouse. If the calling  argument is missing then 
* it just returns the current setting.
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/19/91   LJ Letendre   Initial Version
*
* Calling parameters:
*                     nLevel - integer value of the level of READs below which
*                              the mouse is inactive. READs are numbered in 
*                              order of execution starting at 1.
*
* Returns:
*          current status
* Notes:
*         To get the current level of read use RDCurLevel().
*
*         Is usually called prior to READ but could be called from within
*         a WHEN clause.

FUNCTION RDMouseLvl(nLevel)

*
* Local variables
*
LOCAL oldsetting    && setting prior to call

* Save old setting now in case we change it

oldsetting=mouse_level

* Set according to input

IF VALTYPE(nLevel)=="N"
	mouse_level=MAX(1,nLevel)
ENDIF

RETURN oldsetting

* End of RDMouseLvl

*******
** RDMouseOn()
*
* this procedure sets the flag which controls whether the mouse is active for
* the current read. If the calling argument is missing then it just returns 
* the current setting.
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*
* Calling parameters:
*                     lOn - Logical = .T. for mouse being active
*                                   = .F. for mouse being off
*
* Returns:
*          current status = .T. or .F.
* Notes:
*         This routine does not signal an error if an incorrect calling
*         parameter is passed. In this case it acks as if the caller passed
*         none.
*
*         This routine should not normally need to be called but is included
*         on the off chance that it will be.

FUNCTION RDMouseOn(lOn)

*
* Local variables
*
LOCAL oldsetting    && setting prior to call

* Save old setting now in case we change it

oldsetting=mouse_on

* Set according to input

IF VALTYPE(lOn)=="L"
	mouse_on=lOn
ENDIF

RETURN oldsetting

* End of RDMouseOn

*****
* MouseCoord()
*
* This function looks at the current getlist and sets up an array of 
* coordinates which define the begining and end of each get.
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*         V1.01     5/10/91   LJ Letendre   Added GetList to call
*
* Calling parameters:  aGetList - the array of gets to be processed
*
* Returns: NIL
*
* Notes: This routine sets the length of the get equal to the size of the
*        string returned by the TRANSFORM function which currently follows
*        all of the picture functions of the GET which is counter to the
*        inference given in the documentation. Since this simplifies the job
*        we will use it here and hope that it doesn't change.
*
*        This routine should be called prior to issuing the READ command
*        or calling readmodal().
*
STATIC FUNCTION MouseCoord(aGetList)

*
* Local variables
*
LOCAL nGetlen  && length of getlist
LOCAL i        && index counter
LOCAL g        && local copy of each object in the getlist
LOCAL nLevel	&& next READ level

* expand the size of the corrdinate array as needed
nLevel=current_level+1
ASIZE(save_coord,nLevel)
nGetlen=LEN(aGetList)
save_coord[nlevel]={}
ASIZE(save_coord[nLevel],nGetlen)

* now go through each element of the getlist and determine the size

FOR i=1 TO nGetlen

	g=aGetList[i]

* Expand the array to three levels

	save_coord[nlevel,i]=;
		{g:row, g:col, g:col+LEN(TRANSFORM(g:VARGET(),g:picture))-1 }

NEXT

* Return to caller work complete

RETURN NIL	

* End of mousecoord

*****
*
* GetMouseFunc()
*
* This function determines if the mouse is in a Get and if it is then at
* which level it needs to drop to and which get it needs to move to. 
* Additionally this routine processes any screen "hot spots" which are selected
* by the user. 
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*         V1.01     5/10/91   LJL           Clipper 5.01 update
*                                           Added row, col and time to code
*                                           block eval call.
*
* Calling Parameters:
*                    nButton - Button which was hit - reserved for future
*                    nRow - Row coordinate of mouse pointer when button hit
*                    nCol - Col coordinate of mouse pointer
*                    nPos - On input contains the current get number
*                    nTime - The time that the button was clicked
* Returns: NIL
*
* Notes: The processing of "Hot Spots" occurs prior to checking for the
* cursor being in a GET field. Therefore, the code block will be executed
* without the check for moving the cursor to another get.
*
*

STATIC FUNCTION GetMouseFunc(nButton,nRow,nCol,nPos,nTime)

*
* Local variables:
*
LOCAL i, j, working, ending, k
LOCAL working2, des_pos, old_pos
LOCAL g

* Set flag to denote completion

working=.T.

* First check to see if any action hot spots were clicked on

j=1
DO WHILE (j<=LEN(MouseSpot).AND.working)

* Check coordinates
	working=.NOT.(MouseSpot[j,9].AND.;
				nRow>=MouseSpot[j,1].AND.nRow<=MouseSpot[j,3].AND.;
				nCol>=MouseSpot[j,2].AND.nCol<=MouseSpot[j,4].AND.;
				(MouseSpot[j,8]=0.OR.MouseSpot[j,8]=nButton))

* If we have a match then execute the code block

	IF .NOT.working

* do the request

		EVAL(MouseSpot[j,5],nButton,nRow,nCol,nTime)

* in case var was reassigned in the code block
		ActiveGet:updateBuffer()

* in case insert status was diddled in SET KEY code
          ShowScoreboard()
* Wait for release if requested
		IF MouseSpot[j,7]
			DO WHILE FT_MBUTREL(1)!=0
			ENDDO
		ENDIF

* Pause for the minimum amount of time

		sleep(MouseSpot[j,6],nTime)
	ENDIF
* increment counter
	j++

ENDDO

* if we did not find a hit then continue on
IF working

* Search for a match in coordinates

	i = current_level
	ending=IIF(mouse_level<1,1,mouse_level)
	working2=.T.

	DO WHILE (i>=ending.AND.working.AND.working2)
		j=1
		DO WHILE (j<=LEN(save_coord[i]).AND.working.AND.working2)
* First check the row since that has no spanning value
			IF save_coord[i,j,Mouserow]=nRow;
				.AND.nCol>=save_coord[i,j,Mouseleft];
				.AND.nCol<=save_coord[i,j,Mouseright]

				working=.F.
* Now check to see if it is excluded at this level and all higher

				k=1
				DO WHILE (k<=LEN(ExcldMouse).AND.working2)
					IF i<=ExcldMouse[k,5];
						.AND.nRow>=ExcldMouse[k,1];
						.AND.nRow<=ExcldMouse[k,3];
						.AND.nCol>=ExcldMouse[k,2];
						.AND.nCol<=ExcldMouse[k,4]

* If we are in an excluded area then kick us out of the whole routine

						working2=.F.
						working=.T.   && so no work gets done below
					ENDIF
					k++
				ENDDO
			ENDIF
			j++
		ENDDO
		i--
	ENDDO

* If working is false then we found a match so Do the work

	IF .NOT.working
		i++
	     save_pos=j-1
* Now based upon which key was hit either move the active get- left key
* or move the cursor - right key

* Left button

		IF nButton=1

* If we are at the correct level then do not adjust for it
			IF i==current_level
* Change get if necessary
				IF (save_pos!=nPos)
					ActiveGet:exitState:=GE_MOUSE
				ENDIF
* at a different level then kill read and Get

			ELSE
				descend_level=i
				ActiveGet:exitState:=GE_ESCAPE
				KillRead=.T.
			ENDIF

* Right Button

		ELSEIF nButton=2

* See if we are in the correct get and if so move the cursor
			IF i==current_level.AND.save_pos==nPos
* Get desired position - a little funky due to scrollable fields

				ActiveGet:display()   && make sure cursor is showing
				old_pos=ActiveGet:pos
				des_pos=old_pos+ncol-COL()
				IF des_pos=ActiveGet:DecPos
					des_pos++
				ENDIF
* Move
				IF des_pos<old_pos
					old_pos--
					DO WHILE ActiveGet:pos>des_pos.AND.;
						.NOT.(old_pos==ActiveGet:pos)
						old_pos=ActiveGet:pos

						ActiveGet:left()
* Check for non-movement
					ENDDO
				ELSEIF des_pos>old_pos
					old_pos--
					DO WHILE ActiveGet:pos<des_pos.AND.;
						.NOT.(old_pos==ActiveGet:pos)
						old_pos=ActiveGet:pos

						ActiveGet:right()
* Check for non-movement
					ENDDO
				ENDIF

			ENDIF
		ENDIF
* Wait for release so that scrolling or hot spots are not
* messed up by not releasing quickly enough

		DO WHILE FT_MBUTREL(0)!=0
		ENDDO

	ENDIF


ENDIF

* Now return

RETURN NIL

* End of  GetMouseFunc


******
*
* RDExclMouse()
*
* This routine allows the caller to exclude gets in an area of the screen from
* being selected at the current and all lower levels.
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*
* Calling Parameters:
*                     nTopRow - the top row of the area to exclude
*                     nLeftCol - the left column of the area
*                     nBotRow - the bottom row of the area to exclude
*                     nRightCol - the right column of the area to exclude
*
* Returns: nID which is an ID number identifying the region so that the
*              region may be restored to active status with a call to
*              REMEXCLUDE(ID)
*
FUNCTION RDExclMouse(nTopRow, nLeftCol, nBotRow, nRightCol)
*
* Local parameters
LOCAL next_exclude, i, working

* Check size of exclude array and enlarge if necessary

IF (free_exclude=0)
	AADD(ExcldMouse,{})
	next_exclude=LEN(ExcldMouse)
ELSE
	next_exclude=free_exclude
	i=next_exclude+1
	free_exclude=0
	working=.T.
* find next free location
	DO WHILE i<LEN(ExcldMouse).AND.working
		IF ExcldMouse[i,1]=-1
			working=.F.
			free_exclude=i
		ENDIF
		i++
	ENDDO

ENDIF

* Now add the coordinates

ExcldMouse[next_exclude]={nTopRow, nLeftCol, nBotRow, nRightCol,current_level}

RETURN next_exclude

* End of RDExclMouse

******
*
* RDRemExcl()
*
* This subroutine clears the excluded region set by ExcludeMouse for the
* currently active READ
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*
* Calling Parameters : nID - which is the ID number of the region to place
*                            back to active duty. It is given by ExcludeMouse.
*
* Returns: NIL
*
FUNCTION RDRemExcl(nID)
*
* Local variables
LOCAL i, working

ExcldMouse[nID,1]:=ExcldMouse[nID,2]:=-1
ExcldMouse[nID,3]:=ExcldMouse[nID,4]:=-1
ExcldMouse[nID,5]=0
IF nID<free_exclude.OR.free_exclude=0
	free_exclude=nID
ENDIF

* shrink the array if possible.

i=LEN(ExcldMouse)
working=.T.
DO WHILE i>=free_exclude.AND.working
	working=(ExcldMouse[i,1]<0)
	i--
ENDDO
ASIZE(ExcldMouse,i+1)

RETURN NIL

* End of RemExclude

******
*
* MOUSEREAD()
*
* This routine calls all of the appropriate routines to do a read using the
* mouse for field selection
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*         V1.01     5/10/91   LJ Letendre   changed call to MouseCoord
*
* Calling Parameters:
*                     aGetList - input - The list of gets normally passed to
*                                readmodal
*
* Returns: Whatever ReadModal returns
*
*
FUNCTION MOUSEREAD(aGetList)
*
* Local variables:
LOCAL savemouse, nX, nY, result

* See if we have a mouse and reset it. This does no harm on multiple reads.

IF !IgnoreMouse
	IF (savemouse:=Mouse_On.AND.mouseinited)
		FT_MGETPOS(@nX,@nY)
	ENDIF

	mouseinited:=FT_MINIT()

	IF mouseinited
* Set the mouse flag on saving the old
		Mouse_On=.T.
* Save the coordinates of the fields
		mousecoord(aGetList)
* Restore the position if necessary
		IF savemouse
			FT_MSETPOS(nX,nY)
		ENDIF
	ENDIF

ENDIF

* Now do the read

result=ReadModal(aGetList)

IF !IgnoreMouse
* Reset the world

	Mouse_On:=savemouse

	ASIZE(save_coord,MAX(current_level,1))

ENDIF

RETURN result

* End of MOUSEREAD

******
*
* RDHotSpot()
*
* This function allows the caller to define a location on the screen which
* if clicked on with the mouse will cause an action to take place.
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*         V1.01     5/10/91   LJL           Added row, col and time to code
*                                           block eval call documentation.
* 
* Calling parameters:
*                     nTopRow - the top row of the area 
*                     nLeftCol - the left column of the area
*                     nBotRow - the bottom row of the area
*                     nRightCol - the right column of the area 
*                     bAction - Code block which will be executed when
*                              mouse is clicked in the area
*                     nButton - Optional button number for action to occur. IF
*                              equal to 0 or NIL, the action occurs on 
*                              clicking anybutton (the code block can decide 
*                              what to do with based upon the button). If equal
*                              to 1, code block executes only on left click,
*                              if equal to 2 only on right click and if equal
*                              to 4(?) then the middle button.
*                     nSleep - Optional value of a minimum time (in seconds) to
*                              wait between servicing multiple button presses. 
*                              Prevents routine from operating too quickly and 
*                              reading the press of a button multiple times 
*                              when not intended. If =NIL then the default value
*                              is used (see MDefaultSleep()).
*                      lRelease - Optional Logical Value. If set to .T. the
*                              servicing routine will pause after the completion
*                              of bAction for the release of the mouse button(s)
*                              Useful for guaranteeing no multiple hits on
*                              an area. If =NIL then the default is used (see
*                              MDefaultRelease())
*
* Returns: nId which is an ID to be used to remove the area with a call
*              to RemHotSpot(nId)
*
* Note: The code block bAction is called with four arguments:
*
*                 nButNum: the number of the button pressed with
*                          1=left, 2=right, 4=middle(?).
*                 nRow: The row that the mouse cursor was in when it
*                       was clicked
*                 nCol: The column that the mouse cursor was in when it
*                       was clicked
*                 nTime: The time returned by SECOND() shortly after the
*                       button was clicked.
*
*        Thus the code block should have a form similar to the following
*        if one wishes to use the button/cursor information:
*
*               {|nButNum, nRow, nCol, nTime| MyFunc(NButNum,nRow,nCol,nTime)}

FUNCTION RDHotSpot( nTopRow, nLeftCol, nBotRow, nRightCol, bAction, nButton,;
				 nSleep, lRelease)
*
* Local variables
*
LOCAL next_spot, working, i

* Entry point

* Now add the coordinates

RETURN AddHotSpot(MouseSpot,@free_spot,;
                 {nTopRow, nLeftCol, nBotRow, nRightCol, bAction,;
                  IIF(nSleep=NIL,defSleep,nSleep),;
                  IIF(lRelease=NIL,defRelease,lRelease),;
                  IIF(nButton=NIL,0,nButton),.T.})

* End of RDAddHotSpot

******
*
* RDRemHotSpot()
*
* This subroutine clears the specified Hotspot 
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*
* Calling Parameters : nID - which is the ID number of the region to remove
*                            from active duty. It is given by AddHotSpot.
*
* Returns: NIL
*
FUNCTION RDRemHotSpot(nID)
*
* Local variables
*
LOCAL i, working

* Set values to those off of the screen and no code block

MouseSpot[nID,1]:=MouseSpot[nID,2]:=MouseSpot[nID,3]:=MouseSpot[nID,4]:=-1
MouseSpot[nID,5]=NIL
IF nID<free_spot.OR.free_spot=0
	free_spot=nID
ENDIF

* Shrink array if possible

i=LEN(MouseSpot)
working=.T.
DO WHILE i>=free_spot.AND.working
	working=MouseSpot[i,1]<0
	i--
ENDDO

ASIZE(MouseSpot,i+1)


RETURN NIL

* End of RDRemHotSpot

******
*
* RDCoolSpot()
*
* This subroutine deactivates the specified HotSpot without deleting it
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/17/91   LJ Letendre   Initial Version
*
* Calling Parameters : nID - which is the ID number of the region to remove
*                            from active duty. It is given by AddHotSpot.
*
* Returns: NIL
*
FUNCTION RDCoolSpot(nID)
*
* Local variables
*

MouseSpot[nid,9]=.F.

RETURN NIL

* End of RDCoolSpot

******
*
* RDWarmSpot()
*
* This subroutine reactivates the specified HotSpot which was deactivated
* by RDCoolSpot
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/17/91   LJ Letendre   Initial Version
*
* Calling Parameters : nID - which is the ID number of the region to return 
*                            to active duty. It is given by AddHotSpot.
*
* Returns: NIL
*
FUNCTION RDWarmSpot(nID)
*
* Local variables
*

MouseSpot[nId,9]=.T.

RETURN NIL

* End of RDWarmSpot


*****
*
*  RDDefSleep()
*
* This routine sets the default minimum time between servicing the mouse
* button when on a "hot spot". Useful for slowing things down.
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*
* Calling Paramters: nDefSleep - Number of second for the default interval
*                                If absent no change made.
*
* Returns: current setting
*
* Note: the default time within the system is 0.2 seconds
*
FUNCTION RDDefSleep(nDefSleep)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=DefSleep

IF nDefSleep!=NIL
	DefSleep=nDefSleep
ENDIF

RETURN oldsetting

* End of RDDefSleep

*****
*
*  RDDefRelease()
*
* This routine sets the default logical value controling if the program
* waits for the release of the mouse button before continuing when it is in
* a "Hot Spot"
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/20/91   LJ Letendre   Initial Version
*
* Calling Paramters: lDefRelease - If present will set the default action
*                                  on releasing the mouse button before
*                                  continuing when servicing a "Hot Spot"
*                                  If absent no change made. .T. causes
*                                  a wait for release.
*
* Returns: current setting
*
*
* Note: The default release action is not to require a release (= .F.)
*
*
FUNCTION RDDefRelease(lDefRelease)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=DefRelease

IF lDefRelease!=NIL
	DefRelease=lDefRelease
ENDIF

RETURN oldsetting

* End of RDDefRelease

******
*
* RDCurLevel()
*
* This routine will return the current level of READs
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/25/91   LJL       Initial Version
*
* Calling parameters: None
*
* Returns:
*          The current level of READs currently functioning. The level number
*          is the current count of nested READs starting at 1.
*
*

FUNCTION RDCurLevel

RETURN current_level

* End of RDCurLevel


******
*
*   RDDescend()
*
* Purpose: This routine returns a logical indicating if the GET/READ system is
* descending to a lower level read based upon a request by the mouse system
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/10/91   LJL       Initial Version
*
* Calling Parameters: None
*
* Returns: .T. if the GET/READ system will descend to a lower level than
*           the current one
*          .F. if it will stay at the same level.
*
* Notes: This routine can be useful when a READ is performed in a VALID clause.
*        It is the equivalent to LASTKEY()=K_ESC.
*
FUNCTION RDDescend

RETURN (descend_level!=0)

* End of RDDescend

*****
*
* function RDIgnoreMouse()
*
* Purpose: force the routines to ignore the mouse and perform the overhead
*          necessary for mouse support
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/10/91   LJL       Initial Version
*
* Calling Parameters: lIgnore - logical for ignoring mouse .T. = act as if
*                               mouse is not present. If absent just returns
*                               current setting
*
* Returns: setting in effect prior to call
*
FUNCTION RDIgnoreMouse(lIgnore)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=IgnoreMouse

IF lIgnore!=NIL
	IgnoreMouse=lIgnore
ENDIF

RETURN oldsetting

* End of RDIgnoreMouse

******
*
* function RDCancelDescend()
*
* Purpose: to cancel the effect of a mouse click on a lower level GET
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/11/91   LJL       Initial Version
*
* Calling Parameters: None
*
* Returns: NIL
*
* Notes: At times it may be useful to cancel the effect of the mouse causing
* a run down to a lower level read. This function will provide that effect.

FUNCTION RDCancelDescend

descend_level=0

RETURN NIL

* End of RDCancelDescend

* End Mouse Change
