*******************************************************************
FUNCTION Alert( cMessage, aChoices, nTopRow, cColor, lBell, nTime )
*******************************************************************
/*
 - Alert() substitude
 - John E. Graceland ( 3-23-94 )
 - Replacement for Clipper's ALERT() Function
 - Clipper 5.n
 - Syntax: Alert( <cMessage> [,<aChoices>, <nTopRow>, <cColor>, <lBell>] )
 - Features: Emulates Clipper's ALERT(), additional options are
             Starting row position of box, set color, sound bell
             Invoke Clippers dbugger from within Alert(), time out a 
             message, displays vertically when cannot fit horizontally.
 - Returns a numeric value equal to the option selected, <Esc> = 0
*/

LOCAL;
n,;
nCol,;
nRow,;
cScreen,;
nPromLeft,;
nBoxLeft,;
nBoxRight,;
nMsgLen,;
nBoxLen    := 0,;
nPromLen   := 0,;
cOldColor  := SETCOLOR(),;
cOldWrap   := SET( 35, "ON" ),;
lOldCenter := SET( 37, .F. ),;
lOldBlink  := SETBLINK(.F.),;
aMessage   := {},;
bPgUp      := SETKEY(K_PGUP, {||NIL} ),;
bPgDn      := SETKEY(K_PGDN, {||NIL} ),;
nChoice    := 0,;
lVertical  := (.F.),;
nBoxWidth  := 0,;
nMaxBottom,;
cCur

IF aChoices==NIL
   // force "OK" if no choices are passed
   aChoices:={}
   AADD(aChoices,IF(nTime==NIL,"OK","<Esc>"))
END

// set length of prompt line
AEVAL( aChoices, {|aArray| nPromLen += LEN(aArray)+2 })

// load message array
WHILE ";" $ cMessage
   // test for multiple line message
   AADD(aMessage, SUBSTR(cMessage,1,AT(";",cMessage)-1 ) )
   cMessage := STUFF(cMessage,1,AT(";",cMessage), "" )
END
IF "" != cMessage
   // add remaining message string to array
   AADD(aMessage,cMessage)
END
nMsgLen := LEN(aMessage)

// determine box length based on largest message line
AEVAL( aMessage, {|aArray| nBoxLen := MAX(nBoxLen,LEN(aArray)+4) })

nPromLen  += ( (LEN(aChoices)+1) * 2 )
cColor    := IIF( ISCOLOR(), IIF( cColor == NIL,"W+/BG,N/W+",cColor),"N/W,W+/N")
lBell     := IIF( lBell == NIL, .F., lBell )
nTopRow   := IIF( nTopRow == NIL, 10, nTopRow )

// test for the larger of box length vs. length of prompt line
nBoxWidth := IIF( nBoxLen > nPromLen, nBoxLen, nPromLen + 4 )
lVertical := ( MAXCOL() - nBoxWidth ) / 2 < 0

IF lVertical
   nBoxWidth:=nBoxLen
   AEVAL( aChoices, {|aArray| nBoxWidth := MAX( nBoxWidth,LEN(aArray)) })
   nBoxLeft  := ( MAXCOL() - nBoxWidth ) / 2
   nBoxRight := nBoxLeft + nBoxWidth + 2
   nPromLeft := nBoxLeft 
ELSE
   nBoxLeft  := ( MAXCOL() - nBoxWidth ) / 2
   nBoxRight := nBoxLeft + nBoxWidth
   nPromLeft := ( ( MAXCOL()-nPromLen ) / 2) 
END

// save the original screen
DISPBEGIN()

SETCOLOR( cColor )
// display Alert box

nMaxBottom := nTopRow+nMsgLen+IF(lVertical,LEN(aChoices)+1,2)+1
IF nMaxBottom > MAXROW()-1
   nTopRow -= nMaxBottom - MAXROW()
   nMaxBottom := MAXROW()
END

cScreen:=SAVESCREEN(nTopRow, nBoxLeft, nMaxBottom, nBoxRight+1)
@ nTopRow, nBoxLeft, nMaxBottom, nBoxRight+1 BOX "Ŀ " 

FOR n:=1 TO nMsgLen
   @ nTopRow+n,nBoxLeft+1 SAY PADC( aMessage[n], nBoxWidth, SPACE(1) )
NEXT

nCol       := nPromLeft + IF(lVertical,1,3 )
cOldWrap   := SET( 35, "ON" )
lOldCenter := SET( 37, .F. )

// Display the prompt line
nRow:=ROW()+2
FOR n:=1 TO LEN( aChoices )
   IF lVertical
      IF nTime==NIL
         @ nRow+n-1, nCol PROMPT SPACE(1)+aChoices[n]+SPACE(1)
      ELSE
         @ nRow+n-1, nCol SAY SPACE(1)+aChoices[n]+SPACE(1)
      END
   ELSE
      IF nTime==NIL
         @ nRow, nCol PROMPT SPACE(1)+aChoices[n]+SPACE(1)
      ELSE
         @ nRow, nCol SAY SPACE(1)+aChoices[n]+SPACE(1)
      END
      nCol += LEN(aChoices[n])+4 
   END
NEXT
DISPEND()

IF lBell
   // sound bell
   TONE(499,2)
   TONE(299,1)
ENDIF
IF nTime == NIL
   MENU TO nChoice
ELSE
   nCur:=SETCURSOR(0)
   INKEY( nTime )
   //KEYBOARD CHR(K_ESC)
   //MENU TO nChoice
   SETCURSOR(nCur)
   ClearBuffer()
END
// restore some settings here
SET( 35, cOldWrap )
SET( 37, lOldCenter )
SETBLINK( lOldBlink )
RESTSCREEN(nTopRow, nBoxLeft, nMaxBottom, nBoxRight+1,cScreen)
SETCOLOR( cOldColor )
SETKEY(K_PGUP, bPgUp )
SETKEY(K_PGDN, bPgDn )

RETURN IF( (LASTKEY()=K_ESC.OR.LASTKEY()=K_PGUP.OR.LASTKEY()=K_PGDN),0,nChoice)










