/*
 *
 *   MEMODEMO.PRG
 *   Version 1.01
 *
 *   Demonstration program for MEMOGET's.
 *
 *   Copyright (c) 1995 by John Fretwell
 *   All Rights Reserved Worldwide
 *
 */

#include "MGET.CH"  // MEMOGET include file
#include "BOX.CH"
#include "COMMON.CH"
#include "INKEY.CH"
#include "SETCURS.CH"

#define CLR_GET "N/W,N/BG"

function Main()
  local getlist := {}
  local cName, cAddress, cCity, cState, cZip, mMiscinfo, mNotes, dUpdated

  SET SCOREBOARD OFF

  // Set the insert key to toggle both the insert mode and the cursor
  setkey( K_INS, {|| setcursor( ;
         if( readinsert( ! readInsert() ), SC_NORMAL, SC_INSERT ) ) } )

  // Static text
  dispbox( 0, 0, maxrow(), maxcol(), replicate( chr(177),9 ), "N/B" )
  dispbox(  0,  0,  3, 79, B_SINGLE + space(1), "B/BG" )
  @  1,  2 say "MGet Demo Program 1.0"  color "B/BG"
  @  1, 65 say "John Fretwell"          color "B/BG"
  @  2,  2 say "Created 03/05/95"       color "B/BG"
  @  2, 63 say "CIS #70751,3560"        color "B/BG"

  dispbox(  5,  2, 23, 77, B_DOUBLE + space(1), "GR+/B" )
  @  6,  5 say "Name...: "       color "W+/B"
  @  7,  5 say "Address: "       color "W+/B"
  @  8,  5 say "City...: "       color "W+/B"
  @  8, 43 say "State: "         color "W+/B"
  @  8, 56 say "Zipcode: "       color "W+/B"
  @ 10,  5 say "Miscellaneous: " color "W+/B"
  @ 16,  5 say "Notes: "         color "W+/B"
  @ 22,  5 say "Last updated: "  color "W+/B"

  use SAMPLE new
  cName     := SAMPLE->NAME
  cAddress  := SAMPLE->ADDRESS
  cCity     := SAMPLE->CITY
  cState    := SAMPLE->STATE
  cZip      := SAMPLE->ZIP
  mMiscinfo := SAMPLE->MISCINFO
  mNotes    := SAMPLE->NOTES
  dUpdated  := SAMPLE->UPDATED

  // Set block to be evaled when memo limit is reached
  MemoLimitBlock( {|| tone( 100, 2 ), tone( 0, 1 ) } )

  @  6, 14 get cName    color CLR_GET
  @  7, 14 get cAddress color CLR_GET
  @  8, 14 get cCity    color CLR_GET
  @  8, 50 get cState   color CLR_GET
  @  8, 65 get cZip     color CLR_GET
  @ 11,  5, 14, 74 memoget mMiscInfo valid !empty( mMiscInfo ) ;
                   color CLR_GET limit 50
  @ 17,  5, 20, 74 memoget mNotes when !empty( cName )         ;
                   valid !empty( mNotes ) color CLR_GET
  @ 22, 19 get dUpdated color CLR_GET

	read

  // Save Data if we didn't ESC
  if !( lastkey() == K_ESC )
    SAMPLE->NAME     := cName
    SAMPLE->ADDRESS  := cAddress
    SAMPLE->CITY     := cCity
    SAMPLE->STATE    := cState
    SAMPLE->ZIP      := cZip
    SAMPLE->MISCINFO := mMiscinfo
    SAMPLE->NOTES    := mNotes
    SAMPLE->UPDATED  := dUpdated
	endif

  SAMPLE->( dbclosearea() )

return NIL
