* FILE ........: MEMO_GET.PRG
*****************************************************************************
* PROGRAM......: MGET()
* AUTHOR.......: Dale L. Clark
* DATE.........: 1/15/89
* COPYRIGHT....: Dale L. Clark, 1989.  Placed in the Public Domain.
* DESCRIPTION..: This function is used to simulate a GET on clipper memo
*                fields to reduce code size of applications using memo fields.
*
* SYNTAX.......: MGET( <expC1> , <expN1> , <expN2> , <expN3> , <expN4>
*                      [ , <expL1> [ ,<expC2> [ , <expN5> [ ,<expN6> ] ] ] ] )
*
* RETURNS......: Logical .F. if improper required parameters are passed,
*                otherwise it return a logical .T.
*
* NOTE.........: This function uses a variable called MGET1.  You should
*                declare this variable as PRIVATE at the highest level of
*                your program, otherwise the variable will be declared as
*                a PUBLIC within this function and memory fragmentation may
*                result.
*****************************************************************************
FUNCTION MGET
*
PARAMETERS mname,mtop,mleft,mbottom,mright,medit,mudf,mlen,mtabs
PRIVATE    mname,mtop,mleft,mbottom,mright,medit,mudf,mlen,mtabs
*
* Test the required parameters for proper type.
IF TYPE("M->mname") + TYPE("M->mtop") + TYPE("M->mleft") + ;
                      TYPE("M->mbottom") + TYPE("M->mright") != "CNNNN"
   RETURN(.F.)        && Return .F. if any bad required parameters are passed.
ENDIF
*        Insure that the optional parameters are fixed with proper type and
*        assign default values to uninitialized parameters.
*
M->mudf  = IF(TYPE("M->mudf") = "C", '"'+M->mudf+'"', '"MGET_F"')
M->mlen  = IF(TYPE("M->mlen") = "N", M->mlen, (M->mright - M->mleft - 1))
M->mtabs = IF(TYPE("M->mtabs") = "N", M->mtabs, 4)
M->medit = IF(TYPE("M->medit") = "L", IF(M->medit, ".T.", ".F."), ".T.")
*
* Build a parameter list string to be passed to the valid VAL_MGET function
*
PRIVATE    parmlist,mcolor
parmlist = '"' + mname + '",' + STR(M->mtop,3,0) + ',' + STR(M->mleft,3,0);
  +  ',' + STR(M->mbottom,3,0) + ',' + STR(M->mright,3,0) + ',' + M->medit;
  +  ',' + M->mudf + ',' +  STR(M->mlen,3,0) + ',' + STR(M->mtabs,3,0)
*
*          Ensure that the variable MGET1 is available for the READ command.
IF TYPE("MGET1") = "U"
   PUBLIC mget1
ENDIF
mget1 = ""                            && Set MGET1 to contain a null string.
*
*         Display the memo field (using MEMOEDIT) in the GET editing colors.
mcolor = SETCOLOR(HIGHLIGHT())
MEMOEDIT(&mname,M->mtop,M->mleft,M->mbottom,M->mright,.F.,27,mlen,mtabs)
SETCOLOR(mcolor)
*
* Reset the color and do a GET on the empty variable.  The parameter list
* passed to the VAL_MGET function is MACROed to prevent timing conflicts.
*
@ M->mtop,M->mleft GET mget1 VALID VAL_MGET(&parmlist.)
RETURN(.T.)   && Return!
*****************************************************************************
* PROGRAM......: VAL_MGET()
* AUTHOR.......: Dale L. Clark
* DATE.........: 1/15/89
* COPYRIGHT....: Dale L. Clark, 1989.  Placed in the Public Domain.
* DESCRIPTION..: This function is used to simulate a GET on clipper memo
*                fields.  Normally this function will be used as a VALID
*                function for a variable MGET1 which is a NULL string when
*                the READ is encountered.
*
* NOTE.........: This function uses a variable called MGET1.  This variable
*                must be declared and assigned a NULL string value prior to
*                the execution of the READ.  No error checking is done on
*                this function as it is to be used with the MGET function and
*                is not normally called directly.
*****************************************************************************
FUNCTION VAL_MGET      && Called during the validation of GET for MGET1
*
PARAMETERS vname,vtop,vleft,vbottom,vright,vedit,vudf,vlen,vtabs
PRIVATE    vname,vtop,vleft,vbottom,vright,vedit,vudf,vlen,vtabs
PRIVATE    key,vscreen,vmemo,vcolor
*
IF LEN(M->MGET1) > 0   && Test to see if this is the second pass through!
   M->MGET1 = ""       && If it is, shrink MGET1 back to a NULL string
   RETURN(.T.)         && and return a .T. to allow leaving the field.
ENDIF
*
M->key = INKEY(0)                   && capture the keystroke
*
* <down arrow> or <Enter> returns .T. (normal drop-through keys)
IF M->key = 24 .OR. M->key = 13
   RETURN(.T.)
ENDIF
*
* Check for problem keys  <Esc>,<Ctrl>+<W>,<PgUp>,<PgDn>,<up arrow>.
* Each of these keys will only work properly during a normal GET so we must
* expand the field to be 1 character wide and stuff the key board with the
* appropriate keystoke.
*
IF STR(M->key,2,0) $ "27,23, 3,18, 5"
   M->MGET1 = SUBSTR(&vname. + " ",1,1)
   KEYBOARD CHR(M->key)               && Stuff the keyboard with the keystroke
   RETURN(.F.)                        && Return .F. to start the second pass.
ENDIF
*
* If it is not a problem keystroke, just pass the keystroke into MEMOEDIT()
*
KEYBOARD CHR(M->key)
SAVE SCREEN TO M->vscreen        && Just in case the UDF changes the screen.
vcolor = SETCOLOR(HIGHLIGHT())
M->vmemo = MEMOEDIT(&vname.,M->vtop,M->vleft,M->vbottom,M->vright,;
                     M->vedit,M->vudf,M->vlen,M->vtabs)
IF .NOT. (M->vmemo == &vname.)               && If changes were made,
   REPLACE &vname. WITH M->vmemo             && REPLACE the memo field.
ENDIF
RESTORE SCREEN FROM M->vscreen               && Display the memo again
MEMOEDIT(&vname,M->vtop,M->vleft,M->vbottom,M->vright,.F.,27,vlen,vtabs)
SETCOLOR(vcolor)
RETURN(.T.)                                  && Return .T., you are done!
*****************************************************************************
* PROGRAM......: MGET_F()
* AUTHOR.......: Dale L. Clark
* DATE.........: 1/15/89
* COPYRIGHT....: Dale L. Clark, 1989.  Placed in the Public Domain.
*
* DESCRIPTION..: This function is used to as the default MEMOEDIT UDF
*                for the MGET() function.  This function provides relative
*                cursor position and Insert statuswhile in MEMOEDIT.
*****************************************************************************
FUNCTION MGET_F                              && Default UDF for MGET()
PARAMETERS status,line,column
IF M->status = 3
   @ 23, 0 CLEAR
   @ 23, 0 SAY "Press <Ctrl>+<W> to save changes or <Esc> to discard."
   @ 24, 0 SAY IF(READINSERT(),"Insert   ", "Overwrite")
ENDIF
IF LASTKEY() = 22
   @ 24,  0 SAY IF(.NOT. READINSERT(),"Insert   ", "Overwrite")
ENDIF
@ 24, 20 SAY "Current position is line " + LTRIM(STR(M->line,4,0)) ;
             + ", " + "Column " + LTRIM(STR(M->column,4,0)) + "   "
RETURN(0)
*************************************************************************
* PROGRAM......: HIGHLIGHT()
* AUTHOR.......: Dale L. Clark
* DATE.........: 1/15/89
* COPYRIGHT....: Dale L. Clark, 1989.  Placed in the Public Domain.
*
* DESCRIPTION..: This function is returns the current GET color.
*****************************************************************************
FUNCTION HIGHLIGHT            && Returns the color of a GET.
PRIVATE hilite
EXTERNAL SETCOLOR
hilite = SETCOLOR()
hilite = SUBSTR( hilite, AT( "," , hilite ) + 1 )
RETURN( SUBSTR( hilite, 1, AT( "," , hilite ) - 1 ) )
*****************************************************************************
* EOF - MEMO_GET.PRG