*****************************************************************************
** Author Mark H. Kania  -- Written in Feb or Mar of 1990.    CIS# 76270,2436
**
** ASP Member and author of the BUILDER code generator.
** Look for file BLDR10.ZIP in LIB 7 of the CIS CLIPPER forum for the code
** generator. (end of sales pitch)
**
** This is my standard procedure to call MEMOEDIT() which allows restricting
** the number of lines that can be editted.  Note that if the memo is ALREADY
** greater than the maximum lines, the whole memo will still be read into
** memory but the cursor will not be allowed past the maximum lines passed
** to this proc.
**
** This was uploaded because of the incredible demand during the course of
** a thread started in mid July of 1993.  The thread was about restricting
** the number of lines entered into a memo field.  Here is my solution, I
** am embarassed as to its simplicity.  I hope this does the job for
** everyone who has asked.
*****************************************************************************

*****************************************************************************
** PROC SHOW_MEMO
**
** generic proc to display/edit a memo field
**
** Pass:
** M_TOP       Numeric     Top row screen coordinate for MEMOEDIT()   Required
**                         function.
** M_LEFT      Numeric     Left column screen coordinate.             Required
** M_BOTTOM    Numeric     Bottom row screen coordinate.              Required
** M_RIGHT     Numeric     Right column screen coordinate.            Required
**
** M_FIELD     Memo        field name-pass the name of a memvar here  Required
**                         as a  quoted literal (i.e. "M_MEMFIELD")
**
** M_EDIT      Logical     if .T. edit.  If .F. display only.         Optional
**                         Default value is .F..
** M_TXT_CLR   Character   SET COLOR TO value.                        Optional
**                         Default is current color.
** M_MAXLNS    Numeric     Maximum edittable line count.              Optional
**                         Default is zero, which is unlimited.
**
** M_EDITEND   Logical     If .T. start editting at end of memo.      Optional
**                         If .F. start editting at beginning of memo.
**                         Default is .F..
**
*****************************************************************************

proc show_memo
  priv m_top,m_left,m_bottom,m_right,m_field,m_edit,m_txt_clr, ;
     m_maxlns,old_clr,m_editend,m_iline,m_icol,m_wrow,m_wcol
  para m_top,m_left,m_bottom,m_right,m_field,m_edit,m_txt_clr, ;
     m_maxlns,m_editend

  if pcount()<9
    m_editend=.f.
  endi
  if pcount()<8
    m_maxlns=0
  endi
  if pcount()<7
    m_txt_clr=setcolor()
  endi
  if len(m_txt_clr)=0
    m_txt_clr=setcolor()
  endi
  if pcount()<6
    m_edit=.f.
  endi
  old_clr=setcolor(m_txt_clr)
  if pcount()<7
*   set colo to (wmsg_clr)     **<<< my defalut color memvar
  else
    set colo to (m_txt_clr)
  endi

  m_iline=0
  m_wrow=0
  m_icol=0
  m_wcol=0

  if m_editend
    m_iline=mlcount(&m_field,m_right-m_left-1)
    m_wrow=int((m_bottom-m_top)*.5)
    m_icol=len(trim(memoline(&m_field,m_right-m_left-1, ;
             mlcount(&m_field,m_right-m_left-1))))+1
    m_wcol=m_icol
  endi

  &m_field=memoedit(&m_field,m_top+1,m_left+1,m_bottom-1,m_right-1, ;
      m_edit,"MEMFUNC",m_right-m_left-1,4,m_iline,m_icol,m_wrow,m_wcol)

  set colo to (old_clr)
  retu
  memfunc()          && this always links in MEMFUNC when SHOW_MEMO is
                     && called.

*************************************************************************
** UDF executed on every memo key press
**
func memfunc
  para zmode,zline,zcol         && these passed by Clipper MEMOEDIT()

  ** uncomment message to display Line and Column numbers
  *message("L"+alltrim(str(zline))+" C"+alltrim(str(zcol)),24,70,9,msg_clr)

  ** logic to only allow m_maxlns of text
  **
  if m_maxlns>0 .and. zline>m_maxlns
    if m_edit
      errtone(1)
    endi
    keyboard chr(5)     && up arrow
    retu(0)
  endi
  retu(0)
