;* $Header$
;**************************************************************************
;* Program Name: member.asm                                                   *
;* Author: Matthew Colegrove                                              *
;*************************** ALL RIGHTS RESERVED **************************
;* Created: 3-5-1992 at 1:55pm                                            *
;* $Revision$   $Modtime$
;**************************************************************************
;*
;* $Log$
;*
;
;* USAGE:   NW_MEMBER ("group")    where group is a NW group in the bindery
;*
;* Returns: .T. if userid running program belongs to "group", otherwise .f.
;*
;*
;* This program is released to the public domain by the author.
;*
;*
PUBLIC     nw_member

extrn     __parC:FAR
extrn     __parCLen:Far
extrn     __retL:FAR

DGROUP     GROUP   grp_data

grp_data   SEGMENT PUBLIC  'DATA'

; get connection info request buffer
gci_req    dw     2h                        ; buffer length
           db    16h                        ; subfunction 16h
i_conid    db     0                         ; connection number

; get connection info reply buffer
gci_rep    dw    62h                        ; buffer length
o_id       dd     0                         ; object id
o_type     dw     0                         ; object type
o_name     db    48 dup (0)                 ; object name (asciiz)
o_login    db     7 dup (0)                 ; login time
           db     0                         ; undocumented byte

; is object in set request buffer
iois_req   dw   120                         ; buffer length (max 120 bytes)
           db    43h                        ; subfunction 43h
ob_type    dw     0                         ; object type
ob_nlen    db     0                         ; object name length byte
ob_name    db   115 dup (0)                 ; remainder of buffer  

; is object in set reply buffer
iois_rep   dw     0                         ; length of buffer (0)

; working variables
property   db    'GROUPS_I''M_IN',0         ; property name (max 15 + NIL)
prop_len   equ   ($-property-1)             ; length of property name

group_name db    32 dup (0)                 ; group name
gname_len  db     0                         ; group name length

dest_off   dw     0                         ; destination offset
dest_tar   dw     0                         ; destination target

grp_data   ENDS

_Prog      SEGMENT 'CODE'
           ASSUME cs:_Prog, ds:DGROUP, es: DGROUP

nw_member   PROC    FAR

           push   bp                        ; Save registers as req by Clipper
           mov    bp,sp
           push   ds
           push   es
           push   si
           push   di

           ; load DS and ES with location of DATA segment

           mov    ax,dgroup
           mov    ds,ax
           mov    es,ax

           ; get group name passed as parameter from Clipper
           ; first get parameter length

           push   es                        ; save ES before Clipper calls
           mov    ax,1                      ; first parameter
           push   ax
           call   __parclen                 ; returns length in AX
           mov    [gname_len],al            ; save length
           add    sp, 2                     ; fix up stack

           ; now get group name parameter

           mov    ax,1
           push   ax
           call   __parc                    ; returns DX:AX pointer to string
           add    sp, 2

           pop    es                        ; restore ES to value before Cliper calls
           mov    di,OFFSET dgroup:group_name      ; destination of string
           xor    ch,ch                     ; clear ch
           mov    cl,[gname_len]            ; move string length to CX
           mov    ds,dx                     ; segment pointer to parameter
           mov    si,ax                     ; offset pointer to parameter
       rep movsb                            ; copy string to destination

           mov    es:byte ptr [di], 0h      ; place a zero byte after the parameter

           mov    ax,dgroup                 ; restore DS pointer to data segment
           mov    ds,ax

; get connection number -- Netware API

           mov    ax,0dc00h                 ; function DCh
           int    21h                       ; call interrupt

; get connection info -- Netware API

           mov    [i_conid],al              ; load connection number
           mov    si,OFFSET dgroup:gci_req         ; load SI with request buffer
           mov    di,OFFSET dgroup:gci_rep         ; load DI with reply buffer
           mov    ax,0e300h                 ; function E3h
           int    21h                       ; call interrupt

           cmp    al,0
           jne    failed

; is object in set   -- Netware API
; copy object type from buffer to buffer

           mov    si,OFFSET dgroup:o_type          ; iois_req buffer
           mov    di,OFFSET dgroup:ob_type
           movsw                            ; move word and inc SI and DI by 2

; copy object name from buffer to buffer
           mov    dest_off,di               ; save DI
           inc    di                        ; skip over length byte
           call   CopyString                ; copy object name to iois_req buf

           mov    [dest_tar],di             ; save position of DI
           mov    di,[dest_off]             ; move offset of length byte to DI
           mov    [di],cl                   ; move length byte into buffer

           mov    di, [dest_tar]            ; restore pointer to last position of buffer

; copy property length byte
           mov    al,prop_len               ; move length of property string to AL
           stosb                            ; move length to output buffer

; copy property string
           mov    si,OFFSET dgroup:property
           call   CopyString                ; copy property string to output buf

           inc    di                        ; skip high order byte
           mov    al,2                      ; set up member type (2 == GROUP type)
           stosb                            ; copy to request buffer

           mov    [dest_off],di             ; save position of length byte
           inc    di                        ; leave a space
           mov    si,OFFSET dgroup:group_name
           call   CopyString

           mov    di,[dest_off]
           mov    [di],cl

; should be finished loading request buffer, now set ES:DI, DS:SI
; pairs to point to proper buffers for int 21h call

           mov    si,OFFSET dgroup:iois_req        ; load DS:SI with adr of req buf
           mov    di,OFFSET dgroup:iois_rep        ; load es:di with adr of reply buf

           mov    ax,0e300h                 ; load and call function
           int    21h

           cmp    al,0
           je     success
           jmp    failed

success:
           mov    ax,1                      ; load True in AX
           push   ax
           call   __retL                    ; call Clipper function
           add    sp, 2                     ; ajust stack pointer

           jmp    exit                      ; then get out

failed:      
           xor    ax,ax                     ; clear AX == loads False
           push   ax
           call   __retL                    ; call Clipper function
           add    sp, 2                     ; then get out

exit:   
           pop    di                        ; Restore registers
           pop    si
           pop    es
           pop    ds
           pop    bp

           ret

nw_member   ENDP                             ; End of routine
;
; subroutine to copy string from one memory location to another
;
; source string DS:SI
; target string ES:DI
;
; registers destroyed:  SI, DI, AL, CX
;
CopyString PROC
           cld                              ; inc direction flag
           xor   cx,cx                      ; clear cx

CopyStringLoop:
           lodsb                            ; load al with byte from ds:si
           cmp   al,0                       ; is it end of the string (0)
           je    CopyExit                   ; if end of string, get out

           inc   cl                         ; increment string length counter
           stosb                            ; move byte to destination (es:di)
           jmp   CopyStringLoop             ; cycle around again

CopyExit:
           ret

CopyString ENDP                             ; end of proc CopyString

_Prog      ENDS                             ; End of code segment
           END
