**********************************************************
* MATFUNC.PRG - Multi-Dimension Array Handling Functions *
* Copyright(c) 1989, 3P Software // All Rights Reserved  *
* Notes:                                                 *
*   These functions are released into the Public Domain  *
*   by 3P Software providing the following conditions    *
*   are adhered to:                                      *
*     1) The Copyright notice above must not be removed. *
*     2) Any revisions must be indicated below and all   *
*        credits due to any revising author will be      *
*        maintained.                                     *
* -------------------------------------------------------*
*  November 01, 1989 - Pedro P. Polakoff III             *
*                      Original Release of this Code     *
**********************************************************


* Function: MATRIX
* Purpose : Creates a Mult-Dimension Matrix
* Syntax  : MATRIX("MatrixName",Dim-1,Dim-2)
* Returns : Logical Status of operation
* Notes   : Allows Maximum of 8 significant characters in the Matrix Name
*
function matrix
parameters _an,_d1,_d2
private _a1,_a2,_stat
  _stat=.f.
  if(pcount()=3 .and. type("_an")="C" .and. type("_d1")="N" .and. type("_d2")="N")
    _a1=substr(_an,1,8)+"1"
    _a2=substr(_an,1,8)+"2"
    public &_a1.[_d1]
    public &_a2.[(_d1*_d2)]
    afill(&_a1.,chr(0))
    afill(&_a2.,chr(0))
    _stat=.t.
  endif
return(_stat)  


* Function: MATPUT
* Purpose : Places a Value into a Matrix
* Syntax  : MATPUT("MatrixName",Dim-1,Dim-2,Value)
* Returns : Logical Status of Operation
* Notes   : Maximum of 8 significant characters in Matrix Name,
*           0 as Dim-2 defaults to Matrix level 1 element.
*
function matput
parameters _an,_d1,_d2,_va
private _a1,_a2,_stat,_c,_ss
  _stat=.f.
  if(pcount()=4 .and. type("_an")="C" .and. type("_d1")="N" .and. type("_d2")="N")
    _a1=substr(_an,1,8)+"1"
    _a2=substr(_an,1,8)+"2"
    if (_d2==0)
      &_a1.[_d1]=_va
    else
      _ss=(len(&_a2.)/len(&_a1.))
      _c=((_ss*_d1)-(_ss-_d2))
      &_a2.[_c]=_va
    endif
    _stat=.t.
  endif
return(_stat)  

* Function: MATGET
* Purpose : Returns a value from a matrix
* Syntax  : MATGET("MatrixName",Dim-1,Dim-2)
* Returns : Value that resides in the element of the matrix
* Notes   : Maximum of 8 significant characters in Matrix Name,
*           0 as Dim-2 defaults to Matrix level 1 element.
*
function matget
parameters _an,_d1,_d2
private _a1,_a2,_stat,_c,_ss
  if(pcount()=3 .and. type("_an")="C" .and. type("_d1")="N" .and. type("_d2")="N")
    _a1=substr(_an,1,8)+"1"
    _a2=substr(_an,1,8)+"2"
    if (_d2==0)
      _stat=&_a1.[_d1]
    else
      _ss=(len(&_a2.)/len(&_a1.))
      _c=((_ss*_d1)-(_ss-_d2))
      _stat=&_a2.[_c]
    endif
  else
    _stat=chr(0)
  endif
return(_stat)  

