*:*********************************************************************
*:
*:        Program: MAKECODE.PRG
*:
*:         System: INITIALIZE
*:         Author: Joe Mariner aka Piper on Borland/ATBBS
*:      Copyright (c) 1991, Joe Mariner
*:  Last modified: 11/05/91     20:31
*:
*:  Procs & Fncts: MAKEINIT
*:               : MAKEPUBL
*:               : MAKEREPL
*:               : MAKECOND
*:
*:          Calls: MAKEINIT       (procedure in MAKECODE.PRG)
*:               : MAKEPUBL       (procedure in MAKECODE.PRG)
*:               : MAKEREPL       (procedure in MAKECODE.PRG)
*:               : MAKECOND       (procedure in MAKECODE.PRG)
*:
*:    Other Files: DBSETUP.PRG
*:
*:      Documented 11/05/91 at 20:32                SNAP!  version 4.02d
*:*********************************************************************

** MAKE SURE YOU DON'T HAVE A DIFFERENT 'DBSETUP.PRG' IN THE DEFAULT DIR
PARA fil
IF FILE('dbsetup.prg')
   !del dbsetup.*
ENDI
SET ALTE TO dbsetup.prg
DO makeinit WITH fil,'6'
DO makepubl WITH fil,'6'
DO makerepl WITH fil,'8'
DO makecond WITH fil
RETURN

*!*********************************************************************
*!
*!      Procedure: MAKEINIT
*!
*!      Called by: MAKECODE.PRG
*!
*!           Uses: (FIL).DBF      
*!
*!    Other Files: DBSETUP.PRG
*!
*!*********************************************************************
PROC makeinit
** PASS IN FILE NAME AND NUMBER OF FIELDS TO INCLUDE ON EACH LINE
** (NUMERIC, LOGICAL AND DATE ONLY)
** Joe Mariner 12/04/90

PARA fl,num
num = VAL(num)
SET TALK OFF
PRIV field_nm,fldcnt,file_nm,fldtot,cycle,stopcnt,fldlen,fil,hit
STOR fl TO fil
STOR 0 TO fldlen
STOR 1 TO fldcnt,fldtot,cycle,hit
STOR 4 TO stopcnt
USE (fil) in 1 EXCL
SELE 1
GO BOTT

DO WHIL fldtot < 129 .AND. '' <> FIELD(fldtot)
   fldtot = fldtot +1
ENDD
SET ALTE TO dbsetup.prg ADDI
SET ALTE ON
? "** These 'make' procs (makeinit, makepubl, makerepl, makecond) courtesy of:"
? "** Joe Mariner aka Piper on Borland/ATBBS"
??
? "****---------"
? "PROC makeinit"
DO WHIL cycle < stopcnt
   DO WHIL fldcnt <= fldtot
      field_nm  = FIELD(fldcnt)
      IF TYPE(FIELD(fldcnt)) = 'L'
         IF  hit = 1 .OR. 0 = MOD(hit,num)
            ? "STORE " + ".F." + " TO m->" + field_nm
         ELSE
            ?? ", m->" + field_nm
         ENDI
         hit = hit + 1
      ENDI
      fldcnt = fldcnt + 1
   ENDD
   cycle  = cycle + 1
   fldcnt = 1
   hit = 1
   
   DO WHIL fldcnt <= fldtot
      field_nm  = FIELD(fldcnt)
      IF TYPE(FIELD(fldcnt)) = 'D'
         IF hit = 1 .OR. 0 = MOD(hit,num)
            ? "STORE " + "{  /  /  }" + " TO m->" + field_nm
         ELSE
            ?? ", m->" + field_nm
         ENDI
         hit = hit + 1
      ENDI
      fldcnt = fldcnt + 1
   ENDD
   cycle  = cycle + 1
   fldcnt = 1
   hit = 1
   
   DO WHIL fldcnt <= fldtot
      field_nm  = FIELD(fldcnt)
      IF TYPE(FIELD(fldcnt)) = 'C'
         STOR &field_nm TO &field_nm
         fldlen = LTRIM(STR(LEN(&field_nm)))
         ? "STORE SPACE(" + fldlen + ") TO m->" + field_nm
      ENDI
      fldcnt = fldcnt + 1
   ENDD
   cycle  = cycle + 1
   fldcnt = 1
   hit = 1
   
   DO WHIL fldcnt <= fldtot
      field_nm  = FIELD(fldcnt)
      IF TYPE(FIELD(fldcnt)) = 'N'
         IF hit = 1 .OR. 0 = MOD(hit,num)
            ? "STORE " + "0" + " TO m->" + field_nm
         ELSE
            ?? ", m->" + field_nm
         ENDI
         hit = hit + 1
      ENDI
      fldcnt = fldcnt + 1
   ENDD
   cycle  = cycle + 1
   fldcnt = 1
   hit = 1
   
ENDD
USE
SET ALTE OFF
SET ALTE TO
SET TALK ON
RETU

*!*********************************************************************
*!
*!      Procedure: MAKEPUBL
*!
*!      Called by: MAKECODE.PRG
*!
*!           Uses: (FIL).DBF      
*!
*!    Other Files: DBSETUP.PRG
*!
*!*********************************************************************
PROC makepubl
** PASS IN FILE NAME AND NUMBER OF FIELDS TO INCLUDE ON EACH LINE
** (NUMERIC, LOGICAL AND DATE ONLY)
** Joe Mariner 12/04/90

PARA fl,num
num = VAL(num)
SET TALK OFF
PRIV field_nm,fldcnt,file_nm,fldtot,cycle,stopcnt,fldlen,fil,hit
STOR fl TO fil
STOR 0 TO fldlen
STOR 1 TO fldcnt,fldtot,cycle,hit
STOR 3 TO stopcnt
USE (fil) in 1 EXCL
SELE 1
GO BOTT

DO WHIL fldtot < 129 .AND. '' <> FIELD(fldtot)
   fldtot = fldtot +1
ENDD
SET ALTE TO dbsetup.prg ADDI
SET ALTE ON
??
? "****---------"
? "PROC makepubl"
DO WHIL cycle < stopcnt
   DO WHIL fldcnt <= fldtot
      field_nm  = FIELD(fldcnt)
      IF TYPE(FIELD(fldcnt)) = 'L'
         IF  hit = 1 .OR. 0 = MOD(hit,num)
            ? "PUBL " + "m->" + field_nm
         ELSE
            ?? ", m->" + field_nm
         ENDI
         hit = hit + 1
      ENDI
      fldcnt = fldcnt + 1
   ENDD
   cycle  = cycle + 1
   fldcnt = 1
   hit = 1
   
   DO WHIL fldcnt <= fldtot
      field_nm  = FIELD(fldcnt)
      IF TYPE(FIELD(fldcnt)) = 'D' .OR. TYPE(FIELD(fldcnt)) = 'C'
         IF hit = 1 .OR. 0 = MOD(hit,num)
            ? "PUBL " + "m->" + field_nm
         ELSE
            ?? ", m->" + field_nm
         ENDI
         hit = hit + 1
      ENDI
      fldcnt = fldcnt + 1
   ENDD
   cycle  = cycle + 1
   fldcnt = 1
   hit = 1
   
   cycle  = cycle + 1
   fldcnt = 1
   hit = 1
   
   DO WHIL fldcnt <= fldtot
      field_nm  = FIELD(fldcnt)
      IF TYPE(FIELD(fldcnt)) = 'N'
         IF hit = 1 .OR. 0 = MOD(hit,num)
            ? "PUBL " + "m->" + field_nm
         ELSE
            ?? ", m->" + field_nm
         ENDI
         hit = hit + 1
      ENDI
      fldcnt = fldcnt + 1
   ENDD
   cycle  = cycle + 1
   fldcnt = 1
   hit = 1
   
ENDD
USE
SET ALTE OFF
SET ALTE TO
SET TALK ON
RETU

*!*********************************************************************
*!
*!      Procedure: MAKEREPL
*!
*!      Called by: MAKECODE.PRG
*!
*!           Uses: (FIL).DBF      
*!
*!    Other Files: DBSETUP.PRG
*!
*!*********************************************************************
PROC makerepl
** PASS IN FILE NAME AND NUMBER OF LINES TO REPEAT REPLACE

PARA fil,num
num = VAL(num)
USE (fil)
SET TALK OFF
PRIV field_nm,fldcnt,file_nm,fldtot
STOR 1 TO fldcnt,fldtot
DO WHIL fldtot < 129 .AND. '' <> FIELD(fldtot)
   fldtot = fldtot +1
ENDD
SET ALTE TO dbsetup.prg ADDI
SET ALTE ON
??
? "****---------"
? "PROC makerepl"
DO WHIL fldcnt < 129 .AND. '' <> FIELD(fldcnt)
   field_nm  = FIELD(fldcnt)
   IF 1 = fldcnt .OR. 0 = MOD(fldcnt,num)
      ? "REPL " + field_nm +" WITH m->"+field_nm
      IF fldcnt # fldtot-1
         ??",;"
      ENDI
   ELSE
      ? "   " + field_nm +" WITH m->"+field_nm
   ENDI
   IF 1 # fldcnt .AND. 0 # MOD(fldcnt,num) .AND. num-1 # MOD(fldcnt,num);
         .AND. fldcnt < fldtot-1
      ??",;"
   ENDI
   fldcnt = fldcnt + 1
ENDD
USE
SET ALTE OFF
SET ALTE TO
SET TALK ON
RETU

*!*********************************************************************
*!
*!      Procedure: MAKECOND
*!
*!      Called by: MAKECODE.PRG
*!
*!           Uses: (FIL).DBF      
*!
*!    Other Files: DBSETUP.PRG
*!
*!*********************************************************************
PROC makecond
** PASS IN FILE NAME ONLY
PARA fil
USE (fil) EXCL
PRIV field_nm,fldcnt,file_nm,fldtot,m_exact,m_talk
STOR 1 TO fldcnt,fldtot
STOR SET('EXAC') TO m_exact
STOR SET('TALK') TO m_talk
SET TALK OFF
SET EXACT ON
DO WHIL fldtot < 129 .AND. '' <> FIELD(fldtot)
   fldtot = fldtot +1
ENDD
SET ALTE TO dbsetup.prg ADDI
SET ALTE ON
??
? "****---------"
? "PROC condrepl"
? "STOR .F. to replflag"
? "PRIV m_exact"
? "STOR SET('EXAC') TO m_exact"
? "SET EXACT ON"
DO WHIL fldcnt < 129 .AND. '' <> FIELD(fldcnt)
   field_nm  = FIELD(fldcnt)
   DO CASE
   CASE TYPE(field_nm) = "C"
      ? "IF " + field_nm + " <> m->" + field_nm
   OTHE
      ? "IF " + field_nm + " <> m->" + field_nm
   ENDC
   ? "   REPL " + field_nm +" WITH m->"+field_nm
   ? "   STOR .T. TO replflag"
   ? "ENDI"
   fldcnt = fldcnt + 1
ENDD
? "set exact &m_exact"
USE
SET ALTE OFF
SET ALTE TO
SET EXACT &m_exact
SET TALK &m_talk
RETU

*: EOF: MAKECODE.PRG
