;
;               ͻ
;                                                       
;                     This program is adapted from      
;                                                       
;                              DTR and AT               
;                                  by                   
;                    Donavon Kuhn  &  Jon Niedfeldt     
;                               (c) 1985                
;                                                       
;                      Adaptation for Clipper (A86)     
;                                  by                   
;                              John Karns               
;                                                       
;                       Clipper/Modem Interface         
;                                                       
;                             CLIPDIAL.ASM              
;                                                       
;                            v1.0  10/25/88             
;                                                       
;               ͼ
;
;
;   Thank you Mssrs. Kuhn and Niedfeldt!
;
;   Calling syntax:  Call DIALIT with "Hayes command"
;                    where the hayes command is a character string
;                    without the AT on the front.  (Since all commands
;                    start with an AT, the module will supply it).
;
;                    COM1 is the default unless you specify otherwise.
;
;   Examples:
;            Call DIALIT with "Com2:DT1234567"  && Can use COM1 thru 4
;
;            Call DIALIT with "DT1234567" && Dial # 1234567 (default COM1)
;
;            Call DIALIT with "H"         && Hang up
;
;            (Upper or lower case may be used.)
;



upcase  macro   char
	local	nocvt

	ifb	<char>

	upcase	al

	else

	cmp	char,'a'
	jb	nocvt
	cmp	char,'z'
	ja	nocvt
	sub	char,32
nocvt:
	endif
	endm


	   PUBLIC  DIALIT


extrn     _PARC:far      ; Clipper's character 'getter'
extrn     _RETNI:far     ; Clipper's (Short) Integer 'returner'

;-------------------------- stack area begins --------------------+
stacks    segment   stack     ; stack segment starts here
	  dw        5 dup(0)  ; reserve 5 levels of stack with zeros
stacks    ends                ; stack segment ends

;-------------------------- data area begins ---------------------+
;
DGROUP  GROUP   datasg  ; Clipper's Data Segment

;               the 'public' in the next statement combines
;               the datasg to Clipper's DGROUP group

datasg    segment public  'DATA'

OFFVAL    dw      0             ; init with 0
SEGVAL    dw      0             ; init with 0

datasg    ends 	                ; end of datasg (in DGROUP)


;-------------------------- code area starts ---------------------+

_prog   segment    BYTE  'PROG'
        assume  cs:_prog,ds:datasg,ss:stacks


DIALIT          proc    far

        push    bp              ; preserve return address
        mov     bp,sp           ; move stack pointer

        mov     ax,1            ; get first para
        push    ax              ; push AX
        call    _PARC           ; call Chara "getter"
        add     sp,2            ; restore stack
	mov     OFFVAL,bx       ; get OFFSET address
	mov     SEGVAL,ax       ; get SEGMENT address

        push    ds              ; preserve DS
        push    es              ; preserve ES

        mov     ax,DGROUP       ; get DGROUP segment
        mov     es,ax           ; and place in ES

; in the next three statements, the order that it appears is
; important because the values of SI & AX must first be taken
; from the DATASG extension before assigning the DGROUP segment
; address to DS

	mov     si,OFFVAL
	mov     ax,SEGVAL
	mov     ds,ax
	xor     ax,ax           ; zero out AX
	mov     al,[si]         ; move first SI value to AL


;--------------------- Start "AT" routine -----------------------+
	jmp     start1

base	dw	0

start1:
	mov     bl,0                    ;default com port (COM1:)

	upcase                          ;using UPCASE without a parameter
	cmp     al,'C'                  ;(defaults to AL)
	jnz     nocom

	mov     cl,[si][1]
	upcase  cl                      ;using UPCASE using another register
	cmp     cl,'O'
	jnz     nocom

	mov     al,[si][2]
	upcase  al                      ;using UPCASE with AL as the parm
	cmp     al,'M'
	jnz     nocom

	cmp     byte ptr [si][4],':'
	jz      check_port

toohi:
	mov	bx,1
	jmp     alldone
notfound:
	mov	bx,2
	jmp     alldone

check_port:
	mov	al,[si][3]		; get the com number
	sub	al,'1'			; convert to binary
	cmp	al,3			; greater than com4?
	ja	toohi                   ; error code 1
	add     si,5                    ; set string pointer after colon
	mov     bl,al                   ; move the port # to bl

nocom:
	xor     bh,bh
	shl	bl,1
	mov     ax,40h
	push    ds                      ; preserve ds
	mov     ds,ax
	mov	ax,ds:[bx]
	pop     ds                      ; restore ds
	cmp	ax,0
	jnz	comok

	jmp	notfound

comok:
	push	ax
	call    dtr_on
	pop	ax
	mov     base,ax
	mov	al,'A'
	call	auxout
	mov	al,'T'
	call	auxout

outlp:
	mov     al,[si]
	inc     si
	call    crtest
	call    auxout
	cmp     al,13                   ; originally, a CHR(13) had to appended
	jnz     outlp

	xor	bx,bx			; error code 0 - no errors
	jmp     alldone


crtest  proc    near
	cmp     al,0                    ; chek 4 null terminator
	jne     notnull                 ; no, next char
	mov     al,13                   ; yes, add CR
notnull: ret
crtest  endp


dtr_on  proc    near
	mov     dx,ax
	add	dx,4
	in	al,dx
	or      al,3                    ;set dtr bit
	out     dx,al
	ret
dtr_on  endp


auxout  proc    near
	push	ax
	mov	dx,base
	add	dx,5

txlp:
	in	al,dx
	and	al,20h
	jz	txlp

	pop	ax
	sub	dx,5
	out	dx,al
	ret
auxout	endp


;-------------------------- code area ends ---------------------+

alldone:

	pop     es              ; restore
	pop     ds              ; restore
	pop     bp              ; restore

	mov     ax,DGROUP       ; get DGROUP address
	mov     ds,ax           ; assign to DS
	push    ds              ; push segment address

	push	bx		; error code
	call	_RETNI		; pass to Clipper
	pop	bx		; restore stack
	pop     ds              ; restore
	ret                     ; actual ret to caller
dialit  endp

_prog   ends                    ; end of segment
	end

