; File......: DEFAULT.ASM
; Author....: Ted Means
; Date......: $Date:   15 Aug 1991 23:06:40  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   E:/nanfor/src/default.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/default.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:06:40   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:22   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:12   GLENN
;  Nanforum Toolkit
;  
;


;  $DOC$
;  $FUNCNAME$
;     FT_DEFAULT()
;  $CATEGORY$
;     DOS/BIOS
;  $ONELINER$
;     Retrieve and optionally change the current default drive
;  $SYNTAX$
;     FT_DEFAULT( [ <cDrive> ] ) -> cDrive
;  $ARGUMENTS$
;     <cDrive> is optional, and if specified is the new default drive.
;  $RETURNS$
;     The current default drive.  If a change of default drive is requested,
;     the return value is the drive AFTER the change is made.  This allows
;     you to make sure you specified a valid drive (i.e. if you attempt to
;     change the default drive, and the function returns a different drive
;     letter than the one you specified, then the drive does not exist).
;  $DESCRIPTION$
;     Useful any time you need to know or change the default drive.
;
;     The source code is written to adhere to Turbo Assembler's IDEAL mode.
;     To use another assembler, you will need to rearrange the PROC and
;     SEGMENT directives, and also the ENDP and ENDS directives (a very
;     minor task).
;  $EXAMPLES$
;     cDrive := FT_DEFAULT()  && Get the current drive
;     FT_DEFAULT("C")         && Switch to drive C
;
;     IF FT_DEFAULT("E") != "E"
;        Qout( "Drive E does not exist!" )
;     ENDIF
;  $END$
;

         IDEAL

Public   FT_DEFAULT

Extrn    __ParInfo:Far
Extrn    __ParC:Far
Extrn    __RetC:Far

Drive    EQU       Word Ptr BP - 2

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     FT_DEFAULT          Far

         Push      BP                        ; Save BP
         Mov       BP,SP                     ; Set up stack reference
         Sub       SP,2                      ; Allocate space for drive

         Xor       AX,AX                     ; Prepare to count params
         Push      AX                        ; Save on stack
         Call      __ParInfo                 ; Retrieve param count
         Or        AX,AX                     ; Zero parameters passed?
         JZ        GetDrive                  ; If so, don't set drive

         Mov       AX,1                      ; Specify first parameter
         Push      AX                        ; Save parameter # on stack
         Call      __ParInfo                 ; Get param type
         Test      AX,1                      ; Parameter a character?
         JZ        GetDrive                  ; If not, don't set drive

         Mov       AX,1                      ; Select parameter #1
         Push      AX                        ; Save parameter # on stack
         Call      __ParC                    ; Retrieve it
         Mov       ES,DX                     ; Load segment value
         Mov       BX,AX                     ; Load offset value
         Mov       DL,[Byte Ptr ES:BX]       ; Get drive letter
         And       DL,0DFh                   ; Convert to uppercase
         Sub       DL,"A"                    ; ASCII to binary
         Mov       AH,0Eh                    ; DOS service--set default drive
         Int       21h                       ; Call DOS

GetDrive:Mov       AH,19h                    ; DOS service--get current drive
         Int       21h                       ; Call DOS
         Add       AL,"A"                    ; Binary to ASCII
         CBW                                 ; Zero terminate string
         Mov       [Drive],AX                ; Store default drive

Finish:  Push       SS                       ; Save segment on stack
         LEA        AX,[BP - 2]              ; Move offset to AX
         Push       AX                       ; Save offset on stack
         Call      __RetC                    ; Send return value to Clipper app
         Mov       SP,BP                     ; Restore SP
         Pop       BP                        ; Restore BP
         Ret
Endp     FT_DEFAULT
Ends     _NanFor
End

