    PAGE    60,132
    TITLE   ISCURSOR - Cursor on or off function for Clipper s'87
; Clipper S'87 function to test if the cursor is ON or OFF
; Entered into the Public Domain. Use at your own risk.
; Assembled with Microsift MASM  4.0
;
;  I would like to thank any and all of my fellow Clipper users who
;  share their work via NANSIG.  I was motivated to write this function
;  after incorporating some of the HELP and RULER PROC's and FUNCTIONS
;  into my applications.  If they are called from a MENU wait state
;  (when the cursor is OFF), they return with the cursor ON, a small
;  problem, but unsightly none the less.  This small function can be
;  used to test for the cursor state on entry into these procs, and
;  the result used to set the cursor on exit.
;
;  John Scott Prinke 6/14/88    Source: BFH594
;
; DISCUSSION:
;  Memory at 0000:0461 stores the starting scan
;  line of the cursor.  ( 0460 stores starting scan line)
;
;  IF the cursor is ON, starting scan line is 06H for CGA,
;                       0BH for EGA and Monochrome
;  Clipper seems to use the CGA mode for EGA displays.
;  IF the cursor is OFF, the starting scan line is 20H.
;
;  You can test this with DEBUG by writing a one liner in Clipper
;        SET CURSOR OFF
;  compiling, linking, and running it.
;  Then enter DEBUG, and at the -prompt, type "d 0000:0450".
;    The eight 2 byte words on the 0450 line are the hex number
;    columns and rows for the location of the cursor on the eight
;    respective text video pages.  If Clipper removed the cursor
;    by placing it off the page, these bytes would show it.  What
;    they show is the location of the cursor (if it was on) when you
;    typed the -d 0000:0450 command into debug.  Only the first (active)
;    video page shows a cursor location if your computer is anything
;    like mine.  Remember, they are in hex, or Base16 notation.
;
;  The first two hex bytes on the 0460 line are the starting and
;    ending scan lines for the cursor.  WHen the cursor is ON my EGA
;    (and CGA) read 07 06, for a typical vanilla cursor.  I have not tested
;    Monochrome or VGA's, but I would expect 0C 0B for the Monochrome.
;    When the cursor is OFF, I read 00 20.
;
;  By reading the memory at 0461, and comparing it to 20, this function
;    could return logical .T. or .F. for ON and OFF respectively.
;
;  Instead, I used the BIOS VIDEO SERVICE 3 to get the same information,
;  hopefully maintaining some "good programming practices."  Video
;  Service 3 : Read Cursor Position provides the starting and ending
;  scan lines, and the column and row of the cursor for the video page
;  identified in the BH register when it is called.  For this function,
;  all I need is the CH register, the starting scan line.
;
;
;
;  Reference  PROGRAMMER'S GUIDE TO THE IBM PC, 1985
;             PETER NORTON
;             pp 174-176, 92, 55

        PUBLIC  ISCURSOR           ; NAME OF FUNCTION AS PUBLIC
        EXTRN  __RETL:FAR          ; DECLARE CALLED FUNCTIONS EXTERNAL
                                   ; external function from Clipper
                                   ;   allowing return of Logical parm

  DGROUP GROUP         DATASG              ;Clipper's Data Segment
  DATASG SEGMENT       PUBLIC '_DATA'

  DATASG               ENDS

  _PROG                SEGMENT  'CODE'
                       ASSUME     CS:_PROG,DS:DGROUP,ES:DGROUP

  ;------------------- Save Current Registers Values -----------------

  ISCURSOR    PROC       FAR
              PUSH       BP              ; Save stack
              MOV        BP,SP
              PUSH       DS
              PUSH       ES
              PUSH       SI
              PUSH       DI
;-------------------  BIOS call  -------------------------------------
; BIOS CALL
        MOV AH, 3                   ;  VIDEO SERVICE 3
        MOV BH, 0                   ;  VIDEO PAGE 0 - FIRST (ACTIVE) PAGE
        INT 10H                     ;  VIDEO BIOS REQUEST
                                    ; returns start scan line - CH
                                    ; returns end scan line   - CL
                                    ; returns cursor row      - DH
                                    ; returns cursor colum    - DL
;------------------  Determine logical return value -------------------
        MOV BX, 0001H               ; START OUT AS TRUE, CHANGE IF FALSE
        CMP CH, 20H                 ; COMPARE WITH 20H (CURSOR OFF)
        JNE ISCURSOR_RET            ; JUMP OVER LOGICAL RESET IF CURSOR ON
        MOV BX, 0000H               ; RESET LOGIC TO .F. IF CURSOR OFF

  ;------------------- Restore Registers and Return ------------------

  ISCURSOR_RET:
        POP  DI                ; Restore Stack
        POP  SI
        POP  ES
        POP  DS
        POP  BP
        ;
        PUSH BX               ; push logical value onto stack
        CALL __RETL           ; return it to Clipper
        ADD SP,2              ; increment stack pointer
        RET

  ISCURSOR   ENDP             ; Function ends
  _PROG      ENDS             ; Code segment ends
  END                         ; program

