
{HC:  HardCopy  by Craig S. Steinberg, O.D.
Compuserve ID: 70166,337
IBMSW Sig and Ashton-Tate Sig  (go ibmsw, go ash-18)
Public Domain.  Feel free to copy, transfer and improve!
Author takes no responsibility for use of this program.

Program for making hardcopy printouts of dBASE program files.
Requires Epson or Compatible printer.

   a. 88 lines per page
   b. one line double strike header line at start of each program that
      gives print date and name of file being printed.
   c. left margin of 5 char.
   d. 12 cpi printing (elite)
   e. one blank line at top of file and 6 blank lines at bottom giving
      80 lines of code per page

Command line parameters:
------------------------

? - help screen
name - name of file to print, default ext = .prg
name.ext - full name of file to print

If no command line parameter, prompt for name of file to print.  After
printing the file, ask for the next file name.  Continue until no file name
is entered (return).  Default ext = .prg.                                  }


PROGRAM HC;

type
   AnyString  = string[255];
   FileName   = string[12];

var
   Infile        : text;
   line          : AnyString;
   n,x           : integer;      {line counters}
   InFileName    : FileName;
   ps            : FileName;     {command line parameter}
   Ioerr         : boolean;

{wait for any key to be struck to continue}
PROCEDURE Wait;
Var
  AnyKey : Char;
Begin
  Read(Kbd,AnyKey);
end;

{display help screen if ? is command line parameter}
Procedure HelpScreen;
Begin
   ClrScr;
   Writeln('                              HardCopy  1.0 ');
   writeln;
   writeln('                           by  Craig Steinberg ');
   writeln;
   LowVideo;
   writeln('Format:   HC  [?] / [filename] [.ext]');
   writeln;
   writeln('          ? - displays this help screen');
   writeln('   Filename - immediately prints "filename"');
   writeln;
   writeln('Default filename extension is ".PRG".  File must be in current directory.');
   writeln('If no filename is entered you will be prompted for filename(s) to print.');
   writeln('If a filename is entered on the command line you are returned to DOS ');
   writeln('immediately after the file has been printed.');
   writeln;
   writeln('Print Parameters (Epson compatible printer): ');
   writeln;
   writeln('Elite print (12 characters per inch).');
   writeln('88 lines per page, 80 lines of code.');
   writeln('Left margin of 5 spaces on each line.');
   writeln('First page header shows file being printed.');
   writeln('Page eject after each file is printed.');
   writeln;
   writeln('Version 1.0, June 29, 1986.  Released into Public Domain by author.');
   writeln;
   HighVideo;
   write('Press any key to return to DOS . . .');
   wait;
   ClrScr;
   halt;
end;

{check for disk/file errors, based upon IOError.pas in turbo tutor}
PROCEDURE IOCheck(var IOerr : boolean);
const
  IOVal   : Integer = 0;
  IOerror : boolean = False;
var
  Ch    : Char;
begin
  HighVideo;
  IOerr   := False;
  IOVal   := IOresult;
  IOError := (IOVal <> 0);
  if IOError then begin
    IOerr := True;
    GotoXY (17,12);
    case IOVal of
      $01  :  Write('Input file "',InFileName,'" does not exist.');
      $05  :  Write('Error: Can''t read from the input file.');
      $06  :  Write('Error: Can''t write to output file.');
      $F0  :  Write('Error: Disk write error.');
      $F1  :  Write('Error: Directory is full.');
    else      Write('Unknown I/O error:  ',IOVal:3)
    end;
    GotoXY (17,13); Write('Press any key to continue . . . ');
    write(chr(7));
    LowVideo;
    wait;
    GotoXY (1,12); ClrEol;
    GotoXY (1,13); ClrEol;
  end
end; { of proc IOCheck }


{**********************************************
         BEGIN MAIN PROGRAM CODE
***********************************************}

begin
   ClrScr;

   { if no command line parameters make sure variables are blank }
   if ParamCount < 1 then begin
      ps := '';
      InFileName := '';
   end;

   { if ? is entered with filename display help screen and exit }
   if ParamStr(1) = '?' then HelpScreen;

   { display title }
   HighVideo;
   GotoXY (27,4); Write('Formatted dBASE HardCopy');
   GotoXY (27,5); Write('');
   GotoXY (1,24); Write('Enter HC ? for help.');
   GotoXY (60,24); Write('By Craig S. Steinberg');
   LowVideo;

   { if filename on command line save the filename in memory var ps }
   if (ParamCount >= 1) then ps := ParamStr(1);

   { loop until no filename is entered at prompt }
   repeat  {until length(infilename) = 0}

      { if a command line filename was entered save it as the filename,
      otherwise prompt for the filename to print}
      if length(ps) > 0 then InFileName := ps
      else begin
         GotoXY (17,10); ClrEol;
         GoToXY (10,8); Write('Enter filename to print  [            ]');
         GotoXY (53,8); Write('Press [RETURN] to Exit');
         GotoXY (36,8); Read(InFileName);
      end;

      { If no ext is given and more than eight char are entered then
      truncate the filename to eight characters }
      If (pos('.',InFileName) = 0) and (length(InFileName) > 8) then
         InFileName := copy(InFileName,1,8);

      { Add default extension if needed }
      IF length(InFileName) > 0 then
      Begin
         if pos('.',InFileName) = 0 then InFileName := InFileName + '.prg';
         LowVideo;
         GotoXY (17,10);  Write('Printing file: ' + InFileName);

         { open the file to be printed and point to beginning of it }
         {$I-}
         Assign(InFile,InFileName);   IOCheck(IOerr);
         Reset(InFile);               IOCheck(IOerr);
         {$I+}

         { if there is an error then exit, otherwise continue }
         if (IOErr and (length(ps) > 0)) then begin
            ClrScr;
            halt;
         end;

         if not IOErr then begin

         { set 88 lines per page, 1/8 inch line spaceing}
         write(lst,#27#48);

         { print header line }
         writeln(lst,'');            { blank line }
         write(lst,#27#69);          { double strike }
         write(lst,InFileName:80);   { print filename, flush right }
         writeln(lst,#27#70);        { back to single strike }

         write(lst,#27#77);          { elite on }
         write(lst,#27#108#5);       { margin 5 }
         write(lst,#10#13);          { next line }

         {begin processing}
         x := 1;  {count number of lines printed}
         n := 3;  {start on line number 3}
         GotoXY (45,10); write('Printing line #');

         { process until the end of the file is reached }
         while not eof(InFile) do
         begin
            readln(InFile,line);        { read in a line if text }
            writeln(lst,line);          { write it out to the printer }
            GotoXY (61,10); write(x);   { display the line # being printed }
            x := x + 1;  n := n + 1;    { increment the counters }
            if n = 82 then begin        { are we at the end of the page? }
               write(lst,#12);          {    yes so formfeed }
               n := 3;                  {    restart counter }
               writeln(lst,'');         {    print a couple  }
               writeln(lst,'');         {    of blank lines  }
               writeln(lst,'')
            end
         end;

         {end of the file: form feed, bell and reset printer }
         write(lst,#12); write(lst,#7); write(lst,#27#64);

         { make sure the input file is closed }
         Close(InFile);

         { if command line file was printed blank out InFileName so that
         the repeat condition is false and no filenames are prompted for }
         if length(ps) > 0 then InFileName := '';
         end;
      end;
   until length(InFileName) = 0;
   ClrScr;
end.

