*****************************************************************************
*
* Program Name : sampedit
*
* Written By   : David L. Collison
* Written On   : December 09, 1989
*
* Updated By   : David L. Collison
* Updated On   : December 09, 1989
*
* Copyright    : Copyright (c), 1989 - Executive Assist
*
* Description  : This program will show the use of the full screen
*                validation routine.
*
* Files Used   :
*
* Prg's Called : mm_utvld - Function to validate all data entry.
*                mm_envst - Function to set up default operating environment.
*                mm_scclr - Function to set screen colors.
*                mm_schdr - Function to draw screen headers and footers.
*                mm_utmsc - Function to display code messages to user.
*
* Parameters   :
*
*****************************************************************************

*
* Force compiler to compile all procedures/functions within the following
*     programs.
*

SET PROCEDURE TO SAUVALID
SET PROCEDURE TO ML_UTVLD
SET PROCEDURE TO SAMPLIBR

MM_ENVST ()                && Set the initial operating environment

*
* Declare and initialize all local variables.
*

PRIVATE M_MENUMBER, M_MEFRSTNM, M_MEMIDDLE, M_MELASTNM, M_MEADDRS1, M_MEADDRS2
PRIVATE M_MECITYNM, M_MESTATID, M_MEZIPCOD, M_MEPHONNO, M_MEBUSNES, M_MEBADDR1
PRIVATE M_MEBADDR2, M_MEBCITYN, M_MEBSTATE, M_MEBZIPCD, M_MEBPHONE, M_MEBEXTEN
PRIVATE M_MEDTJOIN, M_MEDUESPD, M_ACTION  , M_EDITOP  , M_EDITOK  , M_ARVALD
PRIVATE M_ORGSCR  , M_ARGTYN

MM_SCCLR ( 'NO' )          && Set up inital screen colors and clear screen
CLEAR

*
* Draw the inital screen border, headers and footers.
*

MM_SCHDR ( PROCNAME(), 'Sample Full Screen Edit/Validation' )

MM_UTMSC ( 'OF' )          && Set up opening files message on screen bottom

*
* Initialize all private variables
*

M_EDITOK = .T.

M_ACTION = SPACE ( 01 )
M_EDITOP = SPACE ( 01 )
M_ORGSCR = SPACE ( 00 )
M_ARVALD = SPACE ( 00 )

DECLARE M_ARVALD [ 21 ]

AFILL ( M_ARVALD, 'VALDTRUE' )

*
* Open datafile and initialize memory variables based on datafile.
*

SELECT 0
MM_DFOPN ( 'CLIPUSER', .F. )
SET INDEX TO CLIPUSER

*
* Defualt screen information to datafile ghost record (blank information.)
*

GOTO BOTTOM
SKIP 1

M_MENUMBER = MENUMBER
M_MEFRSTNM = MEFRSTNM
M_MEMIDDLE = MEMIDDLE
M_MELASTNM = MELASTNM
M_MEADDRS1 = MEADDRS1
M_MEADDRS2 = MEADDRS2
M_MECITYNM = MECITYNM
M_MESTATID = MESTATID
M_MEZIPCOD = MEZIPCOD
M_MEPHONNO = MEPHONNO
M_MEBUSNES = MEBUSNES
M_MEBADDR1 = MEBADDR1
M_MEBADDR2 = MEBADDR2
M_MEBCITYN = MEBCITYN
M_MEBSTATE = MEBSTATE
M_MEBZIPCD = MEBZIPCD
M_MEBPHONE = MEBPHONE
M_MEBEXTEN = MEBEXTEN
M_MEDTJOIN = MEDTJOIN
M_MEDUESPD = MEDUESPD

*
* Load validation routines for gets that will be activated.
*

M_ARVALD [ 01 ] = 'SAV_USER ( M_MENUMBER , M_EDITOP )'
M_ARVALD [ 08 ] = 'SAV_STAT ( M_MESTATID )'
M_ARVALD [ 09 ] = 'SAV_ZIPC ( M_MEZIPCOD )'
M_ARVALD [ 10 ] = 'SAV_PHON ( M_MEPHONNO )'
M_ARVALD [ 15 ] = 'SAV_STAT ( M_MEBSTATE )'
M_ARVALD [ 16 ] = 'SAV_ZIPC ( M_MEBZIPCD )'
M_ARVALD [ 17 ] = 'SAV_PHON ( M_MEBPHONE )'
M_ARVALD [ 18 ] = 'SAV_EXTN ( M_MEBEXTEN )'
M_ARVALD [ 19 ] = 'SAV_DATE ( M_MEDTJOIN )'
M_ARVALD [ 20 ] = 'SAV_DATE ( M_MEDUESPD, M_MEDTJOIN )'

*
* Display the initial screen to user.
*

@ 03, 02 SAY 'USER ID'     GET M_MENUMBER PICTURE '999999'

@ 05, 02 SAY 'NAME: FIRST' GET M_MEFRSTNM PICTURE '@!'
@ 05, 36 SAY 'MID'      GET M_MEMIDDLE PICTURE '@!'
@ 05, 42 SAY 'LAST'        GET M_MELASTNM PICTURE '@!'

@ 07, 02 SAY 'HOME ADDRESS'
@ 07, 42 SAY 'BUSINESS ADDRESS'

@ 09, 02 SAY 'STRT'        GET M_MEADDRS1 PICTURE '@!'
@ 10, 07                   GET M_MEADDRS2 PICTURE '@!'
@ 11, 02 SAY 'CITY'        GET M_MECITYNM PICTURE '@!'
@ 11, 28 SAY 'STATE'       GET M_MESTATID PICTURE '@!'
@ 12, 02 SAY 'ZIP '        GET M_MEZIPCOD PICTURE '!!!!!-!!!!'
@ 13, 02 SAY 'PHN '        GET M_MEPHONNO PICTURE '(999)999-9999'

@ 08, 42 SAY 'BUSN'        GET M_MEBUSNES PICTURE '@!'
@ 09, 42 SAY 'STRT'        GET M_MEBADDR1 PICTURE '@!'
@ 10, 47                   GET M_MEBADDR2 PICTURE '@!'
@ 11, 42 SAY 'CITY'        GET M_MEBCITYN PICTURE '@!'
@ 11, 68 SAY 'STATE'       GET M_MEBSTATE PICTURE '@!'
@ 12, 42 SAY 'ZIP '        GET M_MEBZIPCD PICTURE '!!!!!-!!!!'
@ 13, 42 SAY 'PHN '        GET M_MEBPHONE PICTURE '(999)999-9999'
@ 13, 62 SAY 'EXT'         GET M_MEBEXTEN PICTURE '9999'

@ 15, 02 SAY 'JOIN'        GET M_MEDTJOIN PICTURE '@D'
@ 16, 02 SAY 'PAID'        GET M_MEDUESPD PICTURE '@D'
@ 20, 78                   GET M_ACTION

@ 24, 00 CLEAR

CLEAR GETS

DO WHILE M_EDITOK

   *
   * Determine edit option from user.
   *

   M_ORGSCR = SAVESCREEN ( 24, 00, 24, 79 )

   @ 24, 00 SAY 'EDIT OPTIONS:'

   @ 24, 15 PROMPT 'ADD'
   @ 24, 20 PROMPT 'DISPLAY'
   @ 24, 29 PROMPT 'MODIFY'
   @ 24, 37 PROMPT 'REMOVE'
   @ 24, 45 PROMPT 'EXIT'

   M_EDITOP = 0

   MENU TO M_EDITOP

   RESTSCREEN ( 24, 00, 24, 79, M_ORGSCR )

   DO CASE
      CASE M_EDITOP = 05 .OR. LASTKEY() = 27

         *
         * If selecting option to exit or pressing the escape key exit
         *    the edit loop.
         *

         M_EDITOK = .F.
         LOOP

      CASE M_EDITOP = 00

         *
         * If no option is selected, prompt the user to retry edit option.
         *

         LOOP

   ENDCASE

   *
   * Get the record that needs to be edited/display/deleted or added
   *

   SET ESCAPE ON

   @ 03, 02 SAY 'USER ID'     GET M_MENUMBER PICTURE '999999'        VALID MM_UTVLD ( @M_ARVALD, 01, 01 )

   READ

   SET ESCAPE OFF

   IF LASTKEY() = 27

      *
      * If the user escapes out of this record, prompt for the next record.
      *

      LOOP

   ENDIF

   @ 05, 02 SAY 'NAME: FIRST' GET M_MEFRSTNM PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 02, 21 )
   @ 05, 36 SAY 'MID'         GET M_MEMIDDLE PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 03, 21 )
   @ 05, 42 SAY 'LAST'        GET M_MELASTNM PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 04, 21 )

   @ 09, 02 SAY 'STRT'        GET M_MEADDRS1 PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 05, 21 )
   @ 10, 07                   GET M_MEADDRS2 PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 06, 21 )
   @ 11, 02 SAY 'CITY'        GET M_MECITYNM PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 07, 21 )
   @ 11, 28 SAY 'STATE'       GET M_MESTATID PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 08, 21 )
   @ 12, 02 SAY 'ZIP '        GET M_MEZIPCOD PICTURE '!!!!!-!!!!'    VALID MM_UTVLD ( M_ARVALD, 09, 21 )
   @ 13, 02 SAY 'PHN '        GET M_MEPHONNO PICTURE '(999)999-9999' VALID MM_UTVLD ( M_ARVALD, 10, 21 )

   @ 08, 42 SAY 'BUSN'        GET M_MEBUSNES PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 11, 21 )
   @ 09, 42 SAY 'STRT'        GET M_MEBADDR1 PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 12, 21 )
   @ 10, 47                   GET M_MEBADDR2 PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 13, 21 )
   @ 11, 42 SAY 'CITY'        GET M_MEBCITYN PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 14, 21 )
   @ 11, 68 SAY 'STATE'       GET M_MEBSTATE PICTURE '@!'            VALID MM_UTVLD ( M_ARVALD, 15, 21 )
   @ 12, 42 SAY 'ZIP '        GET M_MEBZIPCD PICTURE '!!!!!-!!!!'    VALID MM_UTVLD ( M_ARVALD, 16, 21 )
   @ 13, 42 SAY 'PHN '        GET M_MEBPHONE PICTURE '(999)999-9999' VALID MM_UTVLD ( M_ARVALD, 17, 21 )
   @ 13, 62 SAY 'EXT'         GET M_MEBEXTEN PICTURE '9999'          VALID MM_UTVLD ( M_ARVALD, 18, 21 )

   @ 15, 02 SAY 'JOIN'        GET M_MEDTJOIN PICTURE '@D'            VALID MM_UTVLD ( M_ARVALD, 19, 21 )
   @ 16, 02 SAY 'PAID'        GET M_MEDUESPD PICTURE '@D'            VALID MM_UTVLD ( M_ARVALD, 20, 21 )
   @ 20, 78                   GET M_ACTION                           VALID MM_UTVLD ( M_ARVALD, 21, 21 )
   
   DO CASE
      CASE M_EDITOP = 01 .OR. M_EDITOP = 03       && Add or modify record

         READ

         SELECT CLIPUSER

         MM_LKREC ()
         REPLACE MEFRSTNM WITH M_MEFRSTNM, MEMIDDLE WITH M_MEMIDDLE, MELASTNM WITH M_MELASTNM
         REPLACE MEADDRS1 WITH M_MEADDRS1, MEADDRS2 WITH M_MEADDRS2, MECITYNM WITH M_MECITYNM
         REPLACE MESTATID WITH M_MESTATID, MEZIPCOD WITH M_MEZIPCOD, MEBUSNES WITH M_MEBUSNES
         REPLACE MEBADDR1 WITH M_MEBADDR1, MEBADDR2 WITH M_MEBADDR2, MEBCITYN WITH M_MEBCITYN
         REPLACE MEBSTATE WITH M_MEBSTATE, MEBZIPCD WITH M_MEBZIPCD, MEBPHONE WITH M_MEBPHONE
         REPLACE MEBEXTEN WITH M_MEBEXTEN, MEDTJOIN WITH M_MEDTJOIN, MEDUESPD WITH M_MEDUESPD
         MM_LKRUN ()

      CASE M_EDITOP = 04

         CLEAR GETS

         M_ORGSCR = SAVESCREEN ( 24, 00, 24, 79 )

         M_ACTION = MM_UTGET ( 24, 00, 'REMOVE THIS RECORD (Y/N) : ', 'YN' )

         IF M_ACTION = 'Y'

            MM_LKREC ()
            DELETE
            MM_LKRUN ()

         ENDIF

      CASE M_EDITOP = 02

         CLEAR GETS

   ENDCASE

ENDDO

CLOSE DATABASES
CLEAR

RETURN


            
