#include "getexit.ch"
#include "inkey.ch"
#include "set.ch"
#include "setcurs.ch"
#include "emc.ch"   // This is non-system specific include file

#DEFINE pDISPCHAR ""

FUNCTION GetSecret( oGet,cString )
/**************************************************************************
 MODULE:   GetSecret()

 PURPOSE:  Custom GetReader which reads sensitive information

 SYNTAX:   GetSecret(<expO1>,<expC2>)

 PASS TO:  <expO1>    : Get object
           <expC2>    : String to hold entered text

 RETURNS:  Entered text

 DEFAULTS: N/A, both fields necessary

 SUMMARY:  This function is intended mainly to read passwords, but it could
           be used for any sensitive information.  As the user types, a
           "" is echoed to the screen instead of whatever character has
           been entered.  The GET variable contains the actual value entered
           by the user.  Be sure to look at the example below.

           Note the example below.  The variable which is after the GET
           statement is not what the programmer is interested in.  This is a
           hold variable, and contains only a string of "" characters.  The
           actual typed characters are contained in <expC2>, which needs to
           be passed by reference.  <expC2> contains just what the user
           entered, it is not padded with spaces.  If the user entered spaces
           at the end of the string, they are there just as they were
           entered.

           Formatting PICTURES clauses will have not have the expected result,
           so avoid them. These are pictures clauses like "@!" or
           "(999)999-9999".  "@K" does work as expected, however.

           Post- and Prevalidating (VALID and WHEN) works fine.

           The original author (Mark Richards) suggests you include this in
           GETSYS.PRG.  I didn't, and it worked fine.  I included my own copy
           of GetApplyKey() however, for I needed a special one.

           I do not support the following keys:

                  CASE ( nKey == K_CTRL_RIGHT )
                    oGet:wordRight()

                  CASE ( nKey == K_CTRL_LEFT )
                    oGet:wordLeft()

                  CASE ( nKey == K_CTRL_T )
                    oGet:delWordRight()


 SOURCE:   _GETSCRT.PRG

 NOTES:    This function was taken from a PD function called READPWD done by
           Author: Mark Richards
                   Nashua, NH
                   (603) 882-8052

           I used Mark's function as a skeleton and worked my function around
           his.  His would not work if in a multi-GET READ.  Also, most of
           the navigation keys (delete, backspace, etc.) wouldn't work
           properly.  I replaced the "*" with "" (CHR(254)) because I
           thought it looked better, and "*" is what's displayed for a
           numeric overflow, and I didn't want to confuse the user.



 EXAMPLE:
            .
            .
            .

            cUser := PADR(N_WHOAMI(),47)

            @ 1,2 SAY "Username:"
            @ 2,2 SAY "Password:"

            cHold := SPACE(47)

            @ 1,12 GET cUser PICT "@K!S15"
            @ 2,12 GET cHold SEND READER := {|x| GetSecret(x,@cPass)} PICT "@KS15"

            .
            .
            .



 AUTHOR              DATE                  COMMENT
 David Gullett       08-25-94 01:12pm      Downloaded and altered.


 This code is GeethanksWare.  If you use it, send me a message on CIS saying,
 "Gee, thanks."

 David Gullett
 C/O EMC
 (805) 484-902
 CIS: 73657,2013

************************************************************************/

/*

 ͻ
  The following is the original documentation, and may not be accurate      
  to how GetSecret operates now.  I would like to give Mark credit however, 
  because I used his code.                                                  
 ͼ

   READPWD()

   Special reader for Passwords

   (1) Place at the bottom of GETSYS.PRG
   (2) Re-compile GETSYS.PRG (compile with /m/n/w)
   (3) Include the new GETSYS.OBJ in your link

   Author: Mark Richards
           Nashua, NH
           (603) 882-8052

   This special password reader is hereby released into the public domain
   without warranty of any kind. (translation: you may have this and use
   it forever at your own risk).

 The following is an advertisement Ŀ
 Mark Richards, adept with Clipper 5.0x, long-time Clipper developer     
 (circa Winter '85) stands/sits ready to assist you with your Clipper/   
 "C" and assembly language requirements.  He may be conveniently reached 
 at (603) 882-8052 for your needs, large and small.  Call today!         
               *** end of advertisement ***                              


   Rev 1.0 29 Aug., 1991    First release of ReadPwd
   ---------------------------------------------------------------------

   To call this special reader, use the SEND operator as follows:

   @ row(), col() get <variable> SEND:reader:={|x|ReadPwd(x)}
   read

   This will establish the ReadPwd reader for the current get.

   ReadPwd echoes a tone and the asterisk character to the display.
   The actual contents of what was typed is returned.

   I've only tested this simple reader in one case.  You may discover
   bugs.  If you do, please let me know and i'll update ReadPwd.

   ReadPwd was adapted from the reader in Nantucket's Getsys.prg.

   Enjoy!

*/


  LOCAL nKey, nGetPos, cOldVal

  DEFAULT cString TO ""
  cOldVal := cString

  IF ( GETPREVALIDATE(oGet) )
    oGet:SETFOCUS()
    DO WHILE ( oGet:exitState == GE_NOEXIT )
      IF ( oGet:typeOut )
        oGet:exitState := GE_ENTER
      ENDIF

      DO WHILE ( oGet:exitState == GE_NOEXIT )
        nKey := INKEY(0)
        GetApplyKey( oGet, nKey, @cString ,cOldVal)
      ENDDO

      IF ( !GETPOSTVALIDATE(oGet) )
        oGet:EXITSTATE := GE_NOEXIT
      ENDIF
    ENDDO

    /* store the current get position */
    nGetPos := oGet:pos
    oGet:KILLFOCUS()

    /* restore the get to the actual value stored in cString */
//     EVAL(oGet[nGetPos],cString)
  ENDIF

RETURN cString

/***
*
*  GetApplyKey()
*
*  Apply a single INKEY() keystroke to a GET
*
*  NOTE: GET must have focus.
*
*/
STATIC FUNCTION GetApplyKey( oGet, nKey ,cString,cOldVal )

LOCAL cKey
LOCAL bKeyBlock

#define K_UNDO          K_CTRL_U

  // Check for SET KEY first
  IF !( ( bKeyBlock := setkey( nKey ) ) == NIL )
    GetDoSetKey( bKeyBlock, oGet )
    RETURN NIL                          // NOTE
  ENDIF

  DO CASE
    CASE ( nKey == K_UP )
      oGet:exitState := GE_UP

    CASE ( nKey == K_SH_TAB )
      oGet:exitState := GE_UP

    CASE ( nKey == K_DOWN )
      oGet:exitState := GE_DOWN

    CASE ( nKey == K_TAB )
      oGet:exitState := GE_DOWN

    CASE ( nKey == K_ENTER )
      oGet:exitState := GE_ENTER

    CASE ( nKey == K_ESC )
      IF ( SET( _SET_ESCAPE ) )
        cString := cOldVal
        oGet:undo()
        oGet:exitState := GE_ESCAPE
      ENDIF

    CASE ( nKey == K_PGUP )
      oGet:exitState := GE_WRITE

    CASE ( nKey == K_PGDN )
      oGet:exitState := GE_WRITE

    CASE ( nKey == K_CTRL_HOME )
      oGet:exitState := GE_TOP


  #ifdef CTRL_END_SPECIAL

    // Both ^W and ^End go to the last GET
    CASE ( nKey == K_CTRL_END )
      oGet:exitState := GE_BOTTOM

  #else

    // Both ^W and ^End terminate the READ (the default)
    CASE ( nKey == K_CTRL_W )
      oGet:exitState := GE_WRITE

  #endif


    CASE ( nKey == K_INS )
      SET( _SET_INSERT, !SET( _SET_INSERT ) )

    CASE ( nKey == K_UNDO )
      oGet:UNDO()
      cString := cOldVal

    CASE ( nKey == K_HOME )
      oGet:home()

    CASE ( nKey == K_END )
      oGet:end()

    CASE ( nKey == K_RIGHT )
      oGet:right()

    CASE ( nKey == K_LEFT )
      oGet:left()

/*    CASE ( nKey == K_CTRL_RIGHT )
      oGet:wordRight()

    CASE ( nKey == K_CTRL_LEFT )
      oGet:wordLeft()
*/
    CASE ( nKey == K_BS )
      cString := LEFT(cString,oGet:POS - 2)+SUBSTR(cString,oGet:POS)
      oGet:backSpace()

    CASE ( nKey == K_DEL )
      cString := LEFT(cString,oGet:POS - 1)+SUBSTR(cString,oGet:POS + 1)
      oGet:delete()

/*    CASE ( nKey == K_CTRL_T )
      oGet:delWordRight()
*/
    CASE ( nKey == K_CTRL_Y )
      cString := LEFT(cString,oGet:POS - 1)
      oGet:delEnd()

    CASE ( nKey == K_CTRL_BS )
      cString := LEFT(cString,oGet:POS - 1)
      oGet:delWordLeft()

    OTHERWISE

      IF ( nKey >= 32 .AND. nKey <= 255 )

        cKey := CHR( nKey )

        IF oGET:CLEAR
          cString := ""
        ENDIF

        IF ( SET( _SET_INSERT ) )
          cString := LEFT(cString,oGet:POS-1)+cKey+SUBSTR(cString,oGet:POS)
          oGet:insert( pDISPCHAR )
        ELSE
          cString := LEFT(cString,oGet:POS-1)+cKey+SUBSTR(cString,oGet:POS+1)
          oGet:overstrike( pDISPCHAR )
        ENDIF

        IF ( oGet:typeOut )
          IF ( SET( _SET_BELL ) )
            ?? CHR(7)
          ENDIF

          IF ( !SET( _SET_CONFIRM ) )
            oGet:exitState := GE_ENTER
          ENDIF
        ENDIF
      ENDIF
   ENDCASE

RETURN NIL

