/* GETMEMO.PRG
   Custom reader to do MEMOEDIT on a GET
   Author: Glenn Alcott (CIS 76044,747)

   This function allows a MEMOEDIT on a GET field by creating a custom reader
   for the field.  In addition to the normal Ctrl-W key for exiting MEMOEDIT,
   it also allows you to define two alternative save/exit keys, one of which
   will jump to the previous GET and the other to the next one.  Without this
   facility, there would be no way to move backwards once you had passed
   through this field.
*/

#include "getexit.ch"
#include "inkey.ch"

/* Define the exit keys that will go to the previous and next fields when
   exiting the memo. */
#define K_MEMO_UP K_F4
#define K_MEMO_DOWN K_F5

* This is just a procedure to test it.
proc main
local f1,f2,f3,f4,f5
local top:=6,left:=3,bottom:=12,right:=78
clear screen
fld1:=fld2:=fld3:=fld4:=fld5:=space(10)
@ top-1,left-1 to bottom+1,right+1 double
memoedit(fld3,top,left,bottom,right,.f.,.f.)  // initial display of the field
@ 1,1 get fld1
@ 2,1 get fld2
/* The GET coordinates for the field to be edited should be off the screen
  so it will not be displayed as a normal field. */
@ 3,100 get fld3 send reader:={|x|MEMOREADER(x,top,left,bottom,right)}
@ 15,1 get fld4
@ 15,1 get fld5
read
clear screen
quit


func MEMOREADER( get,top,left,bottom,right )
  local buf
  if ( GetPreValidate(get) )
    get:SetFocus()
    buf:=memoedit(get:varget(),top,left,bottom,right,.t.,"ME_GETKEYS")
    if lastkey()!=K_ESC
      get:varput(buf)
      if nextkey()=K_UP
        get:exitState := GE_UP
      elseif nextkey()=K_DOWN
        get:exitState := GE_DOWN
      endif
    else   // on Esc, redisplay the old version
      get:exitState := GE_DOWN
      memoedit(get:varget(),top,left,bottom,right,.f.)
    endif
    clear typeahead   // prevents weird behavior due to KEYBOARDing
    get:KillFocus()
  endif
return NIL

func ME_GETKEYS (mode, line, column)
local retval
if mode < 3   // MEMOEDIT is idle or unassigned key pressed
  do case
  case lastkey()==K_MEMO_UP
    keyboard chr(K_UP)
    retval:=K_CTRL_W    // this causes a save and exit
  case lastkey()==K_MEMO_DOWN
    keyboard chr(K_DOWN)
    retval:=K_CTRL_W
  case lastkey()==K_CTRL_W .or. lastkey()==K_ESC
    keyboard chr(K_DOWN)
    retval:=0
  endcase
else       // MEMOEDIT initialization mode
  retval:=0
endif
return retval