/*
 * File......: FTPARSE.PRG
 * Author....: Gary F. Alderson
 * CIS ID....: INTERNET> Gary_Alderson@UManitoba.CA
 * Date......: $1993-04-10$
 * Revision..: $1.00$
 * Log file..: $Logfile$
 * 
 * This is an original work by [Gary F. Alderson] and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#ifdef FT_TEST

    FUNCTION MAIN()
    MEMVAR GETLIST
    LOCAL aToken
    LOCAL cString := "The quick brown fox jumped over the lazy dog"
    LOCAL cDelim := " "

    CLS
    SET CONFIRM ON
    @ 10,01 SAY "String to be parsed:";
            GET cString PICTURE "@KS44"
    @ 12,01 SAY "Delimiter between tokens:";
            GET cDelim
    READ

    aToken := FT_PARSE(cString, cDelim)
    QOUT('The string "'+cString+'"')
    QOUT('Delimiter  "'+cDelim+'"')
    QOUT("Its tokens:")
    AEVAL( aToken, {|cToken| QOUT('"'+cToken+'"')} )

    RETURN (NIL)

#endif

/*  $DOC$
 *  $FUNCNAME$
 *      FT_PARSE()
 *  $CATEGORY$
 *      To be assigned
 *  $ONELINER$
 *      This routine will split up a character string into tokens.
 *  $SYNTAX$
 *      FT_PARSE( <cString>, [<cDelim>] ) -> aToken
 *  $ARGUMENTS$
 *      cString - the character string to be parsed into tokens
 *      cDelim  - the delimiter which seperates the tokens
 *  $RETURNS$
 *      An array of tokens contained in the string is returned.
 *  $DESCRIPTION$
 *      This routine when called with a character string containing several
 *      tokens and a character string containing the delimiter between those
 *      tokens, will return an array of the tokens. If a delimiter is not
 *      passed then a space will be used. As well, leading and trailing blanks
 *      are removed from the string and its tokens.
 *  $EXAMPLES$
 *      aToken := FT_PARSE("C:\A\VERY\LONG\FILE\SPEC\ABC.TXT", "\")
 *      Upon return, aToken will contain the following array
 *           {"C:","A","VERY","LONG","FILE","SPEC","ABC.TXT"}
 *  $SEEALSO$
 *      none
 *  $INCLUDE$
 *      none
 *  $END$
 */
FUNCTION FT_PARSE(cString, cDelim)
LOCAL nPtr
LOCAL aToken := {}

cDelim  := IF(cDelim == NIL, " ", cDelim)
cString := ALLTRIM(cString)

DO  WHILE (nPtr := AT(cDelim, cString)) != 0
    AADD(aToken, IF(nPtr > 1, RTRIM(LEFT(cString, nPtr-1)), ""))
    cString := IF(LEN(cString) > nPtr, LTRIM(SUBSTR(cString, nPtr+1)), "")
ENDDO

AADD(aToken, cString)

RETURN(aToken)
