
























                            Manu Roibal Prieto
                        Sagastagoitia, 13 2 B izq
                      Barakaldo 48903. Bizkaia. Spain.
               Voice phone 34-4-4992660 FAX/BBS 34-4-4605666























Printout of `FAST.lib 3.50  Reference'
Printed by the Norton Guides Printer v2.0 (NGP.EXE).


                                 - Page 1 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 1, Data Types




    Here I show some simple functions to handle the variables and types
  of data that I hope will be to your liking.

 



 Conversions

 


    ASCIIToEBCDIC()

         Converts an ASCII string to EBCDIC

    Syntax:

         ASCIIToEBCDIC( cString ) -> cNewString

         cString : The string to convert

    Description:

         Converts an ASCII string to EBCDIC notation.

    Return:

         A new string in EBCDIC notation.

    Example:

         ? ASCIIToEBCDIC( "Hello world" )

See Also: "EBCDICToASCII()" 


    Byte2Hex()

         Converts a byte into a hexadecimal string

    Syntax:

         Byte2Hex ( cByte ) -> cHexadecimal

         cByte : Byte to convert.

    Description:

         Converts a byte into a hexadecimal string.

                                 - Page 2 -
Norton Guide: `FAST.lib 3.50  Reference'



    Return:

         Hexadecimal number or NIL if cByte is not a character.

    Example:

         ? Byte2Hex ( "O" )             // "4F"

See Also: "Byte2Bin()" 


    Byte2Bin()

         Converts a byte to a binary string

    Syntax:

         Byte2Bin ( cByte ) -> cBinary

         cByte : Byte to convert.

    Description:

         Converts a byte to a binary string.

    Return:

         Binary number or NIL if cByte is not a character.

    Example:

         ? Byte2Hex ( "O" )             // "01001111"

See Also: "Byte2Hex()" 


    ByteAnd()

         Makes an And of two bytes bit to bit

    Syntax:

         ByteAnd ( cByte1, cByte2 ) -> cNewByte

         cByte1 y cByte2 : Bytes to do the And.

    Description:

         Makes an And Between the two specified bytes and returns the
         new byte as the result.

    Return:

         The resulting byte of the And or NIL if any of the two entry bytes

                                 - Page 3 -
Norton Guide: `FAST.lib 3.50  Reference'


         are not character type.

    Example:

         ? ByteAnd ( "O", "A" )

See Also: "ByteNot()" "ByteOr()" 


    ByteNot()

         Makes a Not of the byte bit to bit

    Syntax:

         ByteNot ( cByte ) -> cnewbyte

         cByte : Byte to do the Not.

    Description:

         Makes a Not of the specified byte and returns the new byte with
         the result.

    Return:

         The result byte of the Not or NIL if any of the entry bytes is
         not of the type character

    Example:

         ? ByteNot ( "O" )

See Also: "ByteAnd()" "ByteOr()" 


    ByteOr()

         Makes an Or of two bytes bit to bit

    Syntax:

         ByteOr ( cByte1, cByte2 ) -> cnewbyte

         cByte1 y cByte2 : Bytes to do de Or.

    Description:

         Makes an Or between the two specified bytes and returns the
         new byte with the result.

    Return:

         The result of the Or or NIL if any of the two bytes is not
         character type.

                                 - Page 4 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         ? ByteOr ( "O", "A" )

See Also: "ByteAnd()" "ByteNot()" 


    Color2Num()

         Converts a color string into a color numeric

    Syntax:

         Color2Num ( cColor ) -> nColor

         cColor : The color in string format

    Description:

         Converts a color in string format into numeric format. If the
         entry parameter is a string with more than a color, the style
         "W/B, B/W...", is returned to the numeric value of the first
         element.

    Return:

         Type color in numeric format.

    Example:

         ? Color2Num ( "W+/B" )   //   31

See Also: "Num2Color()" 


    Dec2Bin()

         Converts a decimal number to a binary string.

    Syntax:

         Dec2Bin ( nDec ) -> cBinary

         nDec : The decimal number to convert.

    Description:

         Converts a number in decimal base to a string in binary base.

    Return:

         The binary string.

    Example:

                                 - Page 5 -
Norton Guide: `FAST.lib 3.50  Reference'



         ? Dec2Bin ( 10 )   //   "1010"

See Also: "Hex2Dec()" "Byte2Hex()" "Byte2Bin()" 


    DelBit()

         Deactivates a bit selected from a byte

    Syntax:

         DelBit ( cByte, nBitPos ) -> cNewByte

         cByte   : Byte to be deactivated.
         nBitPos : Bit position inside the byte.

    Description:

         Puts to 0 a selected bit from a byte and returns the new byte.

    Return:

         New byte or NIL if cByte is not a character or nBitPos if is not
         numeric.

    Example:

         cNewByte := DelBit ( "C", 2 )

See Also: "IsBit()" "SetBit()" 


    EBCDICToASCII()

         Converts an EBCDIC string to ASCII

    Syntax:

         EBCDICToASCII( cString ) -> cNewString

         cString : The string to convert

    Description:

         Converts an EBCDIC string to ASCII notation.

    Return:

         A new string in ASCII notation.

    Example:

         ? EBCDICToASCII( "Hello world" )


                                 - Page 6 -
Norton Guide: `FAST.lib 3.50  Reference'


See Also: "ASCIIToEBCDIC()" 


    Hex2Dec()

         Converts a hexadecimal string to a decimal number

    Syntax:

         Hex2Dec ( cHex ) -> nDec

         cHex : The hexadecimal string to be converted.

    Description:

         Converts a string in hexadecimal base to a integer in
         decimal base.

    Return:

         The decimal integer.

    Example:

         ? Hex2Dec ( "FA" )

See Also: "Dec2Bin()" "Byte2Hex()" "Byte2Bin()" 


    Inter()

         Interchanges two variables

    Syntax:

         Inter( xVar1, xVar2 ) -> NIL

         xVar1 y xVar2 : The variables to interchange

    Description:

         Interchanges the value of the variables, that have to be indicated
         in the same way as an array {}.

    Return:

         Nothing.

    Example:

         cVar1 := "Hello"
         cVar2 := "Good bye"

         Inter( @cVar1, @cVar2 )
         ? cVar1                        // "Good bye"

                                 - Page 7 -
Norton Guide: `FAST.lib 3.50  Reference'


         ? cVar2                        // "Hello"


    IsBit()

         Determines if Bit 1 or 0

    Syntax:

         IsBit ( cByte, nBitPos ) -> lIsOn

         cByte   : The byte to treat.
         nBitPos : The bit position inside the byte.

    Description:

         Returns a logic indicating if the selected bit inside the byte
         is 1 or 0

    Return:

         A logic indicating answer or NIL if cByte is not a character
         or if nBitPos is not numeric.

    Example:

         lEstaA_1 := IsBit ( "C", 2 )

See Also: "DelBit()" "SetBit()" 


    Num2Color()

         Converts a numeric color to a string color

    Syntax:

         Color2Num ( nColor ) -> cColor

         nColor : The color in numeric format

    Description:

         Converts a color in numeric format to string format. The numeric
         color has to be a value between 0 and 255.

    Return:

         The color in string format or NIL if the number is bigger than
         255 or smaller than 0.

    Example:

         ? Num2Color ( 31 )   // "W+/B"


                                 - Page 8 -
Norton Guide: `FAST.lib 3.50  Reference'


See Also: "Color2Num()" 


    SetBit()

         Activates a selected bit from a byte

    Syntax:

         SetBit ( cByte, nBitPos ) -> cNewByte

         cByte   : The byte to treat.
         nBitPos : The position of the bit inside the byte.

    Description:

         Puts to 1 a selected bit from a byte returning the new byte.

    Return:

         The new byte or NIL if cByte is not a character or nBitPos is
         not numeric.

    Example:

         cNewByte := SetBit ( "C", 2 )

See Also: "DelBit()" "IsBit()" 


    Purge()

         Purges the value of a variable

    Syntax:

         Purge ( xVar ) -> xNewVar

         xVar : The variable to purge

    Description:

         Returns a value of the purged parameter, I mean, if xVar is
         numeric returns 0, if character returns spaces, if date "  /  /  "
         if array {}.

    Return:

         The purged value.

    Example:

         cNew := Purge ( "Hello" )       // "    "
         cMax := Purge ( { "Hello" } )   // {}
         cMax := Purge ( 123 )           // 0

                                 - Page 9 -
Norton Guide: `FAST.lib 3.50  Reference'


         cMax := Purge ( .T. )           // .F.



 Imperial and Metric

 


    nAcre2Ha()

         Acres into hectares

    Syntax:

         nAcre2Ha( nNumber ) -> nResul

         nNumber : is the value in acres.

    Description:

         Converts an area from acres into hectares.

    Return:

         The value of nNumber converted into hectares.

    Example:

         ? nAcre2Ha( 5 )                        // 2.0234

See Also: "nHa2Acre()" 


    nAcre2M()

         Acres into meters

    Syntax:

         nAcre2M( nNumber ) -> nResul

         nNumber : is the value in acres.

    Description:

         Converts an area from acres into meters.

    Return:

         The value of nNumber converted into meters.

    Example:

         ? nAcre2M( 5 )

                                 - Page 10 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "nM2Acre()" 


    nCm2Inch()

         Centimeters into inches

    Syntax:

         nCm2Inch( nNumber ) -> nResul

         nNumber : is the value in centimeters.

    Description:

         Converts a length from centimeters into inches.

    Return:

         The value of nNumber converted into inches.

    Example:

         ? nCm2Inch( 30 )                       // 11.811

See Also: "nInch2Cm()" 


    nCC2Inch()

         Cubic centimeters into cubic inches

    Syntax:

         nCC2Inch( nNumber ) -> nResul

         nNumber : is the value in cubic centimeters.

    Description:

         Converts a volume from cubic centimeters into cubic inches.

    Return:

         The value of nNumber converted into cubic inches.

    Example:

         ? nCC2Inch( 25 )                       // 1.525

See Also: "nInch2CC()" 


    nCF2Ltr()

                                 - Page 11 -
Norton Guide: `FAST.lib 3.50  Reference'



         Cubic feet into liters

    Syntax:

         nCF2Ltr( nNumber ) -> nResul

         nNumber : is the value in cubic feet.

    Description:

         Converts a volume from cubic feet into liters.

    Return:

         The value of nNumber converted into liters.

    Example:

         ? nCF2Ltr( 2 )                         // 56.657

See Also: "nLtr2CF()" 


    nInch2CC()

         Cubic inches into cubic centimeters

    Syntax:

         nInch2CC( nNumber ) -> nResul

         nNumber : is the value in cubic inches.

    Description:

         Converts a volume from cubic inches into cubic centimeters.

    Return:

         The value of nNumber converted into cubic centimeters.

    Example:

         ? nInch2CC( 3 )                        // 49.16

See Also: "nCC2Inch()" 


    nCm2CYd()

         Cubic meters into cubic yards

    Syntax:


                                 - Page 12 -
Norton Guide: `FAST.lib 3.50  Reference'


         nCm2CYd( nNumber ) -> nResul

         nNumber : is the value in cubic meters.

    Description:

         Converts a volume from cubic meters into cubic yards.

    Return:

         The value of nNumber converted into cubic yards.

    Example:

         ? nCm2CYd( 5 )                         // 6.54

See Also: "nCYd2Cm()" 


    nCYd2Cm()

         Cubic yards into cubic meters

    Syntax:

         nCYd2Cm( nNumber ) -> nResul

         nNumber : is the value in cubic yards.

    Description:

         Converts a volume from cubic yards into cubic meters.

    Return:

         The value of nNumber converted into cubic meters.

    Example:

         ? nCYd2Cm( 7 )                         // 5.3522

See Also: "nCm2CYd()" 


    nGal2Ltr()

         Gallons into liters

    Syntax:

         nGal2Ltr( nNumber ) -> nResul

         nNumber : is the value in gallons.

    Description:

                                 - Page 13 -
Norton Guide: `FAST.lib 3.50  Reference'



         Converts a volume from gallons into liters.

    Return:

         The value of nNumber converted into liters.

    Example:

         ? nGal2Ltr( 2 )                        // 9.0909

See Also: "nLtr2Gal()" 


    nGr2Oz()

         Grams into ounces

    Syntax:

         nGr2Oz( nNumber ) -> nResul

         nNumber : is the value in grams.

    Description:

         Converts a weight from grams into ounces.

    Return:

         The value of nNumber converted into ounces.

    Example:

         ? nGr2Oz( 50 )                         // 1.765

See Also: "nOz2Gr()" 


    nHa2Acre()

         Hectares into acres

    Syntax:

         nHa2Acre( nNumber ) -> nResul

         nNumber : is the value in hectares.

    Description:

         Converts an area from hectares into acres.

    Return:


                                 - Page 14 -
Norton Guide: `FAST.lib 3.50  Reference'


         The value of nNumber converted into acres.

    Example:

         ? nHa2Acre(5)                          // 12.3555

See Also: "nAcre2Ha()" 


    nInch2Cm()

         Inches into centimeters

    Syntax:

         nInch2Cm( nNumber ) -> nResul

         nNumber : is the value in inches.

    Description:

         Converts a length from inches into centimeters.

    Return:

         The value of nNumber converted into centimeters.

    Example:

         ? nInch2Cm( 12 )                      // 30.48

See Also: "nCm2Inch()" 


    nKg2Lb()

         Kilograms into pounds

    Syntax:

         nKg2Lb( nNumber ) -> nResul

         nNumber : is the value in kilograms.

    Description:

         To convert a weight from kilograms into pounds.

    Return:

         The value of nNumber converted into pounds.

    Example:

         ? nKg2Lb(5)                            // 11.023

                                 - Page 15 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "nLb2Kg()" 


    nLb2Kg()

         Pounds into kilograms

    Syntax:

         nLb2Kg( nNumber ) -> nResul

         nNumber : is the value in pounds.

    Description:

         Converts a weight from pounds into kilograms.

    Return:

         The value of nNumber converted into kilograms.

    Example:

         ? nLb2Kg(4)                    // 1.8144

See Also: "nKg2Lb()" 


    nLtr2CF()

         Liters into cubic feet

    Syntax:

         nLtr2CF( nNumber ) -> nResul

         nNumber : is the value in liters.

    Description:

         Converts a volume from liters into cubic feet.

    Return:

         The value of nNumber converted into cubic feet.

    Example:

         ? nLtr2CF( 50 )                        // 1.765

See Also: "nCF2Ltr()" 


    nLtr2Gal()

                                 - Page 16 -
Norton Guide: `FAST.lib 3.50  Reference'



         Liters into gallons

    Syntax:

         nLtr2Gal( nNumber ) -> nResul

         nNumber : is the value in liters.

    Description:

         Converts a volume from liters into gallons.

    Return:

         The value of nNumber converted into gallons.

    Example:

         ? nLtr2Gal( 10 )                       // 2.2

See Also: "nGal2Ltr()" 


    nM2Acre()

         Meters into acres

    Syntax:

         nM2Acre( nNumber ) -> nResul

         nNumber : is the value in meters.

    Description:

         Converts an area from meters into acres.

    Return:

         The value of nNumber converted into acres.

    Example:

         ? nM2Acre(5)

See Also: "nAcre2M()" 


    nMt2Yd()

         Meters into yards

    Syntax:


                                 - Page 17 -
Norton Guide: `FAST.lib 3.50  Reference'


         nMt2Yd( nNumber ) -> nResul

         nNumber : is the value in meters.

    Description:

         Converts a length from meters into yards.

    Return:

         The value of nNumber converted into yards

    Example:

         ? nMt2Yd( 8 )                          // 8.7488

See Also: "nYd2Mt()" 


    nOz2Gr()

         Ounces into grams

    Syntax:

         nOz2Gr( nNumber ) -> nResul

         nNumber : is the value in ounces.

    Description:

         Converts a weight from ounces into grams.

    Return:

         The value of nNumber converted into grams.

    Example:

         ? nOz2Gr( 4 )                          // 113.31

See Also: "nGr2Oz()" 


    nYd2Mt()

         Yards into meters

    Syntax:

         nYd2Mt( nNumber ) -> nResul

         nNumber : is the value in yards.

    Description:

                                 - Page 18 -
Norton Guide: `FAST.lib 3.50  Reference'



         Converts a length from yards into meters.

    Return:

         The value of nNumber converted into meters.

    Example:

         ? nYd2Mt( 5 )                          // 4.5721

See Also: "nMt2Yd()" 



 Array16

 


    Add16()

         Adds an element into an array16

    Syntax:

         Add16 ( aArray, xValue ) -> NIL

         aArray : The array16 previously created
         xValue : The value of the new element

    Description:

         Adds an element to the end of an array16 and initializes it
         with the xValue value if it is specified.

    Return:

         Nothing.

    Example:

         a16 := New16 ( 15000, 0 )
         Add16 ( a16, 0 )          // adds a new element

See Also: "Get16()" "Len16()" "New16()" "Scan16()" "Set16()" 


    Get16()

         Returns an element from an array16

    Syntax:

         Get16 ( aArray, nPos ) -> NIL

                                 - Page 19 -
Norton Guide: `FAST.lib 3.50  Reference'



         aArray : The previously array16 created
         nPos   : The position to return

    Description:

         Returns the value of an array16 position. If nPos is not
         specified or if is higher than the number of elements of array16
         the function returns NIL.

    Return:

         The value of the specified position or NIL if nPos is not a
         valid parameter.

    Example:

         a16 := New16 ( 15000, 0 )
         ? Get16 ( a16, 1 )          // Is sure that returns 0

See Also: "Add16()" "Len16()" "New16()" "Scan16()" "Set16()" 


    Len16()

         Returns an array16 length

    Syntax:

         Len16 ( aArray ) -> nLen

         aArray : The previously created array16

    Description:

         Returns the length or the number of elements of an array16.

    Return:

         The number of elements of the array16.

    Example:

         a16 := New16 ( 15000, 0 )
         Add16 ( a16, 0 )
         ? Len16 ( a16 )          // 15001

See Also: "Add16()" "Get16()" "New16()" "Scan16()" "Set16()" 


    New16()

         Creates an array structure with 16 million elements

    Syntax:

                                 - Page 20 -
Norton Guide: `FAST.lib 3.50  Reference'



         New16 ( nNumItems, xInit ) -> aArray

         nNumItems : The array number of elements
         xInit     : The initial value to the array elements

    Description:

         Creates a structure of a new type of data that I want to
         baptize as array16 in honor of its 16 million elements.

         Actually, if available memory would admit it, which I
         doubt, you could get 16.777.216 elements.

    Return:

         The generated array.

    Example:

         New16 ( 125000, 0 )  // creates an 125 element array
                              // initialized to 0

See Also: "Add16()" "Get16()" "Len16()" "Scan16()" "Set16()" 


    Scan16()

         Looks for an element of an array16

    Syntax:

         Scan16 ( aArray, xSearch [, nStart] ) -> nPos

         aArray  : The previously created array16
         xSearch : The value to look for into the array
         nStart  : The initial value of the position to start the looking for.
                   Is by default the first element

    Description:

         Looks for an element in an array16 and returns it's position.

    Return:

         The position where the element is found or 0 if it can not be found.

    Example:

         a16 := New16 ( 15000, 0 )
         Add16 ( a16, 1 )
         ? Len16 ( a16 )            // 15001
         ? Scan ( a16, 1 )          // Returns 15001 too

See Also: "Add16()" "Get16()" "Len16()" "New16()" "Set16()" 

                                 - Page 21 -
Norton Guide: `FAST.lib 3.50  Reference'




    Set16()

         Puts a value into an array16 position

    Syntax:

         Set16 ( aArray, nPos, xValue ) -> NIL

         aArray : The previously created array16
         nPos   : The array position to modify
         xValue : The new value of the specified position

    Description:

         Puts a value to an element of an array16. The value of nPos has
         to be equal or lower to the array16 number of elements.

    Return:

         Nothing.

    Example:

         a16 := New16 ( 15000, 0 )
         Set16 ( a16, 100, "Hello" )  // Now the element 100 is "hello"

See Also: "Add16()" "Get16()" "Len16()" "New16()" "Scan16()" 



 Array

 


    aCar2Arr()

         Converts a string or memo to an array

    Syntax:

         aCar2Arr ( cMemStr, cSep ) -> aArray

         cMemStr    : The string or memo to treat
         cSep       : The element separator

    Description:

         Converts a string or memo to an array using a character as separator
         inside the string.

    Return:


                                 - Page 22 -
Norton Guide: `FAST.lib 3.50  Reference'


         The generated array.

    Example:

         aCar2Arr ( "Fast,Best", "," )     // { "Fast", "Best" }
         aCar2Arr ( "Best@Fast", "@" )     // { "Best", "Fast" }


    aMaxArr()

         Returns the maximum value of an array

    Syntax:

         aMaxArr ( aArray ) -> xMax

         aArray : The array to treat

    Description:

         Returns the maximum value of a specified array by the type of data.
         If is a character array, returns the biggest string and if is a
         numeric array returns the biggest number...

    Return:

         The maximum value or 0 if the array is empty

    Example:

         nMax := aMaxArr ( { 2, 3, 1, 9, 7 } )     // 9
         cMax := aMaxArr ( { "Good", "Bad" } )     // "Good"

See Also: "aMinArr()" 


    aMinArr()

         Returns the minimum value of an array

    Syntax:

         aMinArr ( aArray ) -> xMax

         aArray : The array to treat

    Description:

         Returns the minimum value of a specified array by the type of data.
         If is a character array, returns the smallest string and if it is a
         numeric array returns the smallest number.

    Return:

         The minimum value or 0 if the array is empty.

                                 - Page 23 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         nMax := aMinArr ( { 2, 3, 1, 9, 7 } )     // 1
         cMax := aMinArr ( { "Bad", "Good" } )     // "Bad"

See Also: "aMaxArr()" 


    aDimArr()

         Returns the number of dimensions of an array

    Syntax:

         aDimArr ( aArray ) -> nDim

         aArray : The array to treat

    Description:

         Returns the number of dimensions of an array. The array has to be
         homogeneous since it uses the first position to calculate the
         dimensions.

    Return:

         The array dimensions.

    Example:

         nMax := aDimArr ( { 2, 3, 1, 9, 7 } )          // 1
         nMax := aDimArr ( { { 12, 12 }, { 1, 1 } } )   // 2

See Also: "aMaxArr()" "aMinArr()" 


    RestArray()

         Restores a file array

    Syntax:

         RestArray( cFile, @nError ) -> aArray

         cFile  : The file to be restored
         nError : The error code returned by DOS. 0 there is no error.

    Description:

         Restores any kind of array data except logic for the objects.

    Return:

         The restored array.

                                 - Page 24 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         aArray := RestArray ( "Fast.arr", @nErr )
         If nErr == 0
           Message ( "Ok" )
         Else
           Message ( "DOS error number " + Str ( nErr ) )
         EndIf

See Also: "SaveArray()" 


    SaveArray()

         Saves an array to a file

    Syntax:

         SaveArray( aArray, cFile, @nError ) -> NIL

         aArray   : The array to be saved
         cFile    : The file to be created
         nError   : The error code returned by DOS. 0 there is no error.

    Description:

         Saves any kind of array data except logic for the objects.

    Return:

         Nothing.

    Example:

         SaveArray ( { 23, "Hello world", { 12, 32 } }, "Fast.arr", @nErr )
         If nErr == 0
           Message ( "Ok" )
         Else
           Message ( "DOS error number " + Str ( nErr ) )
         EndIf

See Also: "RestArray()" 



 Date

 


    cGetMonth()

         Returns the specified month.


                                 - Page 25 -
Norton Guide: `FAST.lib 3.50  Reference'


    Syntax:

         cGetMonth( nMonth ) -> cMonth

         nMonth : The month number from 1 to 12

    Description:

         Returns the month in character format of the specified month.

    Return:

         The month in character mode.

    Example:

         ? cGetMonth ( 4 )  // April in international version or
                            // Abril in spanish version

See Also: "dToDMY()" "dAddMonth()" "lLeap()" 


    dToDMY()

         Converts data type Date to String Day/Month/Year.

    Syntax:

         dToDMY( dDate ) -> cDate

         dDate : Date to evaluate.

    Description:

         Returns a string with day/month/year.

    Return:

         The date in String format DD/MM/AA or DD/MM/AAAA.

    Example:

         ? dToDMY ( Date() )  // 31/01/1993

See Also: "cGetMonth()" "dAddMonth()" "lLeap()" "dToMDY()" 


    dToMDY()

         Converts data type Date to String Month/Day/Year.

    Syntax:

         dToMDY( dDate ) -> cDate


                                 - Page 26 -
Norton Guide: `FAST.lib 3.50  Reference'


         dDate : Date to evaluate.

    Description:

         Returns a string with month/day/year.

    Return:

         The date in String format MM/DD/AA or MM/DD/AAAA.

    Example:

         ? dToMDY ( Date() )  // 01/31/1993

See Also: "cGetMonth()" "dAddMonth()" "lLeap()" "dToDMY()" 


    dAddMonth()

         Adds months to a date and returns a new date

    Syntax:

         dAddMonth ( dDate, nMonths ) -> dNewDate

         dDate   : The starting date.
         nMonths : The number of months to add.

    Description:

         Adds nMonths to dDate and returns the new date.

    Return:

         The new date.

    Example:

         ? dAddMonth ( Date(), 8 )

See Also: "cGetMonth()" "dToDMY()" "lLeap()" 


    lLeap()

         Returns a logic indicating if it is a leap year

    Syntax:

         lLeap ( dDate ) -> lIsLeap

         dDate : The date to determinate if it is leap or not

    Description:


                                 - Page 27 -
Norton Guide: `FAST.lib 3.50  Reference'


         The format of the _SET_FORMAT do not affect the result.

    Return:

         .T. if it is leap and .F. it is not.

    Example:

         ? lLeap ( Date() )

See Also: "cGetMonth()" "dToDMY()" "dAddMonth()" 


    FirstDay()

         Returns the first day of the month

    Syntax:

         FirstDay ( dDate ) -> dFirstDay

         dDate : The date which month is going to be treated

    Description:

         Returns the date of the first day at the specified
         Date or month of the system data.

    Return:

         First day of the month Date.

    Example:

         ? FirstDay()                         // 01/03/93
         ? FirstDay( cTod ( "22/01/92" ) )    // 01/01/92

See Also: "LastDay()" 


    Sec2days()

         Converts a given number of seconds to days

    Syntax:

         Sec2days ( nSeconds ) -> nDays

         nSeconds : The number of seconds to convert

    Description:

         Returns the specified number of seconds in days.

    Return:

                                 - Page 28 -
Norton Guide: `FAST.lib 3.50  Reference'



         The number of days.

    Example:

         ? Sec2Days ( 90000 )           // 1


    LastDay()

         Returns the last day of the month

    Syntax:

         LastDay ( dDate ) -> dLastDay

         dDate : The date which month has to be treated

    Description:

         Returns the specified last day of the month.

    Return:

         The date of the last day of the month.

    Example:

         ? LastDay()                         // 31/03/93
         ? LastDay( cTod ( "22/01/92" ) )    // 31/01/92

See Also: "FirstDay()" 


    SToD()

         Converts a string to Clipper Date

    Syntax:

         SToD( cString ) -> dDate

         cString : The string to convert

    Description:

         Converts a string to Clipper date.

    Return:

         A date value.

    Example:

         dDate := SToD( "19902103" )

                                 - Page 29 -
Norton Guide: `FAST.lib 3.50  Reference'


         ? DToS( dDate )                // DToS() is a standard Clipper func.



 Time

 


    TimeAMPM()

         Returns the time in the format am/pm

    Syntax:

         TimeAMPM() -> cTime

    Description:

         Returns system time in the format 12 hours am/pm.

    Return:

         The string with the time.

    Example:

         ? TimeAMPM()               //  "11:21:19 pm"


    Time2Time()

         Returns the difference between two times

    Syntax:

         Time2Time ( cTime1, cTime2 ) -> cDifferentHour

         cTime1 : The first time or start time
         cTime2 : The second time or end time

    Description:

         cTime2 has to be bigger than cTime1.

    Return:

         The difference between both hours as a string.

    Example:

         ? Time2Time ( "22:12:12", "23:12:13" )  // "01:00:01"




                                 - Page 30 -
Norton Guide: `FAST.lib 3.50  Reference'


 Numeric

 


    CompNumber()

         Compress and decompress a Clipper number

    Syntax:

         CompNumber( xValue, lMode, nSize, nDecimals ) -> cCompress|nValue

         xValue    : The number to compress if lMode is .T. or the string
                     to decompress if lMode is .F.
         lMode     : .T. to compress and .F. to decompress
         nSize     : The size of the number. By default 10 digits.
         nDecimals : The number of decimals. By default 0.

    Description:

         Compress a number returning an string or decompress an string
         returning a Clipper number.
         Is ideal for save space in a dbf file.

    Return:

         An string with the compressed number if lMode is .T. or the number
         decompressed if lMode is .F.

    Example:

         nNumber := 9876543210
         ? LEN( STR( nNumber ) )                // 10
         ? LEN( CompNumber( nNumber ) )         // 5


    Cos()

         Calculates a cosine number

    Syntax:

         Cos( nNumber ) -> nCos

         nNumber : The number to calculate the cosine from

    Description:

         Calculates a cosine number with a numeric method.

         Warning!!
         The number has to be in radians, not degrees.

    Return:

                                 - Page 31 -
Norton Guide: `FAST.lib 3.50  Reference'



         The specified cosine number or NIL if the number is not
         specified.

    Example:

         Cos( 0 )    //  1.00

See Also: "Deg2Rad()" "NumPi()" "Rad2Deg()" "Sin()" 


    CoSec()

         Calculates a co-secant number

    Syntax:

         CoSec( nNumber ) -> nCoSec

         nNumber : The number to calculate the co-secant from

    Description:

         Calculates a co-secant number with a numeric method.

         Warning!!
         The number has to be in radians, not degrees.

    Return:

         The specified co-secant number or NIL if the number is not
         specified.

    Example:

         CoSec( 0 )             // 1.00

See Also: "Cos()" "Deg2Rad()" "NumPi()" "Rad2Deg()" 


    CoTec()

         Calculates a co-tangent number

    Syntax:

         CoTan( nNumber ) -> nCoTan

         nNumber : The number to calculate the co-tangent from

    Description:

         Calculates a co-tangent number with a numeric method.

         Warning!!

                                 - Page 32 -
Norton Guide: `FAST.lib 3.50  Reference'


         The number has to be in radians, not in degrees.

    Return:

         The specified co-tangent number or NIL if the number is not
         specified.

    Example:

         CoTan( Deg2Rad ( 45 ) )         // 1.00

See Also: "Cos()" "Deg2Rad()" "NumPi()" "Rad2Deg()" "Sin()" 


    Deg2Rad()

         Converts degrees to radians

    Syntax:

         Deg2Rad( nDegree ) -> nRadian

         nDegree : The number of degrees to convert

    Description:

         This function converts a numeric value that specifies an angle in
         degrees to radians.

    Return:

         The number converted to radians or NIL if the number is not
         specified.

    Example:

         Deg2Rad( 180 )    //  3.141592

See Also: "Cos()" "NumPi()" "Rad2Deg()" "Sin()" 


    Exponent()

         Elevates a number to a given potency

    Syntax:

         Exponent( nNumber, nExponent ) -> nNewNumber

         nNumber   : The number to be elevated.
         nExponent : The potency to elevate the number to.

    Description:

         Elevates a given number to a given potency. The default potency

                                 - Page 33 -
Norton Guide: `FAST.lib 3.50  Reference'


         is two, which is square.

    Return:

         The elevated number.

    Example:

         Exponent( 10, 3 )    //  1000
         Exponent( 10 )       //  100

See Also: "Factorial()" "Sum()" 


    Factorial()

         Returns a factorial number

    Syntax:

         Factorial( nNumber ) -> nFactorial

         nNumber : The number to calculate the factorial from.

    Description:

         Calculates a factorial number that has to be 0 or bigger than 0.

    Return:

         The specified factorial number or NIL if negative number.

    Example:

         Factorial( 4 )    //  24

See Also: "Exponent()" "Sum()" 


    Int2Roman()

         Converts an integer to roman notation

    Syntax:

         Int2Roman( nNumber ) -> cRomanNumber

         nNumber : The number to convert

    Description:

         Converts an integer to roman notation. The number must be positive.

    Return:


                                 - Page 34 -
Norton Guide: `FAST.lib 3.50  Reference'


         A string with the number in roman notation.

    Example:

         Int2Roman( 1217 )    //  "MCCXVII"


    Log10()

         Returns a logarithm in base 10

    Syntax:

         Log10( nNumber ) -> nLogNumber

         nNumber : The number to calculate the logarithm from.

    Description:

         Returns a given logarithm number in base 10 calculated with
         the use of natural logarithms.

    Return:

         The logarithm in base 10 or NIL if negative number.

    Example:

         Log10( 10 )    //  1

See Also: "LogX()" 


    LogX()

         Returns the logarithm in any base

    Syntax:

         LogX( nNumber, nBase ) -> nLogNumber

         nNumber : The number to calculate the logarithm from.
         nBase   : The logarithms base.

    Description:

         Returns the logarithm in the specified base.

         See the function Log10().  It is a separate function because
         you would most likely use base 10.

    Return:

         The logarithm in the specified base or NIL if negative number.


                                 - Page 35 -
Norton Guide: `FAST.lib 3.50  Reference'


    Example:

         LogX( 10, 10 )    //  1

See Also: "Log10()" 


    nRandom()

         Generates a random number

    Syntax:

         nRandom ( nMax ) -> nNumber

         nMax : The maximum value able to take for the number.

    Description:

         Generates a random number between 0 and the specified max number
         minus 1.
         If you desire a random number between, for example, 2 and 5, you
         would use syntax like this:  nVar := 2 + nRandom ( 3 )

    Return:

         The random generated number.

    Example:

         nRandom ( 100 )        // a number betwen 0-99


    NumE()

         Returns the E number

    Syntax:

         NumE() -> nNumber

    Description:

         Returns the E number, which can be very valuable in statistic
         calculus and another areas of mathamatic and numeric analysis.

    Return:

         The E number.

    Example:

         NumE()    //  2.7183

See Also: "NumPi()" 

                                 - Page 36 -
Norton Guide: `FAST.lib 3.50  Reference'




    NumPi()

         Returns the Pi number

    Syntax:

         NumPi() -> nNumber

    Description:

         Returns the Pi number, which can be very valuable in statistic
         calculus and another areas of mathamatic and numeric analysis.

    Return:

         The Pi number.

    Example:

         NumPi()    //  3.141592

See Also: "NumE()" 


    Rad2Deg()

         Converts radians to degrees

    Syntax:

         Rad2Deg( nRadian ) -> nDegree

         nRadian : The radian number to convert

    Description:

         This function converts a numeric value which specifies a radian
         angle into degrees.

    Return:

         The number converted to degrees or NIL if the number is
         not specified.

    Example:

         Rad2Deg( NumPi() )    //  180.00

See Also: "Deg2Rad()" "Cos()" "NumPi()" "Sin()" 


    Sum()


                                 - Page 37 -
Norton Guide: `FAST.lib 3.50  Reference'


         Returns the summation of a number

    Syntax:

         Sum( nNumber ) -> nSummation

         nNumber : The number to calculate the summation from.

    Description:

         Calculates the summation of a number that has to be 0 or bigger
         than 0.

    Return:

         The summation of a specified number or NIL if negative number.

    Example:

         Sum( 4 )    //  10

See Also: "Exponent()" "Factorial()" 


    Sec()

         Calculates a secant number

    Syntax:

         Sec( nNumber ) -> nSec

         nNumber : The number to calculate the secant from

    Description:

         Calculates a secant number with a numeric method.

         Warning!!
         The number has to be in radians, not degrees.

    Return:

         The specified secant number or NIL if the number is not
         specified.

    Example:

         Sec( Deg2Rad ( 90 ) )         // 1.00

See Also: "Deg2Rad()" "NumPi()" "Rad2Deg()" "Sin()" 


    Sin()


                                 - Page 38 -
Norton Guide: `FAST.lib 3.50  Reference'


         Calculates a sine number

    Syntax:

         Sin( nNumber ) -> nSin

         nNumber : The number to calculate the sine from

    Description:

         Calculates a sine number with a numeric method.

         Warning!!
         The number has to be in radians, not degrees.

    Return:

         The specified sine number or NIL if the number is not
         specified.

    Example:

         Sin( NumPi() / 2 )    // 1.00

See Also: "Deg2Rad()" "Cos()" "NumPi()" "Rad2Deg()" 


    Tan()

         Calculates a tangent number

    Syntax:

         Tan( nNumber ) -> nTan

         nNumber : The number to calculate the tangent from

    Description:

         Calculates a tangent number with a numeric method.

         Warning!!
         The number has to be in radians, not degrees.

    Return:

         The specified tangent number or NIL if the number is not
         specified.

    Example:

         Sec( Deg2Rad ( 45 ) )         // 1.00

See Also: "Cos()" "Deg2Rad()" "NumPi()" "Rad2Deg()" "Sin()" 


                                 - Page 39 -
Norton Guide: `FAST.lib 3.50  Reference'




 String

 


    AsciiAdd()

         Adds or subtracts all elements of a string

    Syntax:

         AsciiAdd( cString, nAdds ) -> cNewString

         cString : The string to manipulate
         nAdds   : The number to add

    Description:

         Adds or subtracts all elements of a string and returns the
         new string.

    Return:

         The new string.

    Example:

         ? AsciiAdd( "0123456789", 1 )      //  "123456789:"
         ? AsciiAdd( "0123456789", -1 )     //  "/012345678"

See Also: "AsciiSum()" 


    AsciiSum()

         Adds all elements of a string

    Syntax:

         AsciiSum( cString ) -> nAdds

         cString : The string to manipulate

    Description:

         Adds all ascii values of a specified string.

    Return:

         The sum of all ascii values.

    Example:


                                 - Page 40 -
Norton Guide: `FAST.lib 3.50  Reference'


         ? AsciiSum( "AB" )             // 131

See Also: "AsciiAdd()" 


    At2()

         Looks for the Nth occurrence in a string

    Syntax:

         At2( cSearch, cTarget [, nOcur] ) -> nPos

         cSearch : The character substring to search for
         cTarget : The character string to search
         nOcur   : Number of the occurrence, default is 1

    Description:

         The parameters are the same as AT() of the standard library
         Clipper.lib except for nOcur that indicates the number of the
         occurrences to return. The default nOcur is 1.
         The function is Case Sensitive.

    Return:

         The same than AT().

    Example:

         ? At2 ( "a", "Manu Roibal" )      //  2
         ? At2 ( "a", "Manu Roibal", 2 )   // 10
         ? At2 ( "a", "Manu RoibAl", 2 )   // 0


    aToken()

         Returns an array of words from a string

    Syntax:

         aToken( cString [, cSepara] ) -> aWords

         cString : The string to treat
         cSepara : A string with valid word separators. By default
                   ,;:. ?!()&/*+-%[]{}"

    Description:

         Treats a string as if it were a phrase creating an array of words
         contained in the string. May be very useful to syntactic analyzers
         generation, pseudo-compilers...

    Return:


                                 - Page 41 -
Norton Guide: `FAST.lib 3.50  Reference'


         An array of words.

    Example:

         aArray := aToken ( "Fast Library For Clipper" )
         For nInd := 1 To Len ( aArray )
           ? aArray[ nInd ]
         Next

See Also: "NumToken()" "Token()" 


    Capital()

         Converts the first letters to capitals

    Syntax:

         Capital( cString ) -> cNewString

         cString : The string to convert

    Description:

         Converts the whole letter string to lower-case letters except
         for the first letter of each word which are capital. Respects
         blankspaces on the left and on the right.

    Return:

         The capitalized a string.

    Example:

         ? Capital ( " manu ROIBAL " )   // " Manu Roibal "


    CharEven()

         Returns a string with the even bytes of another string

    Syntax:

         CharEven( cString ) -> cNew

         cString : The string to manipulate

    Description:

         Returns a string with the even bytes of the specified string.

    Return:

         The new string.


                                 - Page 42 -
Norton Guide: `FAST.lib 3.50  Reference'


    Example:

         ? CharEven( "1234567890" )   // "24680"

See Also: "CharMix()" "CharOdd()" 


    CharMix()

         Mixes two strings and generates another

    Syntax:

         CharMix( cStrEven, cStrOdd ) -> cNew

         cStrEven : The first string to manipulate
         cStrOdd  : The second string to manipulate

    Description:

         Mixes two specified strings and generates another string.

    Return:

         The new string.

    Example:

         ? CharMix( "02468", "13579" )   // "0123456789"

See Also: "CharEven()" "CharOdd()" 


    CharOdd()

         Returns a string with the odd bytes of another string

    Syntax:

         CharOdd( cString ) -> cNew

         cString : The string to manipulate

    Description:

         Returns a string with the odd bytes of the specified string.

    Return:

         The new string.

    Example:

         ? CharOdd( "1234567890" )   // "13579"


                                 - Page 43 -
Norton Guide: `FAST.lib 3.50  Reference'


See Also: "CharEven()" "CharMix()" 


    Expand()

         Expands a string

    Syntax:

         Expand( cString [, cExpand] ) -> cNewString

         cCadena : The string to expand
         cExpand : The character to expand with

    Description:


         Expands cString with cExpand being placed between each
         of cString's characters.  cExpand's default value is a
         blank space.

    Return:

         The expanded string.

    Example:

         ? Expand ( "Itxaso", "*" )            // I*t*x*a*s*o
         ? Expand ( "itxaso" )                 // i t x a s o
         ? Expand ( "Itxaso", "* *" )          // I* *t* *x* *a* *s* *o


    Like()

         Compares two strings using wildcards

    Syntax:

         Like( cMask, cString ) -> lEqual

         cMask   : One string may contain the wildcards * and ?
         cString : The other string to compare

    Description:

         Compare two strings with wildcards to one position (?)
         or wildcards to n positions (*).

         The function is case sensitive.

    Return:

         A logic indicating if the strings are similar or not.

    Example:

                                 - Page 44 -
Norton Guide: `FAST.lib 3.50  Reference'



         ? Like ( "*A*",  "Fast" )          // .F.
         ? Like ( "*a*",  "Fast" )          // .T.
         ? Like ( "?ast", "Fast" )          // .T.


    NumToken()

         Returns the word count of a string

    Syntax:

         NumToken( cString [, cSepara] ) -> nWords

         cString : The string to treat
         cSepara : A string with valid word separators. By default
                   ,;:. ?!()&/*+-%[]{}"

    Description:

         Treats a string as if it were a phrase determining the word count.

         May be very useful to syntactic analyzers generation,
         pseudo-compilers...

    Return:

         The word count.

    Example:

         ? NumToken ( "Fast Library For Clipper" )

See Also: "aToken()" "Token()" 


    Occurs()

         Looks for the number of occurrences in a string

    Syntax:

         Occurs( cString, cSearch ) -> nTimes

         cString : The string to search
         cSearch : The sub-string to look for in cString

    Description:

         Returns the number of times that cSearch is in cString.

         The function is Case Sensitive.

    Return:


                                 - Page 45 -
Norton Guide: `FAST.lib 3.50  Reference'


         The number of times that cSearch is in cString.

    Example:

         ? Occurs ( "Manu Roibal", "j" )   //  0
         ? Occurs ( "Manu Roibal", "A" )   //  0
         ? Occurs ( "Manu Roibal", "a" )   //  2


    StrGetCar()

         Returns a character from a string

    Syntax:

         StrGetCar( cString, nPos ) -> nChar

         cString : The string to treat
         nPos    : The string position to return

    Description:

         Returns the ASCII value of the character in the specified
         position inside the string.

         This function, in conjunction with StrSetCar() may be very
         useful when a string is to be treated in C style as if it
         were character arrays.

    Return:

         The ASCII character value.

    Example:

         ? StrGetCar ( "Hello World", 1 )      //  72
         ? StrGetCar ( "Hello world", 0 )      //  NIL
         ? StrGetCar ( "Hello world", 5 )      //  32

See Also: "StrSetCar()" 


    StrSetCar()

         Modifies a character in a string

    Syntax:

         StrSetCar( cString, nPos, nChar ) -> cNewString

         cString : The string to treat
         nPos    : The string position modify
         nChar   : The new character to replace

    Description:

                                 - Page 46 -
Norton Guide: `FAST.lib 3.50  Reference'



         Modifies a string at the specified position and returns the new
         string.

         This function, in conjunction with StrSetCar() may be very
         useful when a string is to be treated in C style as if it were
         character arrays.

    Return:

         The modified string.

    Example:

         ? StrSetCar ( "Hello world", 1, 32 )   //  " Hello world"
         ? StrSetCar ( "Hello world", 0, 35 )   //  "Hello world"
         ? StrSetCar ( "Hello world", 7, 85 )   //  "Hello world"

See Also: "StrGetCar()" 


    Token()

         Returns a string word given a delimiter and occurrence

    Syntax:

         Token( cString, [cSepara], [nWord] ) -> cWord

         cString : The string to treat
         cSepara : A string with valid word separators. By default
                   ,;:. ?!()&/*+-%[]{}"
         nWord   : The word number to return. By default 1.

    Description:

         Treats a string as if it were a phrase determining a specified
         word from within the string.

    Return:

         The specified word or "" if the word number is higher than the
         maximum number of words in the phrase.

    Example:

         ? Token ( "Fast Library For Clipper", , 2 )    // "Library"

See Also: "aToken()" "NumToken()" 



 Stack

 

                                 - Page 47 -
Norton Guide: `FAST.lib 3.50  Reference'




    StackEmpty()

         Determines if stack is empty

    Syntax:

         StackEmpty( aStack ) -> lEmpty

         aStack : The created stack with StackNew()

    Description:

         Returns a logic indicating if stack is empty.

    Return:

         .T. if empty and .F. if it has any element.

    Example:

         aStack := StackNew ()
         StackPush ( aStack, "hello matthew" )
         If StackEmpty ( aStack )
           ...

See Also: "StackHead()" "StackNew()" "StackPop()" "StackPush()" 


    StackHead()

         Returns the top of the FIFO stack

    Syntax:

         StackHead( aStack ) -> xHeadValue

         aStack : The created stack with StackNew()

    Description:

         Returns the value of the stack top, I mean the last entered
         value, without removing from stack.

    Return:

         The top value of the stack.

    Example:

         aStack  := StackNew ()
         StackPush ( aStack, "hello world" )
         ? StackHead( aStack )            // "hello world"


                                 - Page 48 -
Norton Guide: `FAST.lib 3.50  Reference'


See Also: "StackNew()" "StackPop()" "StackPush()" "StackEmpty()" 


    StackNew()

         Creates a FIFO type stack

    Syntax:

         StackNew() -> aNewStack

    Description:

         Creates a empty FIFO type stack. Remember FIFO (First In First Out)

    Return:

         The created stack.

    Example:

         aStack := StackNew()

See Also: "StackHead()" "StackPop()" "StackPush()" "StackEmpty()" 


    StackPop()

         Removes a stack element

    Syntax:

         StackPop( aStack ) -> xOldHead

         aStack : The stack created with StackNew()

    Description:

         Removes a stack element and returns this element's value.

    Return:

         The older stack head value.

    Example:

         aStack  := StackNew ()
         StackPush ( aStack, "hello world" )
         StackPush ( aStack, "Bye bye" )
         ? StackPop ( aStack )           // "Bye bye"
         ? StackHead( aStack )           // "hello world"

See Also: "StackHead()" "StackNew()" "StackPush()" "StackEmpty()" 



                                 - Page 49 -
Norton Guide: `FAST.lib 3.50  Reference'


    StackPush()

         Introduces an element into the stack

    Syntax:

         StackPush( aStack, xValue ) -> NIL

         aStack : The created stack with StackNew()
         xValue : The new value to introduce into the stack

    Description:

         Introduces a new element into the stack and places it as stack
         head.

    Return:

         Nothing.

    Example:

         aStack := StackNew ()
         StackPush ( aStack, "hello world" )
         StackPush ( aStack, "bye" )
         ? StackHead( aStack )            // "bye"

See Also: "StackHead()" "StackNew()" "StackPop()" "StackEmpty()" 



























                                 - Page 50 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 1, Dbf/Memo




    Now I open a new section in Fast Library answering to some users. In
 this section I'll go collecting functions for handling databases and memo
 fields.

 


    Gather()

         Initializes a register with the information of an array

    Syntax:

         Gather( aArray ) -> NIL

         aArray : An array with the information

    Description:

         Initializes a register with the information of an array that
         previously could have been generated with the Scatter function.
         The table the data comes from is the one that is in the default
         work area. This table must be opened.

    Return:

         Nothing.

    Example:

         use sold new
         dbGoBotton()
         aArray := Scatter ()
         aArray [ 1 ] := "matthew"
         Gather ( aArray )

See Also: "Scatter()" 


    HaveDbt()

         Indicates if the Dbf has a linked Dbt

    Syntax:

         HaveDbt( cDbf ) -> lHave

         cDbf : The name of the Dbf with extension to be verified

    Description:

                                 - Page 51 -
Norton Guide: `FAST.lib 3.50  Reference'



         Indicates if the specified Dbf has a linked Dbt, if it has any
         memo field.

    Return:

         .T. if it has memo fields or .F. if it hasn't

    Example:

         ? HaveDbt( "Fast.dbf" )


    Scatter()

         Returns an array with the information of a register

    Syntax:

         Scatter() -> aArray

    Description:

         Returns an array with the information of a register.
         The table the data comes from is the one that is in the default
         work area. This table must be opened.

    Return:

         An array with the same structure as the register and loaded with
         the current register of the table.

    Example:

         use clients new
         aArray := Scatter ()
         aArray [ 1 ] := "Joe"
         Gather ( aArray )

See Also: "Gather()" 















                                 - Page 52 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 1, Disk and File




    These next functions are to centralize all accesses to one or more
 binary files in Clipper.

    These functions check all kinds of errors that could be produced
 in a Clipper program when it accesses binary files, like, the file
 doesn't exist, or trying to access a file without locking it.

    Besides, you'll be able to forget the I/O errors because all file access
 functions retry the operation and inform the user if there's some error.

 


    ArjFile()

         Returns the contents of an ARJ file

    Syntax:

         ArjFile ( cFile ) -> aARJ

         cFile : The name of the ARJ file

    Description:

         Returns a bidimensional array with information about the contents
         of an ARJ file.

         The subarrays have the following format:

         {
           { cName, nCompr, nSize, nRatio, dDate, cTime }
           ...
           { cName, nCompr, nSize, nRatio, dDate, cTime }
         }

         cName          File name
         nSize          Real size of file
         nCompr         Compressed size
         nRatio         Compression ratio
         dDate          Date of file
         cTime          Time of file

    Return:

         An array with information about the contents of ARJ file.

    Example:

         aARJ := ArjFile ( "C:\FastLib\Fast.Arj" )

                                 - Page 53 -
Norton Guide: `FAST.lib 3.50  Reference'


         For nInd := 1 To Len ( aARJ )
           For nOther := 1 To Len ( aARJ [ nInd ] )
             ? aARJ [ nInd, nOther ]
           Next
         Next

See Also: "ZipFile()" 


    ClipperPath()

         Returns the Clipper Path

    Syntax:

         ClipperPath() -> cPath

    Description:

         Returns a string with the Clipper Path.

    Return:

         Clipper Path.

    Example:

         ? ClipperPath () // C:\DATA;

See Also: "DOSPath()" 


    Clp2WKS()

         Convert a Clipper array to WKS Lotus File

    Syntax:

         Clp2WKS( cFile, aSheet ) -> NIL

         cFile  : The file to create
         aSheet : A Clipper array with the WorkSheet

    Description:

         Convert a Clipper array to WKS Lotus File creating a new file
         with extensin .WKS.

    Return:

         Nothing.

    Example:

         FUNCTION Example()

                                 - Page 54 -
Norton Guide: `FAST.lib 3.50  Reference'


         LOCAL aWorkSheet:={ ;
                           { "Column 1", "Column 2", "Column 3" }, ;
                           { 1991,  156,  625, 887,  123, 178   }, ;
                           { 1992,  161,   75,  72,  124        }, ;
                           { 1993,  711, -918, 716,  122        }, ;
                           { 1994, 1932, 1827, 998              }, ;
                           { 1995,  154,   12,  12, 9912        }, ;
                           { 1996,  612,   15,   3, 1921, 122   }, ;
                           { 1997, 18.4,  0.1,   1              }, ;
                           { 1998, 1213,  121, 121, 2121, 121   } }
             Clp2Wks( "DEMO", aWorkSheet )
         RETURN NIL


    Compress()

         Compress or decompress a file

    Syntax:

         Compress( cFileIn, cFileOut, lMode, bBlock ) -> nResult

         cFileIn  : Input file
         cFileOut : Output file
         lMode    : .T. compress and .F. decompress
         bBlock   : The codeblock to be evaluated

    Description:

         This function allows to compress any type of file. The compress
         ratio depends of the data type of the file, executable, text...
         This function decompress the previous compressed files too.

         The codeblock parametter receives 2 parametters:

         bBlock := { | x, y | QOut( x, y ) )

         When compress:

           x --> The number of bytes loaded.
           y --> Compression rate.

         When decompress:

           x --> The number of bytes loaded.
           y --> % bytes decompressed

         There's no limit in file size.

    Return:

         Return values:
             0 (no errors)
             1 (not enought memory)
             2 (load error)

                                 - Page 55 -
Norton Guide: `FAST.lib 3.50  Reference'


             3 (write error)

    Example:

         IF Compress( "PROGMAN.EXE", "PROGMAN.LZH", .T., { || NIL } ) == 0
           ?  "File compress ok. Decompressing with other name..."
           IF Compress( "PROGMAN.LZH", "OTROPRG.EXE". .F., { || NIL } ) == 0
             ?? "File decompress ok"
           ELSE
             ?  "Errors during decompression"
           ENDIF
         ELSE
           ?  "Errors during compression"
         ENDIF


    DirChange()

         Changes the directory

    Syntax:

         DirChange( cNewDirec ) -> nError

         cNewDirec : New directory

    Description:

         Changes the default DOS directory.

    Return:

         Returns the DOS error or zero if there is no error.

    Example:

         DirChange ( "\OS2\MDOS" )

See Also: "DirDel()" "DirCreate()" 


    DirCreate()

         Creates a directory

    Syntax:

         DirCreate( cDirec ) -> nError

         cDirec : New directory

    Description:

         Creates a new directory.


                                 - Page 56 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         Returns the DOS error or zero if there is no error.

    Example:

         DirCreate ( "\OS2\Midir" )

See Also: "DirDel()" "DirChange()" 


    DirDel()

         Deletes a directory from disk

    Syntax:

         DirDel( cDirec ) -> nError

         cDirec : Directory to delete

    Description:

         Deletes a directory. If it's the default directory DirDel() returns
         error.

    Return:

         Returns the DOS error or zero if there is no error.

    Example:

         DirDel ( "\OS2\TEMP" )

See Also: "DirChange()" "DirCreate()" 


    DirExist()

         Determines if a directory exists

    Syntax:

         DirExist( cDirec ) -> lExist

         cDirec : Directory to search

    Description:

         Determines if a directory is found.

    Return:

         .T. if directory is found and .F. if not found.


                                 - Page 57 -
Norton Guide: `FAST.lib 3.50  Reference'


    Example:

         ? DirExist ( "C:\OS2\MDOS" )    // .T.
         ? DirExist ( "A:\DATA" )        // .T.


    DiskFree()

         Returns the free space of a disk

    Syntax:

         DiskFree( nDisk ) -> nFree

         nDisk : 0 -> default disk
                 1 -> A:
                 2 -> B:
                 3 -> C:
                 ...

    Description:

         Returns the free space of a specified disk

    Return:

         The free space.

    Example:

         ? DiskSize( 0 )        // Disk Capacity
         ? DiskFree( 0 )        // Disk Free

See Also: "DiskSize()" 


    DiskSerNum()

         Returns the disk serial number

    Syntax:

         DiskSerNum( [nUnit] ) -> cSerialNumber

         nUnit : Unit number:
                 0 -> Default unit
                 1 -> A:
                 2 -> B:
                 3 -> C:
                 ...

    Description:

         Returns the serial number of the disk if it has been formatted
         with DOS 4.01 or greater.

                                 - Page 58 -
Norton Guide: `FAST.lib 3.50  Reference'



         The default value for nUnit is 0, is that to say, if no parameters
         are given, the function returns the serial number of the default unit.

    Return:

         A character value with the disk serial number.

    Example:

         ? DiskSerNum()           //    "1A3D-66B1"


    DiskSize()

         Returns the capacity of a disk

    Syntax:

         DiskSize( nDisk ) -> nCapacity

         nDisk : 0 -> default disk
                 1 -> A:
                 2 -> B:
                 3 -> C:
                 ...

    Description:

         Returns the capacity of a specified disk

    Return:

         The capacity.

    Example:

         ? DiskSize( 0 )        // Disk Capacity
         ? DiskFree( 0 )        // Disk Free

See Also: "DiskFree()" 


    DOSPath()

         Returns the DOS Path

    Syntax:

         DOSPath () -> cPath

    Description:

         Returns the DOS Path as a character value.


                                 - Page 59 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         DOS Path.

    Example:

         ? DOSPath () // C:\DOS;C:\CLIPPER5\BIN;

See Also: "ClipperPath()" 


    fAttributes()

         Returns the attributes of a file

    Syntax:

         fAttributes( cFile ) -> cAttributes

         cFile : The name of the file

    Description:

         Returns the attributes of a file, H if it's a hidden file, S system,
         A archive and R read only.

    Return:

         A character value with attributes or NIL if the file not found.

    Example:

         ? fAttributes ( "Fast.txt" )   // "A"

See Also: "fDate()" "fTime()" "fSize()" 


    fbClose()

         Closes binary files

    Syntax:

         fbClose( aHandle ) -> NIL

         aHandle : File handle array to close

    Description:

         Closes all the specified files in the array.

    Return:

         Nothing.


                                 - Page 60 -
Norton Guide: `FAST.lib 3.50  Reference'


    Example:

         fbClose ( { nHandIn, nHandOut, nHandErr } )

See Also: "fbOpen()" "fbCreate()" "fbWrite()" "fbRead()" 


    fbCreate()

         Creates a binary file

    Syntax:

         fbCreate( cFile ) -> nHandle

         cFile : The name of the file

    Description:

         Creates a file with name cFile. If cFile exists, it will be truncated
         to size 0. If there's some error, it retries 5 times and then asks
         the user if he wants to retry.

    Return:

         A file handle or -1 if an error is found.

    Example:

         nHandle := fbCreate ( "Fast.txt" )

See Also: "fbOpen()" "fbClose()" "fbWrite()" "fbRead()" 


    fbOpen()

         Opens a binary file

    Syntax:

         fbOpen( cFile, nMode ) -> nHandle

         cFile : The name of the file
         nMode : DOS open mode

    Description:

         Trys to open the file cFile in mode nMode with 5 retries and asks
         the user if he wants to continue retrying.

    Return:

         A file handle or -1 if an error is found.

    Example:

                                 - Page 61 -
Norton Guide: `FAST.lib 3.50  Reference'



         nHandle := fbOpen ( "Fast.txt", 0 )
         If nHandle == -1
           BoxWarning ( "Open error" )
         EndIf

See Also: "fbClose()" "fbCreate()" "fbWrite()" "fbRead()" 


    fbRead()

         Reads bytes from a binary file

    Syntax:

         fbRead( nHandle, cBuffer, nBuffer, nRead, ;
                 cFile, lForce ) -> lExit

         nHandle : The file handle of the file.
         cBuffer : The buffer to fill.
         nBuffer : The number of bytes to read.
         nRead   : Variable that returns the number of bytes read.
         cFile   : The name of the file.
         lForce  : Logic value to force nBuffer to be the same value
                   as nRead.

    Description:

         Reads nBuffer bytes from the file (nHandle/cFile) depositing the
         result in cBuffer. If cBuffer isn't big enough, the function will
         fill it with spaces at the end.  cFile is used to allow error
         messages to be displayed. If lForce is .T. the value read from the
         file must be nBuffer bytes and doesn't return until nRead is equal
         to that amount.  If lForce is .F. the function returns even though
         the value nRead hasn't been reached. Forget retries cause the
         same function checks all of that.

    Return:

         If there's some error, returns .F. if not returns .T.

    Example:

         cFile     := "Fast.txt"
         nHand     := fbOpen ( cFile, 0 )
         nRead     := 0
         nBuffer   := 100
         cBuffer   := Space ( nBuffer )
         lForce    := .F.
         If ! fbRead( nHand, cBuffer, nBuffer, @nRead, cFile, lForce )
           BoxWarning ( "The reading has been unsuccessful" )
         Else
           BoxWarning ( "I've read " + Str ( nRead ) + " Bytes" )
         EndIf
         fbClose ( { nHand } )

                                 - Page 62 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "fbOpen()" "fbClose()" "fbCreate()" "fbWrite()" 


    fbWrite()

         Writes to a binary file

    Syntax:

         fbWrite ( nHandle, cBuffer, nBuffer, nWrite, ;
                   cFile, lForce ) -> lexit

         nHandle : The file handle of the file.
         cBuffer : The buffer to write to the file.
         nBuffer : The number of bytes to be written.
         nWrite  : Variable that returns the number of bytes written.
         cFile   : The name of the file.
         lForce  : Logic value to force nBuffer to be the same value
                   as nWrite.

    Description:

         Writes nBuffer bytes from cBuffer to the file (nHandle).  cFile is
         used to allow error messages to be dislpayed. If lForce is .T. the
         value written to the file must be nBuffer bytes and doesn't return
         until nRead is equal to that amount. If lForce is .F. the function
         returns even though the value nRead hasn't been reached.  Forget
         retries becuase the same function checks all of that.

    Return:

         If there's an error returns .F. if not, returns .T.

    Example:

         cFile     := "Fast.txt"
         nHand     := fbOpen ( cfile, 2 )
         nWrite    := 100
         nBuffer   := 100
         cBuffer   := Space ( nBuffer )
         lForce    := .T.
         If ! fbWrite( nHand, cBuffer, nBuffer, @nWrite, cfile, lForce )
           Warning( "The read has been unsuccessful" )
         Else
           Warning( Str( nWrite ) + " must be the same " + Str( nBuffer ) )
         EndIf
         fbClose ( { nHand } )

See Also: "fbOpen()" "fbClose()" "fbCreate()" "fbRead()" 


    fCopy()

         Copies a file

                                 - Page 63 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         fCopy ( cSource, cTarget ) -> nError

         cSource : Source filename
         cTarget : Target filename

    Description:

         Copies a file returning the same values as the standard function
         fError().

    Return:

         0 if there's no error or a number indicating the error.

    Example:

         ? fCopy( "c:\txt\text", "d:\origin\demo.txt" )


    fDate()

         Returns the date of a file

    Syntax:

         fDate ( cFile ) -> dDate

         cFile : The name of the file

    Description:

         Returns file date as a date value.

    Return:

         The date of the file or NIL if file not exists

    Example:

         ? fDate ( "Fast.Txt" )  //   22/12/92

See Also: "fAttributes()" "fTime()" "fSize()" 


    fDefUnit()

         Changes the default drive

    Syntax:

         fDefUnit( nUnit ) -> NIL


                                 - Page 64 -
Norton Guide: `FAST.lib 3.50  Reference'


         nUnit : New default drive

    Description:

         Changes the default drive to the new specified
         drive knowing that 0=A:, 1=B;, ...

    Return:

         Nothing.

    Example:

         fDefUnit ( 1 )  // Change B:

See Also: "fMaxUnit()" 


    fDel()

         Deletes a file from disk

    Syntax:

         fDel( cFile ) -> nError

         cFile : The name of the file

    Description:

         Deletes the specified file.

    Return:

         Returns the DOS error or zero if there is no error.

    Example:

         If fDel ( "\dos\command.com" ) == 0
           BoxWarning( "Nooooooooo" )
         EndIf


    fExtension()

         Returns the file extension

    Syntax:

         fExtension ( cFile ) -> cExtension

         cFile : The name of the file

    Description:


                                 - Page 65 -
Norton Guide: `FAST.lib 3.50  Reference'


         Returns the file extension following the DOS rule for description,
         that is to say, a name of 8 letters followed by a point and an
         extension of 3 letters.

    Return:

         File extension as a character value or "" if file doesn't exist

    Example:

         ? fExtension ( "C:\FastLib\Fast.Txt" ) // Txt

See Also: "fName()" "fPath()" "fUnit()" 


    fEof()

         Determines if a file handle is in EOF

    Syntax:

         fEof( fHandle ) -> lEOF

         fHandle : File handle

    Description:

         Determines if a file handle is in EOF.

    Return:

         A logic value indicating if the file handle is in EOF.

    Example:

         fHandle := fOpen( "demo.txt", 0 )
         ? fEof( fHandle )

See Also: "fGoBottom()" "fGoTop()" "fPos()" 


    fGoBottom()

         Moves the file handle to end

    Syntax:

         fGoBottom( fHandle ) -> nNewPosition

         fHandle : File handle

    Description:

         Moves the file handle to end returning the new position.


                                 - Page 66 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         A number with the new position.

    Example:

         fHandle := fOpen( "demo.txt", 0 )
         fGoBottom( fHandle )

See Also: "fEof()" "fGoTop()" "fPos()" 


    fGoTop()

         Moves the file handle to begin

    Syntax:

         fGoTop( fHandle ) -> nNewPosition

         fHandle : File handle

    Description:

         Moves the file handle to begin returning the new position.

    Return:

         A number with the new position.

    Example:

         fHandle := fOpen( "demo.txt", 0 )
         fGoTop( fHandle )

See Also: "fEof()" "fGoBottom()" "fPos()" 


    fMaxUnit()

         Returns the number of logic DOS drives

    Syntax:

         fMaxUnit() -> nDrives

    Description:

         Returns the number of logic DOS drives. Frequently, if a Novell
         net exists a return of 32 is common. Under native DOS a return of 5
         or the value of LASTDRIVE, which ever is greater.

    Return:

         The number of logic DOS drives.

                                 - Page 67 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         nDrives := Str ( fMaxUnit () )
         ? "I have " + nDrives + " on my system."

See Also: "fDefUnit()" 


    fName()

         Returns the name of a file without extension

    Syntax:

         fName ( cFile ) -> cName

         cFile : The name of the file

    Description:

         Returns the name of a file following the DOS rule for description,
         that is to say, a name of 8 letters followed by a point and an
         extension of 3 letters.

    Return:

         The name of a file without extension.

    Example:

         ? fName ( "C:\FastLib\Fast.Txt" ) // Fast

See Also: "fExtension()" "fPath()" "fUnit()" 


    fPath()

         Returns the path of a file

    Syntax:

         fPath ( cFile ) -> cPath

         cFile : The name of the file

    Description:

         Returns the path of a file following the DOS rule for description,
         that is to say, a name of 8 letters followed by a point and an
         extension of 3 letters.

    Return:

         The path of the file.

                                 - Page 68 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         ? fPath ( "C:\FastLib\Fast.Txt" ) // C:\FastLib\

See Also: "fExtension()" "fName()" "fUnit()" 


    fPos()

         Returns the actual position of a file handle

    Syntax:

         fPos( fHandle ) -> nPosition

         fHandle : File handle

    Description:

         Returns the actual position of a file handle. This position is
         relative to the begining of file.

    Return:

         A number with the position.

    Example:

         fHandle := fOpen( "demo.txt", 0 )
         ? fPos( fHandle )

See Also: "fEof()" "fGoBottom()" "fGoTop()" 


    fRandom()

         Generates a random filename

    Syntax:

         fRandom() -> cFile

    Description:

         Returns a random filename with .TMP extension

    Return:

         The name of the file.

    Example:

         ? fRandom ()           // "WEDKFGVD.TMP"


                                 - Page 69 -
Norton Guide: `FAST.lib 3.50  Reference'



    FreeFiles()

         Returns the number of available DOS File Handles

    Syntax:

         FreeFiles() -> nFiles

    Description:

         Returns the number of available DOS File Handles as a numeric value.

    Return:

         A numeric value of the number of available DOS File Handles.

    Example:

         If FreeFiles() < 20
           BoxWarning ( "I'm sorry but you must have 20 files" )
         EndIF


    fSearch()

         Searches for a string in a file

    Syntax:

         fSearch( cFile, cString ) -> aPosition

         cFile   : The file to searched
         cString : The string to be found

    Description:

         Searches for a string in a file and returns an array with all of the
         positions that the string has been found or an empty array if
         the string isn't found in the file.

    Return:

         An array from 0 to n elements, each element contains one relative
         position to the file, starting from 0.

    Example:

         aRet := fSearch ( "Test.txt", "i want to be free" )
         For nInd := 1 To Len ( aRet )
           ? aRet [ nInd ]
         Next


    fSize()

                                 - Page 70 -
Norton Guide: `FAST.lib 3.50  Reference'



         Returns the size of a file

    Syntax:

         fSize ( cFile ) -> nSize

         cFile : The name of the file

    Description:

         Returns the size of a file as a numeric value.

    Return:

         The size of the file or NIL if the file is not found.

    Example:

         ? fSize ( "Fast.Txt" )  //   112

See Also: "fAttributes()" "fDate()" "fTime()" 


    fTime()

         Returns the time of a file

    Syntax:

         fTime ( cFile ) -> cTime

         cFile : The name of the file

    Description:

         Returns the time of a file as a character value.

    Return:

         The time of the file or NIL if file not found.

    Example:

         ? fTime ( "Fast.Txt" )  //   12:12:13

See Also: "fAttributes()" "fDate()" "fSize()" 


    fUnit()

         Returns the drive where a file exists

    Syntax:


                                 - Page 71 -
Norton Guide: `FAST.lib 3.50  Reference'


         fUnit ( cFile ) -> cUnit

         cFile : The name of the file

    Description:

         Returns the drive where a file exists as a character value.

    Return:

         The drive where the file was found or NIL if file not found.

    Example:

         ? fUnit ( "C:\FastLib\Fast.Txt" ) // C:

See Also: "fExtension()" "fName()" "fPath()" 


    GetLabel()

         Returns the label of a disk

    Syntax:

         GetLabel( nUnit ) -> cLabel

         nUnit : A disk number. 0=Current disk, 1=A:, 2=B:, 3=C:, ...

    Description:

         Returns the label of a disk.

    Return:

         A string with the label.

    Example:

         ? GetLabel ( 0 )               // "MANU ROIBAL"

See Also: "SetLabel()" 


    IsBootAble()

         Determines if the current disk has a boot sector

    Syntax:

         IsBootAble() -> lBoot

    Description:

         Determines if the current disk has a boot sector.

                                 - Page 72 -
Norton Guide: `FAST.lib 3.50  Reference'



    Return:

         A logic value indicating if it has a boot sector.

    Example:

         While ! IsBootAble()
           Warning( "Insert a disk with Operating System" )
         End


    IsFloppy()

         Determines if the current disk is a floppy

    Syntax:

         IsFloppy() -> lFloppy

    Description:

         Determines if the current disk is a floppy.

    Return:

         A logic value indicating if it is a floppy.

    Example:

         If IsFloppy()
           Warning( "Error: You need a hard disk" )
         EndIf

See Also: "IsHardDisk()" "IsNetDev()" 


    IsHardDisk()

         Determines if the current disk is a hard disk

    Syntax:

         IsHardDisk() -> lHard

    Description:

         Determines if the current disk is a hard disk.

    Return:

         A logic value indicating if it's a hard disk.

    Example:


                                 - Page 73 -
Norton Guide: `FAST.lib 3.50  Reference'


         If IsHardDisk()
           Warning( "You have a hard disk" )
         EndIf

See Also: "IsFloppy()" "IsNetDev()" 


    IsNetDev()

         Determines if the current disk is a net disk

    Syntax:

         IsNetDev() -> lLan

    Description:

         Determines if the current disk is a net disk.

    Return:

         A logic value indicating if it's a net disk.

    Example:

         If IsNetDev()
           Warning( "You have a LAN" )
         EndIf

See Also: "IsFloppy()" "IsHardDisk()" 


    IsSmartDrv()

         Determines if SmartDrv has been loaded

    Syntax:

         IsSmartDrv() -> lLoaded

    Description:

         Determines if SmartDrv has been loaded.

    Return:

         A logic value indicating if SMARTDRV.EXE has been loaded.

    Example:

         If IsSmartDrv()
           Warning ( "SmartDrv has been loaded" )
         EndIf



                                 - Page 74 -
Norton Guide: `FAST.lib 3.50  Reference'


    LowDiskFirm()

         Determines the firmware revision of an IDE disk

    Syntax:

         LowDiskFirm() -> cFirm

    Description:

         Determines the firmware revision of an IDE disk using a low level
         method.
         This function is only valid for IDE disks.

    Return:

         An string with the firmware revision.

    Example:

         ? LowDiskFirm()

See Also: "LowDiskModel()" "LowDiskSerial()" 


    LowDiskModel()

         Determines the model of an IDE disk

    Syntax:

         LowDiskModel() -> cModel

    Description:

         Determines the model of an IDE disk using a low level method.
         This function is only valid for IDE disks.

    Return:

         An string with the model.

    Example:

         ? LowDiskModel()

See Also: "LowDiskFirm()" "LowDiskSerial()" 


    LowDiskSerial()

         Determines the serial number of an IDE disk

    Syntax:


                                 - Page 75 -
Norton Guide: `FAST.lib 3.50  Reference'


         LowDiskSerial() -> cSerial

    Description:

         Determines the manufacturer serial number of an IDE disk using
         a low level method.
         This function is only valid for IDE disks.

    Return:

         An string with the serial number.

    Example:

         ? LowDiskSerial()

See Also: "LowDiskFirm()" "LowDiskModel()" 


    SetLabel()

         Sets the label on a disk

    Syntax:

         SetLabel( nUnit [, cNewLabel] ) -> nError

         nUnit     : A disk number. 0=Current disk, 1=A:, 2=B:, 3=C:, ...
         cNewLabel : The new label. Default value is "".

    Description:

         Sets the label on a disk.

    Return:

         DOS error code or zero if there is no error.

    Example:

         cLabel := GetLabel( 0 )
         ? cLabel                       // returns "MANU ROIBAL"
         SetLabel( 0 )                  // purges label
         GetLabel( 0 )                  // returns ""
         SetLabel( 0, cLabel )          // sets new label
         ? GetLabel( 0 )                // returns "MANU ROIBAL"

See Also: "GetLabel()" 


    SmartFlush()

         Flushes the cach buffers of SmartDrv

    Syntax:

                                 - Page 76 -
Norton Guide: `FAST.lib 3.50  Reference'



         SmartFlush() -> NIL

    Description:

         Flushes the cach buffers of SmartDrv.
         This function is also supported by PC-Cache 8.0.

    Return:

         Nothing.

    Example:

         SmartFlush()

See Also: "SmartHits()" "SmartMisses()" "SmartReset()" "SmartSize()" 


    SmartHits()

         Returns the number of SmartDrv cach hits

    Syntax:

         SmartHits() -> nHits

    Description:

         Returns the number of SmartDrv cach hits.
         This function is also supported by PC-Cache 8.0.

    Return:

         A number with the SmartDrv cach hits or NIL if SmartDrv is not
         loaded.

    Example:

         ? SmartHits()

See Also: "SmartFlush()" "SmartMisses()" "SmartReset()" "SmartSize()" 


    SmartMisses()

         Returns the number of SmartDrv cach misses

    Syntax:

         SmartMisses() -> nMisses

    Description:

         Returns the number of SmartDrv cach misses.

                                 - Page 77 -
Norton Guide: `FAST.lib 3.50  Reference'


         This function is also supported by PC-Cache 8.0.

    Return:

         A number with the SmartDrv cach misses or NIL if SmartDrv is not
         loaded.

    Example:

         ? SmartMisses()

See Also: "SmartFlush()" "SmartHits()" "SmartReset()" "SmartSize()" 


    SmartReset()

         Initializes the cach buffers of SmartDrv

    Syntax:

         SmartReset() -> NIL

    Description:

         Initializes the cach buffers of SmartDrv.
         This function is also supported by PC-Cache 8.0.

    Return:

         Nothing.

    Example:

         SmartReset()

See Also: "SmartFlush()" "SmartHits()" "SmartMisses()" "SmartSize()" 


    SmartSize()

         Returns the cach size of SmartDrv

    Syntax:

         SmartSize() -> nSize

    Description:

         Returns the cach size of SmartDrv.
         This function is also supported by PC-Cache 8.0.

    Return:

         Cach size in bytes.


                                 - Page 78 -
Norton Guide: `FAST.lib 3.50  Reference'


    Example:

         ? SmartSize()

See Also: "SmartFlush()" "SmartHits()" "SmartMisses()" "SmartSizeWin()" 


    SmartSizeWin()

         Returns the cach size of SmartDrv during Windows 3

    Syntax:

         SmartSizeWin() -> nSize

    Description:

         Returns the cach size of SmartDrv during Windows 3 execution.
         This function is also supported by PC-Cache 8.0.

    Return:

         Cach size in bytes.

    Example:

         ? SmartSizeWin()

See Also: "SmartFlush()" "SmartHits()" "SmartMisses()" "SmartSize()" 


    ZipFile()

         Returns the contents of a ZIP file

    Syntax:

         ZipFile ( cFile ) -> aZIP

         cFile : The name of the ZIP file

    Description:

         Returns a bidimensional array with information about the contents
         of ZIP file.

         The subarrays have the following format:

         {
           { cName, cFull, dDate, cTime, nSize, nComp, cRatio, cMeth, nNum }
           ...
           { cName, cFull, dDate, cTime, nSize, nComp, cRatio, cMeth, nNum }
         }

         cName          File name

                                 - Page 79 -
Norton Guide: `FAST.lib 3.50  Reference'


         cFull          File name with path
         dDate          Date of file
         cTime          Time of file
         nSize          Real size of file
         nComp          Compressed size
         cRatio         Compression ratio
         cMeth          Compression method
         nNum           Number of file

    Return:

         An array with information about the contents of a ZIP file.

    Example:

         aZIP := ZipFile ( "C:\FastLib\Fast.Zip" )
         For nInd := 1 To Len ( aZIP )
           For nOther := 1 To Len ( aZIP [ nInd ] )
             ? aZIP [ nInd, nOther ]
           Next
         Next

See Also: "ArjFile()" 
































                                 - Page 80 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 1, Games




    What do you want games I say? ... Enjoy yourself!

 


    Caos()

         Reproduce a caos situation on your PC

    Syntax:

         Caos() -> NIL

    Description:

         It Reproduces a caos situation on your PC pushing the letters.
         Just write Caos() in your program.

    Return:

         Nothing.

    Example:

         Caos()


    IsGame()

         Indicates if the system has a joystick

    Syntax:

         IsGame() -> lExist

    Description:

         Determines if the system has a joystick and initializes
         the BIOS communications area.

    Return:

         .T. if there's joystick and .f. if there isn't

    Example:

         If IsJoystick()
           Warning ( "My computer is a gameboy" )
         EndIf


                                 - Page 81 -
Norton Guide: `FAST.lib 3.50  Reference'



    jButton1()

         Indicates if the button 1 of the joystick is pressed

    Syntax:

         jButton1() -> lPush

    Description:

         Indicates if the button 1 of the first joystick on the system is
         pressed or not, returning a logic value.

    Return:

         .T. if it's pressed or .F. if not.

    Example:

         If jButton1()
           Warning ( "Button 1 is down" )
         EndIf

See Also: "jButton2()" 


    jButton2()

         Indicates if the button 2 of the joystick is pressed

    Syntax:

         jButton2() -> lPush

    Description:

         Indicates if the button 2 of the first joystick on the system is
         pressed or not, returning a logic value.

    Return:

         .T. if it's pressed or .F. if not.

    Example:

         If jButton2()
           Warning ( "Button 2 is down" )
         EndIf

See Also: "jButton1()" 



    jClick()

                                 - Page 82 -
Norton Guide: `FAST.lib 3.50  Reference'



         Indicates if any button of the joystick has been pressed

    Syntax:

         jClick() -> lPush

    Description:

         Indicates if any button of the joystick has been pressed. To
         determine which has been used jButton1() and jButton2().

    Return:

         A logic value indicating if any button has been pressed.

    Example:

         If jClick()
           Warning ( "Buttons 1 or/and 2 are down" )
         EndIf

See Also: "jButton1()" "jButton2()" 


    jInArea()

         Determines if the joystick is on a zone

    Syntax:

         jInArea( nY1, nX1, nY2, nX2 ) -> lInArea

         nY1, nX1, nY2, nX2 : The zone's co-ordinates

    Description:

         Determines if the joystick's controls is in a range.

    Return:

         A logic value indicating if it's inside the specified zone.

    Example:

         If jInArea ( 240, 330, 242, 340 )
           Warning ( "Ok. Joystick is in the middle" )
         EndIf


    jPosX()

         Indicates the X position of the joystick

    Syntax:

                                 - Page 83 -
Norton Guide: `FAST.lib 3.50  Reference'



         jPosX() -> nPos

    Description:

         Indicates the position on the X co-ordinate of the system's
         first joystick's control.

    Return:

         The X position of the joystick.

    Example:

         If jPosX() < 400 .And. jPosX() > 200
           Warning( "Perfect" )
         EndIf

See Also: "jPosY()" 


    jPosY()

         Indicates the Y position of the joystick

    Syntax:

         jPosY() -> nPos

    Description:

         Indicates the position on the Y co-ordinate of the system's
         first joystick's control.

    Return:

         The Y position of the joystick.

    Example:

         If jPosY() < 300 .And. jPosY() > 100
           Warning ( "Ok" )
         EndIf

See Also: "jPosX()" 


    Puzzle()

         Play a Puzzle made with 100% Clipper Code

    Syntax:

         Puzzle( [nY], [nX], [cColor] ) -> lWin


                                 - Page 84 -
Norton Guide: `FAST.lib 3.50  Reference'


         nY     : Upper row
         nX     : Left column
         cColor : The screen's color

    Description:

         Enjoy Puzzle.

    Return:

         If winner returns .T., the looser else .F.

    Example:

         Puzzle()

See Also: "Serpent()" 


    Serpent()

         Play the Snake made with 100% Clipper code

    Syntax:

         Serpent( cColor, cColorHead, cColorMark ) -> NIL

         cColor     : The screen's color and the Snake's body
         cColorHead : The Snake's head color when it's pressed down
         cColorMark : The color of the screen's brand

    Description:

         Enjoy serpent game.

    Return:

         Nothing.

    Example:

         Serpent ( "W+/B*", "R+/B*", "G+/B*" )


    SpeakGame()

         Generates a sound with the speaker

    Syntax:

         SpeakGame( nLapsus ) -> NIL

         nLapsus : The sound's duration. This value also determines the
                   frequency of the sound.


                                 - Page 85 -
Norton Guide: `FAST.lib 3.50  Reference'


    Description:

         Generates a sound with the speaker accessing at low level
         and determining the frequency.

    Return:

         Nothing.

    Example:

         SpeakGame( 10000 )











































                                 - Page 86 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 1, Graphics




    This section is intended to give Clipper access to the graphic mode,
 as the standard libraries do not allow use of these video modes.

    They are very simple functions that don't use external libraries,
 instead they generate all the line algorithms based on internal
 calculations. And the code will just increase about 3kb in size!!

 


    BackGraph()

         Draws the back of the 3D graphic

    Syntax:

         BackGraph ( cTitle, nMaxValue, nBaseSize ) -> NIL

         cTitle        : The title of the graphic
         nMaxValue     : The maximum value of the graphic
         nBaseSize     : The base size in pixels

    Description:

         Draws the back of the 3D graphic including title and scale
         depending on nMaxValue.

         In this way, with this function and DrawBar() you can build
         your graphics.

    Return:

         Nothing.

    Example:

         SetVGA()
         BackGraph( "This is a demo", 150000, 60 )
         Inkey( 0 )
         TxtMode()

See Also: "DrawBar()" 


    Degrade()

         Makes a progressive degrade of the palette

    Syntax:


                                 - Page 87 -
Norton Guide: `FAST.lib 3.50  Reference'


         Degrade( cPalette ) -> NIL

        cPalette : A string of 768 bytes with the actual palette or with
                   the one wanted to be taken as reference for the degrade.

    Description:

         This function works in sync with the CRT controller so that
         the degrade can offer a vision of soft and progressive change.

    Return:

         Nothing.

    Example:

         cPalette := GetPalette()
         Degrade( cPalette )
         Upgrade( cPalette )

See Also: "Upgrade()" "GetPalette()" 


    DispChar()

         Writes a character on the screen

    Syntax:

         DispChar ( nChar, nX, nY, nFore, nBack ) -> NIL

         nChar : ASCII value of the character to be printed
         nX    : Coordinate X
         nY    : Coordinate Y
         nFore : The color of the character
         nBack : The color of the background

    Description:

         It writes a character in graphic mode. The mode must be EGA or VGA.

    Return:

         Nothing.

    Example:

         DispChar ( Asc ( "A" ), 20, 30, 2, 0 )

See Also: "DispStr()" 


    DispStr()

         Writes a string on the screen

                                 - Page 88 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         DispStr ( cStr, nX, nY, nFore, nBack, nSep ) -> NIL

         cStr  : The string to be written
         nX    : Coordinate X
         nY    : Coordinate Y
         nFore : The color of characters
         nBack : The color of the background
         nSep  : Space between characters. Default 8 points

    Description:

         It writes a string in graphic mode. The mode must be EGA or VGA.

    Return:

         Nothing.

    Example:

         DispStr ( "Write in graphic mode", 20, 30, 2, 0, 10 )

See Also: "DispChar()" "Outxy()" 


    DrawBar()

         Draws a 3D bar

    Syntax:

         DrawBar( nX, nY, nHigh, nWide, nShadowLen, ;
                  nColor, nShadowColor, lDelimiter, nTypeBar ) -> NIL

         nX           : Coordinate X
         nY           : Coordinate Y
         nHigh        : The height of the bar
                        See example to more information
         nWide        : The width of the bar
         nShadowLen   : The size of the shadow
         nColor       : The color of bar
         nShadowColor : The color of shadow
         lDelimiter   : A logic value indicating if you want draw lines
                        delimiting the bar
         nTypeBar     : Bar Type
                          0 : Default, normal bar
                          1 : top pyramidal bar
                          2 : bottom pyramidal bar
                          3 : cylindric bar

    Description:

         Draws a 3D bar in graphic mode.

                                 - Page 89 -
Norton Guide: `FAST.lib 3.50  Reference'



         This function is used by Graph*() functions in FAST.lib.
         In this way, with this function and BackGraph() you can build
         your graphics.

    Return:

         Nothing.

    Example:

         #define BAR_RATE 250

         nMax  := 0
         aBars := { 100, 200, 300, 400, 500, 300, 200, 350 }

         // obtain the max value of the bars
         aEval( aBars, { | nX | nMax := MAX( nX, nMax ) } )

         SetVGA()
         BackGraph( "Tittle", nMax, 80 )
         FOR nInd := 1 TO LEN( aBars )
           DrawBar( 100, ;
                    300 + ( 30 * nInd ), ;
                    150 / nMax * BAR_RATE, ;
                    20, 10, 3, 11, .F. )
         NEXT
         Inkey( 0 )
         TxtMode()

See Also: "BackGraph()" 


    FliEver()

         Shows a FLI animation until you press a key

    Syntax:

         FliEver( cFileFLI ) -> nResult

         cFileFLI : The FLI file to show

    Description:

         Shows an animation created with Autodesk Animator.

         The animation of the Fast Library demo program is an example
         of a CorelDRAW CD.

    Return:

         0 or another number indicating an error.

    Example:

                                 - Page 90 -
Norton Guide: `FAST.lib 3.50  Reference'



         FliEver( "demo.fli )

See Also: "FliOnce()" 


    FliOnce()

         Shows a FLI animation

    Syntax:

         FliOnce( cFileFLI ) -> nResult

         cFileFLI : The FLI file to show

    Description:

         Shows an animation created with Autodesk Animator.

         The animation of the Fast Library demo program is an example
         of a CorelDRAW CD.

    Return:

         0 or another number indicating an error.

    Example:

         FliOnce( "demo.fli )

See Also: "FliEver()" 


    gBox()

         Draws a box in graphic mode

    Syntax:

         gBox ( nX1, nY1, nX2, nY2, nColor ) -> NIL

         nX1    : Initial coordinate X
         nY1    : Initial coordinate Y
         nX2    : Final coordinate X
         nY2    : Final coordinate Y
         nColor : Numeric value color

    Description:

         It draws a box in graphic mode. The mode must be EGA or VGA.

    Return:

         Nothing.

                                 - Page 91 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         gBox ( 200, 300, 250, 350, 4 )

See Also: "gLine()" 


    gCircle()

         Draws a circle in graphic mode

    Syntax:

         gCircle ( nCenterX, nCenterY, nRadius, nColor ) -> NIL

         nCenterX : Coordinate X of center
         nCenterY : Coordinate Y of center
         nRadius  : Radius value
         nColor   : Numeric value color

    Description:

         It draws a circle in graphic mode. The mode must be EGA or VGA.

    Return:

         Nothing.

    Example:

         gCircle ( 200, 300, 50, 2 )

See Also: "gEllipse()" 


    GetPixel()

         Informs of the color at a point in graphic mode

    Syntax:

         GetPixel( nCol, nRow ) -> nColor

         nCol    : Column of the point to verify
         nRow    : Row of the point to verify

    Description:

         Informs of the color at a point in graphic mode at the
         specified coordinates.

    Return:

         Nothing.

                                 - Page 92 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         nMode := SetVGA()
         If GetPixel ( 330, 240 ) == 0
           DispChar ( "It's Black", 20, 20, 3, 0, 10 )
         EndIf
         Inkey(0)
         TxtMode()

See Also: "SetPixel()" 


    gEllipse()

         Draws an ellipse in graphic mode

    Syntax:

         gEllipse ( nCenterX, nCenterY, nFocusA, nFocusB, nColor ) -> NIL

         nCenterX : Coordinate X of center
         nCenterY : Coordinate Y of center
         nFocusA  : Valor of focus A
         nFocusB  : Valor of focus B
         nColor   : Numeric color value

    Description:

         It draws an ellipse in graphic mode. The mode must be EGA or VGA.

    Return:

         Nothing.

    Example:

         gEllipse ( 200, 300, 60, 50, 3 )

See Also: "gCircle()" 


    gifColors()

         Returns the number of colors of a GIF

    Syntax:

         gifIsGIF ( cFile ) -> nColors

         cFile : Name of the GIF file

    Description:

         This function returns the number of colors that contains the GIF

                                 - Page 93 -
Norton Guide: `FAST.lib 3.50  Reference'


         image.

    Return:

         A value between 2 y 256 indicating the number of colors or NIL if
         the file does not have GIF format.

    Example:

         ? gifColors ( "c:\xx\giveme.gif" )

See Also: "gifIsGIF()" 


    gifIsGIF()

         Indicates if a file has GIF format or not

    Syntax:

         gifIsGIF ( cFile ) -> lIsGIF

         cFile : Name of the GIF file

    Description:

         This function returns a logic indicating if the file is GIF or not.

         The rest of GIF functions use this function to decide when to
         return some value.

    Return:

         .T. if the file is GIF or .F. if it does not have GIF format or
         does not exist.

    Example:

         ? gifIsGIF ( "c:\xx\giveme.gif" )

See Also: "gifVersion()" 


    gifIsPalette()

         Determines if the GIF has palette or not

    Syntax:

         gifIsPalette( cFile ) -> lPalette

         cFile : Name of the GIF file

    Description:


                                 - Page 94 -
Norton Guide: `FAST.lib 3.50  Reference'


         This function determines if it must use the system palette in
         order to show the image or the GIF has its own palette.

    Return:

         A logic indicating if the GIF has palette or NIL if the file does
         not have GIF format.

    Example:

         ? gifIsPalette ( "c:\xx\giveme.gif" )

See Also: "gifIsGIF()" 


    gifShow256()

         Shows a 320x200x256 GIF on the screen

    Syntax:

         gifShow256 ( cFile ) -> lError

         cFile : Name of the GIF file

    Description:

         The GIF can be any size you want. Forget about the 64 kb
         limitation.

         It only works if a VGA card exists in the system.
         The function does not wait for a key, nor restores the video
         mode, so this is left to the user's responsibility. This is
         very useful when you want to show various GIF and you don't
         want to get text mode between one and the other.
         This function works best with GIF of less colors. It has
         been tested with GIFs of 320x200x32 and 320x200x64, also with
         320x200x256.

    Return:

         .T. if all has gone well or .F. if the file is not found or the
         GIF format is incorrect.

    Example:

         If IsVGA()
           nOldMode := SetVGA256()
           If gifShow256 ( "f:\xxx\giveme.gif" )
             Inkey(0)
           EndIf
           VideoMode ( nOldMode )
         EndIf

See Also: "GifShowVESA()" 

                                 - Page 95 -
Norton Guide: `FAST.lib 3.50  Reference'




    gifShowVESA()

         Shows a GIF in VESA modes

    Syntax:

         gifShowVESA ( cFile ) -> lError

         cFile : Name of the GIF file

    Description:

         The GIF can be any size you want. Forget about the 64 kb
         limitation.

         It only works if a SVGA VESA compatible card exists on the system.
         The function does not wait for a key, nor restores the video
         mode, so this is left to the user's responsibility. This is
         very useful when you want to show various GIF and you don't
         want to get text mode between one and the other.
         This function works best with GIF of less colors. It has
         been tested with GIFs of 640x400x256, 640x480x256, 800x600x256,
         1024x768x256 and 1280x1024x256.

    Return:

         .T. if all has gone well or .F. if the file is not found or the
         GIF format is incorrect.

    Example:

         If IsVESA()
           cFile    := "f:\xxx\car.gif"
           nOldMode := VideoMode()
           nNewMode := SearchVESA( cFile )
           If nNewMode != NIL
             VESAMode( nNewMode )
             If gifShowVESA ( cFile )
               Inkey(0)
             EndIf
             VideoMode ( nOldMode )
           EndIf
         EndIf

See Also: "gifShow256()" "SearchVESA()" 


    gifVersion()

         Returns the version of a GIF

    Syntax:


                                 - Page 96 -
Norton Guide: `FAST.lib 3.50  Reference'


         gifVersion ( cFile ) -> nVersion

         cFile : Name of the GIF file

    Description:

         This function returns the GIF file format version.

    Return:

         A string containing the version like GIF89a or NIL if the file
         does not have GIF format.

    Example:

         ? gifVersion ( "c:\xx\giveme.gif" )

See Also: "gifIsGIF()" 


    gifX()

         Returns the width of a GIF

    Syntax:

         gifX ( cFile ) -> nWidth

         cFile : Name of the GIF file

    Description:

         This function returns the width, in pixels, of the GIF image.

    Return:

         A numeric value indicating the number of pixels in width or NIL
         if the file does not have GIF format.

    Example:

         ? gifX ( "c:\xx\giveme.gif" )

See Also: "gifIsGIF()" "gifX()" 


    gifY()

         Returns the height of a GIF

    Syntax:

         gifX ( cFile ) -> nLong

         cFile : Name of the GIF file

                                 - Page 97 -
Norton Guide: `FAST.lib 3.50  Reference'



    Description:


         This function returns the height, in pixels, of the GIF image.

    Return:

         A numeric value indicating the number of pixels in height or NIL
         if the file does not have GIF format.

    Example:

         ? gifY ( "c:\xx\giveme.gif" )

See Also: "gifIsGIF()" "gifX()" 


    gLine()

         Draws a line in graphic mode

    Syntax:

         gLine ( nX1, nY1, nX2, nY2, nColor ) -> NIL

         nX1    : Initial coordinate X
         nY1    : Initial coordinate Y
         nX2    : Final coordinate X
         nY2    : Final coordinate Y
         nColor : Numeric value color

    Description:

         Draws a line in graphic mode. The mode must be EGA or VGA.

    Return:

         Nothing.

    Example:

         gLine ( 200, 300, 250, 350, 4 )

See Also: "gBox()" 


    GraphBar()

         Bar graphics with Clipper!!

    Syntax:

         GraphBar( cTitle, aArray1, aArray2, aArray3, aArray4, ;
                   nTypeBar ) -> NIL

                                 - Page 98 -
Norton Guide: `FAST.lib 3.50  Reference'



         cTitle   : Title or legend of graphic
         aArray1  : contain a legend and an array of values for the graphic.
         aArray2  :  "
         aArray3  :  "
         aArray4  :  "
         nTypeBar : Bar Type
                      0 : Default, normal bar
                      1 : top pyramidal bar
                      2 : bottom pyramidal bar
                      3 : cylindric bar

    Description:

         It generates bar graphics in Clipper. It only works in EGA
         and VGA.

         The number of bars will be the highest size of the 4 subarrays.
         This function is made from other functions of Fast Library, so
         if you do not like it, you can make your own directly. The only
         objective is to save you some work.

         Fast offers the resources to rebuild this function if there is
         something in it that you would like to modify more to you liking.
         The only thing needed is some simple knowledge of Plain Geometry.

    Return:

         Nothing.

    Example:

         SetVGA ()
         GraphBar ( "GraphBar Demo", ;
                    { "HP",       { 481, 212, 212, 266, 699, 312 } }, ;
                    , ;
                    { "DEC",      { 481, 212, 212, 266, 699, 312 } }, ;
                    { "IBM",      { 281, 332, 212, 557, 499, 612 } }, ;
                    1 )
         Inkey (0)
         TxtMode ()

See Also: "GraphBar2()" "GraphBar3()" "GraphEllipse()" "GraphTart()" 


    GraphBar2()

         Another bar graph with Clipper!!

    Syntax:

         GraphBar2( cTitle, aArray, nTypeBar ) -> NIL

         cTitle   : Title or legend of graphic
         aArray   : A bidimensional array containing numerical values

                                 - Page 99 -
Norton Guide: `FAST.lib 3.50  Reference'


         nTypeBar : Bar Type
                      0 : Default, normal bar
                      1 : top pyramidal bar
                      2 : bottom pyramidal bar
                      3 : cylindric bar

    Description:

         It generates a bar graph in Clipper. It only works in EGA
         and VGA.

         This function is made from other functions of Fast Library, so
         if you do not like it, you can make your own directly. The only
         objective is to save you some work.

         Fast offers the resources to rebuild this function if there is
         something in it that you would like to modify more to you liking.
         The only thing needed is some simple knowledge of Plain Geometry.

    Return:

         Nothing.

    Example:

         SetVGA ()
         GraphBar2( "GraphBar2 Demo", ;
                    { { 481, 212, 212, 266, 699, 312 }, ;
                      { ... }, ;
                      { 481, 212, 212, 266, 699, 312 }, ;
                      { 281, 332, 212, 557, 499, 612 } ;
                    }, ;
                    2 )
         Inkey (0)
         TxtMode ()

See Also: "GraphBar()" "GraphBar3()" "GraphEllipse()" "GraphTart()" 


    GraphBar3()

         And another bar graph with Clipper!!

    Syntax:

         GraphBar3( cTitle, aItems, aArray, nTypeBar ) -> NIL

         cTitle   : Title of graphic
         aItems   : An array containing legends
         aValues  : An array containing numerical values
         nTypeBar : Bar Type
                      0 : Default, normal bar
                      1 : top pyramidal bar
                      2 : bottom pyramidal bar
                      3 : cylindric bar

                                 - Page 100 -
Norton Guide: `FAST.lib 3.50  Reference'



    Description:

         It generates a bar graphics in Clipper. It only works in EGA
         and VGA.

         This function is made from other functions of Fast Library, so
         if you do not like it, you can make your own directly. The only
         objective is to save you some work.

         Fast offers the resources to rebuild this function if there is
         something in it that you would like to modify more to you liking.
         The only thing needed is some simple knowledge of Plain Geometry.

    Return:

         Nothing.

    Example:

         SetVGA ()
         GraphBar3( "GraphBar3 Demo", ;
                    { "Item1", "Item2", "Item3", "Item4" }, ;
                    {     481,     212,     212,     266 }, ;
                    3 )
         Inkey (0)
         TxtMode ()

See Also: "GraphBar()" "GraphBar2()" "GraphEllipse()" "GraphTart()" 


    GraphEllipse()

         Pie graph with Clipper!!

    Syntax:

         GraphEllipse ( nX, nY, nFocus, aArray ) -> NIL

         nX     : Coordinate X of the center of the ellipse
         nY     : Coordinate Y of the center of the ellipse
         nFocus : Focus A of the ellipse
         aArray : An array of values for the graphic. It allows as
                  many elements as you like.

    Description:

         It generates a pie graph in Clipper. It only works in EGA
         and VGA.

         This function does not have the option to place title and legends
         because, as it allows you to place the graphic in a specific
         position, it may be of interest to place this data in whichever
         place you like.


                                 - Page 101 -
Norton Guide: `FAST.lib 3.50  Reference'


         It is important to realize that the graph will be painted in zones of
         different colors, always starting with color 1 in the first zone, 2
         in the second, and so on until 15. This process will be recursively
         repeated if there is more than 15 zones. This is a very important
         point in order to determine later the color of each legend in the
         graphic.  It is also important to realize that Fast offers the
         resources to rebuild this function if there is something in it that
         is not to your liking. The only thing needed is some simple
         knowledge of Plain Geometry.

    Return:

         Nothing.

    Example:

         SetVGA()
         cTitle := "Fast Graphic System"
         GraphEllipse( 320, 240, 100, { 17, 3, 15, 60, 15 } )
         DispStr ( cTitle, 320 - Len ( cTitle ) * 4, 370, 15, 0 )
         Legend ( 320, 460, 15, 4, "Fast Library" )
         Inkey (0)
         TxtMode ()

See Also: "Legend()" "DispStr()" "GraphBar()" "GraphBar2()" "GraphTart()" 


    GraphLine()

         Line graph with Clipper!!

    Syntax:

         GraphLine( cTitle, aArray ) -> NIL

         cTitle : Title or legend of graphic
         aArray : A bidimensional array containing numerical values

    Description:

         It generates a line graph in Clipper. It only works in EGA
         and VGA.

         This function is made from other functions of Fast Library, so
         if you do not like it, you can make your own directly. The only
         objective is to save you some work.

         Fast offers the resources to rebuild this function if there is
         something in it that you would like to modify more to you liking.
         The only thing needed is some simple knowledge of Plain Geometry.

    Return:

         Nothing.


                                 - Page 102 -
Norton Guide: `FAST.lib 3.50  Reference'


    Example:

         SetVGA ()
         GraphLine( "GraphLine Demo", ;
                    { { 481, 212, 212, 266, 699, 312 }, ;
                      { ... }, ;
                      { 481, 212, 212, 266, 699, 312 }, ;
                      { 281, 332, 212, 557, 499, 612 } ;
                    } )
         Inkey (0)
         TxtMode ()

See Also: "GraphBar()" "GraphBar2()" "GraphEllipse()" "GraphZone()" 


    GraphTart()

         Pie graph with Clipper!!

    Syntax:

         GraphTart ( nX, nY, nRadius, aArray ) -> NIL

         nX      : Coordinate X of the center of the circumference
         nY      : Coordinate Y of the center of the circumference
         nRadius : Radius of the circumference
         aArray  : An array of values for the graphic. It allows as
                   many elements as you like.

    Description:

         It generates a pie graph in Clipper. It only works in EGA
         and VGA.

         This function does not have the option to place title and legends
         because, as it allows you to place the graphic in a specific
         position, it may be of interest to place this data in whichever
         place you like.

         It is important to realize that the graphic will be painted in zones
         of different colors, always starting with color 1 in the first
         zone, 2 in the second, and so on until 15. This process will be
         recursively repeated if there is more than 15 zones. This is a
         very important point in order to determine later the color of
         each legend in the graphic.

         It is also important to realize that Fast offers the resources to
         rebuild this function if there is something in it that is not of your
         likeing. The only thing needed is some simple knowledge of Plain
         Geometry.

    Return:

         Nothing.


                                 - Page 103 -
Norton Guide: `FAST.lib 3.50  Reference'


    Example:

         SetVGA()
         cTitulo := "Fast Graphic System"
         GraphTart ( 320, 240, 100, { 17, 3, 15, 60, 15 } )
         DispStr ( cTitulo, 320 - Len ( cTitulo ) * 4, 370, 15, 0 )
         Legend ( 320, 460, 15, 4, "Fast Library" )
         Inkey (0)
         TxtMode ()

See Also: "Legend()" "DispStr()" "GraphBar()" "GraphBar2()" "GraphEllipse()" 


    GraphZone()

         Zone graph with Clipper!!

    Syntax:

         GraphZone( cTitle, aArray ) -> NIL

         cTitle : Title or legend of graphic
         aArray : A bidimensional array containing numerical values

    Description:

         It generates a zone graph in Clipper. It only works in EGA
         and VGA.

         This function is made from other functions of Fast Library, so
         if you do not like it, you can make your own directly. The only
         objective is to save you some work.

         Fast offers the resources to rebuild this function if there is
         something in it that you would like to modify more to you liking.
         The only thing needed is some simple knowledge of Plain Geometry.

    Return:

         Nothing.

    Example:

         SetVGA ()
         GraphZone( "GraphZone Demo", ;
                    { { 481, 212, 212, 266, 699, 312 }, ;
                      { ... }, ;
                      { 481, 212, 212, 266, 699, 312 }, ;
                      { 281, 332, 212, 557, 499, 612 } ;
                    } )
         Inkey (0)
         TxtMode ()

See Also: "GraphBar()" "GraphBar2()" "GraphEllipse()" "GraphLine()" 


                                 - Page 104 -
Norton Guide: `FAST.lib 3.50  Reference'



    IsCGA()

         Detects if a CGA card exists

    Syntax:

         IsCGA() -> lCGA

    Description:

         Detects if a CGA card exists in the system and it returns a
         logic indicating the result.

    Return:

         .T. if it exists and .F. if not.

    Example:

         If IsCGA()
           ? "There's a CGA card"
         EndIf

See Also: "IsEGA()" "IsHerc()" "IsLCD()" "IsVGA()" 


    IsEGA()

         Detects if a EGA card exists

    Syntax:

         IsEGA() -> lEGA

    Description:

         Detects if a EGA card exists in the system and it returns a
         logic indicating the result.

    Return:

         .T. if it exists and .F. if not.

    Example:

         If IsEGA()
           ? "There's a EGA card"
         EndIf

See Also: "IsCGA()" "IsHerc()" "IsLCD()" "IsVGA()" 


    IsHerc()


                                 - Page 105 -
Norton Guide: `FAST.lib 3.50  Reference'


         Detects if a Hercules card exists

    Syntax:

         IsHerc() -> lHerc

    Description:

         Detects if a Hercules card exists in the system and it returns a
         logic indicating the result.

    Return:

         .T. if it exists and .F. if not.

    Example:

         If IsHerc()
           ? "There's a Hercules Card"
         EndIf

See Also: "IsCGA()" "IsEGA()" "IsLCD()" "IsVGA()" 


    IsLCD()

         Detects if a LCD monitor exists

    Syntax:

         IsLCD() -> lLCD

    Description:

         Detects if a LCD monitor exists in the system and it returns a
         logic indicating the result.

    Return:

         .T. if it exists and .F. if not.

    Example:

         If IsLCD()
           ? "There's a LCD monitor"
         EndIf

See Also: "IsCGA()" "IsEGA()" "IsHerc()" "IsVGA()" 


    IsMono()

         Detects if a VGA mono card exists

    Syntax:

                                 - Page 106 -
Norton Guide: `FAST.lib 3.50  Reference'



         IsMono() -> lVGAMono

    Description:

         Detects if a VGA mono card exists in the system and it returns a
         logic indicating the result.

    Return:

         .T. if it exists and .F. if not.

    Example:

         If IsMono()
           ? "There's a VGA mono card"
         EndIf

See Also: "IsCGA()" "IsEGA()" "IsHerc()" "IsLCD()" "IsVGA()" "IsVESA()" 


    IsVESA()

         Detects if the graphic system is VESA compatible

    Syntax:

         IsVESA() -> lVESA

    Description:

         It returns a logic indicating if the system is compatible with the
         standard placed by the VESA committee. If your graphic card is not
         VESA compatible contact your distributor and there probably will
         be a driver that allows to emulation VESA.

    Return:

         A logic indicating if it is compatible

    Example:

         If IsVESA()
           ? VESAVer()
         EndIf

See Also: "IsVGA()" "VESAMode()" "VESAOEM()" "VESAVer()" 


    IsVGA()

         Detects if a VGA card exists

    Syntax:


                                 - Page 107 -
Norton Guide: `FAST.lib 3.50  Reference'


         IsVGA() -> lVGA

    Description:

         Detects if a VGA card exists in the system and it returns a
         logic indicating the result.

    Return:

         .T. if it exists and .F. if not.

    Example:

         If IsVGA()
           ? "There's a VGA card"
         EndIf

See Also: "IsCGA()" "IsEGA()" "IsHerc()" "IsLCD()" "IsMono()" "IsVESA()" 


    Legend()

         Draws and fills a square and optionally text

    Syntax:

         Legend ( nX, nY, nSize, nColor, cText ) -> NIL

         nX      : Left upper coordinate X of the square
         nY      : Left upper coordinate Y of the square
         nSize   : Size of the square
         nColor  : Color of the square
         cText   : A text associated with this color in the legend

    Description:

         This function already existed in version 1.25 of Fast, though
         it was not documented because it was used internally by GraphBar().

         Now, with the inclusion of GraphTart() the user is allowed to create
         the legends where and when he likes and that's why it has been
         documented.

    Return:

         Nothing.

    Example:

         SetVGA()
         cTitulo := "Fast Graphic System"
         GraphTart ( 320, 240, 100, { 17, 3, 15, 60, 15 } )
         DispStr ( cTitulo, 320 - Len ( cTitulo ) * 4, 370, 15, 0 )
         Legend ( 320, 460, 15, 4, "Fast Library" )
         Inkey (0)

                                 - Page 108 -
Norton Guide: `FAST.lib 3.50  Reference'


         TxtMode ()

See Also: "DispStr()" "GraphBar()" "GraphTart()" 


    Origin()

         Modifies the video origin in the CRT controller

    Syntax:

         Origin( nX, nY ) -> NIL

         nX : Coordinate X
         nY : Coordinate Y

    Description:

         It accesses the CRT controller and fixes the relative position
         given as the start position of the video memory.

         For example, if we call to Origin( 5, 6 ) we are indicating that
         the new position in X is shifted 5 pixels and in Y is shifted 6
         pixels. With all this we will descend the image 6 lines and move
         it right 5 columns.

         These movements are extraordinarily fast.

    Return:

         Nothing.

    Example:

         gifShow256( "demo.gif" )
         For nInd := 0 To 200 Step 2
           Origin( 0, nInd )
         Next


    Outxy()

         Writes a string on the screen in all modes

    Syntax:

         Outxy( nX, nY, cString, nColor ) -> NIL

         nX      : Coordinate X
         nY      : Coordinate Y
         cString : The string to be written
         nColor  : The color of characters

    Description:


                                 - Page 109 -
Norton Guide: `FAST.lib 3.50  Reference'


         It writes a string in graphic mode. The functions work in all
         CGA, Herc, EGA, VGA and SVGA modes.

    Return:

         Nothing.

    Example:

         DispStr ( 20, 10, "Write in graphic mode", 10 )

See Also: "DispChar()" "DispStr()" 


    GetPalette()

         Returns the actual color palette

    Syntax:

         GetPalette() -> cPalette

    Description:

         It returns a 768 bytes string with the present color palette.

         This function is very useful with Upgrade() and Degrade().

    Return:

         A 768 bytes string with the color palette.

    Example:

         cPalette := GetPalette()
         Degrade( cPalette )
         Upgrade( cPalette )

See Also: "Degrade()" "SetPalette()" "Upgrade()" 


    pcxBitsPixel()

         Returns the number of bits per pixel of the PCX

    Syntax:

         pcxBitsPixel ( cFile ) -> nBitsPixel

         cFile : Name of the PCX file

    Description:

         This function returns the number of bits per pixel of the PCX
         file if it exists and has a PCX format. Else returns NIL.

                                 - Page 110 -
Norton Guide: `FAST.lib 3.50  Reference'



    Return:

         The number of bits per pixel or NIL if the file does not exists
         or does not have PCX format.

    Example:

         ? pcxBitsPixel ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" 


    pcxIsPCX()

         Indicates if a file has PCX format or not

    Syntax:

         pcxIsPCX ( cFile ) -> lEsPCX

         cFile : Name of the PCX file

    Description:

         This function returns a logic indicating if the file is PCX or not.

         The rest of the PCX functions uses this one to determine when to
         return a value.

    Return:

         .T. if the file is a PCX or .F. if it does not have PCX format or
         does not exist.

    Example:

         ? pcxIsPCX ( "c:\fast\lib\fast.pcx" )


    pcxShow()

         Shows a 16 color PCX on the screen

    Syntax:

         pcxShow ( cFile, [lPalette], [nX], [nY] ) -> lError

         cFile    : Name of the PCX file
         lPalette : A logic indicating if we like the PCX palette or the
                    actual one of the system. If it is .T. then prevails
                    the one from the file. If it is .F. the one from the
                    system. By default is .T.
                    This option is very useful for programs like PaintBrush
                    for Windows that destroys palettes.

                                 - Page 111 -
Norton Guide: `FAST.lib 3.50  Reference'


         nX       : Initial coordinate X where we want to see the PCX.
                    Default value is 0. It may be assigned whichever value
                    between 0 and the number of horizontal pixels of the
                    actual mode. For example, if it is VGA, between 0 and
                    639.
         nY       : Initial coordinate Y where we want to see the PCX.
                    Default value is 0. It may be assigned whichever value
                    between 0 and the number of vertical pixels of the
                    actual mode. For example, if it is VGA, between 0 and
                    479.

    Description:

         The PCX can be any size you want. Forget about the 64 kb
         limitation.

         It only works if a VGA card exists in the system.

         The function does not activate the video mode when entering, nor
         deactivate the video mode when leaving. Nor does it wait for a
         key. This is very useful when you want to show various PCX one
         after the other and you do not want to get text mode between one
         and the other.

         The PCX file can have whichever resolution you want, that is, it
         can be 20x100... Meaning there is no need to use the known
                        resolutions like 640x480 or 640x350.

    Return:

         .T. if it all has gone well or .F. if the file is not found, the
         system does not have a VGA or the PCX format is incorrect.

    Example:

         nOldMode := SetVGA()
         If pcxShow ( "c:\fast\lib\fast1.pcx", .T. 10, 10 )
           Inkey(0)
         EndIf
         VideoMode ( noldmode )

See Also: "pcxShow256()" 


    pcxShow256()

         Shows a 320x200x256 PCX on the screen

    Syntax:

         pcxShow256 ( cFile, [lPalette], [lDegrade] ) -> lError

         cFile    : Name of the PCX file
         lPalette : A logic indicating if we like the PCX palette or the
                    actual one of the system. If it is .T. then prevails

                                 - Page 112 -
Norton Guide: `FAST.lib 3.50  Reference'


                    the one from the file. If it is .F. the one from the
                    system. By default is .T.
                    This option is very useful for programs like PaintBrush
                    for Windows that destroys palettes.
         lDegrade : A logic indicating if you like to fix the palette in a
                    progressive way simulating a degrade (.T.) or if we
                    want to fix it in a fast way (.F.). Default value is .F.
                    Only available when lPalette is .T.

    Description:

         The PCX can be any size you want. Forget about the 64 kb
         limitation.

         It only works if a VGA card exists in the system.

         The function does not wait for a key, nor restores the video
         mode, so this is left to the user's responsibility. This is
         very useful when you want to show various PCX files one after the
         other and you do not want to get text mode between one and the other.

    Return:

         .T. if it all has gone well or .F. if the file is not found, the
         system does not have a VGA or the PCX format is incorrect.

    Example:

         noldmode := SetVGA256()
         If pcxShow256 ( "c:\fast\lib\m_roibal.pcx" )
           Inkey(0)
         EndIf
         VideoMode ( noldmode )

See Also: "pcxShow()" 


    pcxPlanes()

         Returns the number of planes of the PCX

    Syntax:

         pcxPlanes ( cFile ) -> nPlanes

         cFile : Name of the PCX file

    Description:

         This function returns the number of planes of the PCX file if it
         exists and it has a PCX format. Else returns NIL

    Return:

         The number of planes or NIL if the file does not exist or if it is

                                 - Page 113 -
Norton Guide: `FAST.lib 3.50  Reference'


         not a PCX

    Example:

         ? pcxPlanes ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" 


    pcxPalette()

         Returns the color palette of the PCX

    Syntax:

         pcxPalette ( cFile ) -> cPalette

         cFile : Name of the PCX file

    Description:

         This function returns the color palette of the PCX file if it
         is of any sense. The return value has no meaning if the video card
         is monochrome.

    Return:

         A string of 48 bytes with the colors palette or NIL if the file
         does not exist or it is not a PCX.

    Example:

         cPalette := pcxPalette ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" 


    pcxResH()

         Returns the horizontal resolution of the PCX

    Syntax:

         pcxResH ( cFile ) -> nResH

         cFile : Name of the PCX file

    Description:

         This function returns the horizontal resolution of the PCX file if
         it exists and has a PCX format. Else returns NIL.

    Return:

         The horizontal resolution or NIL if the file does not exist or it

                                 - Page 114 -
Norton Guide: `FAST.lib 3.50  Reference'


         is not a PCX.

    Example:

         ? pcxResH ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" "pcxResV()" 


    pcxResV()

         Returns the vertical resolution of the PCX

    Syntax:

         pcxResV ( cFile ) -> nResV

         cFile : Name of the PCX file

    Description:

         This function returns the vertical resolution of the PCX file if
         it exists and has a PCX format. Else returns NIL.

    Return:

         The vertical resolution or NIL if the file does not exist or it
         is not a PCX.


    Example:

         ? pcxResV ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" "pcxResH()" 


    pcxVersion()

         Returns the format version of the PCX file

    Syntax:

         pcxVersion ( cFile ) -> cVersion

         cFile : Name of the PCX file

    Description:

         It returns the format version of the PCX file if it is known.

         This function allows formats from 2.5 until 3.0. The rest of
         the formats below 2.5 are compatible with this one.

    Return:

                                 - Page 115 -
Norton Guide: `FAST.lib 3.50  Reference'



         A string with the format version of the PCX file

    Example:

         ? pcxVersion ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" 


    pcxX1()

         Returns the initial coordinate X of the PCX

    Syntax:

         pcxX1 ( cFile ) -> cCoorX1

         cFile : Name of the PCX file

    Description:

         It returns the initial coordinate X of the PCX file, that it is
         usually 0.

    Return:

         The value of the initial coordinate X.

    Example:

         ? pcxX1 ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" "pcxX2()" "pcxY1()" "pcxY2()" 


    pcxX2()

         Returns the final coordinate X of the PCX

    Syntax:

         pcxX2 ( cFile ) -> cCoorX2

         cFile : Name of the PCX file

    Description:

         It returns the final coordinate X of the PCX file. This value
         usually determines on its own the PCX width, even when the exact
         value would be like:

                nWidth := pcxX2 - pcxX1 + 1

         But due to the pcxX1 usually takes value 0, the value pcxX2 + 1

                                 - Page 116 -
Norton Guide: `FAST.lib 3.50  Reference'


         indicates the width by itself.

    Return:

         The value of the final coordinate X.

    Example:

         ? pcxX2 ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" "pcxX1()" "pcxY1()" "pcxY2()" 


    pcxY1()

         Returns the initial coordinate Y of the PCX

    Syntax:

         pcxY1 ( cFile ) -> cCoorY1

         cFile : Name of the PCX file

    Description:

         It returns the initial coordinate Y of the PCX file, that it is
         usually 0.

    Return:

         The value of the initial coordinate Y.

    Example:

         ? pcxY1 ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" "pcxX1()" "pcxX2()" "pcxY2()" 


    pcxY2()

         Returns the final coordinate Y of the PCX

    Syntax:

         pcxY2 ( cFile ) -> cCoorY2

         cFile : Name of the PCX file

    Description:

         It returns the final coordinate Y of the PCX file. This value
         usually determines on its own the PCX height, even when the exact
         value would be like:


                                 - Page 117 -
Norton Guide: `FAST.lib 3.50  Reference'


                nHeight := pcxY2 - pcxY1 + 1

         But due to the pcxY1 usually takes value 0, the value pcxY2 + 1
         indicates the height by itself.

    Return:

         The value of the final coordinate Y.

    Example:

         ? pcxY2 ( "c:\fast\lib\fast.pcx" )

See Also: "pcxIsPCX()" "pcxX1()" "pcxX2()" "pcxY1()" 


    SearchVESA()

         Searches the VESA mode of a gif file

    Syntax:

         SearchVESA ( cFile ) -> nMode

         cFile : Name of the GIF file

    Description:

         Initializes a GIF file and returns the appropriate VESA mode to
         display the image.

    Return:

         The appropriate VESA mode or NIL if cFile not exist, cFile is not
         a GIF file or the size of GIF file is unknown.

    Example:

         cFile    := "f:\xxx\car.gif"           // 1024x768x256
         ? SearchVESA( cFile )                  // VESA mode 261

See Also: "gifColors()" "gifShowVESA()" "gifX()" "gifY()" 


    SetEGA()

         Activates the 640x350 16 colors EGA mode

    Syntax:

         SetEGA() -> nOldMode

    Description:

         It turns the video mode EGA 640x350x16 colors and returns the

                                 - Page 118 -
Norton Guide: `FAST.lib 3.50  Reference'


         last mode.

         This function is a special case of the generic VideoMode().

    Return:

         The last video mode.

    Example:

         SetEGA()

See Also: "VideoMode()" "SetVGA()" "TxtMode()" 


    SetPalette()

         Sets the actual color palette

    Syntax:

         SetPalette( cPalette ) -> NIL

         cPalette : a string with the new color palette

    Description:

         Sets the actual color palette.

    Return:

         Nothing.

    Example:

         SetPalette( cNewPalette )

See Also: "Degrade()" "GetPalette()" "Upgrade()" 


    SetPixel()

         Draws a point in graphic mode

    Syntax:

         SetPixel( nCol, nRow, nColor ) -> NIL

         nCol    : The column where to place the point.
         nRow    : The row where to place the point.
         nColor  : The color. It must be a numeric value.

    Description:

         It draws a point on the screen at the coordinates and colors

                                 - Page 119 -
Norton Guide: `FAST.lib 3.50  Reference'


         specified.

    Return:

         Nothing.

    Example:

         nMode := SetVGA()
         SetPixel ( 330, 240, 2 )
         Inkey(0)
         TxtMode()

See Also: "GetPixel()" 


    SetVGA()

         Activates the 640x480 16 colors VGA mode

    Syntax:

         SetVGA() -> nOldMode

    Description:

         It turns the video mode VGA 640x480x16 colors and returns the
         last mode.

         This function is a special case of the generic VideoMode().

    Return:

         The last video mode.

    Example:

         SetVGA()

See Also: "SetEGA()" "VideoMode()" "TxtMode()" 


    SetVGA256()

         Activates the 320x200 256 colors VGA mode

    Syntax:

         SetVGA256() -> nOldMode

    Description:

         It turns the video mode VGA 320x200x256 colors and returns the
         last mode.


                                 - Page 120 -
Norton Guide: `FAST.lib 3.50  Reference'


         This function is a special case of the generic VideoMode().

    Return:

         The last video mode.

    Example:

         SetVGA256()

See Also: "SetEGA()" "VideoMode()" "SetVGA()" "TxtMode()" 


    SetVGA()

         Activates the 80x25 text mode

    Syntax:

         TxtMode() -> nOldMode

    Description:

         It turns the 80x25 text video mode and returns the last mode.

         This function is a special case of the generic VideoMode().

    Return:

         The last video mode.

    Example:

         TxtMode()

See Also: "SetEGA()" "VideoMode()" "SetVGA()" 


    Upgrade()

         Makes a progressive restore of the palette

    Syntax:

         Upgrade( cPalette ) -> NIL

         cPalette : A string of 768 bytes with the actual palette or with
                    the one wanted to be taken as reference for the upgrade.

    Description:

         This function works in synchronism with the CRT controller so that
         the degrade can offer a vision of soft and progressive change.

    Return:

                                 - Page 121 -
Norton Guide: `FAST.lib 3.50  Reference'



         Nothing.

    Example:

         cPalette := GetPalette()
         Degrade( cPalette )
         Upgrade( cPalette )

See Also: "Degrade()" "GetPalette()" 


    VESAMode()

         Activates a VESA video mode

    Syntax:

         VESAMode( [nMode] ) -> nOldMode

         nMode : The VESA video mode to make active from the table:

           VESA 1.0

              0-255   ->   OEM video modes, CGA, EGA, VGA...
                256   ->   640 x  400 x 256 colors Graph
                257   ->   640 x  480 x 256 colors Graph
                258   ->   800 x  600 x  16 colors Graph
                259   ->   800 x  600 x 256 colors Graph
                260   ->  1024 x  768 x  16 colors Graph
                261   ->  1024 x  768 x 256 colors Graph
                262   ->  1280 x 1024 x  16 colors Graph
                263   ->  1280 x 1024 x 256 colors Graph
                264   ->    80 x   60 x  16 colors Text
                265   ->   132 x   25 x  16 colors Text
                266   ->   132 x   43 x  16 colors Text
                267   ->   132 x   50 x  16 colors Text
                268   ->   132 x   60 x  16 colors Text

           VESA 1.2

                269   ->   320 x  200 x 32k colors Graph
                270   ->   320 x  200 x 64k colors Graph
                271   ->   320 x  200 x 16M colors Graph
                272   ->   640 x  480 x 32k colors Graph
                273   ->   640 x  480 x 64k colors Graph
                274   ->   640 x  480 x 16M colors Graph
                275   ->   800 x  600 x 32k colors Graph
                276   ->   800 x  600 x 64k colors Graph
                277   ->   800 x  600 x 16M colors Graph
                278   ->  1024 x  768 x 32k colors Graph
                279   ->  1024 x  768 x 64k colors Graph
                280   ->  1024 x  768 x 16M colors Graph
                281   ->  1280 x 1024 x 32k colors Graph
                282   ->  1280 x 1024 x 64k colors Graph

                                 - Page 122 -
Norton Guide: `FAST.lib 3.50  Reference'


                283   ->  1280 x 1024 x 16M colors Graph

    Description:

         It activates a video mode via VESA driver. The advantage of using
         this driver is that you can forget about programming different SVGA
         cards as the VESA driver will make them all behave in the same way.

         The driver exists on most BBS < Universal VESA > that can be
         installed over a great number of chip sets. Nevertheless, It is
         recommended to use the specific VESA drivers for each card as these
         ones are more optimized.

    Return:

         The last video mode.

    Example:

         ? VESAMode( 257 )  // activate mi SVGA a 640x480x256 colors

See Also: "IsVESA()" "VESAOEM()" "VESAVer()" 


    VESAOEM()

         Returns the OEM of the VESA driver

    Syntax:

         VESAOEM() -> cOEM

    Description:

         It returns a string with the OEM or builder of the VESA driver.

    Return:

         A string with the name of the builder.

    Example:

         ? VESAOEM()

See Also: "IsVESA()" "VESAMode()" "VESAVer()" 


    VESAVer()

         Returns the VESA driver version

    Syntax:

         VESAVer() -> cVersion


                                 - Page 123 -
Norton Guide: `FAST.lib 3.50  Reference'


    Description:

         It returns a 5 character string with the VESA driver version, no
         matter if the driver is soft made or it is included in the video
         card.

    Return:

         A string like xx.xx with the driver version.

    Example:

         If IsVESA()
           ? VESAVer()
         EndIf

See Also: "IsVESA()" "VESAMode()" "VESAOEM()" 


    VideoMode()

         Returns and/or changes the video mode

    Syntax:

         VideoMode( nNewMode ) -> nOldMode

         nNewMode : The new video mode.
                    01 -> 40x25
                    03 -> 80x25
                    15 -> EGA 640x350 Mono
                    16 -> EGA 640x350 Color
                    17 -> VGA 640x480 Mono
                    18 -> VGA 640x480 Color
                    ...

    Description:

         It returns the active video mode and optionally changes it if
         nNewMode is specified. For getting more information about the
         video modes consult the interrupts list of Ralf Brown which is
         available in almost all BBS.

    Return:

         The active video mode.

    Example:

         nOld := VideoMode ( 18 )
         DispStr ( "Hello", 10, 10, 7, 12 )
         Inkey(0)
         VideoMode ( nOld )


                                 - Page 124 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 1, Keyboard




    These functions are to centralize all of the accesses of the keyboard in
 Clipper.

 


    ClrBuffer()

         Empties the keyboard buffer and Lastkey() value

    Syntax:

         ClrBuffer() -> NIL

    Description:

         ClrBuffer() is a keyboard function that clears all pending keys
         from the Clipper keyboard buffer and Lastkey() value.

    Return:

         Nothing.

    Example:

         ClrBuffer()

See Also: "Inkey2()" "SetLastKey()" 


    FastKey()

         Sets the maximum typematic rate

    Syntax:

         FastKey() -> NIL

    Description:

         Sets the minimum typematic interval time and auto-repeat start
         delay time.

    Return:

         Nothing.

    Example:

         FastKey()

                                 - Page 125 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "NormKey()" "SlowKey()" 


    Inkey2()

         Does the same as Inkey() but takes care of Setkey()

    Syntax:

         Inkey2( nSeconds ) -> NIL

    Description:

         The working of this function is exactly the same as the
         standard Inkey() of Clipper.lib library but takes care of
         the SetKey() defined on the system.

    Return:

         The same as InKey()

    Example:

         InKey2( 0 )

See Also: "ClrBuffer()" 


    IsAlt()

         Determines if the Alt key is pressed

    Syntax:

         IsAlt() -> lPress

    Description:

         Determines if the Alt key is pressed returning a logic value.

    Return:

         A logic value indicating if is pressed or not.

    Example:

         If IsAlt()
           Warning ( "Alt is down" )
         EndIf

See Also: "IsCtrl()" "IsLShift()" "IsRShift()" 


    IsCaps()

                                 - Page 126 -
Norton Guide: `FAST.lib 3.50  Reference'



         Determines if the Caps lock key is active

    Syntax:

         IsCaps( [ lNew ] ) -> lActive

         lNew : a logic value with the new state of Caps lock key

    Description:

         Determines if the Caps lock key is active returning a logic value.

    Return:

         A logic value indicating if is active or not.

    Example:

         If IsCaps()
           Warning ( "Capslock is on" )
         EndIf

See Also: "IsInsert()" "IsNum()" "IsScroll()" 


    IsCtrl()

         Determines if the Ctrl key is pressed

    Syntax:

         IsCtrl() -> lPress

    Description:

         Determines if the Ctrl key is pressed returning a logic value.

    Return:

         A logic value indicating if is pressed or not.

    Example:

         If IsCtrl()
           Warning ( "Ctrl is down" )
         EndIf

See Also: "IsAlt()" "IsLShift()" "IsRShift()" 


    IsInsert()

         Determines if Insert mode is active


                                 - Page 127 -
Norton Guide: `FAST.lib 3.50  Reference'


    Syntax:

         IsInsert( [ lNew ] ) -> lActive

         lNew : a logic value with the new mode of Insert key

    Description:

         Determines if the Insert key is active returning a logic value.

    Return:

         A logic value indicating if is active or not.

    Example:

         If ! IsInsert()
           Warning ( "Insert is on" )
         EndIf

See Also: "IsCaps()" "IsNum()" "IsScroll()" 


    IsLShift()

         Determines if the Left Shift key is pressed

    Syntax:

         IsLShift() -> lPress

    Description:

         Determines if the Left Shift key is pressed returning a logic
         value.

    Return:

         A logic value indicating if is pressed or not.

    Example:

         If IsLShift()
           Warning ( "Left Shift is down" )
         EndIf

See Also: "IsAlt()" "IsCtrl()" "IsRShift()" 


    IsNum()

         Determines if the Num lock key is active

    Syntax:


                                 - Page 128 -
Norton Guide: `FAST.lib 3.50  Reference'


         IsNum( [ lNew ] ) -> lActive

         lNew : a logic value with the new state of Num lock key

    Description:

         Determines if the Num lock key is active returning a logic value.

    Return:

         A logic value indicating if is active or not.

    Example:

         If IsNum()
           Warning ( "Numeric pad is active" )
         EndIf

See Also: "IsCaps()" "IsInsert()" "IsScroll()" 


    IsRShift()

         Determines if the Right Shift key is pressed

    Syntax:

         IsRShift() -> lPress

    Description:

         Determines if the Right Shift key is pressed returning a logic
         value.

    Return:

         A logic value indicating if is pressed or not.

    Example:

         If IsRShift()
           Warning ( "Right shift is down" )
         EndIf

See Also: "IsAlt()" "IsCtrl()" "IsLShift()" 


    IsScroll()

         Determines if the Scroll lock key is active

    Syntax:

         IsScroll( [ lNew ] ) -> lActive


                                 - Page 129 -
Norton Guide: `FAST.lib 3.50  Reference'


         lNew : a logic value with the new state of Scroll lock key

    Description:

         Determines if the Scroll lock key is active returning a logic
         value.

    Return:

         A logic value indicating if is active or not.

    Example:

         If IsScroll()
           Warning ( "Scroll lock is active" )
         EndIf

See Also: "IsCaps()" "IsInsert()" "IsNum()" 


    KeyScan()

         Extracts a character from the keyboard buffer

    Syntax:

         KeyScan() -> nKey

    Description:

         Extracts a character from the keyboard buffer or halts the program
         until a key is pressed.

         KeyScan() returns an integer value identifying the key extracted
         from the keyboard buffer.

                nkey % 256 = ascii code   (0 in function keys)
                nKey / 256 = scan code

    Return:

         The key pressed.

    Example:

         nKey := KeyScan()
         ? nKey / 256
         ? nKey % 256

See Also: "KeyStuff()" 


    KeyStuff()

         Stuffs a character into the keyboard buffer

                                 - Page 130 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         KeyStuff( nAscii, nCod ) -> NIL

    Description:

         Stuffs a character into the keyboard buffer without clearing pending
         keystrokes.  Allows function keys. It must input the ascii code of
         the key or the scan code.  The function keys have the ascii code at 0
         and indicate this value on the scan code.  The normal keys (not
         function) indicatet his value on the ascii code and this scan code is
         at 0.

    Return:

         Nothing.

    Example:

         nKey := KeyScan()
         KeyStuff ( nKey % 256, nKey / 256 )

See Also: "KeyScan()" 


    NormKey()

         Sets the normal typematic rate

    Syntax:

         NormKey() -> NIL

    Description:

         Sets the normal typematic interval time and auto-repeat start
         delay time.

    Return:

         Nothing.

    Example:

         NormKey()

See Also: "FastKey()" "SlowKey()" 


    SetLastKey()

         Sets the LastKey() value

    Syntax:

                                 - Page 131 -
Norton Guide: `FAST.lib 3.50  Reference'



         SetLastKey( nKey ) -> NIL

    Description:

         SetLastKey() is a keyboard function that clears all pending keys
         from the Clipper keyboard buffer and sets the LastKey() value.

    Return:

         Nothing.

    Example:

         #include "inkey.ch"

         SetLastKey( K_ESC )

See Also: "ClrBuffer()" 


    SlowKey()

         Sets the minimum typematic rate

    Syntax:

         SlowKey() -> NIL

    Description:

         Sets the maximum typematic interval time and auto-repeat start
         delay time.

    Return:

         Nothing.

    Example:

         SlowKey()

See Also: "FastKey()" "NormKey()" 












                                 - Page 132 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 1, LAN and Multitaskers




    Here you have a few functions available to make your work with Novell,
  Windows and DesqView be less boring.

 


    DesqVer()

         Returns DesqView version

    Syntax:

         DesqVer() -> cVersion

    Description:

         Returns DesqView version or an empty string if DesqView is not
         running.

    Return:

         A character value with DesqView version or an empty string if
         Desqview is not running.

    Example:

         If IsDesqView()
           Warning( "DesqView Version: " + DesqVer() )
         EndIf

See Also: "IsDesqView()" 


    IsDesqView()

         Desqview installation check

    Syntax:

         IsDesqView() -> lLoaded

    Description:

         Determines if DesqView is installed.

    Return:

         A logic value.

    Example:

                                 - Page 133 -
Norton Guide: `FAST.lib 3.50  Reference'



         If IsDesqView()
           Warning( "Desqview is present" )
         EndIf

See Also: "IsWin3()" "IsLANtastic()" "IsMSLAN()" "IsNovell()" 


    IsLANtastic()

         LANtastic installation check

    Syntax:

         IsLANtastic() -> lLAN

    Description:

         Determines if LANtastic is installed.

    Return:

         A logic value.

    Example:

         If IsLANtastic()
           Warning ( "LANTastic is present" )
         EndIf

See Also: "IsDesqView()" "IsMSLAN()" "IsNovell()" "IsWin3()" 


    IsMSLAN()

         MS LAN installation check

    Syntax:

         IsMSLAN() -> lMSLAN

    Description:

         Determines if a MS LAN is installed.

    Return:

         A logic value.

    Example:

         If IsMSLAN()
           Warning ( "MS LAN is present. Hello Bill." )
         EndIf


                                 - Page 134 -
Norton Guide: `FAST.lib 3.50  Reference'


See Also: "IsDesqView()" "IsLANtastic()" "IsNovell()" "IsWin3()" 


    IsNovell()

         Novell installation check

    Syntax:

         IsNovell() -> lNovell

    Description:

         Determines if Novell Netware is installed.

    Return:

         A logic value.

    Example:

         If ! IsNovell()
           Warning ( "Netware, better" )
         EndIf

See Also: "IsDesqView()" "IsLANtastic()" "IsMSLAN()" "IsWin3()" 


    IsWin3()

         Windows 3 installation check

    Syntax:

         IsWin3() -> lWin

    Description:

         Determines if Windows 3 is installed.

    Return:

         A logic value.

    Example:

         If IsWin3()
           Warning ( "Close the window" )
         EndIf

See Also: "IsDesqView()" "IsLANtastic()" "IsMSLAN()" "IsNovell()" 


    nwAbortCap()


                                 - Page 135 -
Norton Guide: `FAST.lib 3.50  Reference'


         Novell Netware, cancels LPT capture

    Syntax:

         nwAbortCap( nPort ) -> nError

         nPort : LPT port. 0 = LPT1, 1 = LPT2, 2 = LPT3

    Description:

         Cancels remote printer capture and aborts pending works.

    Return:

         A numeric value indicating an error or zero if there is no error.

    Example:

         If nwAbortCap() == 0
           Warning ( "Captured ok" )
         EndIf

See Also: "nwBeginCap()" "nwEndCap()" "nwFlushCap()" 


    nwBeginCap()

         Novell Netware, starts LPT capture

    Syntax:

         nwBeginCap( nPort ) -> nError

         nPort : LPT port. 0 = LPT1, 1 = LPT2, 2 = LPT3

    Description:

         Begins capture to a remote printer.

    Return:

         A numeric value indicating an error or zero if there is no error.

    Example:

         If nwBeginCap() == 0
           Warning ( "Captured ok" )
         EndIf

See Also: "nwAbortCap()" "nwEndCap()" "nwFlushCap()" 


    nwEndCap()

         Novell Netware, ends LPT capture

                                 - Page 136 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         nwEndCap( nPort ) -> nError

         nPort : LPT port. 0 = LPT1, 1 = LPT2, 2 = LPT3

    Description:

         Ends remote printer capture and aborts pending works.

    Return:

         A numeric value indicating an error or zero if there is no error.

    Example:

         If nwEndCap() == 0
           Warning ( "Captured ok" )
         EndIf

See Also: "nwAbortCap()" "nwBeginCap()" "nwFlushCap()" 


    nwFlushCap()

         Novell Netware, refreshes LPT capture

    Syntax:

         nwFlushCap( nPort ) -> nError

         nPort : LPT port. 0 = LPT1, 1 = LPT2, 2 = LPT3

    Description:

         Refreshes data printer queue information.

    Return:

         A numeric value indicating an error or zero if there is no error.

    Example:

         If nwFlushCap() == 0
           ...
         EndIf

See Also: "nwAbortCap()" "nwBeginCap()" "nwEndCap()" 


    nwLogout()

         Novell Netware, system logout


                                 - Page 137 -
Norton Guide: `FAST.lib 3.50  Reference'


    Syntax:

         nwLogout() -> nError

    Description:

         Says goodbye to Novell ending all pending works and services.

    Return:

         A numeric value indicating an error or zero if there is no error.

    Example:

         If nwLogout() == 0
           Warning ( "Good bye." )
         EndIf

See Also: "nwStation()" 


    nwStation()

         Novell Netware, gets station number

    Syntax:

         nwStation() -> nConnect

    Description:

         Returns station number connection.

    Return:

         A numeric value indicating the station number connection.

    Example:

         ? Str( nwStation() )

See Also: "nwLogout()" 


    WinVersion()

         Returns MS-Windows version

    Syntax:

         WinVersion() -> cVersion

    Description:

         Returns MS-Windows version or an empty string if Windows is not

                                 - Page 138 -
Norton Guide: `FAST.lib 3.50  Reference'


         running.

    Return:

         A character value with Windows version or an empty string if Windows
         is not running.

    Example:

         Warning( "Windows Version: " + WinVersion() )

See Also: "IsWin3()" 


    WinClipSize()

         Determines the size of the win 3 clipboard

    Syntax:

         WinClipSize() -> nBytes

    Description:

         Determines the size of the win 3 clipboard if windows is running.

    Return:

         A numerical value indicating the size of the win 3 clipboard.

    Example:

         If WinOpenClip()
           ? WinClipSize()
           If ! WinCloseClip()
             ? "Error closing clipboard"
           EndIf
         Else
           "Error opening clipboard"
         EndIf

See Also: "WinCloseClip()" "WinOpenClip()" 


    WinCloseClip()

         Closes the win 3 clipboard

    Syntax:

         WinCloseClip() -> lOk

    Description:

         Closes the win 3 clipboard if windows is running.

                                 - Page 139 -
Norton Guide: `FAST.lib 3.50  Reference'



    Return:

         A logic value indicating if an error is found.

    Example:

         If WinOpenClip()
           ? WinClipSize()
           If ! WinCloseClip()
             ? "Error closing clipboard"
           EndIf
         Else
           "Error opening clipboard"
         EndIf

See Also: "WinClipSize()" "WinOpenClip()" 


    WinDelClip()

         Deletes the content of the win 3 clipboard

    Syntax:

         WinDelClip() -> lOk

    Description:

         Deletes the content of the win 3 clipboard if windows is running.

    Return:

         A logic value indicating if an error is found.

    Example:

         If WinOpenClip()
           ? WinClipSize()
           If ! WinDelClip()
             ? "Error deleting clipboard"
           EndIf
           If ! WinCloseClip()
             ? "Error closing clipboard"
           EndIf
         Else
           "Error opening clipboard"
         EndIf

See Also: "WinClipSize()" "WinOpenClip()" 


    WinGetClip()

         Gets the content of the win 3 clipboard

                                 - Page 140 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         WinGetClip() -> cClip

    Description:

         Gets the content of the win 3 clipboard if windows is running.

    Return:

         A string with the content of the win 3 clipboard.

    Example:

         If WinOpenClip()
           cBuffer := WinGetClip()
           WinCloseClip()
         EndIf

See Also: "WinClipSize()" "WinOpenClip()" 


    WinOpenClip()

         Opens the win 3 clipboard

    Syntax:

         WinOpenClip() -> lOk

    Description:

         Opens the win 3 clipboard if windows is running.

    Return:

         A logic value indicating if an error is found.

    Example:

         If WinOpenClip()
           cBuffer := WinGetClip()
           WinCloseClip()
         EndIf

See Also: "WinClipSize()" "WinCloseClip()" 


    WinSetClip()

         Sets the win 3 clipboard with a specified value

    Syntax:


                                 - Page 141 -
Norton Guide: `FAST.lib 3.50  Reference'


         WinSetClip( cClip ) -> lOk

         cClip : The value to insert in the win 3 clipboard

    Description:

         Sets the content of the win 3 clipboard if windows is running.

    Return:

         A logic value indicating if an error is found.

    Example:

         If WinOpenClip()
           WinSetClip( "This a text" )
           WinCloseClip()
         EndIf

See Also: "WinClipSize()" "WinOpenClip()" 



































                                 - Page 142 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 1, MetaFunctions




    Trying to document everything would be impossible. You better look
 around and find out what you need.

 


    AsciiTab()

         Shows an ascii table

    Syntax:

         AsciiTab( [nRow], [nCol], [nStart] ) -> NIL

         nRow   : Row of ascii table
         nCol   : Column of ascii table
         nStart : Initial ascii character

    Description:

         Shows an ascii table at a given position.

    Return:

         Nothing.

    Example:

         AsciiTab( 10, 10, 1 )


    Backup()

         Makes a backup

    Syntax:

         Backup( [dDate], [cTime], [cUser], [cUnit], aDir, [lRec], ;
                 [cColor], [bBlock] ) -> lError

         dDate     : Backup date
         cTime     : Backup time
         cUser     : Backup user. 127 more characters
         cUnit     : Backup drive
         aDir      : Bidimensional array of directories to save.
         lRec      : A logical value that indicates if the subdirectories
                     are being backed up.
         cColor    : Color of the statistics window
         bBlock    : A codeblock to evaluate before reading a new disk.


                                 - Page 143 -
Norton Guide: `FAST.lib 3.50  Reference'


    Description:

         Backups all the given directories.

         WARNING
         This function calls dbCloseAll() so it closes all data base files.

    Return:

         A logical indicating if an error has been found.

    Example:

         If Backup ( Date (), Time (), "FAST.lib", "A:\", ;
                     { { "C:\DOS\",      "*.*"   }, ;
                       { "C:\OS2\MDOS\", "*.COM" } }, ;
                    .T., "N/W,N/W", ;
                    { || NewDisk() } )
           BoxWarning ( "Backup ok" )
         Else
           BoxWarning ( "Errors detected" )
         EndIf

         Function NewDisk ()
             Format ( 0, 4, .F. )    // Format a 3 HD disk in A:
         Return ( .T. )              // It must returns .T.
                                     // If returns .F. cancels the backup

See Also: "Restore()" 


    BigClock()

         Shows a digital watch with large numbers

    Syntax:

         BigClock( [nRow], [nCol] ) -> NIL

         nRow   : Row position
         nCol   : Column position

    Description:

         This function shows a digital watch with large numbers and waits
         until a key is pressed restoring the screen.

    Return:

         Nothing.

    Example:

         BigClock( 10, 20 )


                                 - Page 144 -
Norton Guide: `FAST.lib 3.50  Reference'


See Also: "Clock()" 


    Calculator()

         Displays a calculator

    Syntax:

         Calculator( [cColor], [cColorNum], [ColorMem] ) -> nResult

         cColor    : Box color
         cColorNum : Numbers color
         cColorMem : Memory numbers color

    Description:

         Display a calculator with selected colors.

    Return:

         The result of calculation if F10 is pressed or NIL if Esc is
         pressed.

    Example:

         nRes := Calculator ( "N/W", "G+/N", "R+/N" )


    Calendar()

         Display a calendar

    Syntax:

         Calendar( [nY], [nX], [cColor], [cSunday], [cColorHigh] ) -> dDate

         nY         : Row position
         nX         : Column position
         cColor     : Calendar color
         cSunday    : Sunday's color
         cColorHigh : Selected day color

    Description:

         Display a calendar at the given position and colors.

    Return:

         Selected date if < is pressed or NIL if Esc is pressed.

    Example:

         dDate := Calendar ( 5, 20, "N/BG", "R/BG", "GR+/B" )


                                 - Page 145 -
Norton Guide: `FAST.lib 3.50  Reference'



    ChkDsk()

         Checks a floppy format

    Syntax:

         ChkDsk ( nDisk ) -> nFormat

         nDisk : Disk unit to check. A: -> 0, B: -> 1.

    Description:

         Checks a floppy disk format and returns a numerical value.

    Return:

         -2 Bad parameters
         -1 Format error
          0 Unknown format
          1 360 kb   5 DD
          2 720 kb   3 DD
          3 1.2 mb   5 HD
          4 1.44 mb  3 HD

    Example:

         nFormat := ChkDsk ( 0 )
         If nFormat > 0
           Format ( 0, nFormat, .T. )
         Else
           Warning ( "Unknown format" )
         EndIf

See Also: "Format()" 


    ChooseColor()

         Allows color choice

    Syntax:

         ChooseColor( [nRow], [nCol], [lShowColor] ) -> NIL

         nRow       : Row of window, by default 3.
         nCol       : Column of window, by default 28.
         lShowColor : A logic value indicating if the color in string
                      format must be showed during selection. By default
                      is false, .F.

    Description:

         Allows to user to choose a color.


                                 - Page 146 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         The color in string format or NIL if Esc has been pressed.

    Example:

         ? "Selected Color is " + ChooseColor( 3, 28, .T. )


    Chrono()

         Gets/Sets 3 programable chronos

    Syntax:

         Chrono( nChrono [, lLoad] ) -> nTime

         nChrono : Chrono number ( 1 2 3 )
         lLoad   : A logic indicating if we want to load the chrono with
                   the actual time. Default value is .F.

    Description:

         Gets/Sets 3 internal chronos. Each of them come be programmed
         separately.

    Return:

         The interval between actual time and the time when the chrono was
         programmed.

    Example:

         Chrono( 1, .T. )       // Chrono 1 with actual time
         Delay( 10 )            // Delay, 10 seconds
         ? Chrono( 1 )          // 10


    Clock()

         Un/Installs a resident clock

    Syntax:

         Clock( [lActive], [nPosY], [nPosX], [cColor] ) -> lIsActive

         lActive : A logic value indicating if we want to activate (.T.) or
                   deactivate (.F.) the watch.
                   If parameter is NIL, Clock() returns the actual mode.
         nPosY   : Row position. By default 0.
         nPosX   : Column position. By default 70.
         cColor  : Clock color. By default "GR+/B"

    Description:


                                 - Page 147 -
Norton Guide: `FAST.lib 3.50  Reference'


         Shows a watch without the programmer action.

    Return:

         The actual watch mode. .T. active and .F. inactive.

    Example:

         Clock( .T., 0, 1, "W/B" )  // installs the clock on row 0, column 1
                                    // color "W/B"
         Inkey( 0 )
         Clock( .F. )

See Also: "BigClock()" 


    DirTree()

         Create an array with structure of a disk

    Syntax:

         DirTree( cMask, cDir ) -> aArray

         cMask : Format the directories must fulfill to be searched.
         cDir  : Beginning directory.

    Description:

         Returns an array with specified directories order from father to
         child.

    Return:

         An array with directories.

    Example:

         Window ( 4, 0, 22, 29, "Directory C:\", "ͻȺ ", .T. )
         aChoice ( 5, 2, 21, 27, DirTree ( "\*.*", "C:\" ), .T. )


    Editor()

         Edits a text file

    Syntax:

         Editor ( [cFile], [cColor] ) -> NIL

         cFile  : File to edit.
         cColor : Editor color.

    Description:


                                 - Page 148 -
Norton Guide: `FAST.lib 3.50  Reference'


         Execute an ascii editor with files not larger than 64 kb.

    Return:

         Nothing.

    Example:

         Editor ( "Fast.Ini", "W/B" )

See Also: "Notes()" 


    FastMemo()

         Edits a memo value

    Syntax:

         FastMemo( nY1, nX1, nY2, nX2, cMemo, [cTitle], [cColBro], ;
                   [lShadow], [lWrite] ) -> cNewMemo

         nY1     : Upper left Y coordinate
         nX1     : Upper left X coordinate
         nY2     : Lower right Y coordinate
         nX2     : Lower right X coordinate
         cMemo   : Memo to edit
         ctitle  : Window title
         cColBro : Window color
         lShadow : A logic value to indicate shadowing
         lWrite  : A logic value indicating if memo is read/only

    Description:

         Edit a Clipper memo field.

    Return:

         A new memo value.

    Example:

         Local cMemo := "Hello"
         ? FastMemo( 10, 10, 20, 55, cMemo, "MemoTest", "GR+/B", .T., .T. )


    FontEdit()

         Edits character fonts

    Syntax:

         FontEdit( [ cFile ] ) -> NIL

         cFile : The filename with the font

                                 - Page 149 -
Norton Guide: `FAST.lib 3.50  Reference'



    Description:

         Edit character fonts from Clipper.

    Return:

         Nothing.

    Example:

         FontEdit( "cubo.fon" )


    Format()

         Formats a floppy

    Syntax:

         Format ( nDisk, nFormat, lQuick ) -> nError

         nDisk   : Disk unit to format. A:=0, B:=1.
         nFormat : Format. 360=1, 720=2, 1.2=3, 1.44=4
         lQuick  : A logical value indicating if you want QuickFormat or not.

    Description:

         Formats a floppy disk with a specified format.

    Return:

         -2 Bad parameters
         -1 Format error
          0 Ok

    Example:

         nFormat := ChkDsk ( 0 )
         If nFormat > 0
           Format ( 0, nFormat, .T. )
         Else
           Warning ( "Unknown format" )
         EndIf

See Also: "ChkDsk()" 


    GaugeNew()

         Creates and inits a status bar

    Syntax:

         GaugeNew( nRow, cMessage, cColor ) -> aBar

                                 - Page 150 -
Norton Guide: `FAST.lib 3.50  Reference'



         nRow     : Row position
         cMessage : Message to display
         cColor   : Window color

    Description:

         Creates and inits a status bar returning an array structure with
         bar information to GaugeUpdate().

    Return:

         An array structure.

    Example:

         aGauge := GaugeNew( 9, "Fast Library Installation progress", "G" )

See Also: "GaugeUpdate()" 


    GaugeUpdate()

         Increases a status bar

    Syntax:

         GaugeUpdate( aBar, nInc ) -> NIL

         aBar : An array with bar information
         nInc : Increment 0-1

    Description:

         Increases a status bar that has been created with GaugeNew().

    Return:

         Nothing.

    Example:

         aGauge := GaugeNew( 9, "Fast Library Installation", "G" )
         GaugeUpdate( aGauge, 0.5 )
         GaugeUpdate( aGauge, 0.5 )

See Also: "GaugeNew()" 


    InspectDBF()

         Inspects the active workareas

    Syntax:


                                 - Page 151 -
Norton Guide: `FAST.lib 3.50  Reference'


         InspectDBF() -> NIL

    Description:

         This function inspects the active workareas giving information
         about its.

    Return:

         Nothing.

    Example:

         InspectDBF()

See Also: "InspectOBJ()" "InspectSETS()" 


    InspectOBJ()

         Inspects an array or object

    Syntax:

         InspectOBJ( cVarName, xVar ) -> NIL

         cVarName : The name of memory variable
         xVar     : The var to inspect

    Description:

         This function inspects an array or object and allows to change it.

    Return:

         Nothing.

    Example:

         aArray := { "Hello", 12, { "First", "Second" }, { || NIL } }
         InspectOBJ( "aArray", aArray )

See Also: "InspectDBF()" "InspectSETS()" 


    InspectSETS()

         Inspects the SETS

    Syntax:

         InspectSETS() -> NIL

    Description:


                                 - Page 152 -
Norton Guide: `FAST.lib 3.50  Reference'


         This function inspects the sets and allows to change its.

    Return:

         Nothing.

    Example:

         InspectSETS()

See Also: "InspectDBF()" "InspectOBJ()" 


    IsFastGT()

         Determines if FAST.GT is linked

    Syntax:

         IsFastGT() -> lLinked

    Description:

         Determines if FAST.GT is linked.
         FAST.GT is a FAST.* software that allows Clipper standard
         programs running in graphic mode without additional changes to
         the source code.

    Return:

         A logic value.

    Example:

         If IsFastGT()
           ? "Oh!!! we are in graphic mode"
         EndIf


    IsPirate()

         Determines if the program is a pirated copy

    Syntax:

         IsPirate() -> lIsPirate

    Description:

         This function determines if the program in execution is a pirated
         copy.  The first time you run the program it will be automarked.
         In this way, you can check this mark on next executions.
         If you execute the program in another system, IsPirate() will
         return .T., otherwise it will return .F.


                                 - Page 153 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         A logic value indicating if the program in execution is a pirate
         copy.

    Example:

         If IsPirate()
           ? "Don't forget to register"
           Quit
         EndIf


    IsSound()

         Determines if speaker sounds are allowed

    Syntax:

         IsSound( [lMode] ) -> lOldMode

         lMode : A logic to indicate the new value.

    Description:

         This function determines if speaker sounds are allowed when
         a function of Fast Library is running.

    Return:

         Actual mode.

    Example:

         lSound := IsSound( .F. )
         Serpent()                      // without sound
         IsSound( lSound )


    Manager()

         A little PCTools in Clipper

    Syntax:

         Manager ( [cColor], [cColorHigh] ) -> NIL

         cColor     : File Manager color.
         cColorHigh : Buttons of dialog boxes color.

    Description:

         Runs a little File Manager as PCTools.

    Return:

                                 - Page 154 -
Norton Guide: `FAST.lib 3.50  Reference'



         Nothing.

    Example:

         Manager ( "N/W,N/BG", "N/BG" )


    MiniDebug()

         Evaluate Clipper expressions

    Syntax:

         MiniDebug( nY, cExpr ) -> NIL

         nY    : Row of debugger
         cExpr : Initial expression

    Description:

         Evaluate valid Clipper expressions.

    Return:

         Nothing.

    Example:

         MiniDebug( 7, "Replicate( 'Fast ', 2 )" )


    MsgScroll()

         Shows a message with horizontal scroll

    Syntax:

         MsgScroll( nRow, nCol, nSize, cString, cColor ) -> NIL

         nRow    : Row position
         nCol    : Column position
         nSize   : Horizontal size
         cString : Message to show
         cColor  : Message color

    Description:

         Shows a message with horizontal scroll until you press any key.

    Return:

         Nothing.

    Example:

                                 - Page 155 -
Norton Guide: `FAST.lib 3.50  Reference'



         MsgScroll( 10, 12, 20, "Press any key to continue", "GR+/B" )


    Notes()

         Makes your calculations in a Lotus123 style

    Syntax:

         Notes ( [cColor], [cColorBrowse], [cFile] ) -> NIL

         cColor       : Spreadsheet color
         cColorBrowse : The template of colors for the browse.
         cFile        : HC file with Spreadsheet

    Description:

         With this function you can access a spreadsheet.

    Return:

         Nothing.

    Example:

         Notes( "W/B,N/BG", "W/B,N/BG,G/B,W/B,R+/B", "example1.hc" )

See Also: "Editor()" 


    RealStars()

         Shows a star field simalator

    Syntax:

         RealStars( nSpeed ) -> NIL

         nSpeed : the speed of the stars. Range 1-10. Default value is 3.

    Description:

         Sets the screen to black and starts showing stars in different
         colors and sizes. Waits until a key is pressed to restore the
         old values.

    Return:

         Nothing.

    Example:

         RealStars()


                                 - Page 156 -
Norton Guide: `FAST.lib 3.50  Reference'


See Also: "Stars()" "ScreenSaver()" 


    Restore()

         Restores a backup

    Syntax:

         Restore( [cUnit], aDirec, cColor ) -> lExit

         cUnit  : Backup unit
         aDirec : Directory array to restore
         cColor : Window color

    Description:

         Restores from cUnit all files whose names are contained in one of
         the elements of the array.

         WARNING!!
         This function makes a dbCloseAll()

    Return:

         A logic value indicating the result.

    Example:

         Restore ( "A:\", { "C:\DOS" }, "N/W,N/W" )

See Also: "Backup()" 


    ScreenSaver()

         Shows a screen saver

    Syntax:

         ScreenSaver( cColor [, cMessage] ) -> NIL

         cColor   : Message color
         cMessage : Message to display

    Description:

         Your monitor will thank you for ever.

    Return:

         Nothing.

    Example:


                                 - Page 157 -
Norton Guide: `FAST.lib 3.50  Reference'


         ScreenSaver( "BG+/N", "Fast Library For Clipper ScreenSaver" )

See Also: "Stars()" 


    Stars()

         Shows a screen saver

    Syntax:

         Stars() -> NIL

    Description:

         Sets the screen to black  and starts showing stars in different
         colors and sizes. Waits until a key is pressed to restore the
         old values.

    Return:

         Nothing.

    Example:

         Stars ()

See Also: "RealStars()" "ScreenSaver()" 


    VirCheck()

         Checks the memory for 100+ viruses

    Syntax:

         VirCheck() -> aVirus

    Description:

         Checks the memory for 100+ viruses.
         VirCheck finds the next viruses:

              shake                          invader
              mg                             669 / thirteen minutes
              1063 / mono                    plastique / anticad
              jabberwocky                    horse-2
              murphy-2                       patricia / smack
              plastique2576 / anticad 2576   horse
              sparse                         murphy-1 / murphy-4
              shirley                        zherkov-1882
              1876 / dash-em                 nomenklatura
              948 / screenplus1              magnitogorsk
              lozinsky / zherkov             hitchcock
              dark avenger-1028              1193 / copyright

                                 - Page 158 -
Norton Guide: `FAST.lib 3.50  Reference'


              ussr-707                       justice
              europe-92                      cascade
              516 / leapfrog                 1067 / headcrash
              rape-747                       klaeren / hate
              growing block                  squeaker
              SVC                            SVC 5.0 or SVC 6.0
              vriest                         carioca
              789 / filehider                eddie-2
              blinker                        backtime
              600 or voronezh family         hey you
              datalock                       ussr-1049
              slow / zerotime                solano
              905 / backfont                 sverdlov
              socha                          yankee or mlti
              mh-757                         milous
              vitcode                        westwood
              fellowship                     diamond-a
              diamond-b                      dir
              gotcha                         plovdiv 1.3
              durban                         brothers
              jerusalem family               armagedon
              8-tunes                        mendoza
              fu manchu                      anarkia
              spyer / kiev                   terror
              jerusalem-g                    pregnant
              frere jacques                  tremor
              pcvrsds                        carfield
              gp1                            cinderella
              dbase                          troi
              border                         483
              flip                           2468 / tequila
              black monday                   sunday
              tumen 0.5 / hero               twins
              08/15 / many fingers           ontario
              year 1992 / b1m92              revenge

         VirCheck() only checks the memory and no disks or files.

    Return:

         An array with an element for each virus. This elemento is .F. if
         the virus is not active in memory or .T. if the virus is active.

    Example:

         FUNCTION Demo()
         LOCAL lVirus := .F.
         LOCAL aArray
         LOCAL nInd
         LOCAL aName  := { ;
              "shake",                          "invader", ;
              "mg",                             "669 / thirteen minutes", ;
              "1063 / mono",                    "plastique / anticad", ;
              "jabberwocky",                    "horse-2", ;
              "murphy-2",                       "patricia / smack", ;

                                 - Page 159 -
Norton Guide: `FAST.lib 3.50  Reference'


              "plastique2576 / anticad 2576",   "horse", ;
              "sparse",                         "murphy-1 / murphy-4", ;
              "shirley",                        "zherkov-1882", ;
              "1876 / dash-em",                 "nomenklatura", ;
              "948 / screenplus1",              "magnitogorsk", ;
              "lozinsky / zherkov",             "hitchcock", ;
              "dark avenger-1028",              "1193 / copyright", ;
              "ussr-707",                       "justice", ;
              "europe-92",                      "cascade", ;
              "516 / leapfrog",                 "1067 / headcrash", ;
              "rape-747",                       "klaeren / hate", ;
              "growing block",                  "squeaker", ;
              "SVC",                            "SVC 5.0 or SVC 6.0", ;
              "vriest",                         "carioca", ;
              "789 / filehider",                "eddie-2", ;
              "blinker",                        "backtime", ;
              "600 or voronezh family",         "hey you", ;
              "datalock",                       "ussr-1049", ;
              "slow / zerotime",                "solano", ;
              "905 / backfont",                 "sverdlov", ;
              "socha",                          "yankee or mlti", ;
              "mh-757",                         "milous", ;
              "vitcode",                        "westwood", ;
              "fellowship",                     "diamond-a", ;
              "diamond-b",                      "dir", ;
              "gotcha",                         "plovdiv 1.3", ;
              "durban",                         "brothers", ;
              "jerusalem family",               "armagedon", ;
              "8-tunes",                        "mendoza", ;
              "fu manchu",                      "anarkia", ;
              "spyer / kiev",                   "terror", ;
              "jerusalem-g",                    "pregnant", ;
              "frere jacques",                  "tremor", ;
              "pcvrsds",                        "carfield", ;
              "gp1",                            "cinderella", ;
              "dbase",                          "troi", ;
              "border",                         "483", ;
              "flip",                           "2468 / tequila", ;
              "black monday",                   "sunday", ;
              "tumen 0.5 / hero",               "twins", ;
              "08/15 / many fingers",           "ontario", ;
              "year 1992 / b1m92",              "revenge" ;
              }

         ? "Welcome to FAST.lib SCAN-VIR TOOL demo"
         ? "FAST.lib detects 100+ viruses as jerusalem, flip, dbase..."
         ?
         ? "Press any key to continue..."
         Inkey( 0 )

         ? "Checking memory for viruses..."
         aArray := VirCheck()

         ?
         ? "Checking memory report..."

                                 - Page 160 -
Norton Guide: `FAST.lib 3.50  Reference'


         aEval( aArray, { | lX | IIF( lX, lVirus := .T., ) } )

         ?
         IF lVirus
           ? "DANGER!!! Viruses found"
           FOR nInd := 1 TO LEN( aArray )
             IF aArray[ nInd ]
               ? "Viruses " + aName[ nInd ] + " detected in memory"
               Tone( 500, 10 )
             ENDIF
           NEXT
         ELSE
           ? "Viruses not found"
         ENDIF
         ?
         RETURN NIL







































                                 - Page 161 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 2, Menus




    With these functions, you will be able to create simple event-driven
 pop-up menus. Making and using them is easy.

    The entire menuing system is based on arrays; this way, you can add or
 delete items and divider lines in each menu. When you add an item, it is
 initially selectable. Later, the attribute of selections can be logically
 set. When a divider line is added, it is automatically non-selectable
 and will remain so.

 


    AddItem()

         Adds a selectable item to a submenu

    Syntax:

         AddItem( aMenu, nSubMenu, cItem, [cMess], [nPos], [aSub] ) -> NIL

         aMenu    : The menu created with NewMenu()
         nSubMenu : The number of the submenu to which the item
                    is to be added
         cItem    : The item to add to the submenu
         cMess    : The message text for the item
         nPos     : The position of the item in the submenu;
                    last position if not specified
         aSub     : An array of the submenu options

    Description:

         Adds an item to a submenu, activating the item as selectable.

    Return:

         NIL.

    Example:

         aMenu := NewMenu( { "^System", "^Tools", "^Other" }, ;
                           { "N/W", "R/W", "W/B",  "W+/B", ;
                             "N/W", "W/B", "N+/W", "R/W", "GR+/B" } )
         AddItem ( aMenu, 1, "Item ^1", "Message", , { "Sub1", "Sub2" } )

See Also: "AddLine()" "DelItem()" 


    AddLine()

          Adds a divider line to a submenu as a non-selectable item

                                 - Page 162 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         AddLine( aMenu, nSubMenu [, nPos] ) -> NIL

         aMenu    : The menu created with NewMenu()
         nSubMenu : The number of the submenu to which the
                    divider line is to be added
         nPos     : The position of the divider line in the submenu;
                    last position if not specified

    Description:

         Adds a divider line to a submenu, setting it as non-selectable.

    Return:

         NIL.

    Example:

         aMenu := NewMenu( { "^System", "^Tools", "^Other" }, ;
                           { "N/W", "R/W", "W/B",  "W+/B", ;
                             "N/W", "W/B", "N+/W", "R/W", "GR+/B" } )
         AddItem ( aMenu, 1, "Item ^1", "Message 1" )
         AddItem ( aMenu, 1, "Item ^2", "Message 2" )

         AddLine ( aMenu, 1, 2 )  // add a line between two items.

See Also: "AddItem()" "DelItem()" 


    DelLine()

         Deletes an item from a Submenu

    Syntax:

         DelLine( aMenu, nSubMenu, nPos ) -> NIL

         aMenu    : The menu created with NewMenu()
         nSubMenu : The number of the submenu from which
                    the item is to be deleted
         nPos     : The position in the submenu of the item to be deleted

    Description:

         Deletes an item or a divider line from a submenu and resizes
         the submenu array.

    Return:

         NIL.

    Example:

                                 - Page 163 -
Norton Guide: `FAST.lib 3.50  Reference'



         aMenu := NewMenu( { "^System", "^Tools", "^Other" }, ;
                           { "N/W", "R/W", "W/B",  "W+/B", ;
                             "N/W", "W/B", "N+/W", "R/W", "GR+/B" } )
         AddItem ( aMenu, 1, "Item ^1", "Message 1" )
         AddItem ( aMenu, 1, "Item ^2", "Message 2" )

         DelLine ( aMenu, 1, 2 )  // Delete the second item

See Also: "AddItem()" "AddLine()" 


DispMenu()

         Activates a menu that has been previously created

    Syntax:

         DispMenu( aMenu [, nInit] ) -> nOption

         aMenu : An array defining the structure of the menu that was
                 created previously with NewMenu().
         nInit : An optional numeric value indicating the number of the item
                 to be highlighted when the menu is first displayed

    Description:

         Activates a menu and processes all navigation keys, returning
         a value computed as:

            nOption := ;
               ( Menu_Num * 10000 ) + ( Opt_Num * 100 ) + SubMenu Option

         Note that multiple menus can be created and later activated
         as needed; this can be very useful for maintaining menus in
         a variety of languages.

         The associated message text for each item will be displayed on
         the screen row specified by SET MESSAGE TO <nRow>.

    Return:

         A numeric value indicating the selected option,
         or 0 if Esc is pressed.

    Example:

         aMenu := NewMenu( { "^System", "^Tools", "^Other" }, ;
                           { "N/W", "R/W", "W/B",  "W+/B", ;
                             "N/W", "W/B", "N+/W", "R/W", "GR+/B" } )

         AddItem ( aMenu, 1, "Item ^1-1", "Message" )
         AddItem ( aMenu, 1, "Item ^2-1", "Message" )
         AddItem ( aMenu, 2, "Item ^1-2", "Message" )
         AddItem ( aMenu, 2, "Item ^2-2", "Message" )

                                 - Page 164 -
Norton Guide: `FAST.lib 3.50  Reference'


         AddItem ( aMenu, 3, "Item ^1-3", "Message" )

         nOpt := DispMenu ( aMenu, 3 )

         Do Case
           Case nOpt == 101             // Menu 1, option 1
             ...
           Case nOpt == 102             // Menu 1, option 2
             ...
         EndCase

See Also: "NewMenu()" 


    OffItem()

         Deactivates one item of a submenu

    Syntax:

         OffItem( aMenu, nSubMenu, nPos ) -> NIL

         aMenu    : The menu created with NewMenu()
         nSubMenu : The number of the submenu in which to deactivate the item
         nPos     : The position of the item in the submenu

    Description:

         Deactivates an item so that it cannot be selected or
         seen in the menu.

    Return:

         NIL.

    Example:

         aMenu := NewMenu( { "^System", "^Tools", "^Other" }, ;
                           { "N/W", "R/W", "W/B",  "W+/B", ;
                             "N/W", "W/B", "N+/W", "R/W", "GR+/B" } )
         AddItem ( aMenu, 1, "Item ^1", "Message 1" )
         AddItem ( aMenu, 1, "Item ^2", "Message 2" )

         OffItem ( aMenu, 1, 2 )  // Deactivates the second item.

See Also: "OnItem()" 


    OnItem()

         Reactivates an item of a submenu

    Syntax:

         OnItem( aMenu, nSubMenu, nPos ) -> NIL

                                 - Page 165 -
Norton Guide: `FAST.lib 3.50  Reference'



         aMenu    : The menu created with NewMenu()
         nSubMenu : The number of the submenu in which to reactivate the item
         nPos     : The position of the item in the submenu

    Description:

         Reactivates a menu item, making it selectable again.
         A divider line cannot be made selectable.
         Only an item previously deactivated can be reactivated.

    Return:

         NIL.

    Example:

         aMenu := NewMenu( { "^System", "^Tools", "^Other" }, ;
                           { "N/W", "R/W", "W/B",  "W+/B", ;
                             "N/W", "W/B", "N+/W", "R/W", "GR+/B" } )
         AddItem ( aMenu, 1, "Item ^1", "Message 1" )
         AddItem ( aMenu, 1, "Item ^2", "Message 2" )

         OffItem ( aMenu, 1, 2 )  // Deactivate the second item
         OnItem ( aMenu, 1, 2 )   // Now reactivate it

See Also: "OffItem()" 


    NewMenu()

          Creates a new menu structure

    Syntax:

         NewMenu( aOptions, aColors, lShadow ) -> aMenu

         aOptions : A one-dimensional array with the structure:

                       { cOption1, cOption2, ..., cOptionN }

                    Each option may include the symbol "^" to indicate
                    that the character it precedes will be the one you could
                    use with the Alt key to select the option.

         aColors  : An array of 9 elements specifying the colors for:

                     - Non-selected options
                     - Special character of non-selected options
                     - Selected option
                     - Special character of selected option
                     - Items of the submenus
                     - Selected item of the submenus
                     - Non-selectable items of the submenus
                     - Special character of non-selected submenu items

                                 - Page 166 -
Norton Guide: `FAST.lib 3.50  Reference'


                     - Special character of selected submenu items

         lShadow  : A logic value to indicate shadowing. Default .F.

    Description:

         Creates an array defining the structure of a menu and the
         colors in which to display menu options and submenu items
         for each of the conditions listed above for aColors.

    Return:

         An array defining the structure and colors of the newly created menu.

    Example:

         aMenu := NewMenu( { "^System", "^Tools", "^Other" }, ;
                           { "N/W", "R/W", "W/B",  "W+/B", ;
                             "N/W", "W/B", "N+/W", "R/W", "GR+/B" }, ;
                           .T. )

See Also: "DispMenu()" 


    READ

          @ SAY..GET format for Radio Buttons

    Syntax:

         @ nRow, nCol [ SAY cSayText ]
                GET cGetVar
                [ WHEN lPrevalid ]
                [ VALID lPostValid ]
                [ COLOR cColor ]
                WITH RADIOBUTTONS aOptions
                [ NOBOX ]
                [ DOUBLE ]
                [ HORIZONTAL ]


    Description:

         Now you can create attractive radio buttons compliant with
         the CUA specifications by using an additional variant of
         the @ SAY..GET command and the standard CA-Clipper READ command.
         The new @ SAY..GET clause WITH RADIOBUTTONS specifies an
         array containing the radio button characteristics.
         If NOBOX is specified, the radio buttons will be displayed
         without an enclosing box.  If NOBOX is omitted, the radio
         buttons will be enclosed in either a single- or double-line
         box depending on whether or not DOUBLE is specified.  The
         radio buttons will be oriented horizontally if HORIZONTAL
         is specified, and vertically otherwise.


                                 - Page 167 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         Not applicable.

    Example:

         @ 4,5  SAY "Get Normal 1:" GET cGet1
         @ 6,5  SAY "Clipper Lib"   GET nChoice1 ;
                COLOR "R/B" ;
                WITH RADIOBUTTONS { "1 Opc", "2 No buttons", "3 Opc" }
         @ 6,40 SAY "Fast Library"  GET nChoice2 WHEN nChoice1 != 2 ;
                COLOR "W/N" ;
                WITH RADIOBUTTONS { "1 Adios", "2 Agur", "3 Bye bye" }
         @ 7,60 GET nChoice3 ;
                COLOR "GR+/B" ;
                WITH RADIOBUTTONS { "1 Quick", "3 Simple", "4 Beautiful" } ;
                NOBOX
         @ 12,5 SAY "Get Normal 2:" GET cGet2
         @ 17,5 SAY "Buttons 4:"    GET nChoice4 ;
                COLOR "R+/W" ;
                WITH RADIOBUTTONS { "1 Option", "2 Option", "3 Option" } ;
                DOUBLE ;
                HORIZONTAL
         READ































                                 - Page 168 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 2, Mouse




    This section of the library will give complete access to the mouse in
  your Clipper applications.

 


    rButtons()

         Returns number of buttons

    Syntax:

         rButtons() -> nButtons

    Description:

         Returns 2 if mouse is a Microsoft mouse or 3 if mouse is a
         Mouse Systems/Logitech mouse.

    Return:

         A numeric value indicating the number of buttons.

    Example:

         ? rButtons ()


    rCentre()

         Determines if the center button is pressed

    Syntax:

         rCentre() -> lPress

    Description:

         Determines if the center button is pressed returning a logic
         value.

    Return:

         A logic value indicating if is pressed or not.

    Example:

         If rCentre()
           Warning ( "Central button pressed" )
         EndIf

                                 - Page 169 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "rLeft()" "rRight()" 


    rCursorOff()

         Disables the mouse cursor display

    Syntax:

         rCursorOff() -> NIL

    Description:

         Hides the mouse cursor. Multiple calls to this function will require
         multiple calls to rCursorOn() to unhide it.

    Return:

         Nothing.

    Example:

         rCursorOff()

See Also: "rCursorOn()" 


    rCursorOn()

         Enables the mouse cursor display

    Syntax:

         rCursorOn() -> NIL

    Description:

         Shows the mouse cursor. Multiple calls to rCursorOff() will require
         multiple calls to this function to show it.

    Return:

         Nothing.

    Example:

         rCursorOn()

See Also: "rCursorOff()" 


    rClick()

         Returns the button press state

                                 - Page 170 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         rClick() -> lPush

    Description:

         Determines if a mouse button is pressed returning a logic value.

    Return:

         A logic value indicating if is pressed or not.

    Example:

         If rClick()
           ? "Yes"
         EndIf

See Also: "rCentre()" "rRight()" "rLeft()" 


    rGetPosX()

         Returns the horizontal cursor coordinate

    Syntax:

         rGetPosX() -> nCoorX

    Description:

         Returns the mouse horizontal cursor coordinate.

    Return:

         A numeric value indicating the X position.

    Example:

         ? rGetPosX()

See Also: "rGetPosY()" 


    rGetPosY()

         Returns the vertical cursor coordinate

    Syntax:

         rGetPosY() -> nCoorY

    Description:


                                 - Page 171 -
Norton Guide: `FAST.lib 3.50  Reference'


         Returns the mouse vertical cursor coordinate.

    Return:

         A numeric value indicating the Y position.

    Example:

         ? rGetPosY()

See Also: "rGetPosX()" 


    rHardCur()

         Defines the hardware text cursor

    Syntax:

         rHardCur() -> NIL

    Description:

         When the software cursor is selected, the char/attribute data at
         the current screen position is ANDed with the screen mask and
         then XORed with the cursor mask.

    Return:

         Nothing.

    Example:

         rHardCur()

See Also: "rSoftCur()" 


    rInArea()

         Determines if the mouse is on a zone of the screen

    Syntax:

         rInArea( nY1, nX1, nY2, nX2 ) -> lHere

         nY1, nX1, nY2, nX2 : The coordinates of the zone.

    Description:

         Determines if the mouse cursor is inside a zone of the screen

    Return:

         A logic value indicating if is inside of the specified zone.

                                 - Page 172 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         If rInArea ( 10, 10, 12, 20 )
           Warning ( "Mouse ok" )
         EndIf


    rInkey()

         Does the same as Inkey() but also takes care of the mouse

    Syntax:

         rInkey() -> nKey

    Description:

         The same as inkey() but also takes care of the mouse.

    Return:

         Returns the same as inKey() or 1001 if the left button is
         pressed, 1002 if the right button is pressed or 1003 if the center
         button is pressed.

    Example:

         nKey := rInkey(0)
         If nKey > 1000
           Warning ( "Mouse button pressed" )
         ElseIf nKey != 0
           Warning ( "Key pressed" )
         Else
           Warning ( "Nothing" )
         EndIf

See Also: "rInkey2()" 


    rInkey2()

         Does the same as Inkey() and takes care of the mouse and Setkey()

    Syntax:

         rInkey() -> nKey

    Description:

         The same as rInkey() and takes care of the mouse and Setkey().

    Return:

         Returns the same as inkey() or 1001 if the left button is

                                 - Page 173 -
Norton Guide: `FAST.lib 3.50  Reference'


         pressed, 1002 if the right button is pressed or 1003 if the center
         button is pressed.

    Example:

         SetKey ( 1001, { || Warning ( "Mouse Left pressed"  } )
         SetKey ( 1002, { || Warning ( "Mouse Right pressed" } )
         SetKey ( 1003, { || Warning ( "Mouse Central pressed" } )
         nKey := rInkey2(0)
         If nKey != 0
           Warning ( "Key pressed" )
         Else
           Warning ( "Nothing" )
         EndIf

See Also: "rInkey()" 


    rIsMouse()

         Indicates if the system has a mouse

    Syntax:

         rIsMouse() -> lMouse

    Description:

         Determines if the system has a mouse and the mouse driver has been
         loaded.

    Return:

         A logic value indicating if system has a mouse.

    Example:

         If rIsMouse()
           Warning ( "Yes" )
         EndIf

See Also: "rReset()" 


    rLeft()

         Determines if the left button is pressed

    Syntax:

         rLeft() -> lPress

    Description:

         Determines if the left button is pressed returning a logic value.

                                 - Page 174 -
Norton Guide: `FAST.lib 3.50  Reference'



    Return:

         A logic value indicating if is pressed or not.

    Example:

         If rLeft()
           Warning ( "Left button pressed" )
         EndIf

See Also: "rCentre()" "rRight()" 


    rReset()

         Resets mouse driver

    Syntax:

         rReset() -> NIL

    Description:

         Generates a hardware reset driver.

    Return:

         Nothing.

    Example:

         rReset()

See Also: "rIsMouse()" 


    rRight()

         Determines if the right button is pressed

    Syntax:

         rRight() -> lPress

    Description:

         Determines if the right button is pressed returning a logic value.

    Return:

         A logic value indicating if is pressed or not.

    Example:


                                 - Page 175 -
Norton Guide: `FAST.lib 3.50  Reference'


         If rRight()
           Warning ( "Right button pressed" )
         EndIf

See Also: "rCentre()" "rLeft()" 


    rSens()

         Defines the number of mickeys per pixels

    Syntax:

         rSens( nSensHor, nSensVer ) -> NIL

         nSensHor : A numeric value indicates the number of mickeys per
                    pixel horizontally. Default is 8.
         nSensVer : A numeric value indicates the number of mickeys per
                    pixel vertically. Default is 16.

    Description:

         Defines the number of mickeys per 8 pixels horizontally and
         vertically.

    Return:

         Nothing.

    Example:

         rSens( 3, 12 )


    rSetArea()

         Indicates the zone where the mouse is active

    Syntax:

         rSetArea( nY1, nX1, nY2, nX2 ) -> NIL

         nY1 : Initial Y coordinate
         nX1 : Initial X coordinate
         nY2 : Final Y coordinate
         nX2 : Final X coordinate

    Description:

         Indicates the zone where the mouse is to be active.  The system
         won't allow the pointer to move out of this zone.

    Return:

         Nothing.

                                 - Page 176 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         rSetArea ( 12, 20, 15, 60 )


    rSetPos()

         Changes the mouse cursor position

    Syntax:

         rSetPos( nRow, nCol ) -> NIL

         nRow : New row of mouse cursor
         nCol : New col of mouse cursor

    Description:

         Changes the mouse cursor to a new position.

    Return:

         Nothing.

    Example:

         rSetPos ( 12, 20 )


    rSoftCur()

         Defines software text cursor

    Syntax:

         rSoftCur() -> NIL

    Description:

         When the software cursor is selected, the char/attribute data at
         the current screen position is ANDed with the screen mask and then
         XORed with the cursor mask.

    Return:

         Nothing.

    Example:

         rSoftCur()

See Also: "rHardCur()" 



                                 - Page 177 -
Norton Guide: `FAST.lib 3.50  Reference'


    rVersion()

         Returns mouse information

    Syntax:

         rVersion() -> aInfo

    Description:

         Returns information about the mouse and driver.

    Return:

         An array with 3 elements

            aInfo[ 1 ] -> Driver version
            aInfo[ 2 ] -> IRQ used by driver
            aInfo[ 3 ] -> Mouse type:
                            1 -> "bus"
                            2 -> "serial"
                            3 -> "InPort"
                            4 -> "PS/2"
                            5 -> "HP"

    Example:

         LOCAL aTypes := { "bus", "serial", "InPort", "PS/2", "HP" }

         IF rIsMouse()
           aInfo := rVersion()
           ? "Mouse driver version " + aInfo[ 1 ]
           ? "IRQ number " + ALLTRIM( STR( aInfo[ 2 ] ) )
           ? aTypes[ aInfo[ 3 ] ] + " mouse installed"
         ENDIF




















                                 - Page 178 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 2, Printer




    With these functions you can control printing in Clipper. You will
 also be able to control the queue of the print command in DOS.

 


    GetPrinter()

         Gets printer state

    Syntax:

         GetPrinter( [nPrinter] ) -> nStatus

         nPrinter : Printer Number. 0 = LPT1, 1 = LPT2...
                    Defect verify the printer 0

    Description:

         Determines if the printer is ready, out of paper, if is off or there
         is no printer.

    Return:

         A number indicating the printer state over the next list.


          0 READY       ->  Ready
          1 BUSY        ->  Not ready
          2 PAPER       ->  Out of paper
          3 NOTHERE     ->  There's no printer
          4 LAN         ->  Remote printer
          5 ISOFF       ->  Not ready

    Example:

         nStatus := GetPrinter()
         If nStatus == 0 .Or. nStatus == 4
           Warning ( "Printer Ready" )
         EndIf


    IsPrint()

         Determines if PRINT.EXE is loaded

    Syntax:

         IsPrint() -> lLoaded


                                 - Page 179 -
Norton Guide: `FAST.lib 3.50  Reference'


    Description:

         Determines if PRINT.EXE is loaded in memory.

    Return:

         A logic value indicating if is loaded or not.

    Example:

         If IsPrint()
           Warning ( "PRINT has been loaded" )
         EndIf


    pAddFile()

         Adds a file to the print command's queue

    Syntax:

         pAddFile( cFile ) -> lError

         cFile : The file that is to be printed.

    Description:

         Adds a file to the print command's queue.
         Check that PRINT.EXE is installed before using this function.
         The filename must be indicated with full path, e.g. C:\DOS\ANSI.SYS

    Return:

         .T. if everything is Ok. or .F. if there are problems.

    Example:

         If ! pAddFile( "c:\autoexec.bat" )
           Warning ( "Error" )
         EndIf

See Also: "IsPrint()" "pDelAll()" "pDelFile()" "pError()" "pRestart()" 


    pDelAll()

         Deletes all the Print command's queue

    Syntax:

         pDelAll() -> lError

    Description:

         Deletes a the Print command's queue.

                                 - Page 180 -
Norton Guide: `FAST.lib 3.50  Reference'


         Check that PRINT.EXE is installed before using this function.

    Return:

         .T. if everything is Ok. or .F. if there are problems.

    Example:

         If ! pDelAll()
           Warning ( "Error" )
         EndIf

See Also: "IsPrint()" "pAddFile()" "pDelFile()" "pError()" "pRestart()" 


    pDelFile()

         Deletes the Print command's queue

    Syntax:

         pDelFile( cFile ) -> lError

         cFile : The file to delete from the queue.

    Description:

         Deletes the Print command's queue.
         Check that PRINT.EXE is installed before using this function.
         The filename must be indicated with full path, e.g. C:\DOS\ANSI.SYS

    Return:

         .T. if everything is Ok. or .F. if there are problems.

    Example:

         pAddFile ( "c:\config.sys" )
         If ! pDelFile( "c:\config.sys" )
           Warning( "Error" )
         EndIf

See Also: "IsPrint()" "pAddFile()" "pDelAll()" "pError()" "pRestart()" 



         Indicates if the print queue has been stopped

    Syntax:

         pError() -> lError

    Description:

         Indicates if Print has detected any error or problem and has

                                 - Page 181 -
Norton Guide: `FAST.lib 3.50  Reference'


         stopped the queue.
         Check that PRINT.EXE is installed before using this function.

    Return:

         .T. if there is error or .F. if there is not error.

    Example:

         If ! pError()
           Warning ( "Ok" )
         EndIf

See Also: "IsPrint()" "pAddFile()" "pDelAll()" "pDelFile()" "pRestart()" 


    pQueue()

         Returns the Print's queue

    Syntax:

         pQueue() -> aQueue

    Description:

         Returns the Print's queue.
         Check that PRINT.EXE is installed before using this function.

    Return:

         An array with the files of the Print's queue.

    Example:

         If IsPrint()
           aQueue := pQueue()
           For nInd := 1 To Len( aQueue )
             ? aQueue[ nInd ]
           Next
         EndIf

See Also: "IsPrint()" "pAddFile()" "pDelAll()" "pDelFile()" "pError()" 


    pRestart()

         Restarts the Print's queue

    Syntax:

         pRestart() -> lError

    Description:


                                 - Page 182 -
Norton Guide: `FAST.lib 3.50  Reference'


         Restart the Print's queue.
         Check that PRINT.EXE is installed before using this function.

    Return:

         .T. if can be restart or .F. if can not be restart.

    Example:

         If pError()
           If pRestart()
             Warning ( "Restarting queue..." )
           Else
             Warning ( "queue is dead" )
           Endif
         Else
           Warning ( "All right" )
         EndIf

See Also: "IsPrint()" "pAddFile()" "pDelAll()" "pDelFile()" "pError()" 


    PrtScr()

         Prints the current screen

    Syntax:

         PrtScr() -> NIL

    Description:

         Prints the current screen.  This is functionally equivalent to
         the Shift-PrtScrn key.

    Return:

         Nothing.

    Example:

         PrtScr()                       // Prints the screen

See Also: "SetHardCopy()" 


    SetHardCopy()

         Enables/disables hardcopy

    Syntax:

         SetHardCopy( lEnable ) -> Nothing

         lEnable : A logic value indicating enable hardcopy (.T.) or

                                 - Page 183 -
Norton Guide: `FAST.lib 3.50  Reference'


                   disable (.F.)

    Description:

         This function Enables or disables the hardcopy generated by
         the PrtScr key.

    Return:

         A logic value indicating if hardcopy is disable or enable.

    Example:

         SetHardCopy( .F. )                 // disable hardcopy

See Also: "PrtScr()" 


    ToPrint()

         Prints a string on the Printer

    Syntax:

         ToPrint( cString ) -> NIL

         cString : The string to be Printed on the Printer.

    Description:

         Prints a string on the Printer with a CR/LF. Do not open or close
         the Port, this function will do it for you.

    Return:

         Nothing.

    Example:

         ToPrint ( "This string goes to printer" )















                                 - Page 184 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 2, Screen




    These functions help with screen accesses under Clipper.

 


    BigLetter()

         Returns an array with the big banner of a letter

    Syntax:

         BigLetter( nLetter ) -> aFormat

         aLetter : The ASCII value of the letter

    Description:

         Creates an returns an array with the format of a letter to create
         banners.

    Return:

         An array value.

    Example:

         BigLetter( Chr( "A" ) )  // returns      { "          ", ;
                                                    "         ", ;
                                                    "       ", ;
                                                    "       ", ;
                                                    ...          , ;
                                                  }

See Also: "BigString()" "SmallLetter()" "SmallString()" 


    BigString()

         Displays a big banner with a specified string

    Syntax:

         BigString( nRow, nCol, cString, cColor ) -> NIL

         nRow    : Row of banner
         nCol    : Col of banner
         cString : The string to display
         cColor  : The color

    Description:

                                 - Page 185 -
Norton Guide: `FAST.lib 3.50  Reference'



         Creates and displays and banner with a specified string. This function
         uses BigLetter() to create the banner.

    Return:

         Nothing.

    Example:

         BigString( 1, 10, "Hello", "GR+/B" )

See Also: "BigLetter()" "SmallLetter()" "SmallString()" 


    BoxClose()

         Closes a light focus window

    Syntax:

         BoxClose ( aBox ) -> NIL

         aBox : An Array value with a light focus window

    Description:

         Closes a light focus window and restores the screen.

    Return:

         Nothing

    Example:

         BoxClose ( aBox )

See Also: "BoxOpen()" "BoxDelete()" "BoxPush()" 


    BoxDelete()

         Clears the contents of a light focus window

    Syntax:

         BoxDelete( aBox ) -> NIL

         aBox : An Array value of a light focus window

    Description:

         Cleans the contents of a focused window with the effect of
         pressing a button.


                                 - Page 186 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         Nothing.

    Example:

         BoxDelete ( aBox )

See Also: "BoxOpen()" "BoxClose()" "BoxPush()" 


    BoxOpen()

         Opens a light focus window

    Syntax:

         BoxOpen ( nTop, nLeft, nBottom, nRight, cColor, nFast ) -> aBox

         nTop    : Initial Y of the window.
         nLeft   : Initial X.
         nBottom : Final Y.
         nRight  : Final X
         cColor  : Background color of the window
         nFast   : Pushing speed of the window

    Description:

         Opens a window at the specified position with color cColor.
         The color is for the background and its value must not exceed 7
         ( it can not include character "+" )

    Return:

         An array with parameter for BoxPush and BoxClose.

    Example:

         BoxOpen ( 12, 10, 14, 40, "B", 0.2 )

See Also: "BoxDelete()" "BoxClose()" "BoxPush()" 


    BoxMessage()

         Writes a message in a light focus window

    Syntax:

         BoxMessage( cMessage, [nY], [nX], [cColor] ) -> aWindow

         cMessage : Message to display in the window
         nY       : Y coordinate of the window. ( Default: 7 )
         nX       : X coordinate of the window. ( Default: centered )
         cColor   : Color of the window. ( Default: "B" )

                                 - Page 187 -
Norton Guide: `FAST.lib 3.50  Reference'



    Description:

         Shows a message in the window using a focused light window. If
         the Y coordinate is not specified, it assumes the value 7.
         If the X coordinate is not specified, the window shrinks or grows
         depending in the message's length. By default, the color used is
         "B".

         Remember that you can not use the character "+" for colors
         in focused light windows.


    Return:

         An array with information to work with a focused light window.

    Example:

         nCursor  := SetCursor ( 0 )
         aButton  := BoxMessage ( "Fast Library For Clipper", 12, , "G" )
         Inkey(0)
         BoxPush ( abutton )
         Delay ( .1 )
         BoxClose ( abutton )
         SetCursor ( nCursor )

See Also: "Message()" 


    BoxPush()

         Makes a pushing effect in a window with light focus

    Syntax:

         BoxPush ( aBox ) -> NIL

         aBox : An Array value with a light focus window

    Description:

         Makes a pushing effect in the window at the speed passed to the
         function BoxOpen ()

    Return:

         Nothing.

    Example:

         BoxPush ( aBox )

See Also: "BoxOpen()" "BoxDelete()" "BoxClose()" 


                                 - Page 188 -
Norton Guide: `FAST.lib 3.50  Reference'



    BoxQuery()

         Makes a query and returns a logic value

    Syntax:

         BoxQuery( cQuery ) -> lAnswer

         cQuery : Question to show in the box

    Description:

         Asks a question using a focused light window and returns a logical
         value.

    Return:

         A logical value, according to the answer.

    Example:

         If BoxQuery ( "Do you want to exit? (Y/N)" )
           Warning( "Exiting..." )
         EndIf

See Also: "Query()" 


    BoxTurn()

         Turns on/off a window with light focus

    Syntax:

         BoxTurn ( aBox [, lMode] ) -> NIL

         aBox  : An Array value with a light focus window
         lMode : The new visual mode. ( By default: .T. )

    Description:

         Reverses the orientation of a focused light window. If lMode is
         true, the window shows up in the normal way. Otherwise, the
         window shows up as pushed.

    Return:

         Nothing.

    Example:

         BoxTurn ( aBox, .T. )

See Also: "BoxOpen()" "BoxDelete()" "BoxClose()" "BoxPush()" 

                                 - Page 189 -
Norton Guide: `FAST.lib 3.50  Reference'




    BoxWarning()

         Shows a warning in a light focus window

    Syntax:

         BoxWarning( xWarning ) -> NIL

         xWarning : Message to show on the screen. It may be a string or
                    a string array.

    Description:

         Opens up a focused light window showing a message. It waits until a
         key is pressed.

    Return:

         Nothing.

    Example:

         BoxWarning ( "Hello world" )
         BoxWarning ( { "Hello", "", "What are you doing?" } )

See Also: "Warning()" 


    Fascinate()

         Makes an effect on the screen

    Syntax:

         Fascinate( cColor1, cColor2 ) -> NIL

         cColor1 : Initial color, that must not exceed the value 7.
         cColor2 : Final color.

    Description:

         It makes a gradual color change to the color palette in text mode
         changing from cColor1 to cColor2. Use dark or light colors but don't
         mix them, because it looks pretty ugly.

    Return:

         Nothing.

    Example:

         Fascinate( "BG", "G" )
         Fascinate( "G", "GR" )

                                 - Page 190 -
Norton Guide: `FAST.lib 3.50  Reference'




    FastPrint()

         Prints a message on screen

    Syntax:

         FastPrint( nY, nX, cMessage, nColor ) -> NIL

         nY       : Y coordinate
         nX       : X coordinate
         cMessage : Message to display
         nColor   : a numeric value with the color

    Description:

         Prints a message on screen. It's very quick.

    Return:

         Nothing.

    Example:

         #define HIWHITE 15

         FastPrint( 10, 12, "I want to be free...", HIWHITE )


    File2Scr()

         Restores the screen from a file

    Syntax:

         File2Scr( cFile ) -> lSuccess

         cFile : The filename with the saved screen

    Description:

         Restore the screen from a disk file. Default file is Fast.scr.

    Return:

         A logic value indicating if an error is found.

    Example:

         If ! File2Scr ( "MyScreen.Scr" )
           Return ( NIL )
         EndIf

See Also: "Scr2File()" 

                                 - Page 191 -
Norton Guide: `FAST.lib 3.50  Reference'




    GetChar()

         Returns a character from the screen

    Syntax:

         GetChar( nY, nX ) -> cChar

         nY : The Y coordinate
         nX : The X coordinate

    Description:

         Returns a character from the specified position of screen

    Return:

         The character from the screen.

    Example:

         ? GetChar ( 22, 10 )                   // "c"


    Implode()

         Restores a saved screen region

    Syntax:

         Implode( nY1, nX1, nY2, nX2, cScr [, nDelay] ) -> NIL

         nY1    : Upper left Y coordinate
         nX1    : Upper left X coordinate
         nY2    : Lower right Y coordinate
         nX2    : Lower right Y coordinate
         cScr   : The screen saved with SaveScreen()
         nDelay : Delay time. Default value is 10.

    Description:

         Restores a screen or part of it that has been saved with
         SaveScreen().

         It is a spectacular alternative method to RestScreen().

    Return:

         Nothing.

    Example:

         cScr := SaveScreen( 10, 10, 20, 70 )

                                 - Page 192 -
Norton Guide: `FAST.lib 3.50  Reference'


         DispBox( 10, 10, 20, 70, "ͻȺ ", "W/B" )
         Inkey( 0 )
         Implode( 10, 10, 20, 70, cScr, 30 )


    Message()

         Displays a string to the screen

    Syntax:

         Message( nY, nX, cMess [, cColor] ) -> NIL

         nY     : Y coordinate
         nX     : X coordinate
         cMess  : Message to write
         cColor : Optional color of query

    Description:

         Writes cMess at the given coordinates using cColor or the active
         color if cColor is NIL.

    Return:

         Nothing.

    Example:

         Message ( 12, 15, "Hello", "R/B" )

See Also: "Warning()" "Query()" 


    NewBox()

         Opens an exploding window with title and shadow

    Syntax:

         NewBox( nY1, nX1, nY2, nX2, [cTitle], cBox, lShadow, ;
                 [cColor], [nIter], [nDelay] ) -> NIL

         nY1     : Upper left Y coordinate
         nX1     : Upper left X coordinate
         nY2     : Lower right Y coordinate
         nX2     : Lower right X coordinate
         ctitle  : Optional title of the window
         cBox    : Box of the window
         lShadow : A logical value to indicate shadowing
         cColor  : Optional, color of the window
         nIter   : Number of iterations of the explode effect. By default 6
         nDelay  : Delay time. By default 10.

    Description:

                                 - Page 193 -
Norton Guide: `FAST.lib 3.50  Reference'



         It draws a window in the given coordinates with title ctitle
         or without title if ctitle is NIL and with or without shadow
         depending on lShadow.
         The color of window is cColor or the active color if cColor is
         NIL.
         The opening explode speed of the window is defined by nInter.

    Return:

         Nothing.

    Example:

         NewBox( 10, 15, 20, 25, "My title", "ͻȺ ", .T., "GR+/B", 12 )

See Also: "Window()" 


    Query()

         Makes a query and returns a logic value

    Syntax:

         Query( cQuery [, cColor] ) -> NIL

         cQuery : Question to write
         cColor : Optional color of message

    Description:

         Makes a question on line 24 and waits until the user presses
         Y or N.

    Return:

         A logical value indicating the answer.

    Example:

         Query ( "Are you spanish? (Y/N)", "R/B" )

See Also: "Warning()" "Message()" 


    RestScr()

         Restores a saved screen region

    Syntax:

         RestScr( nY1, nX1, nY2, nX2, aScr [, nDelay] ) -> NIL

         nY1    : Upper left Y coordinate

                                 - Page 194 -
Norton Guide: `FAST.lib 3.50  Reference'


         nX1    : Upper left X coordinate
         nY2    : Lower right Y coordinate
         nX2    : Lower right X coordinate
         aScr   : The screen saved with SaveScr()
         nDelay : Delay time. By default 20.

    Description:

         Restores a screen saved with SaveScr() with a spectacular effect.

    Return:

         Nothing.

    Example:

         nMode := 2
         aScr  := SaveScr ( 10, 10, 20, 70, nMode )
         DispBox ( 10, 10, 20, 70, "ͻȺ ", "W/B"  )
         Inkey(1)
         RestScr ( 10, 10, 20, 70, aScr )

See Also: "SaveScr()" 


    SaveScr()

         Saves a screen region

    Syntax:

         SaveScr( nY1, nX1, nY2, nX2, nEffect ) -> aScreen

         nY1     : Upper left Y coordinate
         nX1     : Upper left X coordinate
         nY2     : Lower right Y coordinate
         nX2     : Lower right X coordinate
         nEffect : A numeric value indicating the type of effect
                   1 -> left - right
                   2 -> right - left
                   3 -> up - down
                   4 -> down - up

    Description:

         Saves a screen region that can later be restored with RestScr().

    Return:

         Saved screen region.

    Example:

         nMode := 1
         aScr  := SaveScr ( 10, 10, 20, 70, nMode )

                                 - Page 195 -
Norton Guide: `FAST.lib 3.50  Reference'


         DispBox ( 10, 10, 20, 70, "ͻȺ ", "W/B"  )
         Inkey(1)
         RestScr ( 10, 10, 20, 70, aScr )

See Also: "RestScr()" 


    Scr2File()

         Saves the screen to a file

    Syntax:

         Scr2File( cFile ) -> lError

         cFile : The name of a file with a saved screen

    Description:

         Saves the screen to a file. Default file is Fast.scr.

    Return:

         A logic value indicating if an error is found.

    Example:

         If ! Scr2File ( "Screen.Scr" )
           Warning ( "Not possible!!" )
         EndIf

See Also: "File2Scr()" 


    Screen()

         Clears the screen with optional color and string

    Syntax:

         Screen( [cString], [cColor] ) -> NIL

         cString : String to fill up the screen
         cColor  : Optional color.

    Description:

         Clears the screen with optional string and color.

    Return:

         Nothing.

    Example:


                                 - Page 196 -
Norton Guide: `FAST.lib 3.50  Reference'


         Screen()                          // usual cls
         Screen( "Fast Library " )         // cls with string
         Screen( "Fast Library ", "R/B" )  // cls with string and color


    SetFont()

         Changes the character font

    Syntax:

         SetFont( cFile, lGraphMode ) -> nError

         cFile      : The filename of the font
         lGraphMode : A logic indicating if we are in graphic mode.
                      By default is .F. indicating text mode.

    Description:

         It changes the pointer to the BIOS zone, where the character
         font is placed.  A new character font is placed in memory and
         used.

    Return:

         A numeric value indicating:

                0       Ok
               -1       The file does not exist
               -2       File structure is incorrect

    Example:

         If SetFont ( "c:\os2\mdos\myappl\fonts\roman.fon" ) == 0
           ? "Ok"
         EndIf

         or

         SetVGA()
         SetFont( "c:\dos\fonts\script.fon", .T. )

See Also: "SetFontChar()" 


    SetFontChar()

         Changes a single character font

    Syntax:

         SetFontChar( cString, nChar, lGraphMode ) -> NIL

         cString    : A 16 byte string with the new character font
         nChar      : An Ascii number indicating the char to change

                                 - Page 197 -
Norton Guide: `FAST.lib 3.50  Reference'


         lGraphMode : A logic indicating if we are in graphic mode.
                      By default is .F. indicating text mode.

    Description:

         It changes the pointer to the BIOS zone, where the character
         font is placed.  A new character font is placed in memory and
         used.

    Return:

         Nothing.

    Example:

         lMode := .T.                               // we are in graph mode
         cNewA := Replicate( Chr( 255 ), 16 )
         SetFontChar( cNewA, Ascii( "A" ), lMode )  // the "A" will be a ""

See Also: "SetFont()" 


    SetGray()

         Creates a virtual b/w monitor

    Syntax:

         SetGray( lGray ) -> NIL

         lGray : a logic value indicating if you want a virtual b/w monitor

    Description:

         This function allows your programs to run simulating a b/w
         monitor.
         It's very useful if you want test your programs with a b/w monitor.

    Return:

         Nothing.

    Example:

         cPalette := GetPalette()
         SetGray( .T. )
         BoxWarning( "The monitor is b/w!!!" )
         SetGray( .F. )
         SetPalette( cPalette )
         BoxWarning( "The monitor is color!!!, of course" )


    SmallLetter()

         Returns an array with the compresed banner of a letter

                                 - Page 198 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         SmallLetter( nLetter ) -> aFormat

         aLetter : The ASCII value of the letter

    Description:

         Creates an returns an array with the format of a letter to create
         a compresed banner.

    Return:

         An array value.

    Example:

         SmallLetter( Chr( "A" ) )  // returns    { "        ", ;
                                                    "     ", ;
                                                    "       ", ;
                                                    ...          , ;
                                                  }

See Also: "BigString()" "BigLetter()" "SmallString()" 


    SmallString()

         Displays a compresed banner with a specified string

    Syntax:

         SmallString( nRow, nCol, cString, cColor ) -> NIL

         nRow    : Row of banner
         nCol    : Col of banner
         cString : The string to display
         cColor  : The color

    Description:

         Creates and displays and banner with a specified string. This function
         uses SmallLetter() to create the banner.

    Return:

         Nothing.

    Example:

         SmallString( 1, 10, "Hello", "GR+/B" )

See Also: "BigLetter()" "BigLetter()" "SmallLetter()" 


                                 - Page 199 -
Norton Guide: `FAST.lib 3.50  Reference'



    Wall()

         Simulates a wall

    Syntax:

         Wall( [nY1], [nX1], [nY1], [nX2], [cColor] ) -> NIL

         nY1    : Initial Y coordinate, default is 0
         nX1    : Initial X, default is 0
         nY2    : Final Y, default is 24
         nX2    : Final X, default is 79
         cColor : The color, optional

    Description:

         Draws a wall at the specified coordinates.

    Return:

         Nothing.

    Example:

         Wall( 1, 1, 20, 51, "W/G" )
         Wall( , , , , "GR/N" )


    Warning()

         Shows a warning at line 24

    Syntax:

         Warning( cWarning, [lMode], [cColor] ) -> NIL

         cWarning : The warning to show
         lMode    : Optional action mode
         cColor   : Optional color

    Description:

         If lMode is .T. the function displays a msg and waits for a key
         restoring the screen. If lMode is .F., it doesn't wait for a key nor
         restores the screen. Default value is .T. Default color is "W/N".

    Return:

         Nothing.

    Example:

         Warning( "Push any key" )
         Warning( "Processing, please wait...", .F. )

                                 - Page 200 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "Message()" "Query()" 


    Window()

         Shows a window with optional title and shadow

    Syntax:

         Window( nY1, nX1, nY2, nX2, [cTitle], cBox, lShadow, ;
                  [cColor] ) -> NIL

         nY1     : Upper left Y coordinate
         nX1     : Upper left X coordinate
         nY2     : Lower right Y coordinate
         nX2     : Lower right X coordinate
         ctitle  : The title, optional
         cBox    : The box type
         lShadow : A logical value indicating shadowing
         cColor  : The color, optional

    Description:

         Draws a window at the given coordinates with optional title (no
         title if ctitle is NIL) and shadowed if lShadow is .T.. The color of
         the window is cColor or the active color is cColor is NIL.

    Return:

         Nothing.

    Example:

         Window ( 10, 15, 20, 25, "My title", "ͻȺ ", .T., "GR+/B" )

See Also: "NewBox()" 


















                                 - Page 201 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 2, Serial Comunications




    With this section, serial communications are controlled in Clipper.  The
 functions are low level and use the Interrupt Driven Service task of the
 serial ports.

    These functions manage 4 serial ports, from COM1 to COM4 on AT systems
 and 2 ports, COM1 and COM2 on XT systems.

    The system is compatible with all kinds of current UART's existing on
 the market for PC-XT-AT.  Access to the system is via 8259A, therefore,
 the BIOS routines are taking charge of the UART'S compatibility.

    The system has internal and external buffers available (the same kind that
 the BIOS has available for the keyboard). Thanks to them, we have available
 in memory the incoming and outgoing data for use when we are ready to receive
 or send it. The incoming buffer has been established at 16384 bytes and
 the outgoing buffer at 4096 bytes.

 


    ComCarrier()

         Determines if the Carrier flag is on

    Syntax:

         ComCarrier() -> lCarrier

    Description:

         Determines if the Carrier flag is active. This flag must be
         specifically looked at for transmissions or receptions to confirm
         that the connection is still active. If the carrier is lost, it
         could indicate that the other end of the communication link has
         disconnected.

    Return:

         .T. if the Carrier flag is on and .F. if not.

    Example:

         If ! ComCarrier()
           Warning( "NO CARRIER" )
         Else
           Warning( "CARRIER DETECTED" )
         EndIf

See Also: "ComReady()" 


                                 - Page 202 -
Norton Guide: `FAST.lib 3.50  Reference'



    ComHighDTR()

         Activates the Data Terminal Ready flag

    Syntax:

         ComHighDTR() -> NIL

    Description:

         ComHighDTR() activates the Data Terminal Ready (DTR) flag.

    Return:

         Nothing.

    Example:

         ComHighDTR()           // Activates the Data Terminal Ready flag

See Also: "ComLowDTR()" 


    ComIsEmpt()

         Determines if the reception buffer is empty

    Syntax:

         ComInEmpt() -> lEmpty

    Description:

         Determines if the internal reception buffer is empty.

    Return:

         A logic value indicating if the buffer is empty or not.

    Example:

         If ComInEmpt()
           Warning( "Read buffer is empty" )
         EndIf

See Also: "ComOutEmpt()" 


    ComInFlh()

         Initializes the reception buffers

    Syntax:


                                 - Page 203 -
Norton Guide: `FAST.lib 3.50  Reference'


         ComInFlh() -> NIL

    Description:

         Clears and initializes the reception buffer.

    Return:

         Nothing.

    Example:

         ComInFlh()

See Also: "ComOutFlh()" 


    ComInput()

         Extracts a value from the communications buffer (input)

    Syntax:

         ComInput() -> nValue

    Description:

         Receives a value from the communications buffer.

         ComInput() brings up to date the internal pointers of the reception
         buffer and points to the next value.

    Return:

         The ascii value of the received byte from the port or NIL if there's
         no available byte or the manager isn't active.

    Example:

         While .T.
           If ! ComInEmpt()
             nValue  := ComInput()
             cString += Chr( nValue )
           EndIf
         End

See Also: "ComInEmpt()" "ComInputS()" 


    ComInputS()

         Extracts a string from the communications buffer (input str)

    Syntax:


                                 - Page 204 -
Norton Guide: `FAST.lib 3.50  Reference'


         ComInputS( @cBuffer, nMaxChars ) -> nChars

         cBuffer   : The buffer where the string is to be placed
         nMaxChars : The maximum number of chars to read

    Description:

         Receives a string from the communications buffer.

         ComInputS() brings up to date the internal pointers of the reception
         buffer and points to the next value.

    Return:

         The number of chars received from the port or 0 if there's
         no available byte or the manager isn't active.

    Example:

         cBuffer := Space( 1024 )
         If comInputS( @cSpace, 1024 ) == 1024
           ? "Read Ok"
         EndIf

See Also: "ComInEmpt()" "ComInput()" 


    ComInst()

         Installs a Serial Communications System

    Syntax:

         ComInst( nPort ) -> nError

         nPort : COM port. 1=COM1, 2=COM2, 3=COM3 and 4=COM4

    Description:

         ComInst() installs a Serial Communications System and initializes
         the communication buffers.

         DANGER
         The interrupt manager must be uninstalled by the ComUnInst()
         function before you leave the system.  Otherwise, it will cause a
         general break down in the system.

    Return:

         A number with the following meanings:

           0    Ok
           1    A port out of the range 1-4 was specified
           2    There's no UART for the specified port
           3    The manager was already installed

                                 - Page 205 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         ComInst( 2 )           // installs the manager on COM2

See Also: "ComUnInst()" 


    ComLowDTR()

         Deactivates the Data Terminal Ready flag

    Syntax:

         ComLowDTR() -> NIL

    Description:

         ComLowDTR() deactivates the Data Terminal Ready (DTR) flag.

    Return:

         Nothing.

    Example:

         ComLowDTR()           // Deactivates the Data Terminal Ready flag

See Also: "ComHighDTR()" 


    ComOutput()

         Stuffs a value into the communications buffer (output)

    Syntax:

         ComOutput( nValue ) -> NIL

    Description:

         Sends a value to the communications buffer.

         The function brings up to date the internal pointers to the
         transmission buffer to point to the next element.

    Return:

         Nothing.

    Example:

         While ComReady()
           ComOutput( 32 )              // sends blank spaces to the port
         End

                                 - Page 206 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "ComOutEmpt()" "ComOutputS()" "ComReady()" 


    ComOutputS()

         Stuffs a string into the communications buffer (output str)

    Syntax:

         ComOutputS( cString ) -> NIL

    Description:

         Sends a string to the communications buffer.

         This function brings up to date the internal pointers to the
         transmission buffer to point to the next element.

    Return:

         Nothing.

    Example:

         ComOutputS( "Most people like parties" )

See Also: "ComOutEmpt()" "ComOutput()" "ComReady()" 


    ComOutEmpt()

         Determines if the transmission buffer is empty

    Syntax:

         ComOutEmpt() -> lEmpty

    Description:

         Determines if the internal transmission buffer is empty.

    Return:

         A logic value indicating if the buffer is empty or not.

    Example:

         If ComOutEmpt()
           Warning( "Write buffer is empty" )
         EndIf

See Also: "ComInEmpt()" 



                                 - Page 207 -
Norton Guide: `FAST.lib 3.50  Reference'


    ComOutFlh()

         Initializes the transmission buffers

    Syntax:

         ComOutFlh() -> NIL

    Description:

         Clears and initializes the transmission buffer.

    Return:

         Nothing.

    Example:

         ComOutFlh()

See Also: "ComInFlh()" 


    ComParity()

         Determines the communication parity

    Syntax:

         ComParity( nParity ) -> NIL

         nParity : A parity type.

                      0  or  COM_NONE
                      1  or  COM_EVEN
                      2  or  COM_ODD
                      3  or  COM_ZERO
                      4  or  COM_ONE

                   Defined in Fast.ch

    Description:

         ComParity() determines the communication parity.

    Return:

         Nothing.

    Example:

         ComParity( COM_NONE )          // without parity

See Also: "ComSpeed()" 


                                 - Page 208 -
Norton Guide: `FAST.lib 3.50  Reference'



    ComReady()

         Determines if the system is ready to transmit

    Syntax:

         ComReady() -> lReady

    Description:

         Determines if the system is ready to transmit. This depends on the
         interrupt manager being active and that the transmission spooler
         isn't full.

    Return:

         A logic value indicating if system is ready to transmit

    Example:

         If ComReady()
           Warning( "System Ok" )
         EndIf

See Also: "ComCarrier()" 


    ComSpeed()

         Determines the communication speed

    Syntax:

         ComSpeed( nSpeed ) -> NIL

         nSpeed : Communication speed

    Description:

         ComSpeed() determines the communication speed.

    Return:

         Nothing.

    Example:

         ComSpeed( 2400 )     // 2400 bps

See Also: "ComParity()" 


    ComUnInst()


                                 - Page 209 -
Norton Guide: `FAST.lib 3.50  Reference'


         Uninstalls the Serial Communications System

    Syntax:

         ComUnInst() -> NIL

    Description:

         ComUnInst() Uninstalls the Serial Communications System.

         This must always be called before you leave the system if you
         have previously activated the interrupts manager with ComInst().

    Return:

         Nothing.

    Example:

         ComUnInst()

See Also: "ComInst()" 


    CRC32()

         Returns a CRC32 polynomial of a block as PKZIP

    Syntax:

         CRC32( cBlock ) -> cCRC

         cBlock  : The block to calculate

    Description:

         Calculates a CRC32 bit polynomial of a character or memo value.

    Return:

         A character value with the CRC.

    Example:

         ? CRC32( "Hello" )                   // e.g. edb88320h
         ? CRC32( MemoRead( "Fast.txt" ) )    // e.g. feda3139h

See Also: "XCRC16()" 


    Dial()

         Dials a phone number with the modem

    Syntax:

                                 - Page 210 -
Norton Guide: `FAST.lib 3.50  Reference'



         Dial( cPort, cNumber [, cDial] ) -> lError

         cPort   : The port where the modem is found.
         cNumber : The phone number.
         cDial   : The dialing string.

    Description:

         Dials a phone number with the modem. Don't forget to hang up
         at the end of each phone call and before you dial again.

         The default port is "COM1" and the dialing string by default is
         "ATDP" to call by pulses. Write "ATDT" to call by tones.

    Return:

         If there's any error returns .F. if not, returns .T.

    Example:

         ? "Dialing..."
         Dial( "COM2", "94,4992660" )
         Inkey (0)
         ? "Hangup"
         Hangup( "COM2" )

See Also: "Hangup()" 


    GetBaud()

         Returns the baud rate of a COM port

    Syntax:

         GetBaud( nPort ) -> nBaudRate

         nPort : The port number: 0=COM1, 1=COM2, 2=COM3, 3=COM4

    Description:

         Returns the baud rate of a COM port. For example, a port configured
         by a mouse driver will return 1200, for modem, 2400, 9600, ...

    Return:

         A number with the baud rate.

    Example:

         ? GetBaud( 0 )                        // COM1


    Hangup()

                                 - Page 211 -
Norton Guide: `FAST.lib 3.50  Reference'



         Hangs up the phone

    Syntax:

         Hangup( cPort [, cHangup] ) -> lError

         cPort   : The port where the modem is found.
         cHangup : The string to send to the modem.

    Description:

         Hangs up the phone.  Don't forget to hang up at the end of each
         phone call. The default port is "COM1" and the default Hangup
         String is "+++ATH0".

    Return:

         If there's any error returns .F. if not, returns .T.

    Example:

         ? "Dialing..."
         Dial ( "COM2", "94,4992660", "ATB0DP" )
         Inkey (0)
         ? "Hangup"
         Hangup ( "COM2", "+++ATH0" )

See Also: "Dial()" 


    XCRC16()

         Returns a CRC16 polynomial of a block as XMODEM/ZMODEM

    Syntax:

         XCRC16( nPrevious, cBlock ) -> nCRC16

         nPrevious : The previous CRC16 value or 0
         cBlock    : The block to calculate

    Description:

         Calculates a CRC16 bit polynomial of a character or memo value.

    Return:

         A numeric value with the CRC.

    Example:

         nCRC := XCRC16( 0,    SPACE( 1000 ) )
         // CRC calculated,
         // now, other block

                                 - Page 212 -
Norton Guide: `FAST.lib 3.50  Reference'


         nCRC := XCRC16( nCRC, SPACE( 1000 ) )

See Also: "CRC32()" 




















































                                 - Page 213 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 2, CD-Audio SB DAC Speaker




    A new horizon is opening up for Clipper. The power of sound from within
 our applications is now possible.  Advise your users with sounds for
 errors, warnings, etc.  Let your imagination run wild.  Lets go to
 multimedia naturally with Clipper.

    In version 2.00 the ability for sound in Clipper was given.  In that
 version there was only support for Sound Blaster and Sound Blaster Pro.
 Since then I received lots of petitions to extend this subsystem to the
 Parallel DAC and the Speaker.

    Now we break that wall and give you the possibility to generate sound by
 the parallel DAC and by the speaker.  Not everybody has a Sound Blaster, but
 a speaker is on every machine.

    The maximum frequency depends on the speed of the processor and the
 drivers in memory.

    The most difficult part of sound generation have two aspects.  The first
 is the sparse information about sound formats. The second is the VMM
 system stopping while the sound functions execute.  Compatabilty has been
 achieved with the Sound Blaster, but not yet during DAC and speaker functions
 where the dear VMM pauses in silence.

 


    cdDrive()

         Returns the logical name of the CD unit

    Syntax:

         cdDrive() -> cName

    Description:

         Returns a string value with the name of the CD unit

    Return:

         A string value.

    Example:

         ? cdDrive()          // "E:"


    cdEject()

         Ejects the CD disk

                                 - Page 214 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         cdEject() -> NIL

    Description:

         Ejects the CD. If the CD is playing the call is ignored.

    Return:

         Nothing.

    Example:

         cdPlay()
         ? "Press any key to stop the CD"
         Inkey( 0 )
         cdStop()
         cdEject()

See Also: "cdStop()" "cdPlay()" "cdResume()" 


    cdInfo()

         Returns the contents of a CD disk

    Syntax:

         cdInfo() -> aSongs

    Description:

         Returns the contents of a CD disk. If the CD is playing the
         call is ignored.

    Return:

         An array with the songs of the CD disk.

    Example:

         aSongs := cdInfo()
         For nInd := 1 To Len( aSongs )
           ? aSongs[ nInd ]
         Next


    cdInstall()

         Determines if a CD is installed

    Syntax:


                                 - Page 215 -
Norton Guide: `FAST.lib 3.50  Reference'


         cdInstall() -> lInstall

    Description:

         Returns a logic indicating if a CD is installed.

    Return:

         A logic value.

    Example:

         if ! cdInstall()
           ? "Oh!! no CD detected"
         endif


    cdPlay()

         Starts the CD

    Syntax:

         cdPlay( nSong ) -> NIL

         nSong : A number with the song to play

    Description:

         Starts the CD. If the CD is playing the call is ignored.

    Return:

         Nothing.

    Example:

         cdPlay()
         ? "Press any key to stop the CD"
         Inkey( 0 )
         cdStop()

See Also: "cdEject()" "cdStop()" "cdResume()" 


    cdResume()

         Resumes playing a CD after a pause

    Syntax:

         cdResume() -> NIL

    Description:


                                 - Page 216 -
Norton Guide: `FAST.lib 3.50  Reference'


         Resumes playing a CD after a pause. If the CD is not stopped the call
         is ignored.

    Return:

         Nothing.

    Example:

         cdPlay()
         ? "Press any key to stop the CD"
         Inkey( 0 )
         cdStop()
         ? "Press any key to continue"
         Inkey( 0 )
         cdResume()

See Also: "cdEject()" "cdPlay()" "cdStop()" 


    cdStatus()

         Determines the status of a CD unit

    Syntax:

         cdStatus() -> nError

    Description:

         Determines the status of a CD unit.

    Return:

         A numeric value indicating an error or 0 if everything is OK.

    Example:

         ? cdStatus()


    cdStop()

         Stops or pauses the CD

    Syntax:

         cdStop() -> NIL

    Description:

         Stops or pauses the CD. If the CD is not playing the call
         is ignored.

    Return:

                                 - Page 217 -
Norton Guide: `FAST.lib 3.50  Reference'



         Nothing.

    Example:

         cdPlay()
         ? "Press any key to stop the CD"
         Inkey( 0 )
         cdStop()

See Also: "cdPlay()" "cdResume()" 


    dacVocPlay()

         Plays a file with VOC format by a parallel DAC

    Syntax:

         dacVocPlay( cFile, [nRate], [lKey] ) -> lError

         cFile : The VOC file name.
         nRate : The frequency ratio. Default value is 12000 Hz.
                 Use this value for frequency changes.
         lKey  : A logic value indicating if the sound must be stoped if
                 the user press any key. By default .F. indicating no stop.

    Description:

         Plays a file with VOC format by a parallel DAC.

    Return:

         A logic value indicating if the function finished without error

    Example:

         dacVocPlay( "Luna.Voc", 13224 )

See Also: "dacWavPlay()" 


    dacWavPlay()

         Plays a file with WAV format by a parallel DAC

    Syntax:

         dacWavPlay( cFile, [nRate], [lKey] ) -> lError

         cFile : The name of the file WAV
         nRate : The frequency ratio. Default value is 12000 Hz.
                 Use this value for frequency changes.
         lKey  : A logic value indicating if the sound must be stoped if
                 the user press any key. By default .F. indicating no stop.

                                 - Page 218 -
Norton Guide: `FAST.lib 3.50  Reference'



    Description:

          Plays a file with WAV format by a parallel DAC.

    Return:

         A logic value indicating if the function finished with error

    Example:

         dacWavPlay( "Luna.Wav", 13224 )

See Also: "dacVocPlay()" 


    dacPort()

         Determines the parallel port where the DAC is connected

    Syntax:

         dacPort( nPort ) -> nOldPort

         nPort : The number indicating the parallel port. Value 1 indicates
                 LPT1 and 2 indicates LPT2.

    Description:

         Determines the parallel port where the DAC is connected.
         Default port is LPT1.

    Return:

         The numeric port number the DAC is connected to.

    Example:

         dacPort( 2 )           // Now everything will go to LPT2


    MSCDESVer()

         Returns the version of MSCDEX

    Syntax:

         MSCDEXVer() -> cVersion

    Description:

         Returns a string value with the version of MSCDEX

    Return:


                                 - Page 219 -
Norton Guide: `FAST.lib 3.50  Reference'


         A string value.

    Example:

         ? MSCDEXVer()      // "02.20"


    sbCDVolL()

         Gets/Sets the left volume level of the CD. Only in SB Pro.

    Syntax:

         sbCDVolL( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the left volume set up for the CD on the system if this's
         present.

    Return:

        A numeric value showing the volume bettwen 0 and 15.

    Example:

         ? sbCDVolL()

See Also: "sbCDVolR()" 


    sbCDVolR()

         Gets/Sets the right volume level of the CD. Only in SB Pro.

    Syntax:

         sbCDVolR( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the right volume set up for the CD on the system if this's
         present.

    Return:

        A numeric value showing the volume bettwen 0 and 15.

    Example:

         ? sbCDVolR()

                                 - Page 220 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "sbCDVolL()" 


    sbFMVolL()

         Gets/Sets the left volume level

    Syntax:

         sbFMVolL( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the volume level of the left channel in the Sound Blaster.

    Return:

         A numeric value showing the volume bettwen 0 and 15.

    Example:

         ? sbFMVolL()

See Also: "sbFMVolR()" 


    sbFMVolR()

         Gets/Sets the right volume level

    Syntax:

         sbFMVolR( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the volume level of the right channel in the Sound Blaster.

    Return:

         A numeric value showing the volume bettwen 0 and 15.

    Example:

         ? sbFMVolR()

See Also: "sbFMVolL()" 


    sbInit()

                                 - Page 221 -
Norton Guide: `FAST.lib 3.50  Reference'



         Initiates the Sound Blaster and determines it's presence

    Syntax:

         sbInit() -> lError

    Description:

         Initiates the Sound Blaster and/or Sound Blaster Pro and determines
         it's presence giving back a logic.

         Remember that before calling this function you have to set up the
         IRQ and IO Address if the values you have set up on your system are
         not the default.  This means that if the IRQ is NOT 7h or the IO
         Address is NOT 220h.  Use the functions sbIO() and sbIRQ().

    Return:

         A logic value indicating if the Sound Blaster is available on the
         system at the IRQ and IO Address specified.

    Example:

         If sbInit()
           ? "There's a Sound Blaster Card"
         EndIf

See Also: "sbIO()" "sbIRQ()" 


    sbIO()

         Returns and/or modifies the SB IO Address

    Syntax:

         sbIO( nNewAddr ) -> nAddress

         nNewAddr : The new address the Sound Blaster is configured for.
                    Remember that the value must be introduced in decimal,
                    translate the hexadecimal to decimal.

    Description:

         Returns and/or modifies the IO Address of the Sound Blaster. If
         null the Sound Blaster default address is 220h, but this value can
         be modified by the switches on the card.  Check the Sound Blaster
         Input/Output Address and modify this function to that address.

    Return:

         A numeric value showing the actual IO address.

    Example:

                                 - Page 222 -
Norton Guide: `FAST.lib 3.50  Reference'



         ? sbIO()               // Probably Returns 220h in decimal

See Also: "sbIRQ()" 


    sbIRQ()

         Returns and/or modifies the IRQ of the SB

    Syntax:

         sbIRQ( nNewIRQ ) -> nIRQ

         nNewIRQ : The new IRQ that the Sound Blaster is configured for.
                   Remember that the value must be introduced in decimal,
                   translate the hexadecimal to decimal.

    Description:

         Returns and/or modifies the IRQ of the Sound Blaster. If Null the
         Sound Blaster defaults to IRQ 7h, that means that, assume the
         interruption 08h+07h = 0fh but this value can be modify by
         the switches on the card.

         Check for which IRQ your Sound Blaster has been configured
         and adjust this function to that IRQ.

    Return:

         A numerical value indicating the present IRQ

    Example:

         ? sbIRQ( 5 )    // Update the IRQ to 5 and Returns the previous

See Also: "sbIO()" 


    sbLineVolL()

         Gets/Sets the left volumn Level

    Syntax:

         sbLineVolL( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the volume level established in the left channel
         of the Sound Blaster.

    Return:

                                 - Page 223 -
Norton Guide: `FAST.lib 3.50  Reference'



         A numerical value indicating the volume bettwen 0 and 15.

    Example:

         ? sbLineVolL()

See Also: "sbLineVolR()" 


    sbLineVolR()

         Gets/Sets the right volume level

    Syntax:

         sbLineVolR( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the volume level established in the right channel
         of the Sound Blaster.

    Return:

         A numerical value indicating the volume bettwen 0 and 15.

    Example:

         ? sbLineVolR()

See Also: "sbLineVolL()" 


   sbMastVolL()

         Gets/Sets the Master left volume level

    Syntax:

         sbMastVolL( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the Master volume level established in the left channel
         of the Sound Blaster.

    Return:

         A numerical value indicating the volume bettwen 0 and 15.


                                 - Page 224 -
Norton Guide: `FAST.lib 3.50  Reference'


    Example:

         ? sbMastVolL()

See Also: "sbMastVolR()" 


    sbMastVolR()

         Gets/Sets the Master right volume level

    Syntax:

         sbMastVolR( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the Master volume level established in the right channel
         of the Sound Blaster.

    Return:

         A numerical value indicating the volume bettwen 0 and 15.

    Example:

         ? sbMastVolR()

See Also: "sbMastVolL()" 


    sbRecScrL()

         Gets/Sets the left volume level of the recording

    Syntax:

         sbRecScrL( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the recording left volume level established in the
         Sound Blaster.

    Return:

         A numerical value indicating the volume bettwen 0 and 15.

    Example:

         ? sbRecScrL()

                                 - Page 225 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "sbRecScrR()" 


    sbRecScrR()

         Gets/Sets the right volume level of the recording

    Syntax:

         sbRecScrR( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the recording right volume level established in the
         Sound Blaster.

    Return:

         A numerical value indicating the volume bettwen 0 and 15.

    Example:

         ? sbRecScrR()

See Also: "sbRecScrL()" 


    sbVocPlay()

         Plays a file with VOC format by the Sound Blaster

    Syntax:

         sbVocPlay( cFile, [nRate], [lKey] ) -> lError

         cFile : The name of the VOC file
         nRate : The frequency ratio. Default value is 12000 Hz.
                 Use this value for frequency changes.
         lKey  : A logic value indicating if the sound must be stoped if
                 the user press any key. By default .F. indicating no stop.

    Description:

         Plays a file with VOC format by the Sound Blaster.

    Return:

         A logic value indicating if the function finished without error

    Example:

         sbVocPlay( "Fast.Voc", 13224 )

                                 - Page 226 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "sbWavPlay()" 


    sbVocVolL()

         Gets/Sets the left VOC volume level

    Syntax:

         sbVocVolL( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the VOC volume level established in the left channel
         of the Sound Blaster.

    Return:

         A numerical value indicating the volume bettwen 0 and 15.

    Example:

         ? sbVocVolL()

See Also: "sbVocVolR()" 


    sbVocVolR()

         Gets/Sets the right VOC volume level

    Syntax:

         sbVocVolR( [nNewVol] ) -> nVol

         nNewVol : The new volume level bettwen 0 and 15.

    Description:

         Gets/Sets the VOC volume level established in the right channel
         of the Sound Blaster.

    Return:

         A numerical value indicating the volume bettwen 0 and 15.

    Example:

         ? sbVocVolR()

See Also: "sbVocVolL()" 


                                 - Page 227 -
Norton Guide: `FAST.lib 3.50  Reference'



    sbWavPlay()

         Plays a file with WAV format by the Sound Blaster

    Syntax:

         sbWavPlay( cFile, [nRate], [lKey] ) -> lError

         cFile : The name of the WAV file
         nRate : The frequency ratio. Default value is 12000 Hz.
                 Use this value for frequency changes.
         lKey  : A logic value indicating if the sound must be stoped if
                 the user press any key. By default .F. indicating no stop.

    Description:

         Plays a file with WAV format by the Sound Blaster.

    Return:

         A logic value indicating if the function finished without error

    Example:

         sbWavPlay( "Luna.Wav", 13224 )

See Also: "sbVocPlay()" 


    spkVocPlay()

         Plays a file with VOC format by the speaker

    Syntax:

         spkVocPlay( cFile, [nRate], [lKey] ) -> lError

         cFile : The name of the VOC file
         nRate : The frequency ratio. Default value is 12000 Hz.
                 Use this value for frequency changes.
         lKey  : A logic value indicating if the sound must be stoped if
                 the user press any key. By default .F. indicating no stop.

    Description:

         Plays a file with VOC format by the speaker.

    Return:

         A logic value indicating if the function finished without error

    Example:

         spkVocPlay( "Handel.voc", 13224 )

                                 - Page 228 -
Norton Guide: `FAST.lib 3.50  Reference'



See Also: "spkWavPlay()" 


    spkWavPlay()

         Plays a file with WAV format by the speaker

    Syntax:

         spkWavPlay( cFile, [nRate], [lKey] ) -> lError

         cFile : The name of the WAV file
         nRate : The frequency ratio. Default value is 12000 Hz.
                 Use this value for frequency changes.
         lKey  : A logic value indicating if the sound must be stoped if
                 the user press any key. By default .F. indicating no stop.

    Description:

         Reproduces a file with WAV format by the speaker.

    Return:

         A logic value indicating if the function finished without error

    Example:

         spkWavPlay( "Luna.Wav", 13224 )

See Also: "spkVocPlay()" 
























                                 - Page 229 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu List: FAST.lib 2, System




   With these functions I give you control of the Clipper environment
 from within the applications that you make. This way, you can control
 the access to the Clipper's SETS, the modem, setup, passwords, CMOS, BIOS,
 memory, drivers... etc.

 


    BIOSModel()

         Returns the computer model

    Syntax:

         BIOSModel() -> nModel

    Description:

         Returns a number between 0 and 255, that is to say, the decimal
         value of a byte indicating the model of the system that the BIOS
         reports. In a conventional 80386 this value normally is 252, or
         FCh. There are tables where these numbers are located for all the
         existing models in the majority of the assembler bibles.

    Return:

         A numeric value indicating the computer model.

    Example:

         ? BIOSModel()

See Also: "BIOSRev()" "BIOSSubMod()" 


    BIOSRev()

         Returns the BIOS revision

    Syntax:

         BIOSRev() -> nRevision

    Description:

         Returns a number between 0 and 255, that is to say, the decimal
         value of a byte indicating the revision of the system's BIOS.
         The revision usually is in relation to the date of the BIOS.

    Return:

                                 - Page 230 -
Norton Guide: `FAST.lib 3.50  Reference'



         A numeric value indicating the BIOS revision.

    Example:

         BIOSRev()

See Also: "BIOSModel()" "BIOSSubMod()" 


    BIOSSubMod()

         Returns the computer submodel

    Syntax:

         BIOSSubMod() -> nSubModel

    Description:

         Returns a number between 0 and 255, that is to say, the decimal
         value of a byte indicating the SubModel of the computer. This
         value is the one that normally is used by the majority of the
         manufacturers to distinguish their equipment. The worst case is
         a lot of clones manufacturers may use the same values. Is not the
         same with IBM, Compaq or Toshiba who use exclusive values.

    Return:

         A numeric value indicating the computer submodel.

    Example:

         BIOSSubMod()

See Also: "BIOSModel()" "BIOSRev()" 


    cArgV()

         Returns a command line parameter

    Syntax:

         cArgV( nPos ) -> cParam

         nPos : The position of the command line. The 0 position
                is the name of the program that is running. The 1 position
                is the first parameter, 2 the second....

    Description:

         Returns the parameters that has been carried to the application
         and/or the name of the program that is running.


                                 - Page 231 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         A character value with the specified command line parameter.

    Example:

         ? cArgV( 0 )           // the name of the program
         ? cArgV( 2 )           // the second parameter

See Also: "nArgC()" 


    cmosGet()

         Gets a CMOS position

    Syntax:

         cmosGet( nAddress ) -> nValue

         nAddress : The relative address of CMOS. The address
                    table is given below.

    Description:

         Returns the value of a memory cell in CMOS. This can be useful
         to determine various aspects about the system's setup. Remember that
         the input and output parameters must be specified in decimal code,
         even though the table below is given in hexadecimal.

                 00h    Seconds
                 01h    Alarm seconds
                 02h    Minutes
                 03h    Alarm minutes
                 04h    Hours
                 05h    Alarm Hours
                 06h    Day of week
                 07h    Day of month
                 08h    Month
                 09h    Year
                 0Ah    Status register A
                 0Bh    Status register B
                 0Ch    Status register C
                 0Dh    Status register D
                 0Eh    Diagnostic Byte
                 OFh    Shutdown status byte
                 10h    Diskette drive type byte - disk A and B
                 11h    Reserved
                 12h    Fixed disk type byte - disk C and D
                 13h    Reserved
                 14h    Equipment Byte
                 15h    Low base memory byte
                 16h    High base memory byte
                 17h    Low expansion memory byte
                 18h    High expansion memory byte

                                 - Page 232 -
Norton Guide: `FAST.lib 3.50  Reference'


                 19-2Dh Reserved
                 2Eh    Checksum byte 1
                 2Fh    Checksum byte 2
                 30h    Low expansion memory byte
                 31h    High expansion memory byte
                 32h    Date century byte
                 33h    Flags Information byte
                 34-3Fh Reserved

    Return:

         A numeric value with the CMOS position.

    Example:

         ? cmosGet( 6 )           // returns the day of the week

See Also: "cmosSet()" 


    cmosSet()

         Sets a CMOS position

    Syntax:

         cmosSet( nAddress, nValue ) -> NIL

         nAddress : The relative address of CMOS. The address table is given
                    below.
         nValue   : The new value for the indicated position of CMOS

    Description:

         DANGER!!
         This function allows low level access to system. It MUST be used
         with extreme care and requires a thorough knowledge of computer
         Architecture.

         Initialize the value of a cell of the CMOS memory. It can be very
         useful to quickly modify the system's setup. Remember that the
         input and output parameters must be specified in decimal, even though
         the table below is given in hexadecimal.

                 00h    Seconds
                 01h    Alarm seconds
                 02h    Minutes
                 03h    Alarm minutes
                 04h    Hours
                 05h    Alarm Hours
                 06h    Day of week
                 07h    Day of month
                 08h    Month
                 09h    Year
                 0Ah    Status register A

                                 - Page 233 -
Norton Guide: `FAST.lib 3.50  Reference'


                 0Bh    Status register B
                 0Ch    Status register C
                 0Dh    Status register D
                 0Eh    Diagnostic Byte
                 OFh    Shutdown status byte
                 10h    Diskette drive type byte - disk A and B
                 11h    Reserved
                 12h    Fixed disk type byte - disk C and D
                 13h    Reserved
                 14h    Equipment Byte
                 15h    Low base memory byte
                 16h    High base memory byte
                 17h    Low expansion memory byte
                 18h    High expansion memory byte
                 19-2Dh Reserved
                 2Eh    Checksum byte 1
                 2Fh    Checksum byte 2
                 30h    Low expansion memory byte
                 31h    High expansion memory byte
                 32h    Date century byte
                 33h    Flags Information byte
                 34-3Fh Reserved

    Return:

         Nothing.

    Example:

         ? cmosSet( 0, 30 )         // Put the system seconds to 30

See Also: "cmosGet()" 


    CpuType()

         Returns the processor type

    Syntax:

         CpuType() -> nProcessor

    Description:

         Returns the kind of CPU that the system has, following a process
         published directly by Intel. The compatibility of this function
         with processors not from Intel cannot be guaranteed.

    Return:

         Returns a numeric value indicanting:

              0 - 8088
              1 - 8086
              2 - 80286

                                 - Page 234 -
Norton Guide: `FAST.lib 3.50  Reference'


              3 - 80386
              4 - 80486
              5 - Pentium
              6 - 6tium when available
              7 - 7tium when available
              8 - 8tium when available
              9 - 9tium when available
             10 - NEC V20
             11 - NEC V30
             12 - 80188
             13 - 80186

    Example:

         If CpuType () == 5
           ? "Ohh, a pentium"
         EndIf


    Delay()

         Delays a specified number of milliseconds

    Syntax:

         Delay( nMilSeconds ) -> NIL

         nMilSeconds : Number of milliseconds to delay.

    Description:

         Waits for nMilSeconds. This function doesn't attend to the keyboard
         and only finishes when the time is completed.

         The precision is to the millisecond, is that to say, 0.001.

    Return:

         Nothing.

    Example:

         Delay ( 0.5 )          // Delay 0.5 seconds


    Deencrypt()

         Decrypts a string

    Syntax:

         Deencrypt( cString, cPassword ) -> cNewString

         cString   : The string to decrypt
         cPassword : The string used to decrypt

                                 - Page 235 -
Norton Guide: `FAST.lib 3.50  Reference'



    Description:

         Decrypts an string with a secret method.

    Return:

         A decrypt character value.

    Example:

         cValue := Deencrypt ( "Hello world", "This is my password" )

See Also: "Encrypt()" "GetPass()" 


    DOSShell()

         Starts a new command processor

    Syntax:

         DOSShell() -> NIL

    Return:

         Nothing.

    Example:

         ? "Type EXIT to return"
         DOSShell ()


    DPMIVersion()

         Returns the DPMI host version

    Syntax:

         DPMIVersion() -> cVersion

    Description:

         Returns DPMI host version or an empty string if a DPMI host is not
         running.

    Return:

         A character value with the DPMI host version or an empty string if
         a DPMI host is not running.

    Example:

         If IsDPMI()

                                 - Page 236 -
Norton Guide: `FAST.lib 3.50  Reference'


           Warning( "DPMI host Version: " + DPMIVersion() )
         EndIf

See Also: "IsDPMI()" 


    Encrypt()

         Encrypts a string

    Syntax:

         Encrypt( cString, cPassword ) -> cNewString

         cString   : The string to encrypt
         cPassword : The string used to encrypt

    Description:

         Encrypts a string with a secret method.

    Return:

         A encrypt character value.

    Example:

         cValue := Encrypt( "The beach is empty now", "This is my password" )

See Also: "Deencrypt()" "GetPass()" 


    FastRight()

         Returns the Fast Library Copyright

    Syntax:

         FastRight() -> cCopyright

    Description:

         Returns the Fast Library Copyright as a character value.

    Return:

         A character value with Fast Library Copyright.

    Example:

         FastRight()       //  "(C) 1993 Manu Roibal"

See Also: "FastVersion()" 



                                 - Page 237 -
Norton Guide: `FAST.lib 3.50  Reference'


    FastVersion()

         Returns the Fast Library Version

    Syntax:

         FastVersion() -> cVersion

    Description:

         Returns the Fast Library Version as a character value.

    Return:

         A character value with the Fast Library Version.

    Example:

         FastVersion()   //  "Fast Library For Clipper V. 3.11"

See Also: "FastRight()" 


    GetEnviron()

         Gets the system environment

    Syntax:

         GetEnviron() -> aEnviron

    Description:

         Returns the system environment, PATH, SET's...

    Return:

         An array value with the system environment.

    Example:

         aArray := GetEnviron()
         For nInd := 1 To Len( aArray )     // COMSPEC=C:\DOS\COMMAND.COM
           ? aArray[ nInd ]                 // PATH=C:\DOS;D:\CLIPPER5\BIN
         Next                               // PROMPT=$P$G
                                            // ...


    GetPass()

         Gets a password

    Syntax:

         GetPass( nRow, nCol, cMessage, nLen ) -> cPass

                                 - Page 238 -
Norton Guide: `FAST.lib 3.50  Reference'



         nRow     : The line where the password is asked
         nCol     : The column where the password is asked
         cMessage : The message to put just before the petition
         nLen     : Max number of characters of the password

    Description:

         Ask for a password of nLen max characters at the specified
         position

    Return:

         The password (with fingers drumming) or "" if exit with Esc.

    Example:

         cPass := GetPass ( 12, 20, "Input password", 15 )

See Also: "Encrypt()" "Deencrypt()" 


    iDisable()

         Inhibits the maskable interrupts

    Syntax:

         iDisable() -> NIL

    Description:

         Inhibits the maskable interrupts and causes the Clipper VMM
         system to not use the "dead times" to continue it's work.

         This very useful when the response time of a process is crucial
         and we do not want the VMM to use the false dead times.

         Remember that any interrupt can not be used if you do not call the
         function iEnable().

    Return:

         Nothing.

    Example:

         iDisable()
         For nInd := 1 To 100
           NullFunc()               // in this process the VMM is stoped
         Next
         iEnable()

See Also: "iEnable()" 


                                 - Page 239 -
Norton Guide: `FAST.lib 3.50  Reference'



    iEnable()

         Allows the maskable interrupts

    Syntax:

         iEnable() -> NIL

    Description:

         Allows the maskable interrupts. It does not have effect if the
         maskable interrupts are not in effect.

         Must be called after a iDisable() when you want to allow the
         Clipper VMM system to continue.

    Return:

         Nothing.

    Example:

         iDisable()
         For nInd := 1 To 100
           NullFunc()               // in this process the VMM is stoped
         Next
         iEnable()

See Also: "iDisable()" 


    Inb()

         Reads a byte from a hardware port

    Syntax:

         Inb( nPort ) -> nValue

         nPort : System port

    Description:

         DANGER!!
         This function allows low level access to system. It should be used
         with extreme care and requires a through knowledge of computer
         Architecture.

    Return:

         A numeric value received from port.

    Example:


                                 - Page 240 -
Norton Guide: `FAST.lib 3.50  Reference'


         nValue := Inb ( 255 )  // I pick up the value of the FF port

See Also: "Inw()" "Outb()" "Outw()" 


    IniLoad()

         Loads a configuration file .INI

    Syntax:

         IniLoad( cFile, cAppl ) -> aIniFile

         cFile : File to load
         cAppl : Application name

    Description:

         Reads the file and loads the setup information.
         It's the first operation to be used with all .ini functions.

    Return:

         Returns an array with the information in the .INI file.

    Example:

         aIniFile := IniLoad( "Fast.Ini", "MARKET" )

See Also: "IniSearch()" "IniWrite()" "IniSave()" 


    IniSearch()

         Searches for an item in a configuration file .INI

    Syntax:

         IniSearch( aIniFile, cItem, cDefault ) -> cValue

         aIniFile : An array with the information in the .INI file
         cItem    : Item to search
         cDefault : Default value if item is not found

    Description:

         Returns the item's value in the setup file or the cDefault
         value if cItem isn't found.

         cItem must be in Uppercase.

    Return:

         The value of cItem or the default value.


                                 - Page 241 -
Norton Guide: `FAST.lib 3.50  Reference'


    Example:

         cValue := IniSearch ( aIniFile, "CPUTYPE", "386sx" )

See Also: "IniWrite()" "IniSave()" "IniLoad()" 


    IniSave()

         Saves an item in a configuration file .INI

    Syntax:

         IniSave( aIniFile, cItem, cValue ) -> NIL

         aIniFile : An array with the information in the .INI file
         cItem    : Item to modify
         cValue   : New value

    Description:

         Saves the value of an item in the setup but doesn't dump
         to disk until you make a call to IniWrite().

    Return:

         Nothing.

    Example:

         IniSave( aIniFile, "CPUTYPE", "386 DX2 25 Mhz" )

See Also: "IniSearch()" "IniWrite()" "IniLoad()" 


    IniWrite()

         Writes to disk a configuration file .INI

    Syntax:

         IniWrite( aIniFile, cFile, cAppl ) -> NIL

         aIniFile : An array with the information in the .INI file
         cFile    : File to create
         cAppl    : Application name

    Description:

         Creates a file with the existing setup information. The name
         of the application will be placed on the first line of the
         file if this is necessary.

    Return:


                                 - Page 242 -
Norton Guide: `FAST.lib 3.50  Reference'


         Nothing.

    Example:

         IniWrite ( aIniFile, "Fast.Ini", "MARKET" )

See Also: "IniSearch()" "IniSave()" "IniLoad()" 


    Inw()

         Reads a word from a hardware port

    Syntax:

         Inb( nPort ) -> nValue

         nPort : System port

    Description:

         DANGER!!
         This function allows low level access to system. It should be used
         with extreme care and requires a through knowledge of computer
         Architecture.

    Return:

         A numeric value received from port.

    Example:

         nValue := Inb ( 255 )  // Choose a value from the port FF

See Also: "Inb()" "Outb()" "Outw()" 


    IsAnsi()

         Determines if Ansi.sys has been loaded

    Syntax:

         IsAnsi() -> lLoaded

    Description:

         Determines if Ansi.sys has been loaded.

    Return:

         A logic value indicating if has been loaded.

    Example:


                                 - Page 243 -
Norton Guide: `FAST.lib 3.50  Reference'


         If IsAnsi()
           Warning( "Ansi.sys has been loaded" )
         EndIf

See Also: "IsKeyb()" "IsNlsFunc()" "IsShare()" 


    IsCopro()

         Determines if a math coprocessor is present

    Syntax:

         IsCopro() -> lExist

    Description:

         Determines if system has a numeric coprocessor or emulator.

    Return:

         A logic value indicating if a math coprocessor is present.

    Example:

         If IsCopro()
           Warning( "You have a math coprocessor" )
         EndIf

See Also: "IsModem()" 


    IsDPMI()

         Determines if a DPMI host is present

    Syntax:

         IsDPMI() -> lLoaded

    Description:

         Determines if a DOS Protected Mode Interface (DPMI) host is present.

    Return:

         A logic value indicating if a DPMI host is present.

    Example:

         If IsDPMI()
           Warning( "You are running in PM or V86" )
         EndIf

See Also: "DPMIVersion()" 

                                 - Page 244 -
Norton Guide: `FAST.lib 3.50  Reference'




    IsKeyb()

         Determines if Keyb has been loaded

    Syntax:

         IsKeyb() -> lLoaded

    Description:

         Determines if KEYB.SYS has been loaded.

    Return:

         A logic value indicating if has been loaded.

    Example:

         If IsKeyb()
           Warning( "Keyb.sys has been loaded" )
         EndIf

See Also: "IsAnsi()" "IsNlsFunc()" "IsShare()" 


    IsModem()

         Determines if an internal modem is present

    Syntax:

         IsModem() -> lExist

    Description:

         Determines if system has an internal modem.

    Return:

         A logic value indicating if an internal modem is present.

    Example:

         If IsModem()
           Warning ( "You have a internal modem" )
         EndIf

See Also: "IsCopro()" 


    IsMSDOS()

         Determines if Operation System is MSDOS or DRDOS

                                 - Page 245 -
Norton Guide: `FAST.lib 3.50  Reference'



    Syntax:

         IsMSDOS() -> lIsMSDOS

    Description:

         Determines if Operation System (OS) is a Microsoft DOS (MSDOS) or
         a Digital Research DOS (DRDOS).

    Return:

         .F. for DRDOS and .T. for MSDOS (or another one).

    Example:

         If IsMSDOS()
           Warning ( "Very good Bill G..." )
         EndIf

See Also: "IsQEMM()" 


    IsNlsFunc()

         Determines if NlsFunc has been loaded

    Syntax:

         IsNlsFunc() -> lLoaded

    Description:

         Determines if NlsFunc has been loaded.

    Return:

         A logic value indicating if NlsFunc has been loaded.

    Example:

         If IsNlsFunc()
           Warning ( "NlsFunc has been loaded" )
         EndIf

See Also: "IsAnsi()" "IsKeyb()" "IsShare()" 


    IsQEMM()

         Determines if QEMM386.SYS or QRAM.SYS has been loaded

    Syntax:

         IsQEMM() -> lLoaded

                                 - Page 246 -
Norton Guide: `FAST.lib 3.50  Reference'



    Description:

         Determines if QEMM386.SYS or QRAM.SYS has been loaded.

    Return:

         A logic value indicating if QEMM386.SYS or QRAM.SYS has been loaded.

    Example:

         If IsQEMM()
           Warning ( "QEMM386 has been loaded" )
         EndIf

See Also: "IsXMS()" 


    IsShare()

         Determines if Share has been loaded

    Syntax:

         IsShare() -> lLoaded

    Description:

         Determines if Share has been loaded.

    Return:

         A logic value indicating if SHARE.EXE has been loaded.

    Example:

         If IsShare()
           Warning ( "Share has been loaded" )
         EndIf

See Also: "IsAnsi()" "IsKeyb()" "IsNlsFunc()" 


    IsXMS()

         Determines if a XMS driver has been loaded

    Syntax:

         IsXMS() -> lLoaded

    Description:

         Determines if a XMS driver has been loaded.


                                 - Page 247 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         A logic value indicating if a XMS driver has been loaded.

    Example:

         If IsXMS()
           Warning ( "XMS driver is present" )
         EndIf

See Also: "IsQEMM()" 


    nArgC()

         Returns the number of command line parameters

    Syntax:

         nArgC() -> nNumber

    Description:

         Returns the number of parameters passed to the application adding
         one (the name of the program that is running is also included as a
         parameter). The exact syntax of the functions cArgV and cArgC are the
         same.

    Return:

         The number of parameters plus one for the name of the running
         application.

    Example:

         For nInd := 0 To nArgC() - 1
           ? cArgV( nInd )
         Next

See Also: "cArgV()" 


    NullFunc()

         A Function that does nothing

    Syntax:

         NullFunc() -> NIL

    Description:

         This doesn't do anything.  This can be useful in some cases where
         it's necessary to put a function in some codeblocks.


                                 - Page 248 -
Norton Guide: `FAST.lib 3.50  Reference'


    Return:

         Nothing.

    Example:

         aEval ( aArray, { || NullFunc () } )


    NumParalel()

         Returns the number of parallel ports

    Syntax:

         NumParalel() -> nPorts

    Description:

         Returns the number of parallel ports on system.

    Return:

         A numeric value with the number of parallel ports.

    Example:

         Warning( "You have " + Str ( NumParalel() ) + " parallel ports" )

See Also: "NumSerial()" 


    NumSerial()

         Returns the number of serial ports

    Syntax:

         NumSerial() -> nPorts

    Description:

         Returns the number of serial ports on system.

    Return:

         A numeric value with the number of serial ports.

    Example:

         Warning( "You have " + Str ( NumSerial() ) + " serial ports" )

See Also: "NumParalel()" 



                                 - Page 249 -
Norton Guide: `FAST.lib 3.50  Reference'


    DoIdle()

         Configs the internal screensaver of FAST.lib

    Syntax:

         DoIdle( bBlock, nSeconds ) -> NIL

         bBlock   : Will be evaluated by the internal engine
         nSeconds : The time to wait before to pass to idle mode

    Description:

         This function configs the internal screensaver system of FAST.lib.

    Return:

         Nothing.

    Example:

         // This's the old internal screensaver of FAST.lib.

         FUNCTION MAIN()
              DoIdle( { || Example() }, 60 )       // 60 seconds
         RETURN NIL

         FUNCTION Example()
            IF VideoMode() == 3           // we're in text mode
              ScreenSave()
            ENDIF
         RETURN NIL

See Also: "DoInterval()" 


    DoInterval()

         Calls to a function every given time

    Syntax:

         DoInterval( bBlock, nTime ) -> NIL

         bBlock : The codeblock that will be evaluated
         nTime  : The time interval in seconds

    Description:

         Evaluates a codeblock every given time. The minimun time is 1
         second.

    Return:

         Nothing.

                                 - Page 250 -
Norton Guide: `FAST.lib 3.50  Reference'



    Example:

         FUNCTION MAIN()
              DoInterval( { || Example() }, 1 )
         RETURN NIL

         FUNCTION Example()
            @ 0, 70 SAY Time() COLOR "GR+/B"
         RETURN NIL

See Also: "DoIdle()" 


    Outb()

         Outputs a byte to a hardware port

    Syntax:

         Outb( nPort, nValue ) -> NIL

         nPort  : System port
         nValue : Byte to send

    Description:

         DANGER!!
         This function allows low level access to system. It should be used
         with extreme care and requires a thorough knowledge of computer
         Architecture.

    Return:

         Nothing.

    Example:

         Outb ( 255, 3 )

See Also: "Inw()" "Inw()" "Outw()" 


    Outw()

         Outputs a word to a hardware port

    Syntax:

         Outw( nPort, nValue ) -> NIL

         nPort  : System port
         nValue : Word to send

    Description:

                                 - Page 251 -
Norton Guide: `FAST.lib 3.50  Reference'



         DANGER!!
         This function allows low level access to system. It should be used
         with extreme care and requires a thorough knowledge of computer
         Architecture.

    Return:

         Nothing.

    Example:

         Outw ( 255, 32921 )

See Also: "Inw()" "Inw()" "Outb()" 


    Peekb()

         Returns the byte at a memory location

    Syntax:

         Peekb( nSegment, nOffset ) -> nByte

         nSegment : Memory Segment
         nOffset  : Memory Offset

    Description:

         DANGER!!
         This function allows low level access to system. It should be used
         with extreme care and requires a thorough knowledge of computer
         Architecture.

    Return:

         The value of the byte received from the indicated position.

    Example:

         Peekb ( 64, 0 )                // Returns a byte at 0040:0000h

See Also: "Peekw()" "Pokeb()" "Pokew()" 


    Peekw()

         Returns a word at a memory location

    Syntax:

         Peekw( nSegment, nOffset ) -> nWord

         nSegment : Memory Segment

                                 - Page 252 -
Norton Guide: `FAST.lib 3.50  Reference'


         nOffset  : Memory Offset

    Description:

         DANGER!!
         This function allows low level access to system. It should be used
         with extreme care and requires a thorough knowledge of computer
         Architecture.

    Return:

         The value of a word received from the indicated position.

    Example:

         Peekw ( 64, 0 )        // Return the word at 0040:0000h

See Also: "Peekb()" "Pokeb()" "Pokew()" 


    Pokeb()

         Stores a byte at a memory position

    Syntax:

         Pokeb( nSegment, nOffset, nByte ) -> NIL

         nSegment : Memory Segment
         nOffset  : Memory Offset
         nByte    : Byte to store

    Description:

         DANGER!!
         This function allows low level access to system. It should be used
         with extreme care and requires a thorough knowledge of computer
         Architecture.

    Return:

         Nothing.

    Example:

         Pokeb ( 64, 0, 16 )                    // 0040:0000h = 0Fh

See Also: "Peekb()" "Peekw()" "Pokew()" 


    Pokew()

         Stores a word at a memory position

    Syntax:

                                 - Page 253 -
Norton Guide: `FAST.lib 3.50  Reference'



         Pokew( nSegment, nOffset, nWord ) -> NIL

         nSegment : Memory Segment
         nOffset  : Memory Offset
         nWord    : Word to store

    Description:

         DANGER!!
         This function allows low level access to system. It should be used
         with extreme care and requires a thorough knowledge of computer
         Architecture.

    Return:

         Nothing.

    Example:

         Pokew ( 64, 0, 65535 )         //  0040:0000h = FFFFh

See Also: "Peekb()" "Peekw()" "Pokeb()" 


    Reboot()

         Reboot the system

    Syntax:

         Reboot() -> NIL

    Description:

         Reboot the system like Ctrl-Alt-Del, is that to say, it initiates
         a warm boot, not checking memory.

    Return:

         Nothing.

    Example:

         Reboot()


    RestSets()

         Restores Clipper SETS from an array

    Syntax:

         RestSets( aArray ) -> NIL


                                 - Page 254 -
Norton Guide: `FAST.lib 3.50  Reference'


         aArray : An array with saved SETS

    Description:

         Restores Clipper SETS from an array with the saved SETS.

    Return:

         Nothing.

    Example:

         RestSets( aArray )

See Also: "SaveSets()" 


    SaveSets()

         Saves Clipper SETS to an array

    Syntax:

         SaveSets() -> aArray

    Description:

         Saves Clipper SETS to an array.

    Return:

         An array with Clipper SETS.

    Example:

         Local aArray := SaveSets()

See Also: "RestSets()" 


    SetDate()

         Changes the system date

    Syntax:

         SetDate( dNewDate ) -> lError

         dNewDate : A Clipper date value with the new date

    Description:

         Changes the system date with a specified date.

         The opposite operation, is that to say, taking the system date could

                                 - Page 255 -
Norton Guide: `FAST.lib 3.50  Reference'


         be made with the standard function date().

    Return:

         Returns .T. if the date is valid and .F. if it isn't.

    Example:

         If ! SetDate ( CtoD ( "99/99/99" ) )
           Warning ( "Incorrect date" )
         EndIf

See Also: "SetTime()" 


    SetTime()

         Changes time system time

    Syntax:

         SetTime( cNewTime ) -> lError

         cNewTime : A string with the new time

    Description:

         Changes the system time with a specified time in this format:
         HH:MM:SS.

         The opposite operation, is that to say, taking the hour
         of the system could be made with the standard function time().

    Return:

         Returns .T. if the hour is valid and .F. if it isn't.

    Example:

         SetTime ( "17:05:43" )
         If ! SetTime ( "78:99:90" )
           Warning ( "Incorrect time" )
         EndIf

See Also: "SetDate()" 


    SetVerify()

         Changes/Determines the DOS verify flag

    Syntax:

         SetVerify( [lNewValue] ) -> lOldValue


                                 - Page 256 -
Norton Guide: `FAST.lib 3.50  Reference'


         lNewValue : A optional logical value indicating the new value of
                     the DOS verify flag

    Description:

         Changes and determines the value of the internal DOS verify flag.

    Return:

         Returns .T. if verify flag is ON .F. if it isn't.

    Example:

         BoxWarning ( "Verify flag is " + If( SetVerify(), "Yes", "No" ) )


    SystemIdle()

         Gives time to other programs when the program is idling

    Syntax:

         SystemIdle( [lMode] ) -> lOldMode

         lMode : .T. to install the system and .F. to deinstall.

    Description:

         SystemIdle() gives time generating int28h ints to a multitasker such
         as Windows, Windows/NT DosShell, OS/2 or other int28h idle system
         when application is idling.

    Return:

         The actual mode.

    Example:

         SystemIdle( .T. )
















                                 - Page 257 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu Choice: Credits, Copyright


    Copyright

         Ŀ
                                                                  
                       Fast Library For Clipper 3.50              
                                                                  
                          (C) 1992-95 Manu Roibal                 
                                                                  
           Cool Tool Of The Month, April 1994. REFERENCE CLIPPER  
                                                                  
         


    All code included in Fast Library For Clipper, the documentation,
 example programs and this Norton Guide are the property of Manu Roibal.

    It is fully prohibited to sell or distribute by either person,
 corporation or other entity without the express permission of the author.
 It is also fully prohibited to use Fast Library For Clipper for building
 Commercial or Non-commercial Applications with an unregistered copy.


    FAST.lib, (C) 1992-95 Manu Roibal, FAST.Software
    FastWare solutions.

    All trademarks and registered trademarks referenced in this file are the
 property of their respective owners.

See Also: "Technical Notes" "Thanks!" 























                                 - Page 258 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu Choice: Credits, Thanks!


    Thanks

   Too many people have collaborated directly or indirectly to create this
 library. Trying not forgetting anyone (sorry!) I would like to thank them
 for their unlimited patience.

       - Miren Itxaso Pea de Bracamonte

         She made up the name of this library, and thanks to her the code
         of Fast Library was completed when Murphy's laws started it's
         effects.

       - Oscar Fernndez, Serpent BBS

         Because they believed in me when I suggested creating File and
         Message areas used exclusively for Fast in Serpent BBS. Due to
         it, communications between author and beta testers has been fluent
         and funny.

       - Jose Miguel Rodrguez. Sysop Virtual Software

         For his support with this new version. Many of Fast functions
         are based on Virtual Software sources/ideas, the paradise of xBase
         programmers.

       - Jose Ramn Vaamonde, Jorge Tom, Jose Manuel Albarrn & Philippe
         Mingo

         They brought many ideas and conceptual solutions for the developing
         of this new version of Fast. Thanks!

       - Aritza Mollar, Oscar Fernndez, Josu Ugalde, Alfonso Belloso and
         Txomin Martinez

         They never thought that translating this document into English
         was going to be as hard as it was.

       - Miren Itxaso Pea, Philippe Mingo, Jorge Tom, Juan Campos,
         Francesc Valverde, Oscar Fernndez, Esteban Roibal, Gorka Genaga &
         Luca Della Sala

         They translated the messages of Fast Library code into some
         other languages. To all, Thanks.

       - Rory Wright and Dan Applewhite

         Made final language checks in the Norton Guides and example program
         files making this library ready for American distribution.

       - Bert Kerkhof

         For your big ideas and your help in the serial comunications world.

                                 - Page 259 -
Norton Guide: `FAST.lib 3.50  Reference'



       - Nacor Manuel Blanco

         For your help with the Huffman compression and decompression
         methods.

See Also: "Technical Notes" "Copyright" 
















































                                 - Page 260 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu Choice: Credits, Technical Notes


    Technical Notes

    Fast Library For Clipper, in older versions, was written in 100%
 CA-Clipper 5.x code. In the current version, a large portion of its code
 is written in C; for example, the mouse, communications, graphics, video,
 Sound Blaster, timer, CMOS, and other functions which either cannot be
 implemented in pure Clipper code or would not be fast enough. The standard
 CA-Clipper libraries do not support interrupts, and several functions
 in Fast Library For Clipper depend on interrupts.

    Fast Library For Clipper does not use either Public or Private
 variables, thus keeping memory overhead for the symbol table to a minimum
 and avoiding accidental assignments to variables internal to the functions.

    The library has been made more granular than in previous versions so
 that calls to Fast Library functions will cause a minimum of library
 code to be linked into your programs.

    Macros are not used in any Fast Library code.

    Fast Library functions which internally call other Fast Library
 functions use code blocks for passing information to one another.
 All arguments used when calling Fast Library functions from the user's
 code consist of numeric, character, logical, and array data types.

    The code used in both the printed documentation examples and the
 Norton Guide examples uses Hungarian notation because of its
 clarity and for consistency with most other CA-Clipper documentation.

See Also: "Copyright" "Thanks!" 






















                                 - Page 261 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu Choice: Credits, About Language Support


  About Language Support

    Fast Library For Clipper supports a wide variety of languages for
 message text such as that used in dialog boxes. English is used by default.
 The desired language may be selected by simply calling one of the functions
 listed below.

 Available language modules are:

    SetAsturian()       SetBasque()        SetCatalan()
    SetEnglish()        SetFinnish()       SetFrench()
    SetGalician()       SetGerman()        SetItalian()
    SetLusitanian()     SetSpanish()       SetSwedish()

 Language modules in progress:

    Lithuanian()



































                                 - Page 262 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu Choice: Credits, About Protected Mode


  About Protected Mode

    Fast Library For Clipper is compatible with all the popular linkers
 currently on the market. Blinker 1.x, Blinker 2.x, Blinker 3.x (real,
 protected, and dual mode), CA-ExoSpace, RTLink x.x , and WarpLink x.x
 are supported.

    Depending on which linker you use, simply link in the appropriate
 library as specified below.

    To link with Blinker 3.x (real, protected, and dual mode) you must
 specify the file apibli.lib in your script file or command line:

    BLINKER FI my_prog LIB Fast, apibli

       or

    BLINKER FI my_prog LIB Fast, apibli SEA blxclp52 BLI EXE EXT


    To link with Blinker 1.x, Blinker 2.x, RTLink x.x, or
 WarpLink x.x you must include the file apistd.lib in your script
 file or command line:

    BLINKER FI my_prog LIB Fast, apistd

       or

    RTLINK FI my_prog LIB Fast, apistd

       or

    WARPLINK FI my_prog LIB Fast, apistd

    To link with CA-ExoSpace you must use a command line (or an
 equivalent script file):

    EXOSPACE FI my_prog LIB Fast EXO PAC int10, Mouse














                                 - Page 263 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu Choice: Credits, New in this version


  New in this version


     From 3.00

         Menuing system has been improved

         VGA Graphic Mode Support rewritten, including the functions
          for pixels, lines, ellipses, circles, graphics, bars charts,
          pies charts, etc.

         Multi-Linker Support (CA-ExoSpace; Blinker 1.x, 2.x, 3.0;
          RTLink x.x; and WarpLink x.x) has been added

         C Optimizing Code Support has been added

         Reboot() function has been changed to support both cold
          and warm-boot

         CpuType() function has been rewritten

         Italian Language Support bugs have been corrected

         New function ChooseColor() has been added

         Bug in function Like() has been corrected

         Bug in function Serpent() has been corrected

         Encrypt() and DeEncrypt() functions have been changed to
          allow multiple encryption with a password

         New functions IsDPMI() and DPMIVersion() have been added

         Corrected a bug in IsWin3()

         New function WinVersion() has been added

         New functions WinOpenClip(), WinCloseClip(), WinSetClip(),
          WinGetClip(), WinClipSize(), and WinDelClip() have been added
          for managing the Windows 3.x Clipboard from Clipper

         New functions DrawBar() and BackGraph() have been added
          from the GraphBar ClipAPI

         Fixed a bug in SetTime() function

         New function IsPirate() has been added to protect Clipper
          programs from unauthorized use.  Programs can be executed only
          on a machine having a specific configuration

         New function SetVerify() has been added

                                 - Page 264 -
Norton Guide: `FAST.lib 3.50  Reference'



         New function SetGray() has been added

         MaxFiles() function name has been changed to FreeHandles()

         New function GetEnviron() has been added

         New function SToD() has been added

         Function rSoftCur() has been changed to simulate a graphical
          mouse pointer in text mode; function rColors() is no longer
          necessary

         More speed to ChooseColor()

         New parameter in BoxQuery() and BoxWarning()


     From 3.11

         Fixed a bug in CD Audio Support running in protected mode

         Some internal functions has been rewriten to run faster


     From 3.12

         Fixed a bug in RestArray() with multidimensional arrays

         Text Editor addapted to MaxRow() & MaxCol() values

         Fixed a bug in IsPrint() when it runs in protected mode

         A new 3D graph gallery
          You can show 3D bar graphs, 3D top/down pyramidal bar graphs,
          3D cylindric bar graphs, 3D line graphs, 3D tart graphs,
          3D ellipse graphs...

         New function Int2Roman() to convert integers to Roman notation

         Fixed a bug in MSCDEXVer()

         Fixed a bug in DiskSerNum() when it runs in protected mode

         New functions ASCIIToEBCDIC() and EBCDICToASCII()

         Fixed a bug in FSearch() function.

         Fixed a little bug in the upper limit of GraphBar() functions
          when the array contains decimal values

         New functions Caos()

         New parameter cColor to Puzzle() function


                                 - Page 265 -
Norton Guide: `FAST.lib 3.50  Reference'


         Fixed a bug in the CD AUDIO initiation code

         Fixed a bug in dToDMY() function

         New function dToMDY()

         Calendar() function addapted to Sunday, Monday, ... when the
          language selected is English

         New functions BigLetter() & BigString()

         New functions SmallLetter() & SmallString()

         Function FastMemo() changed

         New function SetHardCopy()

         NewMenu() function has a new parameter to allow to create menus
          with shadow

         New function InspectDBF()

         New function InspectSETS()

         New function InspectOBJ()

         Fixed a bug in Like() function running in protected mode

         Fixed a bug in pAddFile()


     From 3.15

         New functions fGoTop(), fGoBottom(), fPos(), fEof()

         New function fCopy()

         New functions LowDiskSerial(), LowDiskFirm() & LowDiskModel()
          to identify the serial number, firmware and model of a hard disk

         New function GetBaud()

         CpuType() returns new values to identify 8088, 8086, 80286,
          80386, 80486, Pentium, 6tium-7tium-8tium-9tium when availables,
          NEC V20, NEC V30, 80188 and 80186.

         Functions IsVGA(), IsEGA(), IsCGA() and IsHerc() rewrited

         Fixed a bug in Lusitanian Support

         New function to convert to Lotus WKS format

         New function XCRC16() for XModem & ZModem

         IsSmartDrv() addapted to 4.00+ API

                                 - Page 266 -
Norton Guide: `FAST.lib 3.50  Reference'



         New functions SmartSize(), SmartSizeWin(), SmartReset(),
          SmartFlush(), SmartHits() and SmartMisses() to control SmartDrv
          and PC Cache

         New function VirCheck() to scan 100+ viruses as tequila, Flip,
          Jerusalem family, yankee, blinker, dbase, and more, much more

     From 3.20

         Fixed bugs in German Support

         Fixed bugs in Italian Support

         Fixed bugs in French Support

         Fixed a bug in ZipFile()

         Fixed a problem in VirCheck() with Novell

         New parameters to SetFont() and SetFontChar()

         New function RealStars(), a real star field

         nRandom() rewriten in C

         Calendar() modified

     From 3.21

         Fixed a bug in DispMenu()

         New function compress() to de/compress files via Huffman method

         New function CompNumber() to de/compress Clipper numbers

         New function rVersion() to determine mouse driver version, mouse
          type and the IRQ used

         New function SystemIdle() to control the application idle status

         Fixed the Clipper v5.01 undefined module CLIP501 message

         The code size has been reduced with the new C compiler options
          The code is more stable and compact

         The internal screensaver engine has been rewrited. Now, is posible
          a full configuration of this system via DoIdle() function.
          The screensaver is sensible to the internal Clipper waitstates
          Now, the functions TimeScr() and AplicName() are not used

         New functions DoIdle() and DoInterval()

         Support for get/set the volume information of the Sound Blaster


                                 - Page 267 -
Norton Guide: `FAST.lib 3.50  Reference'


         Function sbCDVol() has been changed by sbCDVolL() and sbCDVolR()

         Function sbRecScr() has been changed by sbRecScrL() and sbRecScrR()

         Degrade() & Upgrade() functions has been rewrited and improved
          and now run fine in all the VGA cards

         KeyStuff() has been rewrited in C

         New parameter in sbVocPlay(), sbWavPlay(), dacVocPlay(),
          dacWavPlay(), spkVocPlay() & spkWavPlay().

         VirCheck() now returns an array with logical values










































                                 - Page 268 -
Norton Guide: `FAST.lib 3.50  Reference'


Menu Choice: Credits, FAST.* Distributors




     FAST.* DISTRIBUTORS


      Exclusive distributor North, South & Central America 

     ZAC Catalog - Clipper only tools
     106 Access Road
     Norwood, MA 02062
     USA
     Phone 1-800-254-7737  Sales
     Phone 1-617-551-0860  Sales
     FAX   1-617-551-0857  Sales FAX
     FAX   1-717-551-0947  Technical Support FAX


      Finland 

     ATK-Antti Oy
     Lars J W Holm
     Pohjoistullikatu 12
     23500 Nystad
     FINLAND
     Phone +358 22 8415066
     FAX   +358 22 8415067
     BBS   +358 22 8418882


      Nederland 

     Micro Consult Nederland
     Miguel Oliveira
     Rhijngeesterstraalweg 78
     2343 BX Oegstgeest
     NEDERLAND
     Phone +31 71 170401
     FAX   +31 71 156154
     BBS   +31 71 157618


      Italy 

     Momos S.A.S.
     Patrizia Scharrer
     Via Palade 5
     39011 Lana (BZ)
     ITALY
     FAX   +39 473 560979


      Belgium 

                                 - Page 269 -
Norton Guide: `FAST.lib 3.50  Reference'



     BUG, Belgian Clipper User Group
     Luc Charels
     Moerkerkse Steenweg 322
     B-8310 Brugge 3
     BELGIUM
     Phone +32 5035 7866
     FAX   +32 5037 2505


      France 

     DH Conseil
     Hubert DAUL Conseil
     14, Rue des Cits Dolfus - BP 71
     70400 Hericourt
     FRANCE
     Phone +33 84 46 37 76
     FAX   +33 84 46 18 02


      Espaa 

     FAST.Software
     Manu Roibal
     Sagastagoitia 13 2 B izda
     Barakaldo 48903 Bizkaia
     SPAIN
     Phone +34 4 4992660
     FAX   +34 4 4605666
     BBS   +34 4 4605666
























                                 - Page 270 -
Norton Guide: `FAST.lib 3.50  Reference'



                                I N D E X
                                ---------



FAST.lib 1
    Data Types  ...................................................    2
    Dbf/Memo  .....................................................   51
    Disk and File  ................................................   53
    Games  ........................................................   81
    Graphics  .....................................................   87
    Keyboard  .....................................................  125
    LAN and Multitaskers  .........................................  133
    MetaFunctions  ................................................  143


FAST.lib 2
    Menus  ........................................................  162
    Mouse  ........................................................  169
    Printer  ......................................................  179
    Screen  .......................................................  185
    Serial Comunications  .........................................  202
    CD-Audio SB DAC Speaker  ......................................  214
    System  .......................................................  230


Credits
    Copyright  ....................................................  258
    Thanks!  ......................................................  259
    Technical Notes  ..............................................  261
    About Language Support  .......................................  262
    About Protected Mode  .........................................  263
    New in this version  ..........................................  264
    FAST.* Distributors  ..........................................  269




















                                 - Page 271 -
