

*************************************************************************

** FUNCTION LOGICAL YES_NO

** Draws attractive shadow box on the screen centered at line 11 (unless you pass in a
** lineno for the ttt variable (top row), asks a question and prompts for
** a Yes or No  sort of response from the operator. You can pass yr own prompts
** rather than Yes and No, such as "<C>ertainly" and "<G>et stuffed!"
** The author is .not. responsible for any insulting prompts that may be used,
** such as "<Y>es" and "<N>o, I'm too stupid to handle this"
**
** Box is automatically centered horizontally
**
** The first msg is the question that is asked, the second and third are the
** y_msg and n_msg prompts respectively.
** Params byte __new_std and __new_enhcd are the colors used in drawing the
** msg boxes (original values are saved to __old_std and __old_enhcd for
** restoration on exit, so be sure to declare them at some previous point
** (Assuming you have intensity on and can display intense bgrounds, 096+128
** (black on bright yellow bground box) looks pretty good)
**
** With regard to the entry choices, the func looks for upper or lower case
** values of the SECOND repeat SECOND CHARACTER of the y_msg and n_msg;  what
** this means is that you must enter those messages as "<Y>es" rather than "Yes"
** for instance.
**
** The func will loop around until a valid choice is pressed, except that <Esc
** is interpreted as identical to a No or negative response.
**
** Param ttt is the top line for drawing the box and the WRONG! message
** If this is passed as 0 rather than a number, the box defaults to top=11
**
** Since func is a logical, usage might look something like this:
** if yes_no("Want to reindex databases?","<R>eindex","<N>ah, forget it",096+128,031,16)
**
*********************************************************************************************
**  declare external variables and functions

VARDEF     EXTERN
    BYTE     __color_enhcd      && (112) This is the attribute of the inverse
				&&   video (used in GETS, etc..).



   BYTE     __color_std        && (7) This is the attribute used
	                     	&&   when writing to the screen via the ?,
				&&   ACCEPT, INPUT or WAIT commands.
                                &&   (see the IBM technical reference)
ENDDEF


FUNCTION INT MAX prototype
Parameters value int a, value int b

PROCEDURE cursor_on PROTOTYPE
PROCEDURE cursor_off PROTOTYPE
PROCEDURE restorescrn PROTOTYPE
    PARAMETERS VALUE INT saved_scrn
FUNCTION UINT len PROTOTYPE
    PARAMETERS CONST CHAR source_string
FUNCTION CHAR replicate PROTOTYPE
    PARAMETERS CONST CHAR c_expression, VALUE UINT repeat_count
FUNCTION UINT savescrn PROTOTYPE
    PARAMETERS VALUE UINT ur, VALUE UINT uc, VALUE UINT lr, VALUE UINT lc
FUNCTION UINT WAITON PROTOTYPE
    parameters  value char msg, value byte __new_std ,value byte __new_enhcd,  VALUE int tt, value byte mshad, uint xxuint
FUNCTION UINT WAITOFF PROTOTYPE
    parameters uint xxuint
FUNCTION UINT asc PROTOTYPE
    PARAMETERS CONST CHAR string
FUNCTION INT delay PROTOTYPE
    PARAMETERS VALUE INT seconds
FUNCTION CHAR substr PROTOTYPE
    PARAMETERS CONST CHAR source_string, VALUE UINT start_position,;
    VALUE UINT length
FUNCTION CHAR upper PROTOTYPE
    PARAMETERS CONST CHAR source_string
function uint GET_KEY prototype
FUNCTION CHAR lower PROTOTYPE
    PARAMETERS CONST CHAR source_string

**********************************************************************
**  OK here's the function  yes_no() itself

FUNCTION LOGICAL YES_NO
parameters   value char msg,  value char y_msg,  value char n_msg, value byte __new_std ,  ;
            value byte __new_enhcd, value  int ttt


VARDEF
        BYTE    __old_std
        BYTE    __old_enhcd
        CHAR     promptmsg
        CHAR    firstylet
        CHAR    firstnlet
        LOGICAL exitloop
        INT     lll
        INT     bbb
        INT     rrr
        INT     kkk
        UINT    y_n_area
        UINT    wrong
        UINT    keychoice
        INT     i
ENDDEF

exitloop = .F.
DO WHILE EXITLOOP = .F.

promptmsg = (y_msg) + "     " + (n_msg)

kkk = 40-max((len( msg ) / 2), len(promptmsg)/2)

firstylet = substr(y_msg,2,1)
firstnlet = substr(n_msg,2,1)



if ttt=0
      ttt=11
endif
        lll=(kkk-2)
        bbb=(ttt+3)
        rrr=(kkk+max(len(msg),len(promptmsg))+2)


__old_std = __color_std
__color_std = __new_std
__old_enhcd = __color_enhcd
__color_enhcd = __new_enhcd
Cursor_off
y_n_area = savescrn( ttt-1, lll-1,bbb+2, rrr+2 )
__color_std = 0
for i = (ttt+1) to (bbb+1)
@ i, (lll+2) say replicate(" ",((rrr+2)-(lll+2)))
next
__color_std = __new_std
@ ttt+1,lll+1 clear to (ttt+2),rrr-1
@ ttt, lll to (ttt+3), rrr double
@ (ttt+1), (40-(len( msg ) / 2))  say msg
@ (ttt+2), (40-(len(promptmsg)/2)) say  promptmsg

keychoice =   get_key()
__color_std = __old_std
__color_enhcd = __old_enhcd

do case
case  (keychoice = asc(upper(firstylet))  .or. keychoice = asc(lower(firstylet)))
exitloop = .T.
waitoff(y_n_area)
return .T.


case  (keychoice = asc(upper(firstnlet))  .or. keychoice = asc(lower(firstnlet)))
exitloop = .T.
waitoff(y_n_area)
return .F.

case keychoice = 27
exitloop = .T.
waitoff(y_n_area)
return .F.

otherwise
waitoff(y_n_area)
wrong= waiton("WRONG!  Press the first letter of either choice",096+128,096+128,ttt,4,wrong)
delay(4)
waitoff(wrong)


exitloop = .F.
endcase
loop
enddo
cursor_on
ttt=0                             &&reset tlbr to 0 for next waiton() use
lll=0
bbb=0
rrr=0

endpro



***************************************************************************
**  Returns the maximum when two int numeric items (a & b) are compared

FUNCTION INT MAX

Parameters value int a, value int b
if a > b
return a
else
return b
endif
endpro

