;----------------------------------------------------------------------
; JUMP-command for FCO
; (C) Copyright KRS Unternehmensberatung-EDV GmbH
;               Postfach 1265
;               D 5093 Burscheid
; Autor:        Wolfgang Manousek
;               CIS 100010,2071
; Editor:       KRS ETP, Vers. 2.1
; Assembler:    MASM 5.1
;               tab 5,9
; Environment:  FCO 2.1 e
;
;----------------------------------------------------------------------
;
; Revision:     1.0     April 1991         Wolfgang Manousek
;                       Initial release
;----------------------------------------------------------------------


SAVEENV STRUC
    rIP dw  ?
    rCS dw  ?
    rBP dw  ?
    rSP dw  ?
    rSS dw  ?
    rSI dw  ?
    rDI dw  ?
    rES dw  ?
    rDS dw  ?
SAVEENV ENDS



        .model large, c
        .code

        public DefineJump
        public DoJump


DefineJump:              ;;Comment:    proc, wOffset:word, wSegment:word
    ; Define the place to return if we call a DoJump
    ; Try to save the force-environment in a buffer.
    ; The buffer-adress is passed to this function as a parameter.

        mov AX,BP                   ; Save BP ...
        mov DX,SP                   ; ... SP

        push BP                     ; my environment ...
        mov BP,SP

        mov cx, es                  ; Old ES in BX
        mov es, [bp+8]              ; ES:BX points now to SaveEnvBuffer ...
        mov bx, [bp+6]              ;

        mov ES:[BX].rSP,DX          ; old SP
        mov ES:[BX].rBP,AX          ; old BP
        mov ES:[BX].rSI,SI          ; and all the other stuff ...
        mov ES:[BX].rDI,DI
        mov ES:[BX].rSS,SS
        mov ES:[BX].rES,CX
        mov ES:[BX].rDS,DS
        mov AX,[BP+2]
        mov ES:[BX].rIP,AX          ; the return-adresse (Offset)
        mov AX,[BP+4]
        mov ES:[BX].rCS,AX          ; ... and the segment
        xor ax, ax                  ; return with zero

        pop BP

        retf


DoJump:                  ;;Comment: proc, wOffset:word, wSegment:word, Signal:word
    ; Jump back into a old environment
    ; Try to restore the old environment from the wSegment:wOffset

        add SP,4                    ; The old return-adress ...
                                    ;   gone with the wind

        pop BX                      ; The adress of the envioronment-buffer
        pop ES
        pop AX                      ; AX is Signal
        cmp ax, 0                   ; 0 not allowed
        jne @F
            inc AX                  ; Signal = 1

    @@:
        mov SS,ES:[BX].rSS          ; Rebuild the old environment
        mov SP,ES:[BX].rSP
        mov BP,ES:[BX].rBP
        mov SI,ES:[BX].rSI
        mov DI,ES:[BX].rDI

        push ES:[BX].rCS            ; the return-adress ...
        push ES:[BX].rIP
        push ES:[BX].rES            ; ... and some mess, because we used
        mov DS,ES:[BX].rDS          ; ... ES-register
        pop ES

        retf                        ; Gotcha !!


    end


    ; End of File