*.............................................................................
*   Program Name: FILEARY.PRG       Language: Clipper 5.0 with FUNCky library
*   Date Created: 04/17/91            Author: Steve R. Busey
*   Time Created: 16:53:42          
*
*	 Functions to save arrays to a file and read them back from a file -
*     - cannot handle blocks or objects in arrays
*
*	 I use this to save & load user definable configuration files
*
*.............................................................................
#define pCRLF chr(13)+chr(10)					// define carriage return/linefeed

FUNCTION afwrite( fname, array )
	*
	* writes arrays to text file - cannot handle blocks or objects in arrays
	*
	set printer to (fname)
	set device to printer
	setprc(0,0)
	aeval( array, {|x| printelement( x )})
	set printer to
	set device to screen
return( NIL )
***
STATIC FUNCTION printelement( element )		// only callable within this prg
	if valtype(element) =="A"
		@ prow(),pcol() say "{"+pCRLF
		aeval( element, {|x| printelement( x )})	 // call recursively
		@ prow(),pcol() say "}"
	else
		@ prow(),pcol() say valtype(element)
		@ prow(),pcol() say element
	endif
	DevPos( prow()+1,0 )                          // cr/lf
return(NIL)
***
***
***
***
FUNCTION afread( fname )
	*
	* reads arrays from text file - cannot handle blocks or objects in arrays
	*
	MEMVAR fh
	LOCAL aX := {}, cLine, cType

	_newline(10)						// funcky library - set EOL to linefeed
	fh = fopen( fname ,0)
	do while !feof( fh )				// funcky library - detect eof with file handle
		cLine := freadline( fh )	// funcky library - read a line to EOL character
		cType := left(cLine,1)
		cLine := substr(cLine,2)
		DO CASE
			CASE cType == "{"       // array
				aadd(aX,readelement(fh))
			CASE cType == "C"
				aadd(aX,cLine)
			CASE cType == "D"
				aadd(aX,ctod(cLine))
			CASE cType == "L"
				aadd(aX,(cLine=="T"))
			CASE cType == "N"
				aadd(aX,val(cLine))
			CASE cType == "U"
				aadd(aX,NIL)
		ENDCASE
	enddo
	fclose( fh )
return( aX )
***
STATIC FUNCTION readelement( fh )				// only callable within this prg
	LOCAL aX := {}, cLine, cType
	while .t.
		cLine := freadline( fh ) 	// funcky library - read a line to EOL character
		cType := left(cLine,1)
		if cType == "}"				// end of array element
			exit
		endif
		cLine := substr(cLine,2)
		DO CASE
			CASE cType == "{"   // array
				aadd(aX,readelement(fh))	// call recursively
			CASE cType == "C"
				aadd(aX,cLine)
			CASE cType == "D"
				aadd(aX,ctod(cLine))
			CASE cType == "L"
				aadd(aX,(cLine=="T"))
			CASE cType == "N"
				aadd(aX,val(cLine))
			CASE cType == "U"
				aadd(aX,NIL)
		ENDCASE
	end
return( aX )

