****************************************************************************
*              Copyright 1990, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                     *
*****************************************************************************

* STD_PRC.PRG               Standard PROCEDURE FILE
*  NOTE: ALL Functions in this PRG are included in your EXE.
*  So, please do not clutter with ingenious functions infrequently used.


* 
FUNC center   && returns centered string, padded with blanks to full length
   PARAM string, length
   PRIV front,string
   IF LEN(M->string) > M->length
      M->string = SUBS(M->string,1,M->length)
   ENDIF
   M->string = TRIM(LTRIM(M->string))
   front  = SPAC((M->length - LEN(string))/2)
RETURN SUBS(M->front+M->string+SPAC(M->length),1,M->length)

*
FUNC box
   PRIVATE save_screen,mret
   save_screen = .T.       && default is to save and return the old screen
   PARAMETERS r1,c1,num_el,width,title, save_screen
   CO_PUSH()

   M->width = IF(TYPE([M->width])=[U],40,M->width)
   M->width = IF(M->width = 0, 40, M->width)
   M->title = IF(TYPE([M->title]) = [U], [], M->title)
   PRIVATE r2,c2,mret
   M->r2     = M->r1 + M->num_el + 3
   M->c2     = M->c1 + M->width + 1

   IF M->save_screen
      *   this will save to a SCR file if your switch is on.
      mret = SAVESCR(M->r1, MAX(M->c1-1,0), MIN(M->r2+1,24), M->c2)
   ELSE
      mret = []
   ENDIF

   CO_CHG(0)                      && go black for shadows
   DRAWSHADOW(M->r1, M->c1, M->r2, M->c2)

   CO_CHG(curr_grp,M->c_frame)    && for the box frame
   @ M->r1,M->c1,M->r2,M->c2 box stdbox
   @ M->r1+2,M->c1 say [] + REPLICATE([],M->width)+ []
   SCROLL(M->r1+3,M->c1+1,M->r2-1,M->c2-1,0)  && clears the area inside the box
   CO_CHG(curr_grp,M->c_title)    && for the box title
   @ M->r1+1,M->c1+1 SAY CENTER((M->title),width)
   CO_POP()
RETU mret


* 
FUNC make_ntx     &&  Make an index, if it's not already there.
   PARAM mdbf,mntx,mexp
   PRIV mret
   IF ! FILE(TRIM(mntx) + [.NTX])
      * Index not in directory, so create it:
      IF ! OPEN_FILE(mdbf)
         DO kbhit WITH [Unable to open &mdbf file.  Any key continues...]
         USE
         RETU .F.
      ENDIF

      SET DEVICE TO SCREEN
      PRIVATE old_screen
      old_screen = SAVESCR(24,0,24,79)
      IF ! FLOCK()
         DO kbhit WITH [Unable to lock the &mdbf file.  Any key continues...]
         USE
         RETU .F.
      ENDIF

      DO wait_on WITH [Please wait.  Creating index file ] + TRIM(mntx) + [...]
      INDEX ON &mexp TO &mntx
      UNLOCK
      USE
      RESTSCR(old_screen)
      IF mdevice $ [P/F/CON]
         SET DEVICE TO PRINT    && re-set the device
      ENDIF
      DO wait_off
   ENDIF
RETU .T.

* 
PROC printit       &&  Select and setup the printer
   PARA _mstr
   PRIV mkey
   printer = IF(TYPE([mprinter])=[U],[printer],M->mprinter)
   IF PCOUNT() = 0  &&  no prompt was sent, so make a default:
      *   Is netprint or stdprint beig used ?
      IF TYPE([NETPRINT()]) = [UI] .OR. FILE([stdprint.dbf])
         _mstr = SUBS('Set up '+TRIM(M->mprinter)+'.  [F1] for selection, [Esc] to Quit, any key to print...',1,80)
      ELSE
         _mstr = 'Set up the printer.  [F1] for selection, [Esc] to Quit, any key to print...'
      ENDIF
   ENDIF

   IF UPPER(_mstr) <> [NO]  && if NO, then go ahead and print
      @ 24,0
      @ 24,0 SAY _mstr
      SET CONSOLE OFF
      WAIT [] TO mkey       && so we can capture [F1] key
      SET CONSOLE ON
      IF ESC()
         @ 24,0
         RETURN
      ENDIF
   ENDIF

   DO WHILE ! ISPRINTER()     &&  Be sure printer is ready.
      DO kbhit WITH 'Printer is not ready.  Please set up the printer, or [Esc] to Quit.'
      IF ESC()
         RETURN
      ENDIF
   ENDDO

   mdevice = [P]
   DO wait_on WITH [Please wait.   Report in progress...]
   SET PRINT ON
   SET CONSOLE OFF
   SET DEVICE TO PRINT
   ?? M->init                     &&  initialization string
RETU


* 
PROC openit
   PARAM devices    && PSF
   devices = DEFAULT([devices], [PSF])
   PRIVATE  mfilename, xdevice

   @ 23,0 SAY REPLIC([],80)
   @ 24,0
   @ 24,0 SAY [Report to: ]
   SET MESSAGE TO
   IF [P] $ devices
      @ 24,COL()+3 PROMPT [Printer]
   ENDIF
   IF [S] $ devices
      @ 24,COL()+3 PROMPT [Screen]
   ENDIF
   IF [F] $ devices
      @ 24,COL()+3 PROMPT [File]
   ENDIF
   MENU TO xdevice
   @ 24,0

   mdevice = SUBS([Q]+devices,xdevice+1,1)

   DO CASE
      CASE mdevice = [Q] && phf 16:32:27  12/8/1989
         mdevice = [S]

      CASE mdevice = [P]
         DO printit              &&    see PROC printit

      CASE mdevice = [F]
         mfilename = SPAC(20)
         @ 24,20 SAY 'File Name:' GET mfilename PICT '@!'
         CO_CHG(curr_grp,c_sayget)
         READ
         IF ! ESC()
            DO wait_on WITH 'Report in progress.  Writing to file ' + mfilename + [...]
            SET CONSOLE OFF
            SET DEVICE TO PRINT
            SET ALTE TO &mfilename
            SET ALTE ON
            SET PRINT ON
            SET PRINTER TO &mfilename
         ENDIF

      CASE mdevice = [S]
         mdevice   = [PCON]   &&  handled just like a printer.
         SET DEVICE TO SCREEN
         @ 0,0 CLEA
         *  SDB added this on 6/2/1989, keeps track of ROW()
         SET CONSOLE OFF
         SET DEVICE TO PRINT
         SET PRINT ON
         SET PRINTER TO CON
   ENDCASE
   SET MESSAGE TO 24
RETURN


* 
PROC closeit   &&  Close up after reports
   IF Mdevice $ [P/F]      && Printer or File
      @PROW(),PCOL() SAY CHR(12)      && Form feed character
   ENDIF
   SET DEVICE TO SCREEN
   SET ALTERNATE TO
   SET ALTERNATE OFF
   SET PRINT OFF
   SET PRINTER TO
   SET CONSOLE ON

   IF mdevice = [S]        &&   Screen
      DO kbhit             &&   Pause so they can read the screen.
   ENDIF

   mdevice = [S]
   DO wait_off
RETURN

* 

FUNC ldate  && Letter Date: Day, Month Year
   PARAM mdate
   PRIV  mret
   mdate = DEFAULT([mdate], DATE())
   mret  = CMON(mdate)+[ ]+ltrim(STR(DAY(mdate),2))+[, ]+STR(YEAR(mdate),4)
RETURN mret

* 
FUNCTION defined    && Checks to see if this variable is defined.
   PARAM xvar
RETURN TYPE(xvar) # [U]

* 
FUNC default         &&  Assigns your default of nothing is defined
   PARAM variable,;      &&  variable name
         value           &&  default  value
   PRIV mret
   IF TYPE(variable) = [U]
      mret = M->value
   ELSE
      mret = &variable
   ENDIF
RETU mret

* 
FUNC uline    && underline, the same length as mvar
   PARA mvar
RETU (REPLIC([_],LEN(mvar)))

* 
FUNC div    && Divides two numbers, returns 0 if divide by zero.
   PARA  numerator,denominator
RETU IF(denominator=0,0,numerator/denominator)

* 
FUNC esc      &&  RETURN .T. if Escape key hit
RETU  (LASTKEY()=27 .OR. INKEY()=27)

* 
FUNC lookup         && lookup a value (mvar) in database (mdbf) from VALID
   PARA mdbf,;      && alias to look up in (assumed open and indexed)
        mvar,;      && value to lookup
        mwarn,;     && give a warning if not found ?
        say_field,; && field or udf to say
        row,;
        col

   PRIV malias, mret
   mwarn = IF(TYPE([mwarn])=[U],.F.,mwarn)
   row   = IF(TYPE([M->row])=[U],ROW(),M->row)
   col   = IF(TYPE([M->col])=[U],COL()+2,M->col)

   malias = SELE()
   SELE &mdbf
   SEEK mvar
   IF FOUND() .OR. EMPTY(mvar)        &&  We accept empty values.
      mret = .T.
   ELSE
      IF mwarn                        &&  they asked for a warning.
         ?? CHR(7)
         DO kbhit WITH SUBS(TRIM(mvar) + ' not found.  [F1] for help.  Any key continues...',1,80)
      ENDIF
      mret = .F.
   ENDIF
   IF TYPE([say_field])=[C]
      @ M->row,M->col SAY &say_field
   ENDIF
   SELE (malias)
RETURN mret

* 
FUNC dots  && returns your label followed by dots ...............
   PARAM string,length
RETURN SUBS(TRIM(M->string)+[ ]+REPLIC([.],M->length),1,M->length)


* 
FUNC stuff_it   && used to stuff an input value into another variable during valid
   PARAM stuff_value, stuff_var
   STORE stuff_value TO &stuff_var
RETURN .T.
* 

FUNC islast            && check for last day of month
   PARA mdate
RETU DAY(mdate+1)=1 .AND. ! EMPTY(mdate)

* 
FUNC dayplug      && plug a day into month/year
   PARAM mdate,mday
   PRIV mdate,mday
   IF PCOUNT()#2
      mday = 1
   ENDIF
RETU CTOD(SUBS(DTOC(mdate),1,3)+STR(mday,2,0)+[/]+STR(YEAR(mdate),4,0))

* 

FUNC softseek                          && trim last char of string and add 1 ascii value
   PARA mval
   PRIV mret
   DO CASE
      CASE TYPE([mval])=[C]
         mret = SUBS(mval,1,LEN(mval)-1) + CHR(ASC(SUBS(mval,-1,1))+1)
      CASE TYPE([mval])=[N]
         mret = VAL(SUBS(STR(mval),1,LEN(STR(mval))-1)+CHR(ASC(SUBS(STR(mval),-1,1))+1))
      OTHERWISE
         mret = []
   ENDCASE
RETU mret

* 
FUNC off     && test for primary key grouping
   PRIV mret
   IF EOF() .OR. BOF()
      mret = .T.
   ELSE
      IF EMPTY(M->group_key)
         mret = .F.
      ELSE
         mret = M->group # &group_key
      ENDIF
  ENDIF
RETU mret

* 
FUNC top      && get to the top of this group, or top of file
   IF EMPTY(M->group_key)
      GO TOP
   ELSE
      SEEK M->group
   ENDIF
RETURN []

* 

FUNC bott                              && get to the bottom of this group, or bottom of file
   IF EMPTY(M->group)
      GO BOTT                          && Subset is not defined
   ELSE
      SET SOFTSEEK ON                  && Subset defined
      SEEK SOFTSEEK(M->group)          && Move one past grouping
      SET SOFTSEEK OFF
      IF ! BOF()
         SKIP -1                       && If data exists, skip back into group
         IF OFF()
            GOTO LASTREC()+1
         ENDIF
      ENDIF
   ENDIF
RETURN []


* 
FUNC open_file
   PRIVATE ntx1,ntx2,ntx3,ntx4,ntx5,ntx6,ntx7,ntx8,ntx9,ntx10,ntx11,ntx12,mret
   STORE [] TO ntx1,ntx2,ntx3,ntx4,ntx5,ntx6,ntx7,ntx8,ntx9,ntx10,ntx11,ntx12
   PARA dbf,ntx1,ntx2,ntx3,ntx4,ntx5,ntx6,ntx7,ntx8,ntx9,ntx10,ntx11,ntx12
   IF SELE(M->dbf) = 0
      SELE 0
      USE &dbf
   ELSE
      SELE &dbf
   ENDIF
   mret = ! NETERR()
   SET INDE TO &ntx1,&ntx2,&ntx3,&ntx4,&ntx5,&ntx6,&ntx7,&ntx8,&ntx9,&ntx10,&ntx11,&ntx12  && should work
   GO TOP
RETU mret

* 
FUNC ampm          && return time string in HH:MM am format
   PARA mtime
   PRIV val,t
   val = IF(SUBS(mtime,1,2)<[12],[ am],[ pm])
   t   = IF(SUBS(mtime,1,2)>=[13],STR(VAL(SUBS(mtime,1,2))-12,2,0),SUBS(mtime,1,2))
RETU LTRIM(M->t+SUBS(mtime,3,3)+M->val)

* 
FUNC v_subs        && validate string searches
   PARA var,string,ALLTRIM
   ALLTRIM = DEFAULT([ALLTRIM],.T.)
   IF ! EMPTY(var)
      var = IF(ALLTRIM,TRIM(LTRIM(var)),var)
   ENDIF
   PRIV mret
   mret = var $ M->string
   IF ! mret
      ?? CHR(7)
      @ 24,0
      @ 24,0 SAY [Valid responses are : ]+string
   ELSE
      @ 24,0
      @ 24,0 SAY IF(full_screen,scr_prompt,mprompt)
   ENDIF
RETU(mret)

* 

FUNC adding
RETU DEFAULT([mchoice],[X]) = [A] .OR. DEFAULT([fchoice],[X]) = [A]

* 

FUNC editing
RETU DEFAULT([mchoice],[X]) = [E] .OR. DEFAULT([fchoice],[X]) = [E]

* 
FUNC boxx      && BOXX a string
   PARA mrow,mcol,str1,str2,str3,str4,str5
   CO_PUSH()
   PRIV len,mscreen
   IF mdevice#[S]
      DO closeit
   ENDIF
   len = LEN(str1)
   FOR i = 2 TO PCOUNT()-2
     var = [str]+STR(i,1)
     len = MAX(len,LEN(&var))
   NEXT
   mscreen = FRAMEBOX(mrow,mcol,mrow+PCOUNT()-1,mcol+len+4)
   @ mrow+1,mcol+2 SAY str1
   IF PCOUNT() >=4
      @ ROW()+1,mcol+2 SAY str2
   ENDIF
   IF PCOUNT() >=5
      @ ROW()+1,mcol+2 SAY str3
   ENDIF
   IF PCOUNT() >=6
      @ ROW()+1,mcol+2 SAY str4
   ENDIF
   IF PCOUNT() >=7
      @ ROW()+1,mcol+2 SAY str5
   ENDIF
   CO_POP()
RETU mscreen

* 
FUNC unique
   PARA neworder,seekgroup
   seekgroup = IF(TYPE([seekgroup])=[U],.T.,.F.)
   IF ! seekgroup
      PRIV group
      group = []
   ENDIF
   PRIV mret,alias,var,mrec
   IF PCOUNT() = 0
      neworder = INDEXORD()
   ENDIF
   oldorder = INDEXORD()
   SET ORDER TO neworder
   alias = ALIAS()
   var   = READVAR()
   IF ADDING() .OR. (EDITING() .AND. M->&var # &var )
      mrec=RECNO()
      SEEK M->group+M->&var
      IF FOUND()
         ?? CHR(7)
         DO kbhit WITH TRIM(M->&var)+[ is already on file.  Any key continues...]
         mret=.F.
      ELSE
         mret=.T.
      ENDIF
      GOTO mrec
   ELSE
      mret=.T.
   ENDIF
   SET ORDER TO oldorder
RETU(mret)

* 
FUNC cursorkey
   PARA keystroke
   M->keystroke = IF(TYPE([M->keystroke])=[U],LASTKEY(),M->keystroke)
RETU M->keystroke=1  .OR. M->keystroke=2  .OR. M->keystroke=3  .OR. M->keystroke=4  .OR.;
     M->keystroke=5  .OR. M->keystroke=6  .OR. M->keystroke=18 .OR. M->keystroke=19 .OR.;
     M->keystroke=23 .OR. M->keystroke=24 .OR. M->keystroke=26 .OR. M->keystroke=29 .OR.;
     M->keystroke=30 .OR. M->keystroke=31


* 
PROCEDURE backdrop
   IF TYPE([backdrop]) <> [C]
      CO_PUSH()
      CO_CHG(M->c_backdrop,M->c_sayget)
      SCROLL(0,0,24,79,0)
      IF FILE('brick.ok') .AND. ISCOLOR()
         SET COLO TO w+/r
         str1 = REPLICATE([],20)
         str2 = REPLICATE([],20)
         str3 = REPLICATE([],20)
         str4 = REPLICATE([],20)
         @ 0,0 SAY str3
         FOR i = 1 TO 22 STEP 2
            @ i  ,0 SAY str1
            @ i+1,0 SAY str2
         NEXT i
         @ 23, 0 SAY str4
      ELSEIF FILE('clear.ok')
         CLEAR
      ELSE
         str1 = REPLICATE([],80)
         FOR i = 0 TO 23
           @ i,0 SAY str1
         NEXT
      ENDIF
      CO_POP()
      PUBLIC backdrop
      backdrop = SAVESCR(0,0,24,79)
   ELSE
      RESTSCR(backdrop)
   ENDIF
RETURN

* 
PROC abortnofind
   PARA fname
   IF ! FILE(M->fname)
      CLEAR
      ? "ERROR: file "+UPPER(ALLTRIM(M->fname))+" not found."
      ? "       Unable to continue, program halted"
      INKEY(0)
      CLOSE DATA
      QUIT
   ENDIF
RETURN

* 
PROC wait_on      &&  Turns on the flashing wait sign
   PARA _mstr
   IF ! [WAIT] $ SCREENGRAB(1,75,1,78)
      wait_box = SAVESCR(1,75,1,78)
   ENDIF
   CO_PUSH()
   SET COLO TO [W+*/R,R/W]     && hard coded red blink color
   SET DEVI TO SCREEN
   @ 1,75 SAY [WAIT]
   SET COLO TO &normal         && for those without stdcolor
   CO_POP()
   IF TYPE([M->_mstr])=[C]
      DO saystat WITH M->_mstr
   ENDIF
   IF SUBS(mdevice,1,1) $ [PFBA]
      SET DEVICE TO print
   ENDIF
RETURN

* 
PROC wait_off     &&  Erases the flashing wait sign
   IF TYPE([wait_box]) = [C]  && It is defined in this application.
      IF [W] $ wait_box       && It was improperly saved with WAIT in it,
         @ 1,75 SAY SPAC(4)   && so just say some spaces.
      ELSE
         RESTSCR(wait_box)
      ENDIF
   ELSE
      @ 1,75 SAY SPAC(4) &&  wait_box not saved, so say some spaces
   ENDIF
   *  @ 24,0
RETURN

* 
PROC kbhit  &&  keyBoard Hit, with a prompt
   PARA _mstr,timer
   PRIVATE old_screen
   old_screen = SAVESCR(24,0,24,79)
   timer     = IF(TYPE([M->timer])    =[U], 0,  M->timer)
   _mstr   = IF(TYPE([M->_mstr])  =[U], [Any key continues...], M->_mstr)
   DO saystat with M->_mstr
   INKEY(M->timer)      &&  use this instead of wait, so we can set a timer.
   IF LASTKEY() = 28
      KEYBOARD CHR(28)
   ENDIF
   RESTSCR(old_screen)
RETURN

* 
FUNC scrtitle
   PARA mstr,mrow,scol,ecol
   PRIV mcol
   CO_PUSH()
   CO_CHG(curr_grp,c_title)
   IF DEFINED([ecol])
      mcol = (ecol - ((ecol - scol)/2) - (LEN(mstr) / 2))
   ELSE
      mcol = scol
   ENDIF
   @ mrow,mcol SAY mstr
   CO_POP()
RETU []

* 
FUNC yes_no    &&  ask a yes/no question:
   PARA question
   PRIV i, prompt, mkey
   SET DEVI TO SCREEN
   SET CONS ON
   SET PRINT OFF
   DO saystat WITH DEFAULT([question], [Okay to continue? (Y/N) ])
   CURS_ON()
   M->mkey = [*]
   SET CONS OFF
   WAIT [] TO M->mkey
   SET CONS ON
   M->myn = IF(UPPER(M->mkey)=[Y],[Y],[N])
   @ 24,0
   IF mdevice <> [S]
      SET CONS OFF
      SET PRINT ON
      SET DEVI TO PRINT
   ENDIF
RETU M->myn = [Y]

* 
PROC leave
   PARAMETER r1,c1
   PRIVATE manswer
   CO_PUSH()
   CO_CHG(c_pop3)
   manswer = [ ]
   r1 = DEFAULT([r1],10)
   c1 = DEFAULT([c1],23)
   DO BOX WITH r1,c1,4,44,[Leave the system], .F.
   CO_CHG(curr_grp, c_sayget)
   @ r1+3,c1+3  SAY [Sure you want to quit? ] GET manswer PICT [!]
   SET CONFIRM OFF
   READ
   SET CONFIRM ON
   IF manswer $ [QY]
      DO del_mems
      SET COLO TO W/N          && white on black
      CLEAR
      QUIT
   ENDIF
   CO_POP()
RETU

*
FUNC drawshadow
   PRIV mscreen
   PARA r1,c1,r2,c2
   IF M->r2 < 24 .AND. M->c1 > 0
      mscreen = SAVESCREEN(M->r1+1, M->c1-1, M->r2+1, M->c2-1)
      CHG_ATTR(mscreen)
      RESTSCREEN(M->r1+1, M->c1-1, M->r2+1, M->c2-1,mscreen)
   ENDIF
RETU []

*
PROC saystat
   PARA str2say
   CO_PUSH()
   CO_CHG(M->c_status)
   SET DEVICE TO SCREEN
   @ 24,0
   @ 24,0 SAY str2say
   CO_POP()
   IF mdevice $ [PF]
      SET DEVICE TO PRINT
   ENDIF
RETURN

*
PROC topscreen
   CO_PUSH()
   CO_CHG(0,M->c_text)
   DRAWSHADOW(1,19,4,56)
   CO_CHG(c_menus,c_frame)
   @ 1,19,4,56 BOX stdbox
   CO_CHG(curr_grp,M->c_text)
   SCROLL(2,20,3,55,0)
   CO_CHG(0,M->c_text)
   DRAWSHADOW(1,62,4,76)
   CO_CHG(curr_grp,M->c_frame)
   @ 1,62,4,76 BOX stdbox
   CO_CHG(curr_grp,M->c_title)
   SCROLL(2,63,3,75,0)
   @ 3,64 SAY [Station]
   @ 2,20  SAY mhead_1
   @ 3,20  SAY mhead_2
   @ 2,66 SAY DATE()
   @ 3,73 SAY msta
   CO_POP()
RETU

*
FUNC curs_on
   SET CURS ON
   cursoron = .T.
RETU []

*
FUNC curs_off
   SET CURS OFF
   cursoron = .F.
RETU []

* 
PROC seekhelp
   PARA dbf
   SELE &dbf
   SET SOFT ON
   SEEK TRIM(M->&input_var)       &&   get to current value:
   SET SOFT OFF
   IF EOF()
      TOP()
   ENDIF
RETU

* 
FUNC framebox
   PARA tr,lc,br,rc,title
   PRIV mret
   mret = SAVESCR(tr,MAX(M->lc-1,0), MIN(br+1,24), rc)
   CO_PUSH()
   CO_CHG(0)
   DRAWSHADOW(tr,lc,br,rc)
   CO_POP()
   @ tr,lc,br,rc BOX stdbox+[ ]
   IF TYPE([M->title])<>[U]
      SCRTITLE(M->title,tr,lc,rc)
   ENDIF
RETU mret

* 
FUNC escbreak
   PARAM leave_open,break_ok
   IF ESC()
      IF PCOUNT() = 0  && default is to close data.
         CLOSE DATA
      ENDIF
      IF mdevice $ [PF/CON]
         DO closeit
      ENDIF
      BREAK
   ENDIF
RETU .T.

* 
PROC sub_menu_clean
   RESTSCR(menuscreen)
   CLOSE DATA
   IF mdevice <> [S]
      DO closeit
   ENDIF
RETU

* 
PROC pack_index
   PARA dbf
   *  run the procedure, so that all index files are opened as well:
   DO &dbf
   IF NETERR()
      ?? CHR(7)
      DO kbhit WITH dbf + [ database not available.  No reindexing done.  Any key continues...]
      BREAK
   ENDIF
   DO wait_on WITH [Please wait.  Processing ] + dbf + [ database...]
   PACK
   USE
   DO wait_off
RETU

* 
FUNC ldom          && return last day of the month for any given date
  PARA xdate
  PRIV mdate
  M->mdate = M->xdate-DAY(M->xdate)+34
RETU M->mdate-DAY(M->mdate)

* 
FUNC zero         &&  Determines whether a value is truly zero.
  PARAM value,decimals
  IF PCOUNT() < 2
     IF [.] $ STR(M->value)
        M->decimals = LEN(SUBS(STR(M->value),AT([.],STR(M->value))+1))
     ELSE
        M->decimals = 0
     ENDIF
  ENDIF
  PRIVATE string
  string = STR(M->value,14,M->decimals)
RETURN ([0.]+REPLIC([0],M->decimals) = LTRIM(M->string))


FUNC emptyf  && do not delete this function!!! - phf
   PRIV mret
   mret = .f.
   IF EOF()
      TOP()
      IF EOF()
         mret = .t.
      ENDIF
   ELSE
      mret = .f.
   ENDIF
RETU(mret)

FUNC soft
   PARA mval
   SET SOFT ON
   SEEK M->mval
   SET SOFT OFF
RETU (! EOF())


* Screen-saving functions

* 
*FUNC savescr   && by Greg Martin
*   PARA tr,lc,br,rc
*   PRIV screen,corners
*   screen  = SAVESCREEN(tr,lc,br,rc)
*   corners = CHR(tr)+CHR(lc)+CHR(br)+CHR(rc)
*RETU corners+screen

* 
*FUNC restscr   && by Greg Martin
*   PARA screen
*   PRIV tr,lc,br,rc
*   tr     = ASC(SUBS(screen,1,1))
*   lc     = ASC(SUBS(screen,2,1))
*   br     = ASC(SUBS(screen,3,1))
*   rc     = ASC(SUBS(screen,4,1))
*   screen = SUBS(screen,5)
*   RESTSCREEN(tr,lc,br,rc,screen)
*RETU .T.

FUNC savescr   && by Greg Martin
     PARA tr,lc,br,rc
     PRIV screen,corners,mret,mtemp
     screen  = SAVESCREEN(tr,lc,br,rc)
     corners = CHR(tr)+CHR(lc)+CHR(br)+CHR(rc)
     IF TYPE([scr_file]) = [U] .OR. LEN(corners + M->screen) < 512
        mret   =  corners + M->screen
     ELSE
        mret   = NEXTSCRFILE()
        screen = corners+screen
        MEMOWRIT(mret, M->screen)
     ENDIF
RETU mret

FUNC restscr   && by Greg Martin
     PARA screen
     PRIV tr,lc,br,rc

     IF SUBS(M->screen,1,2) = [F_]
        screen = MEMOREAD(M->screen)
     ENDIF
     tr     = ASC(SUBS(screen,1,1))
     lc     = ASC(SUBS(screen,2,1))
     br     = ASC(SUBS(screen,3,1))
     rc     = ASC(SUBS(screen,4,1))
     RESTSCREEN(M->tr,M->lc,M->br,M->rc,SUBS(M->screen,5))
RETU .T.

FUNC nextscrfile
     scr_file = [F_]+msta+[_]+ALLTRIM(STR(VAL(SUBS(scr_file,4+LEN(msta)))+1,4,0)) + [.SCR]
RETU scr_file

PROC del_mems  && delete screen mem vars on the way out.
     PRIV last_file, i, mem_file
     DO wait_on WITH [Please wait.  Erasing temporary screen files...]
     i = 0
     DO WHIL .T.
        i = i + 1
        mem_file = [F_]+msta+[_]+ALLTRIM(STR(i,3)) + [.SCR]
        IF FILE(mem_file)
           ERASE &mem_file
        ELSE
           IF i > 3  && do at least the first 3 loops.
              EXIT
           ENDIF
        ENDIF
     ENDDO
     DO wait_off
RETURN
