
*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************

*  STD_KEYS        ** Standard Keys for Browse

mloop = .T.    && tells BROWSE whether to loop or list.

IF mchoice $ [AEDPFV]
   IF mchoice $ [AE] .AND. M->white
      DO rev_line
   ENDIF
   DO std_&mchoice       &&  executes the standard procedure
ELSE
   *  must be a cursor direction key
   DO rev_line           &&  un-do the current menu bar
   DO cursor             &&  procedure for cursor keys
ENDIF

RETURN
***  eof:std_keys


* 
PROC std_p       && standard single-record print
  PRIVATE i, mfield

  BEGIN SEQUENCE
     IF M->browse   && are currently browsing, whether full screen or not.
        DO std_list    && procedure defined below
     ELSE
        DO printit
        ESCBREAK([leave open])
        FOR i = 1 TO FCOUNT()
           mfield = FIELD(i)
           @ PROW()+1,5   SAY  mfield
           @ PROW(),  20  SAY  &mfield
        NEXT
        DO closeit
     ENDIF
  END SEQUENCE
RETURN

* 
PROC std_list         && prints a list of the table
   PRIV head1, head2, head3, head4, rep_width, rep_line, page, i, mscreen
   DO printit && WITH [Setup the printer for a list of all records.  Any key continues...]
   ESCBREAK([leave open])
   head1 = TRIM(mcomp_name)
   head2 = mtitle
   head3 = wtitle                          && will have to parse ASCII character
   head4 = REPL([_],MAX(LEN(wtitle),LEN(&wfields)))           && underline will
   rep_line = wfields
   rep_width = LEN(head4)
   page  = 0

   * get rid of ASCII characters in wtitle
   FOR i = 1 TO LEN(head3)
      IF ASC(SUBS(head3,i,1)) >= 179
         head3 = SUBS(head3,1,i-1) + [ ] + SUBS(head3,i+1)   && replace with a space
      ENDIF
   NEXT

   * get rid of ASCII characters in wfields
   FOR i = 1 TO LEN(rep_line)
      IF ASC(SUBS(rep_line,i,1)) >= 179
         rep_line = SUBS(rep_line,1,i-1) + [ ] + SUBS(rep_line,i+1)
      ENDIF
   NEXT

   TOP()
   DO WHILE ! OFF() .AND. ESCBREAK([leave open])
      IF PROW() > 55 .OR. page = 0
         page = M->page + 1
         @ 1,1                SAY DATE()
         @ PROW(),   left_col SAY CENTER(head1,rep_width)
         @ PROW()+1, left_col SAY CENTER(head2,rep_width)
         @ PROW(),   1        SAY IIF(M->page > 1,[Page] + STR(page,3),[])
         @ PROW()+2, left_col SAY head3
         @ PROW(),   left_col SAY head4
         @ PROW()+1,0
      ENDIF
      @ PROW()+1,left_col SAY &rep_line
      SKIP
   ENDDO
   TOP()
   DO closeit
   mloop = .F.      && to re-draw records on screen
RETU

* 
PROC std_v   && Currently in Browse , go to View Mode
     IF ! full_screen   &&  not permitted in this one.
        RETURN
     ENDIF
     browse = .F.
     DO full_scr  && uses same mem vars defined in browse
     IF ! mquit   && Did they quit or view from fullscreen
        browse = .T.
        mloop = .F.
        RESTSCR(mscreen)
        CURS_OFF()
     ENDIF
RETURN


* 
PROC std_f   && find
   PRIVATE old_screen, mkey, lastrec
   oldscreen   = SAVESCR(24,0,24,79) && just to retain line 24
   find_prompt = IF(TYPE([find_prompt])=[U],[key]    ,find_prompt)
   find_field  = IF(TYPE([find_field])=[U] ,key_field,find_field)
   find_pict   = IF(TYPE([find_pict])=[U]  ,[@!],find_pict)
   CURS_ON()
   mkey = SPAC(LEN(&find_field))
   CO_CHG(curr_grp,c_text)
   @ 24,0
   @ 24,0 SAY [Enter ] + find_prompt + [ to find ] GET mkey PICT find_pict
   CO_CHG(curr_grp,c_sayget)
   READ
   IF ! (EMPTY(mkey) .OR. ESC())
      mloop = .F.   && browse needs this.
      lastrec = RECNO()
      SET SOFTSEEK ON
      SEEK group+mkey  && CJ 10/11/1989
      SET SOFTSEEK OFF
      IF OFF()
         DO kbhit WITH 'Record not found.  Any key continues... '
         GOTO lastrec
      ENDIF
   ENDIF
   RESTSCR(oldscreen)
   CURS_OFF()
RETURN

* 
PROC std_n      &&   Get to next record
  IF ! EOF()
     SKIP
  ENDIF
  IF OFF()
     ?? CHR(7)   && Bell!
     DO kbhit WITH 'This is the end of your file.  Any key continues...'
     BOTT()
  ENDIF
RETURN


* 
PROC std_b        &&  Go back one record.
  IF ! BOF()
    SKIP -1
  ENDIF
  IF OFF()
     ?? CHR(7)    && Bell!
     DO kbhit WITH 'This is the top of your file.  Any key continues...'
     TOP()
  ENDIF
RETURN

* 
PROC std_init
  PARAM    xchoice
  PRIVATE  i,;         && counter
           fieldname   && fieldname

  IF xchoice = [A]     && Adding
     GOTO LASTREC()+1       && Go past EOF(), to get blank field values.
  ENDIF
  FOR i = 1 TO FCOUNT()
     fieldname = FIELD(i)
     M->&fieldname = &fieldname
  NEXT i
RETURN

* 
PROC std_repl
  PRIVATE  i, fieldname

  *  Record should already have been locked in std_init,
  *  but subsequent pointer movement (HELP or VALID) might have unlocked it.
  BEGIN SEQUENCE
     DO WHIL ! rec_lock(5)
         ?? CHR(7)
         IF ! YES_NO([Record not available.  Want to retry? (Y/N)])
            BREAK       && go back to std_A or std_E
         ENDIF
     ENDDO

     FOR i = 1 TO FCOUNT()
        fieldname = FIELD(i)
        REPLA  &fieldname  WITH  M->&fieldname
     NEXT
  END SEQUENCE
RETURN

* 
PROC std_a     && Standard Add
     PRIV lastrec,needscr
     fromread     = .T.
     add_only_one = IF(TYPE([add_only_one])=[U],.F.,add_only_one)
     lastrec      = RECNO()
     mloop        = .F.
     CURS_ON()
     IF full_screen   && if the gets require a full screen
        IF browse     && need a frame first
           CO_PUSH()
           CO_CHG(c_fullscr,c_frame)
           DO &module._frame
        ENDIF
        DO &meminit WITH [A]    && no need to lock record until we append
        CO_CHG(curr_grp,c_text)
        @ 24,0
        @ 24,0 SAY scr_prompt
        CO_CHG(curr_grp,c_sayget)
        DO &module._gets WITH [M]
        READ
        CO_CHG(curr_grp,c_text)
        IF ESC()   && don't add it
           GOTO lastrec
        ELSE
           * do replaces
           DO mu_add
           @ 24,0
           @ 24,0 SAY IIF(full_screen,scr_prompt,mprompt)
        ENDIF
        IF browse .AND. ! stayinfull
           CO_POP()
           RESTSCR(mscreen)
        ENDIF
     ELSE
        *  gets will be on the current line only
        CO_CHG(curr_grp,c_sayget)
        cur_row = lastrow
        DO WHIL .T.
           IF cur_row = bot_row-1
              SCROLL(firstrow,left_col+1,cur_row,right_col-1,1)  && up one row
           ELSE
              cur_row = cur_row+1
           ENDIF
           DO &meminit WITH [A]    && initialize mem vars.
           @ cur_row,left_col+4 SAY &wfields    && say the blanks
           CO_CHG(curr_grp,c_text)
           @ 24,0
           @ 24,0 SAY "Add new records.  Hit [Esc] when finished adding."
           CO_CHG(curr_grp,c_sayget)
           DO &module._gets WITH cur_row
           READ
           IF ESC()
              GOTO lastrec    && Get back. We are at EOF() now
              EXIT            && Done adding
           ENDIF
           DO mu_add   && adds data to file
           IF add_only_one
              EXIT            && Done adding
           ENDIF
           @ cur_row,left_col+4 SAY &wfields
        ENDDO
     ENDIF
     CURS_OFF()
RETURN

PROC mu_add       && Multi-user ADD
     DO WHIL .T.
        IF ! ADD_REC(5)    && give it 5 tries
           ?? CHR(7)
           DO yes_no WITH [Record not available.  Do you wish to retry? (Y/N)]
           IF myn=[N]
              EXIT    && Record not added
           ENDIF
        ELSE
           DO &mreplace     &&  replace fields with current mem vars
           UNLOCK
           EXIT
        ENDIF
     ENDDO
RETURN


PROC std_e   && Standard Edit
   mloop    = .T.
   fromread = .T.

   IF DELE()
      DO kbhit WITH [Record has been deleted.  Any key continues...]
      RETU
   ENDIF

   *  Lock record 
   DO WHIL ! rec_lock(5)
      ?? CHR(7)
      DO yes_no WITH [Record not available.  Do you wish to retry? (Y/N)]
      IF myn = [N]
         RETURN      && go back to browse
      ENDIF
   ENDDO

   * record is now locked !
   CURS_ON()

   *  Initialize mem vars 
   oldkey = &key_field
   IF full_screen
         mloop = .F.
         IF browse
            CO_PUSH()
            CO_CHG(c_fullscr,c_frame)
            DO &module._frame
         ENDIF

         DO &meminit WITH [E]
         CO_CHG(curr_grp,c_sayget)
         @ 24,0
         @ 24,0 SAY scr_prompt
         DO &module._gets WITH [M]
         READ
         IF ! ESC()     && not keeping these changes
            DO &mreplace     &&  replace fields with current mem vars
         ENDIF
         IF browse .AND. ! stayinfull
            CO_POP()
            RESTSCR(mscreen)
         ENDIF
   ELSE
         DO &meminit WITH [E]    && initialize mem vars.
         **         CO_CHG(curr_grp,c_sayget)
         DO &module._gets WITH cur_row
         READ
         IF ESC()
            @ cur_row,left_col+4 SAY &wfields
         ELSE
            DO &mreplace     &&  replace fields with current mem vars
            IF oldkey = &key_field
               @ cur_row,left_col+4 SAY &wfields
            ELSE   && Changed a key field, so exit!
               mloop = .F.
            ENDIF
         ENDIF
         @ 24,0
         @ 24,0 SAY mprompt
   ENDIF
   UNLOCK
   CURS_OFF()
RETURN


FUNC std_d                           && Delete this record
   PRIVATE deleted
   deleted = .F.

   BEGIN SEQUENCE
      IF ! yes_no( [Sure you want to delete this one? (Y/N) ] )
         DO kbhit WITH [Spared!  Any key continues...]
         BREAK
      ENDIF
      DO WHIL ! rec_lock(5)
         ?? CHR(7)
         IF ! yes_no( [Record not available.  Do you wish to retry? (Y/N)] )
            BREAK      && go back to browse
         ENDIF
      ENDDO

      * record is now locked!
      DELETE
      deleted = .T.
      UNLOCK
      SKIP                            &&  get to record after deletion.
      IF OFF()
           none_left = .T.
           BOTT()
      ELSE
           none_left = .F.
      ENDIF
      lastrec = RECNO()               && new last record, we deleted old one
      browse = DEFAULT([browse],.F.)
      IF browse
           * shift the screen UP, from cur_row:
           IF cur_row <> lastrow
              SCROLL(cur_row,left_col+1,lastrow,right_col-1,1)  && up one
           ENDIF

           * display the new bottom record (one past old bottom)
           SKIP (lastrow - cur_row)
           IF OFF() .OR. none_left
              SCROLL(lastrow,left_col+1,lastrow,right_col-1,0)
              IF cur_row = lastrow     && were we on the last?
                 cur_row = MAX(firstrow, cur_row - 1)  && up one
              ENDIF
              lastrow = MAX(firstrow,lastrow - 1)     && up one
              BOTT()
           ENDIF
           IF ! OFF()
              @ lastrow,left_col+4 SAY &wfields  && new bottom record
           ENDIF
           GOTO lastrec
           white = .F.
      ENDIF
   END SEQUENCE
RETURN M->deleted


PROC cursor
   * Check other kinds of keys (Not beginning with a letter)
   DO CASE
      CASE keypress = 5    && Up Arrow
         DO up_one

      CASE keypress = 24 .OR. keypress = 32   && Down or Space
         DO down_one

      CASE keypress = 1    && Home
         SKIP firstrow - cur_row
         cur_row = firstrow

      CASE keypress = 6    && End
         SKIP lastrow - cur_row
         cur_row = lastrow

      CASE keypress = 18    && PgUp
         SKIP -(bot_row-firstrow-(cur_row-firstrow))
         IF OFF() .OR. BOF()
            TOP()
         ENDIF
         mloop = .F.
         CLEAR TYPEAHEAD

      CASE keypress = 3     && PgDn
         SKIP bot_row-firstrow-(cur_row-firstrow)
         IF OFF()
             ?? CHR(7)
             SKIP -6
             IF OFF()
                BOTT()
             ENDIF
         ENDIF
         mloop = .F.
         CLEAR TYPEAHEAD

      CASE keypress = 23   && Ctrl-End
         BOTT()
         SKIP -(lastrow-firstrow-1)
         IF OFF()
            BOTT()
         ENDIF
         KEYBOARD CHR(6)  && to the very last record on screen
         mloop = .F.

      CASE keypress = 29   && Ctrl-Home
         TOP()
         mloop = .F.

      CASE keypress = 27 .OR. mchoice = [Q]
         mquit = .T.
         mloop = .F.

   ENDCASE
RETURN

* 

PROC up_one   &&  Used by browse routine
   CLEAR TYPEAHEAD
   SKIP -1
   IF OFF()
      ?? CHR(7)
      TOP()
      RETU
   ENDIF

   IF cur_row <= firstrow   && at top
      * shift the screen DOWN
      SCROLL(firstrow,left_col+1,bot_row-1,right_col-1,-1)  && up one row
      @ firstrow,left_col+4 SAY &wfields      &&  display the record
      lastrow = MIN(lastrow + 1, bot_row-1)
   ELSE
      cur_row = cur_row - 1
      IF CHANGED_KEY()
          RETURN      && will beep twice and re-list
      ENDIF
   ENDIF
RETURN

* 

PROC down_one   &&  Used by browse routine
   CLEAR TYPEAHEAD
   IF ROW() = lastrow .AND. lastrow < bot_row-1
      ?? CHR(7)
      RETURN    && do nothing
   ENDIF

   SKIP 1
   IF OFF()
      ?? CHR(7)
      BOTT()
      RETURN
   ENDIF

   IF cur_row >= bot_row-1   && already at the bottom of box
      * shift the screen UP
      SCROLL(firstrow,left_col+1,cur_row,right_col-1,1)  && down one row
      @ bot_row-1,left_col+4 SAY &wfields   && display new record
   ELSE   && move arrow one row down
      cur_row = cur_row + 1
      IF CHANGED_KEY()
          RETURN    && will beep twice and re-list
      ENDIF
   ENDIF
RETURN


FUNC fil_lock
     PARA wait
     IF FLOCK()
        RETU .T.           && locked
     ENDIF
     PRIV forever,old_screen
     wait = DEFAULT([wait],0)
     forever = (wait=0)
     old_screen = SAVESCR(24,0,24,79)

     DO WHIL forever .OR. wait > 0
        IF FLOCK()
           RESTSCR(old_screen)
           RETU .T.           && locked
        ENDIF
        IF mdevice $ [PF]
           SET DEVI TO SCRE
        ENDIF
        @ 24,0
        @ 24,0 SAY [Please wait.  Attempting to lock databases...]
        INKEY(.2)             && wait 1/5 second
        wait = wait - .2
     ENDDO
     IF mdevice <> [S]
        SET DEVI TO PRIN
     ENDIF
RETU .F.                      && not locked

FUNC rec_lock
     IF RLOCK()
        RETU .T.              && locked
     ENDIF
     PARA wait
     PRIV forever,old_screen
     wait = IF(TYPE([wait])=[U],0,wait)
     forever = (wait=0)
     old_screen = SAVESCR(24,0,24,79)
     DO WHIL (forever .OR. wait > 0)
        IF RLOCK()
           RESTSCR(old_screen)
           RETU .T.           && locked
        ENDIF
        IF mdevice $ [PF]
           SET DEVI TO SCRE
        ENDIF
        @ 24,0
        @ 24,0 SAY [Please wait.  Attempting to lock databases...]
        INKEY(.5) = 27        && wait 1/2 second or till esc key is pressed
        wait = wait - .5
     ENDDO
     IF mdevice = [P]
        SET DEVICE TO PRINT
     ENDIF
RETU .F.                      && not locked

* 
FUNC add_rec
  PARA wait
  PRIVATE added,old_screen,forever

  APPEND BLANK
  IF NETERR()
     *  could not lock, so try again:
     PRIV forever, old_screen
     added = .F.
     IF PCOUNT() = 0
        wait = 0
     ENDIF

     forever = (M->wait=0)
     old_screen = SAVESCR(24,0,24,79)
     IF mdevice = [P]
        SET DEVICE TO SCREEN
     ENDIF
     @ 24,0
     @ 24,0 SAY [Please wait.  Attempting to append record...]
     DO WHIL M->forever .OR. M->wait > 0
        APPEND BLANK         && automatic record lock occurs
        IF ! NETERR()
           added = .T.
           EXIT
        ENDIF
        INKEY(.5)   && wait 1/2 second
        wait = M->wait - .5
     ENDDO
     RESTSCR(old_screen)
     IF mdevice <> [S]
        SET DEVI TO PRINT
     ENDIF
  ELSE
     added = .T.
  ENDIF
RETURN M->added


* 
FUNC changed_key    &&  compares your screen with the actual database
   PRIV mreturn
   IF &wfields <> SCREENGRAB(cur_row,left_col+4,cur_row,last_col)
      ?? CHR(7)+CHR(7)
      mloop   = .F.
      mreturn = .T.
   ELSE
      mreturn = .F.
   ENDIF
RETU mreturn

* 

FUNC screengrab
     PARAM trow,lcol,brow,rcol
     PRIV mscreen,mlen
     mscreen = SAVESCREEN(trow,lcol,brow,rcol)
     mlen = LEN(mscreen)/2     && LEN(mscreen) is always even
     SCRUNCH(mscreen)          && FDI C routine (passes by reference)
RETU SUBS(mscreen,1,M->mlen)

