PAGE    60,132
;-------------------------------------------------------------------*
; A_STAT.ASM    Frank Sudia    1.6.88    
; Return user's logical station number on Novell network
;-------------------------------------------------------------------*
; Syntax:     n = station()    && returns an integer
;-------------------------------------------------------------------*
; (c) Copyright, 1987, by Analytical Resources Corporation
; 336 1/2 Maryland Ave., Washington, DC  20002  202-544-7458
;-------------------------------------------------------------------*
; Financial Dynamics, Inc. may transfer or license this program.
; Clipper is a trademark of Nantucket.
;-------------------------------------------------------------------*

NAME    A_STAT
PUBLIC    STATION

EXTRN   __RETNI:FAR        ; Clipper's integer "returner"

CODESEG    SEGMENT PARA PUBLIC
    ASSUME    CS:CODESEG

;-------------------------------------------------------------------*
STATION PROC FAR

    PUSH    BP    ; save environment
    MOV     BP,SP
    PUSH    DS
    PUSH    ES
    PUSH    SI
    PUSH    DI

    MOV     AH,220    ; get station number (note: DCh = 220)
    INT     21H    ; value returned as integer in AL

    XOR     AH,AH    ; zero-out the high byte

    PUSH    AX    ; put return value on the stack
    CALL    __RETNI    ; integer return function
    ADD     SP,2

    POP     DI    ; restore environment
    POP     SI
    POP     ES
    POP     DS
    POP     BP

    RET

STATION     ENDP

;-------------------------------------------------------------------*
CODESEG    ENDS        ; end code segment
    END        ; end program

;-------------------------------------------------------------------*
; EOF    A_STAT.ASM
