*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                                                                           *
*                      (703) 671 - 3003                                                     *
*****************************************************************************


*  Netprint.prg
PARAM mchoice        && their default printer choice
PRIVATE was_open, oldarea

*  called from initial, assumes SETUP is in use.
oldarea = SELE()
IF SELE([SETUP]) = 0
   DO open_file WITH [Setup]
   was_open = .F.
ELSE
   SELE setup
   was_open = .T.
ENDIF

mchoice = IIF(TYPE([M->mchoice])=[N], M->mchoice, 0)

M->printer1 = printer                                && from the setup.dbf
M->printer2 = IIF(TYPE([printer2])=[U], [], printer2)     && from the setup.dbf
M->printer3 = IIF(TYPE([printer3])=[U], [], printer3)     && from the setup.dbf     && from the setup.dbf

IF mchoice = 0     && let em pick one
   IF ! EMPTY(M->printer2+M->printer3)
       * allow selection of printers:
       mchoice = 1
       CO_PUSH()
       CO_CHG(c_menus)
       DO BOX WITH 17,55,3,18,[Printer: ]
       @ 20,58 PROMPT  M->printer1
       @ 21,58 PROMPT  M->printer2
       IF ! EMPTY(M->printer3)
          @ ROW()+1,58  PROMPT  M->printer3
       ENDIF
       SET MESSAGE TO
       @ 24,0
       MENU TO mchoice
       CO_POP()
       IF ESC()   && leave it!
          IF EMPTY(mprinter)   && (but be sure mprinter is defined)
             mprinter = [Printer]
          ENDIF
          RETURN
       ENDIF
   ENDIF
ENDIF

* convert to strings, using the Lotus format: \ indicates CHR()
DO CASE
   CASE mchoice = 2
      mprinter = TRIM(M->printer2)
      condense = pr_str(pcondens2)
      init     = pr_str(pinit2)
      IF TYPE([pbold2]) = [C]
         bold     = pr_str(pbold2)
      ENDIF
      IF TYPE([psideways2]) = [C]
         sideways = pr_str(psideways2)
      ENDIF

   CASE mchoice = 3
      mprinter = TRIM(M->printer3)
      condense = pr_str(pcondens3)
      init     = pr_str(pinit3)
      IF TYPE([pbold3]) = [C]
         bold     = pr_str(pbold3)
      ENDIF
      IF TYPE([psideways3]) = [C]
         sideways = pr_str(psideways3)
      ENDIF

   OTHERWISE
      mprinter = TRIM(M->printer1)
      condense = pr_str(pcondens)
      init     = pr_str(pinit)
      IF TYPE([pbold]) = [C]
         bold     = pr_str(pbold)
      ENDIF
      IF TYPE([psideways]) = [C]
         sideways = pr_str(psideways)
      ENDIF
ENDCASE

* if a batch file is available
IF FILE(mprinter+[.BAT])
   SET CONS OFF
   *  SET PRINTER TO &mprinter  && Needed for 3COM networks only.
   IF MEMORY(0) > 80
      RUN &mprinter    &&  loads DOS first, so takes lots of memory.
   ENDIF
   SET CONS ON
ENDIF

IF ! was_open
   USE
ENDIF

SELE (oldarea)
RETURN

