*  CO_PROCS.PRG      color procedures

*****************************************************************************
*              Copyright 1989, Financial Dynamics, Inc.                     *
*                      (703) 671 - 3003                                                     *
*                                                                           *
*   The color routines and methodology used in this library were developed  *
*   by Scott Hurlbert and Art Salinas from Quantum Data Systems in          *
*   Bakersfield California.                                                 *
*                                                                           *
*****************************************************************************

*
PROC stdcolor
   DO make_ntx WITH [stdcolor],[stdcolor],[videotype+co_group]
   DO open_file WITH [stdcolor],[stdcolor]
RETU


*
FUNCTION co_push
    co_stack = M->co_stack + SUBS([00]+LTRIM(STR(M->curr_grp,2,0)),-2) + STR(M->curr_attr,1)
RETURN []


*
FUNCTION co_pop
   M->curr_grp  = VAL(SUBS(M->co_stack,-3,2))
   M->curr_attr = VAL(SUBS(M->co_stack,-1,1))
   M->co_stack  = SUBS(M->co_stack,1,len(M->co_stack)-3)
   CO_CHG(M->curr_grp,M->curr_attr)
RETURN []

*
FUNCTION co_chg
   PARAMETERS grp,attr,component
   IF TYPE('color1[1]') = [U]
      RETURN (.T.)              && Color system not in use
   ENDIF
   M->attr= IF(TYPE([M->attr]) = [U], 1, M->attr)
   IF M->grp = 0
      M->newcolor  = [N/N,N/N]                && shadow color
      M->newcolor  = [N/N,N/N]                && shadow color
   ELSE
      PRIVATE arrayname,newcolor
      M->arrayname = 'color' + STR(M->attr,1)
      M->newcolor  = &arrayname[M->grp]
      IF TYPE([M->component]) <> [U]
         DO CASE
            CASE component = 1
               newcolor  = SUBS(newcolor,1,5)
            CASE component = 2
               newcolor  = SUBS(newcolor,7,5)
            CASE Component = 3
               newcolor  = SUBS(newcolor,-5)
         ENDCASE
      ELSE
         M->curr_grp  = M->grp
         M->curr_attr = M->attr
      ENDIF
   ENDIF
   SET COLOR TO &newcolor
RETURN []


PROC co_load    &&  loads colors from stdcolor
   PARA vid_type
   PRIVATE i,sel
   DO stdcolor       && open database
   SEEK M->vid_type

   IF ! FOUND()
      *    try using just MONO type.
      M->videotype = [MONO]
      M->vid_type  = M->videotype
      SEEK M->vid_type
   ENDIF

   IF FOUND()
      FOR M->i = 1 to 11
         color1[i] = CO_PARSE(stdcolor->co_sayget)
         color2[i] = CO_PARSE(stdcolor->co_frame)
         color3[i] = CO_PARSE(stdcolor->co_text)
         color4[i] = CO_PARSE(stdcolor->co_title)
         SKIP
      NEXT
   ELSE
      DO KBhit WITH  "Invalid monitor type: ("+M->vid_type+")"
   ENDIF
   USE
RETURN

FUNCTION co_parse
   PARAMETER incoming
   PRIVATE outgoing,s,c
   s = [/]
   c = [,]
   outgoing = SUBS(incoming,1,2)+s+SUBS(incoming,3,2)+c+;
              SUBS(incoming,5,2)+s+SUBS(incoming,7,2)+c+c+c+;
              SUBS(incoming,9,2)+s+SUBS(incoming,11,2)
RETURN (outgoing)

