/*
    CAROUSEL.PRG

    Implementing a Carousel of Database Browsers using Frankie Lib.
    Copyright (c) Angelito Dizon, 1993.  All Rights Reserved.

    Compile: clipper CAROUSEL /a /n /v /w
    Link:    blinker file CAROUSEL lib FRANKIE
      or:    rtlink  file CAROUSEL lib FRANKIE

    Database used:  Customer.dbf, Software.dbf and Hardware.dbf that
                    came with the Frankie Demo Package.

    Frankie lib is available in the CIS Clipper Forum, Lib 7 and in the
    Washington Clipper User Group (WACUG) BBS (301-464-1372) as FRANK.ZIP.
    A Norton Guides database is available as FRANKG.ZIP.  They may also
    exist in other BBSs bearing the same name or FRANK10?.ZIP,
    FRANK10?.ARJ, or the like.

    Question?  Contact Angelito Dizon [71165,1023] or via the WACUG BBS.
*/




#include "inkey.ch"

//---------
func main()
local aScn := ADsavescn( 0,0,24,79 )
local nArea := select()
local aEngines[3], nEngine, lContinue := .t.
local bConfig := {||ADdb_keys( {K_F10}, {||ADdb_exit()} ),;
                    ADdb_lbuttons( { {0,0,2,79}, {9,0,11,79}, {17,0,19,79} },;
                                   {|n| Xlbuts24(n, @nEngine)};
                                 ),;
                    ADdb_escape( {||lContinue := .f., .t.});
                 }

select 0
use customer
select 0
use hardware
select 0
use software

aEngines[1] := { select( "customer" ), customer->( ADdbview( 0,0,8,79, bConfig, .f. ) ) }
aEngines[2] := { select( "hardware" ), hardware->( ADdbview( 9,0,16,79, bConfig, .f. ) ) }
aEngines[3] := { select( "software" ), software->( ADdbview( 17,0,23,79, bConfig, .f. ) ) }

dispbegin()
for nEngine := 1 to len( aEngines )
    // Create browse engines and remember them
    ( aEngines[nEngine][1] )->( ADdb_display( aEngines[nEngine][2] ) )
next

ADchgcolor( 0,0,23,79, "W/N" )
ADsay(24,0, space(80), "N/W" )
setpos(24,0)
ADsay(24,0, "F10:NextBrowse   Esc:Exit       ",    "B/W" )
dispout( "Click Header of a Gray Browse to Move To It",   "GR+/W" )
dispend()

nEngine := 1

do while .t.
    // Activate one engine
    (aEngines[nEngine][1])->( ADdb_activate( aEngines[nEngine][2], .f. ) )

    if lContinue
        // change the engine to be activated next
        nEngine := if( nEngine == len( aEngines ), 1, nEngine + 1 )
        ADchgcolor( 0,0,23,79, "W/N" )
    else
        exit
    endif
enddo

dispbegin()
for nEngine := 1 to len( aEngines )
    ADdb_undisplay( aEngines[nEngine][2] )
    ADdb_kill(  aEngines[nEngine][2] )
next
dispend()

customer->( dbclosearea() )
hardware->( dbclosearea() )
software->( dbclosearea() )
select (nArea)
ADrestscn( aScn )
return NIL

//-----------------------------
static func Xlbuts24(n, nEngine)
nEngine := n - 1
ADm_rwait()     // wait for mouse button to be released
ADdb_exit()
return NIL    

