extrn	__PARC:far
extrn	__PARCLEN:far
extrn	__PARCSIZE:far
extrn	__PARDS:far
extrn	__PARINFA:far
extrn	__PARINFO:far
extrn	__PARL:far
extrn	__PARND:far
extrn	__PARNI:far
extrn	__PARNL:far
extrn	__RET:far
extrn	__RETC:far
extrn	__RETCLEN:far
extrn	__RETDS:far
extrn	__RETL:far
extrn	__RETND:far
extrn	__RETNI:far
extrn	__RETNL:far
;Macros to support Clipper extended function calls.
;  The Index parameter is only required for array elements.
;  If your parameter is the same as the default, it is not loaded.

;Initialize parameter stack count
CL_Pushed	=   0

;Miscellaneous Constants
CL_Undefined	=   0	;Parameter Typing
CL_Character	=   1
CL_Numeric	=   2
CL_Logical	=   4
CL_Date 	=   8
CL_Alias	=   16
CL_Pointer	=   32
CL_Memo 	=   65
CL_Word 	=   128
CL_Array	=   512

CL_True 	=   1	;Logical Values
CL_False	=   0

;Push required parameter for Clipper call, checks parameter existance
; tracks stack use
; Force_DGROUP causes DS save/restore to ensure DS = DGROUP during call
;   ds is saved on the stack before all arguments
;   Default is normally a register, but may be a memory reference.
macro	CL_Push     Default, Actual
    if Force_DGROUP NE 0
	if CL_Pushed EQ 0
	    push    ds			;;ds wasn't saved earlier
	endif
    endif
    ifb <Actual>
	display  "Required parameter missing."
	err
    else
	ifdifi <Default>, <Actual>
	    mov     Default, Actual
	endif
	push	Default
	CL_Pushed   =	CL_Pushed + 2
    endif
endm	CL_Push

;Push optional parameter for Clipper call, checks parameter existance,
; tracks stack use
;   Default is normally a register, but may be a memory reference.
macro	CL_PushOpt  Default, Actual
    ifnb <Actual>
	CL_Push <Default>, <Actual>
    endif
endm	CL_PushOpt

;Call Clipper Extend service routine and  clear the stack,
; Force_DGROUP causes DS save/restore to ensure DS = DGROUP during call
;   See macro Save_DGROUP and CL_Push
;   DGROUP must have been saved in Save_DGROUP
;   ds is saved on the stack before all arguments
macro	CL_Call     Routine
    if Force_DGROUP NE 0
	if CL_Pushed EQ 0
	    push    ds			;;ds wasn't saved earlier
	endif
	mov	ds, [Save_DGROUP]	;;point to DGROUP
    endif
    call    Routine
    if CL_Pushed NE 0
	add	SP, CL_Pushed		;;clear stack
	CL_Pushed   =	0
    endif
    ifnb <Force_DGROUP>
	pop	ds			;;restore normal ds
    endif
endm	CL_Call

;Save DGROUP value for Clipper Extend service routine calls
; Invoke on entry from Clipper before ds is changed
; Sets:
;   Save_DGROUP  = DS at entry to macro (DGROUP when called by Clipper)
; Defines:
;   Force_DGROUP = 0 = Don't force DGROUP in CL_Push/CL_Call
;		   1 = Force DGROUP in CL_Push/CL_Call, restore ds after call
macro	Save_DGROUP
    Force_DGROUP    =	    1
    mov [Save_DGROUP], ds
endm	Save_DGROUP

;Get number of elements in an array parameter
;  Returns in ax
;  Uses ax, dx
macro	CL_AParCount	ParameterNumber
    CL_ParInfa	ParameterNumber, 0
endm	CL_AParCount

;Get number of parameters passed
;  Returns in ax
;  Uses ax
macro	CL_ParCount
    CL_ParInfo	0
endm	CL_ParCount

;Get a String parameter
;   Returns pointer in dx:ax
;   Uses ax, dx
macro	CL_ParC     ParameterNumber, Index
    CL_PushOpt	dx, <Index>
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARC
endm	CL_ParC

;Get a String parameter's length
;   Returns length in ax
;   Uses ax, dx
macro	CL_ParCLen  ParameterNumber, Index
    CL_PushOpt	dx, <Index>
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARCLEN
endm	CL_ParCLen

;Get a String parameter's allocated size
; Parameter must be passed by reference (@).
;   Returns size in ax
;	0 = Constant was passed
;   Uses ax, dx
macro	CL_ParCSize ParameterNumber, Index
    CL_PushOpt	dx, <Index>
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARCSIZE
endm	CL_ParCSize

;Get a Date parameter as "YYYYMMDD"
;   Returns pointer in dx:ax
;   Uses ax, dx
macro	CL_ParDS    ParameterNumber, Index
    CL_PushOpt	dx, <Index>
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARDS
endm	CL_ParDS

;Get parameter array element type
;  Returns element description in ax
;  Uses ax, dx
macro	CL_ParInfa  ParameterNumber, Index
    CL_Push	dx, <Index>
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARINFA
endm	CL_ParInfa

;Get parameter type
;  Returns parameter description in ax
;  Uses ax
macro	CL_ParInfo  ParameterNumber
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARINFO
endm	CL_ParInfo

;Get a Logical parameter
;  Returns in ax
;  Uses ax, dx
macro	CL_ParL     ParameterNumber, Index
    CL_PushOpt	dx, <Index>
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARL
endm	CL_ParL

;Get a Numeric double precision parameter
;   Returns pointer to double precision parameter in dx:ax
;   Uses ax, dx
macro	CL_ParND    ParameterNumber, Index
    CL_PushOpt	dx, <Index>
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARND
endm	CL_ParND

;Get a Numeric integer parameter
;  Returns in ax
;  Uses ax, dx
macro	CL_ParNI    ParameterNumber, Index
    CL_PushOpt	dx, <Index>
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARNI
endm	CL_ParNI

;Get a Numeric long integer parameter
;  Returns in dx:ax
;  Uses ax, dx
macro	CL_ParNL    ParameterNumber, Index
    CL_PushOpt	dx, <Index>
    CL_Push	ax, <ParameterNumber>
    CL_Call	__PARNL
endm	CL_ParNL

;Indicate no return value
macro	CL_Ret
    CL_Call	__Ret
endm	CL_Ret

;Return a String
;   Uses dx:ax
macro	CL_RetC     Segment, Offset
    CL_Push	dx, <Segment>
    CL_Push	ax, <Offset>
    CL_Call	__RETC
endm	CL_RetC

;Return a String with length
;   Uses dx:ax, cx
macro	CL_RetCLen  Segment, Offset, Length
    CL_Push	cx, <Length>
    CL_Push	dx, <Segment>
    CL_Push	ax, <Offset>
    CL_Call	__RETCLEN
endm	CL_RetCLen

;Return a Date as "YYYYMMDD"
;   Uses dx:ax
macro	CL_RetDS    Segment, Offset
    CL_Push	dx, <Segment>
    CL_Push	ax, <Offset>
    CL_Call	__RETDS
endm	CL_RetDS

;Return a Logical value (true = non-zero (normally 1))
;  Uses ax
macro	CL_RetL     Value
    CL_Push	ax, <Value>
    CL_Call	__RETL
endm	CL_RetL

;Return a Numeric double precision value
;   Uses dx:cx:bx:ax
macro	CL_RetND    Word3, Word2, Word1, Word0
    CL_Push	dx, <Word3>
    CL_Push	cx, <Word2>
    CL_Push	bx, <Word1>
    CL_Push	ax, <Word0>
    CL_Call	__RETND
endm	CL_RetND

;Return a Numeric integer
;  Uses ax
macro	CL_RetNI    Value
    CL_Push	ax, <Value>
    CL_Call	__RETNI
endm	CL_RetNI

;Return a Numeric long integer
;  Uses dx:ax
macro	CL_RetNL    MSW, LSW
    CL_Push	dx, <MSW>
    CL_Push	ax, <LSW>
    CL_Call	__RETNL
endm	CL_RetNL

