**************************************************************************
**  EST.PRG - DBF/NDX/NTX size estimator                                **
**  Author - David R. Alison                                            **
**  This program is designed to generate a report that                  **
**  will detail the potential maximum size of a data base               **
**  file with a defined record growth.  It is a very good way           **
**  to learn how to use the achoice function.                           **
**                                                                      **
**  To compile the program, simply have both EST.PRG (this file) and    **
**  UTILITY.PRG in the same directory.  Requires Summer 87              **
**                                                                      **
**  If you like the program, please drop me a line.                     **
**                                                                      **
**  Source ID - BFB287                                                  **
**  Compuserve - 71121,3526                                             **
**************************************************************************

**  Updated by DRA - 05/13/88 - 12:58pm

set procedure to utility

**  Set up so that program restores original screen when finished
public screen1, mel, mre   && For use with Achoice Function
mrow = row()
save screen to screen1

**  Set up the color memvars
public c_normal, c_bright, c_uline, c_blink, c_reverse
if iscolor()
   c_normal = 'w/n,n/w,,,n/w'
   c_bright = 'w+/n'
   c_uline = 'n/w,w/n'
   c_blink = 'w+*/n'
   c_reverse = 'n/w,w/n'
   c_odd = 'w+/n,bg+/b,,,w/n'
else
   c_normal = 'w,u,,,u'
   c_bright = 'w+/n,n/w'
   c_uline = 'u'
   c_blink = 'w+*/n'
   c_reverse = 'i'
   c_odd = 'w+/n,i/n,,,w/n'
endif
set cursor off          && Thanks for this function, Nantucket!

do while 1 = 1          && Main program loop

**  Check for dbf's
dbf_count = adir("*.dbf")
if dbf_count < 1
   ErrorBeep()
   color('br')
   ? "ERROR - No DBF's found."
   color('n')
   set cursor on
   cancel
endif

**  Load dbf data into an array
declare dbf_file[dbf_count], dbf_size[dbf_count], dbf_date[dbf_count]
declare dbf_time[dbf_count], dbf_tot[dbf_count]
adir("*.dbf",dbf_file,dbf_size,dbf_date,dbf_time)

**  Load all those seperate arrays we created in the section above into
**  one big text array (dbf_tot) for use with Achoice
i = 1
do while i < (dbf_count + 1)
   dbf_tot[i] = substr((dbf_file[i]+space(15)),1,12)+'  '+str(dbf_size[i],9)+;
   '  '+dtoc(dbf_date[i])+'  '+dbf_time[i]
   i = i + 1
enddo

**  Set up the initial screen
clear
color('n')
@ 1,1 say 'Ŀ'
@ 2,1 say ' EST - dBase file size estimator                         by David R. Alison '
@ 3,1 say ''
@ 6,1 say '                ͻ'
@ 7,1 say '                  File name      Size       Date      Time   '
@ 8,1 say '                ͹'
@ 9,1 say '                                                             '
@ 10,1 say '                                                             '
@ 11,1 say '                                                             '
@ 12,1 say '                                                             '
@ 13,1 say '                                                             '
@ 14,1 say '                                                             '
@ 15,1 say '                                                             '
@ 16,1 say '                                                             '
@ 17,1 say '                                                             '
@ 18,1 say '                                                             '
@ 19,1 say '                ͹'
@ 20,1 say '                 Please select the file you wish to estimate '
@ 21,1 say '                  and press Enter to continue.  (Esc quits)  '
@ 22,1 say '                ͼ'

**  Bold some parts of the screen
color('br')
@ 2,3 say 'EST'
@ 20,19 say 'Please select the file you wish to estimate'
@ 21,20 say 'and press Enter to continue.  (Esc quits)'
color('n')

**  Select the file to work on with the Achoice function
mchoice = 0
color('o')
mchoice = achoice(9,19,18,61,dbf_tot)
color('n')

**  If no data base is selected, restore the original screen and stop
**  the program
if mchoice = 0
   exit
endif

**  The database to estimate is loaded into "file2est" and is "used"
file2est = dbf_file[mchoice]
use &file2est

**  Select fields to index on

**  Declare the array's for the index information.  This is set up
**  very similar to the method for selecting a dbf.
**  Most of the array's are obvious.  The others are...
**  fldtot   : array used by achoice() for selection purposes.  Contains
**             all the data for that index field.
**  fldavail : This is used by achoice() to determine if that index
**             field is available for user selection.
declare fldname[fcount()], fldtype[fcount()], fldwidth[fcount()]
declare flddec[fcount()], fldtot[fcount()], fldavail[fcount()]

**  Use afields() to load the field information into the proper arrays
afields(fldname, fldtype, fldwidth, flddec)

**  Since afields only loads the type of fields as C, D, L, etc..
**  we are going to use a case selection to insert the full name
**  of the field into the array...
i = 1
do while i < (fcount() + 1)             && Loop through all the fields
   do case
        case upper(fldtype[i]) = 'C'
        ftype = 'Character'
        
        case upper(fldtype[i]) = 'N'
        ftype = 'Numeric  '
        
        case upper(fldtype[i]) = 'L'
        ftype = 'Logical  '
        
        case upper(fldtype[i]) = 'M'
        ftype = 'Memo     '
        
        case upper(fldtype[i]) = 'D'
        ftype = 'Date     '
   endcase
   
   **  Here we actually load the information from the array's into
   **  the fldtot array, which will be used for the field selection
   fldtot[i] = substr(substr((fldname[i]+space(15)),1,10)+'  '+ftype+;
   '  '+str(fldwidth[i],3)+'  '+str(flddec[i],3)+'         ',1,35)

   **  Do not allow memo fields to be indexed
   if ftype = 'Memo     '
        fldavail[i] = .f.
   else
        fldavail[i] = .t.
   endif
   i = i + 1

enddo

**  Display the screen for field selection
@ 6,17 clear to 22,64
@ 6,21 say 'ͻ'
@ 7,21 say ' Field Name  Type     Width  Dec    '
@ 8,21 say '͹'
@ 9,21 say '                                     '
@ 10,21 say '                                     '  
@ 11,21 say '                                     '
@ 12,21 say '                                     '
@ 13,21 say '                                     '
@ 14,21 say '                                     '
@ 15,21 say '                                     '
@ 16,21 say '                                     '
@ 17,21 say '                                     '
@ 18,21 say '                                     '
@ 19,21 say '͹'
@ 20,21 say ' Press Enter to check off each field '
@ 21,21 say ' that will be indexed.  Esc exits... '
@ 22,21 say 'ͼ'
color('o')

**  mel & mre are public memvars that are modified by the achoice
**  udf "getfield".  A udf is used because we are only going to
**  flag the field with a  mark.  This way the user can select
**  several fields.  The enter key acts as a toggle for the flag.
**  If a flag is already there, it removes it and vice a versa.
mel = 1
mre = 1

**  Loop through the achoice selection.  Since achoice terminates
**  at the enter key, we are going to call the UDF "getfield".  This
**  function merely changes the public memvars mel & mre to reflect
**  the position of the cursor within achoice.
do while 1 = 1
   mchoice = achoice( 9, 23, 18, 58, fldtot, fldavail, "getfield", mel, mre )
   do case

        **  Checks to see if the last key the user selected was
        **  the enter key.  If so, modify the fldtot array element
        **  to either add/remove the  mark.  Then loop back through
        **  the do while loop and call another achoice.
        case lastkey() = 13
        if substr(fldtot[mchoice],34,1) = ''
            fldtot[mchoice] = substr(fldtot[mchoice],1,33)+' '
        else
            fldtot[mchoice] = substr(fldtot[mchoice],1,33)+''
        endif
        
        **  If the last key pressed was the Esc key, exit the loop.
        case lastkey() = 27
        exit
   endcase
enddo

**  Get the type of index (.ndx or .ntx)
@ 7,22 clear to 7,58
@ 9,22 clear to 18,58
@ 20,22 clear to 21,58
@ 7,22 say '        Database Index Type'
@ 20,23 say 'Please select the type of index and'
@ 21,22 say '            press Enter'

**  Declare the arrays for the index selection.  Since we are going
**  to re-use this array for the report destination we will declare
**  5 elements, using the tmp array as our "available" array.
declare indextyp[5], tmp[5]
indextyp[1] = '     dBase III plus - .NDX type    '
indextyp[2] = '                                   '
indextyp[3] = '        Clipper - .NTX type        '
indextyp[4] = '                                   '
indextyp[5] = '                                   '
tmp[1] = .t.    &&  Skip over the blank spaces
tmp[2] = .f.
tmp[3] = .t.
tmp[4] = .f.
tmp[5] = .f.

**  Activate achoice and get the index type
mindex = 1              &&  Memvar used for the index type
mindex = achoice( 10, 23, 18, 58, indextyp, tmp )

if mindex = 0           &&  If no index type is selcted, loop back
   loop
endif

**  Display a Please Wait sign to the 8088 users...
@ 7,22 clear to 7,58
color('bl')
@ 7,22 say '          ** Please Wait **        '
color('o')

**  Declare two arrays and load them with index size data.
**  ndxsz is where the results of the indexsz function are stored
**  ndxamt is for the number of records in that particular index
**  ndxbyte is for the bytes in numeric format
declare ndxsz[10], ndxamt[10], ndxbyte[10]
ndxamt[1] = 10          &&  10 records
ndxamt[2] = 50          &&  50 records, etc...
ndxamt[3] = 100
ndxamt[4] = 500
ndxamt[5] = 1000
ndxamt[6] = 5000
ndxamt[7] = 10000
ndxamt[8] = 50000
ndxamt[9] = 100000
ndxamt[10] = 500000

**  Start the loop for index size calculation.  r is our
**  loop counter for the ten record amounts
r = 1
do while r < 11
   i = 0
   ndxtot = 0           && Store the total bytes for this record here

   **  Loop through each index for this number of records and add
   **  the total amount to ndxtot if the field has been selected
   do while i < fcount()
      i = i + 1
      if substr(fldtot[i],34,1) = ''
          ndxtot = ndxtot + indexsz( fldwidth[i], ndxamt[r], mindex )
      endif
   enddo
   ndxsz[r] = transform(ndxtot,'9,999,999,999')
   ndxbyte[r] = ndxtot
   r = r + 1
enddo

**  Select the report destination
@ 7,22 clear to 7,58
@ 9,22 clear to 18,58
@ 20,22 clear to 21,58
@ 7,22 say '         Report Destination'
@ 20,23 say ' Select the report destination and'
@ 21,22 say '   press Enter.  Esc cancels...'

**  Determine the output file name from the file2est memvar
outputf = substr(file2est,1,rat('.',file2est))+'out'

**  Determine the length of the right and left borders for the
**  "output to file" selection.  This is how we center the
**  selection in achoice.
border1 = space( int( ((35 - len('Text File ['+upper(outputf)+']')) / 2) ))
border2 = space( 35 - len('Text File ['+upper(outputf)+']') - len(border1))

**  Load the menu selections into the proper arrays
indextyp[1] = '           Printer [PRN]           '
indextyp[2] = '                                   '
indextyp[3] = border1+'Text File ['+upper(outputf)+']'+border2
indextyp[4] = '                                   '
indextyp[5] = '                                   '

**  Again, limit the choice to 1 and 3; no blank spaces
tmp[1] = .t.
tmp[2] = .f.
tmp[3] = .t.
tmp[4] = .f.
tmp[5] = .f.

destin = 1       &&  This memvar is where the report will be printed
destin = achoice( 10, 23, 18, 58, indextyp, tmp )

if destin = 0    &&  They don't want to print?  Geez...
   loop
endif

color('n')

**  Generate the report
set console off
if destin = 1
   set margin to 3
   set print on
else
   set alternate to &outputf
   set alternate on
endif

? 'EST - Database file size estimator                  by David Alison'
? '==================================================================='

**  Determine the type of index and print the results...
if mindex = 1
     ? 'Database: '+upper(substr(file2est+space(12),1,12))+'   Index type: dBase III plus (.NDX)'
else
     ? 'Database: '+upper(substr(file2est+space(12),1,12))+'   Index type: Clipper (.NTX)'
endif
?
? 'Indexes on:         Field Name    Width'
? '                    ==========    ====='
   
**  Loop through the selected index fields and print the field names
i = 0
do while i < fcount()
    i = i + 1
    if substr(fldtot[i],34,1) = ''
        ? space(20) + substr(fldname[i] + space(15), 1, 15) + str(fldwidth[i],3)
    endif
enddo
?
? 'Listed below is the maximum disk space required for this database'
? 'file and the various indexes.  This is an estimate only.  Since'
? 'an index is dynamic, calculating the exact size is not possible.'
?
? '                          |----- Disk space required in bytes -----|'
?
? 'Number of records         Data File        Indexes         Total'
? '=================        =============  =============  ============='
? '        10 . . . . . . . '+dbfsize(10)+'  '+ndxsz[1]+'  '+totbyte(10,ndxbyte[1])
? '        50 . . . . . . . '+dbfsize(50)+'  '+ndxsz[2]+'  '+totbyte(50,ndxbyte[2])
? '       100 . . . . . . . '+dbfsize(100)+'  '+ndxsz[3]+'  '+totbyte(100,ndxbyte[3])
? '       500 . . . . . . . '+dbfsize(500)+'  '+ndxsz[4]+'  '+totbyte(500,ndxbyte[4])
? '     1,000 . . . . . . . '+dbfsize(1000)+'  '+ndxsz[5]+'  '+totbyte(1000,ndxbyte[5])
? '     5,000 . . . . . . . '+dbfsize(5000)+'  '+ndxsz[6]+'  '+totbyte(5000,ndxbyte[6])
? '    10,000 . . . . . . . '+dbfsize(10000)+'  '+ndxsz[7]+'  '+totbyte(10000,ndxbyte[7])
? '    50,000 . . . . . . . '+dbfsize(50000)+'  '+ndxsz[8]+'  '+totbyte(50000,ndxbyte[8])
? '   100,000 . . . . . . . '+dbfsize(100000)+'  '+ndxsz[9]+'  '+totbyte(100000,ndxbyte[9])
? '   500,000 . . . . . . . '+dbfsize(500000)+'  '+ndxsz[10]+'  '+totbyte(500000,ndxbyte[10])

if destin = 1
   set print off
   eject
else
   set alternate off
   close alternate
endif
set console on

loop
   
**  End of the main loop of the program...
exit            &&  Just in case we missed something
enddo

**  Put the screen back on straight...
set cursor on
restore screen from screen1
@ mrow,1 say ''
cancel