// DOSCmdLine
//
// Author   : ShaunB.. (Shaun Botha)
// CIS      : 70043,2641
// Purpose  : Return DOS command line parameters
// Notes    : Clipper breaks the DOS command line into separate parameters
//            which are passed to the main procedure of the program. This
//				  function allows you to process the entire command line yourself
//            instead of having Clipper doing it for you.  Note that the
//				  parameters passed by Clipper to the program remain unchanged.
//
// Operation: When DOS loads a program it creates a PSP (Program Segment Prefix)
//				  which stores a bunch of info about the program.  DOS stores the
//				  command line parameters (everything after the program name) in
//				  the PSP starting at position 129.  Position 128 contains the
//				  length of the parameter string.  The parameters are
//				  terminated by a Carriage-Return/Line-Feed (CR-LF) pair if
//            the parameter string is less than the max of 127 characters.
//
// Usage    : cCmd := DOSCmdLine()  -- see the example below
// Compile  : Clipper DOSCMDLN /n/m/w
// Requires : NANFOR.LIB

#include "ftint86.ch"

#define CMDLEN_OFS		128		// Offset in PSP of len of command line parms
#define CMDLINE_OFS		129      // Offset in PSP of command line parms

#ifdef TESTING
procedure main()
	local cCmdLine

	cCmdLine := DOSCmdLine()
	? cCmdLine
return
#endif


function DOSCmdLine()
	local aRegs[10], nPspSeg, nCmdLen, cCmdLine, x

	// Function 62h of INT 21h returns the segment address of the program's PSP
	aRegs[AX] := makeHi(ft_hex2Dec("62"))
	ft_int86(33, aRegs)

	// Get the segment of the PSP returned by function 62h into BX.  The PSP
	// itself starts at offset 0 in the segment.
	nPspSeg := aRegs[BX]

	// Find length of parameters.
	nCmdLen := ft_peek(nPspSeg, CMDLEN_OFS)

	// Copy the command line parameters.  We'll start one character ahead of
	// the offset as the first character is always a space.
	cCmdLine := ""
	for x := 1 to nCmdLen
		cCmdLine += chr(ft_peek(nPspSeg, CMDLINE_OFS+x))
	next x

	// Strip last character if it's a CR character
	if right(cCmdLine, 1) == chr(13)
  		cCmdLine := left(cCmdLine, len(cCmdLine)-1)
  	endif
return cCmdLine
