/*-------------------------------------------------------------------------*/
// PROGRAM: DOMAIN.PRG
// VERSION: Clipper 5.01
// PURPOSE:
// These two functions will allow you TO MODIFY the config.sys and
// autoexec.bat files.  Minor modifications will allow any changes
// you wish TO be made TO either FILE .  This program was written to allow
// us TO add "SET DOMAIN=RIG" and ensure that environment space was
// adequate FOR the few environment variables we USE on our network.
// DATE:  Decemeber 30, 1991
// AUTHOR: Donald Reese
// NOTES:  Compile WITH /a/n/w  /b can be added FOR debugger info
//         You could make this a generic FUNCTION and pass PARAMETERS TO
//         it.  You could also add error checking to ensure that the
//         new FILES are written correctly.
/*-------------------------------------------------------------------------*/

#include"fileio.ch"

FUNCTION MAIN()
CONFIG()                        //FUNCTION TO MODIFY config.sys file
AUTO()                          //FUNCTION TO MODIFY Autoexec.bat file
RETURN NIL

/*-------------------------------------------------------------------------*/

FUNCTION CONFIG()
local cHandle,cOutfile,nFilelen,cString,nLines  // variables TO handle FILE
local aNewfile := {}                            // array FOR each line
local lCflag := .t.                             // Did we FIND what we needed
local lChanged := .f.                           // and did we CHANGE the FILE
local cCr := CHR(13)                            // carriage RETURN
local cLf := CHR(10)                            // linefeed
local cCrlf := cCr+cLf                          // guess

cHandle := FOPEN("C:\CONFIG.SYS", 2)            // open the FILE
nFilelen := FSEEK(cHandle,0,2)                  // how many bytes

FSEEK(cHandle,0,0)                              // begining of the FILE
DO WHILE FSEEK(cHandle,0,1) < nFilelen          // process the whole thing
   cString := FRELIN(cHandle)                   // READ in one line
   IF LEN(cString) <> 0
      AADD(aNewfile,cString)                     // Add it TO the array
   ENDIF
ENDDO
FOR nLines := 1 TO LEN(aNewfile)                // Check it FOR content
   IF "SHELL" $ UPPER(aNewfile[nLines])
      IF VAL(SUBSTR(aNewfile[nLines],AT("E:",aNewfile[nLines])+2)) < 768
         aNewfile[nLines] := "SHELL=C:\COMMAND.COM /P /E:768"
         lChanged := .t.
      ENDIF
      lCflag = .f.
   ENDIF
NEXT
IF lCflag                                       // Didn't find it?
   AINS(aNewfile,2)
   aNewfile[2] := "SHELL=C:\COMMAND.COM /P /E:768"  // Add it!!
   lChanged := .t.
ENDIF
IF lChanged                                    // Did we CHANGE it?
   cOutfile := FCREATE("C:\CONFIG.SYS", 0)
   FOR nLines := 1 TO LEN(aNewfile)
      FWRITE(cOutfile,aNewfile[nLines]+cCrlf)  // Write it back
   NEXT
   FCLOSE(cOutfile)                            // CLOSE the FILE
ENDIF
RETURN NIL

/*-------------------------------------------------------------------------*/

FUNCTION AUTO()
local cHandle,cOutfile,nFilelen,cString,nLines
local aNewfile := {}
local lCflag := .t.
local lChanged := .f.
local cCr := CHR(13)
local cLf := CHR(10)
local cCrlf := cCr+cLf

cHandle := FOPEN("C:\AUTOEXEC.BAT", 2)
nFilelen := FSEEK(cHandle,0,2)

FSEEK(cHandle,0,0)
DO WHILE FSEEK(cHandle,0,1) < nFilelen
   cString := FRELIN(cHandle)
   IF LEN(cString) <> 0
      AADD(aNewfile,cString)
   ENDIF
ENDDO
FOR nLines := 1 TO LEN(aNewfile)
   IF "DOMAIN" $ UPPER(aNewfile[nLines])
      lCflag = .f.
   ENDIF
NEXT
IF lCflag
   AADD(aNewfile,NIL)
   AINS(aNewfile,2)
   aNewfile[2] := "SET DOMAIN = RIG"
   lChanged := .t.
ENDIF
IF lChanged
   cOutfile := FCREATE("C:\AUTOEXEC.BAT", 0)
   FOR nLines := 1 TO LEN(aNewfile)
      FWRITE(cOutfile,aNewfile[nLines]+cCrlf)
   NEXT
   FCLOSE(cOutfile)
ENDIF
RETURN NIL

/*-------------------------------------------------------------------------*/
/* Parse a line until a carriage RETURN or line feed is found and then     */
/* RETURN that portion as the string TO be added TO the array              */

FUNCTION frelin(cHandle)
local cCharacter, cString
local cLf := CHR(10)
local cCr := CHR(13)
cString = []
DO WHILE .T.
   cCharacter := FREADSTR(cHandle,1)
   IF LEN(cCharacter) = 0 .OR. cCharacter = CHR(26)
      EXIT
   ENDIF
   IF cCharacter = cCr
      cCharacter := FREADSTR(cHandle,1)
      IF cCharacter = cLf
         EXIT
      ELSE
         cString := cString + cCr + cCharacter
      ENDIF
   ELSE
      cString := cString + cCharacter
   ENDIF
ENDDO
RETURN (cString)
/*-------------------------------------------------------------------------*/
// End of Program
