        SUBTTL         SUBTITLE FOR PLIST.EXE TESTING

;******************************************************************
;
;         MACHINE.ASM
;
;         These are some general functions that are used to
;         check the type of processor and I/O devices.
;         They are written to be used with a Lattice C program.
;
;                   Available functions are:
;                   1.) machine() - Check machine ID byte
;                   2.) equip() - Check the equipment flags
;
;******************************************************************

large     equ       0         ; 1 == Large model, 0 == Small

          IF LARGE
          INCLUDE D:\C\MAC\LM8086.MAC
          ELSE
          INCLUDE D:\C\MAC\SM8086.MAC
          ENDIF

;******************************************************************
;
;         Start of code segment for all functions
;
;******************************************************************

          PSEG
          PUBLIC MACHINE , EQUIP

          SUBTTL        MACHINE
          PAGE

;******************************************************************
;
;         MACHINE()
;
;       Read the machine ID byte stored at F000:FEEE
;       and return it to a C program.
;
;         C calling convention:         id = machine( void ) ;
;
;******************************************************************

id_base         equ     0f000h          ; segment for byte
id_offset       equ     0fffeh          ; Offset for byte


          IF LPROG
MACHINE   PROC      far
          ELSE
MACHINE   PROC      near
          ENDIF

          PUSH      BP
          PUSH      DS
          PUSH      ES
          MOV       AX,CS
          MOV       DS,AX
          MOV       dx,id_base
          MOV       es,dx
          MOV       AL,ES:id_offset
          XOR       AH,AH
          POP       ES
          POP       DS
          POP       BP
          RET
MACHINE ENDP

        SUBTTL  EQUIP() - Read And Return Equipment Byte Flag
                PAGE

;******************************************************************
;
;         This next function reads the equipment flags on the system
;         board.  A 16 bit value is return by the BIOS.  Decoding
;         is as follows:
;
;         bit       Definition
;         0         If 1 then diskettes are present
;         1         For PC,XT,AT 1 == 80x7 present
;         2-3       For Non-AT 11 == 64k base RAM
;         4-5       Video adapter type. 11 == Monochrome Card
;                                       10 == 80x25 Color Card
;                                       01 == 40x25 Color Card
;         6-7       Number of diskette drives if bit 0 == 1
;         8         Used on PCjr only
;         9-11      Number of serial adapters
;         12        On Non-AT 1 == game port attached
;         13        Used by PCjr
;         14-15     Number of parellel adapters
;
;******************************************************************


;******************************************************************
;
;         EQUIP()
;
;         Read the equipment byte flags and return the values.
;
;         C calling convention:         val = equip( void ) ;
;
;******************************************************************

          IF LPROG
equip     PROC      far
          ELSE
equip     PROC      near
          ENDIF

          PUSH      BP
          INT       11h                 ; Call ROM BIOS for flags
          POP       BP
          RET
equip     ENDP



          ENDPS
          END


;
;	END OF SAMPLE.ASM
;
;lastline