/*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  Function:  Calc()

   Purpose:  Pop-up Adding Machine

    Syntax:  At or near the beginning of your main program file,
             insert the following commands:
               SET KEY n TO CALC  where "n" is the scan code
                                  returned by INKEY() for the key
                                  you want to activate the
                                  calculator.

      Note:  [ESC] key exits the calculator.
             [ENTER] key is the Total key.
             [DELETE] key deletes numeric key presses in LIFO order.
             This program emulates an adding machine NOT a calculator.
             They don't work the same way.
             You must always press the decimal key to set its position,
             if you don't want the number you entered divided by 100.
             The "SET KEY n TO proc" command only works during wait states,
             so you'll have to add some code to your programs, if you
             use INKEY().

  Modified:  by Tim Dettmering
             From Rodgers Moore Jr. program CALCULTR.PRG
             Updated for Clipper 5.01 by changing public to static
             Added color routines for the different operations
             Added a clearing key for the scrolling area
             Added a shadow from Clipper Source Box.prg
             Added SaveEnv() and RestEnv() - this Saves the screen, cursor
                   and color into a stack, and sets a new color.  This can
                   can be done seperatly if these functions are not available.

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
#include "box.ch"

STATIC CHAR := ' '

FUNCTION CALC()
  LOCAL VALID
  LOCAL FINI := .F.
  LOCAL ACCUM := 0.0
  LOCAL NUM := 0
  LOCAL OldScrn,cTot

  SaveEnv(.T.,,"W/B")
  @ 2,23,21,75 BOX B_SINGLE + " "
  BoxShadow(2,23,21,75) // From Clippper Source BOX.PRG
  OldScrn := SaveScreen(3,53,20,74)
  @  3,47 TO 20,47
  @  2,47 SAY ''
  @ 21,47 SAY ''
  @  3,24 TO 5,46
  @  6,24 TO 8,28
  @  6,30 TO 8,34
  @  6,36 TO 8,40
  @  6,42 TO 8,46
  @ 9,24 TO 11,28
  @ 9,30 TO 11,34
  @ 9,36 TO 11,40
  @ 9,42 TO 14,46
  @ 12,24 TO 14,28
  @ 12,30 TO 14,34
  @ 12,36 TO 14,40
  @ 15,24 TO 17,28
  @ 15,30 TO 17,34
  @ 15,36 TO 17,40
  @ 15,42 TO 20,46
  @ 18,24 TO 20,34
  @ 18,38 TO 20,40
  @ 7,26 SAY 'C'
  @ 7,32 SAY '/'
  @ 7,38 SAY '*'
  @ 7,44 SAY '-'
  @ 10,26 SAY '7'
  @ 10,32 SAY '8'
  @ 10,38 SAY '9'
  @ 11,44 SAY '+'
  @ 13,26 SAY '4'
  @ 13,32 SAY '5'
  @ 13,38 SAY '6'
  @ 16,26 SAY '1'
  @ 16,32 SAY '2'
  @ 16,38 SAY '3'
  @ 17,44 SAY 'T'
  @ 19,29 SAY '0'
  @ 19,39 SAY ''
  DO WHILE !FINI
  SetColor("N/W")
  @ 4,25 SAY ACCUM PICT '99,999,999,999,999.99'
    NUM = NUMINPUT(NUM)
    SetColor("W/B")
    DO CASE
       CASE CHAR = '+'
         SetColor("N/W")
         @ 11,44 SAY '+'
         ACCUM = ACCUM + NUM
         SCROLL(3,53,20,74,1)
         SetColor("W/B")
         @ 20,53 SAY NUM PICT '99,999,999,999,999.99'
         @ 20,74 SAY '+'
         @ 11,44 SAY '+'
       CASE CHAR = '-'
         SetColor("N/W")
         @ 7,44 SAY '-'
         ACCUM = ACCUM - NUM
         SCROLL(3,53,20,74,1)
         SetColor("R/B")
         @ 20,53 SAY NUM PICT '99,999,999,999,999.99'
         @ 20,74 SAY '-'
         SetColor("W/B")
         @ 7,44 SAY '-'
       CASE CHAR = '*'
         SetColor("N/W")
         @ 7,38 SAY '*'
         ACCUM = ACCUM * NUM
         SCROLL(3,53,20,74,1)
         SetColor("G+/B")
         @ 20,53 SAY NUM PICT '99,999,999,999,999.99'
         @ 20,74 SAY '*'
         SetColor("W/B")
         @ 7,38 SAY '*'
       CASE CHAR = '/' .AND. ACCUM <> 0
         SetColor("N/W")
         @ 7,32 SAY '/'
         ACCUM = ACCUM / NUM
         ACCUM = INT((ACCUM + 0.005)*100)/100
         SCROLL(3,53,20,74,1)
         SetColor("GR+/B")
         @ 20,53 SAY NUM PICT '99,999,999,999,999.99'
         @ 20,74 SAY '/'
         SetColor("W/B")
         @ 7,32 SAY '/'
       CASE CHAR = CHR(13)
         SetColor("N/W")
         @ 17,44 SAY "T"
         SCROLL(3,53,20,74,1)
         cTot := If(ACCUM > 0,"N/B","R/B")
         SetColor(cTot)
         @ 20,53 SAY ACCUM PICT '99,999,999,999,999.99'
         @ 20,74 SAY 'T'
         ACCUM = 0.0
         NUM = 0
         SetColor("W/B")
         @ 17,44 SAY "T"
       CASE Upper(CHAR) = "C"
         SetColor("N/W")
         @ 7,26 SAY "C"
         RestScreen(3,53,20,74,OldScrn)
         ACCUM = 0.0
         NUM = 0.0
         SetColor("W/B")
         @ 7,26 SAY "C"
      CASE CHAR = CHR(27)
         FINI = .T.
    ENDCASE
  ENDDO
  CHAR = ' '
  RestEnv()
RETURN NIL


/*:::::::::::::: NUMBER INPUT FUNCTION FOR ADDING MACHINE :::::::::::::::::*/
FUNCTION NUMINPUT(VALUE)
  LOCAL PLACE := 1
  LOCAL NEW := .T.
  LOCAL DECIMAL := .F.
  LOCAL THRU := .F.
     SetColor("N/W")
     DO WHILE !THRU
       @ 4,43 SAY ''
       T_NUM = INKEY()
       IF T_NUM > 0
         CHAR = CHR(T_NUM)
         IF CHAR $ '0123456789'
           SetColor("N/W")
           IF CHAR = '0'
             @ 19,29 SAY '0'
           ELSE
             @ 16-(INT((VAL(CHAR)-1)/3)*3),26+(((VAL(CHAR)-1)%3)*6) SAY CHAR
           ENDIF
           IF NEW
             VALUE = VAL(CHAR)
             NEW = .F.
           ELSE
             IF !DECIMAL
               VALUE = (VALUE * 10) + VAL(CHAR)
             ELSE
               IF PLACE = 1
                 PLACE = 2
                 VALUE = INT(VALUE) + (VAL(CHAR)/10)
               ELSE
                 VALUE = (INT(VALUE*10)/10) + (VAL(CHAR)/100)
               ENDIF
             ENDIF
           ENDIF
           @ 4,25 SAY VALUE PICT '99,999,999,999,999.99'
           SetColor("W/B")
           IF CHAR = '0'
             @ 19,29 SAY '0'
           ELSE
             @ 16-(INT((VAL(CHAR)-1)/3)*3),26+(((VAL(CHAR)-1)%3)*6) SAY CHAR
           ENDIF
           SetColor("N/W")
         ELSE
           DO CASE
              CASE CHAR $ '+-*/cC'+CHR(13)
                IF !NEW .AND. !DECIMAL
                  VALUE = VALUE / 100
                ENDIF
                THRU = .T.
              CASE CHAR = '.'
                DECIMAL = .T.
                IF NEW
                  VALUE = 0
                  NEW = .F.
                ENDIF
                @ 4,25 SAY VALUE PICT '99,999,999,999,999.99'
              CASE CHAR $ CHR(127)+CHR(7)
                IF !DECIMAL
                  VALUE = INT(VALUE/10)
                ELSE
                  IF PLACE = 1
                    DECIMAL = .F.
                    VALUE = INT(VALUE)
                  ELSE
                    PLACE = 1
                    VALUE = INT(VALUE*10)/10
                  ENDIF
                ENDIF
                @ 4,25 SAY VALUE PICT '99,999,999,999,999.99'
              CASE CHAR = CHR(6)
                PLACE = 1
                NEW = .F.
                DECIMAL = .F.
                VALUE = 0
                @ 4,25 SAY VALUE PICT '99,999,999,999,999.99'
              CASE CHAR = CHR(27)
                @ 4,25 SAY VALUE PICT '99,999,999,999,999.99'
                THRU = .T.
           ENDCASE
         ENDIF
       ENDIF
     ENDDO
   SetColor("W/B")
RETURN(VALUE)
