*****************************************************************
*** Filename...........: DISPSTRU.PRG
*** Author.............: Steve Straley
*** Date...............: 1/7/86
*** Purpose............: Simulates dBase III's DISPLAY STRUCTURE
***                      command in Clipper.
*****************************************************************

PARAMETERS Infile

IF LEN(TRIM(infile)) = 0
   infile = SPACE(30)
   @ ROW(),0 SAY "No data base in USE.  Enter filename: " GET infile
   READ
   IF LEN(TRIM(infile)) = 0
      QUIT
   ENDIF
ENDIF
search = AT("TO PRINT",UPPER(infile))
IF search <> 0
   toggle = .T.
   infile = SUBSTR(infile,1,search-1)
ELSE
   toggle = .F.
ENDIF
search = AT(".",infile)
IF search = 0
   infile = TRIM(infile) + ".DBF"
ENDIF
IF .NOT. FILE(infile)
   ? "File Not Found"
   QUIT
ENDIF
RUN DIR &infile > Tempfile.txt
CREATE Temp
USE Temp
APPEND BLANK
REPLACE field_name WITH "LINE", field_type WITH "C", field_len WITH 80
USE
CREATE Template FROM Temp
USE Template
ERASE Temp
APPEND FROM Tempfile.txt SDF
ERASE Tempfile.txt
GO 3
search = AT("of ",line)
direct = SUBSTR(line,search+3)
GO 5
search = AT("-",line)
datein = SUBSTR(line,search - 2,8)
USE &infile
ERASE Template
COPY STRUCTURE EXTENDED TO Template
USE Template
record = STR(LASTREC())
count  = 1
IF toggle
  outfile = SUBSTR(infile,1,AT(".",infile)-1) + ".DSP"
  SET ALTERNATE TO &outfile
  SET ALTERNATE ON
ENDIF
? "Structure for database: " + TRIM(direct) + "\" + infile
? "Number of data records: " + record
? "Date of Last update   : " + datein
? "Field      Field Name      Type      Width     Dec"
GO TOP
DO WHILE .NOT. EOF()
   ?  RECNO()
   ?? SPACE(3)
   ?? field_name
   ?? SPACE(5)
   ?? TYPENAME()
   ?? SPACE(5)
   ?? field_len
   ?? SPACE(5)
   IF field_dec > 0
      ?? field_dec
   ENDIF
   SIP
   COUNT = COUNT + 1
   IF COUNT > 16
      COUNT = 1
      WAIT
   ENDIF
ENDDO
USE
ERASE Template.dbf
ERASE Temp.dbf
IF toggle
   CLOSE ALTERNATE
   SET ALTERNATE OFF
ENDIF


***********************
** Function Typename **
***********************

FUNCTION Typename

DO CASE
CASE field_type = "N"
   RETURN("Numeric  ")
CASE field_type = "D"
   RETURN("Date     ")
CASE field_type = "M"
   RETURN("Memo     ")
CASE field_type = "C"
   RETURN("Character")
CASE field_type = "L"
   RETURN("Logical  ")
ENDCASE
RETURN("Undefined")

*** EOF DISPSTRU.PRG
