**************************************************************************
* 		 Module:		Sample.prg
* 		 Author:		Kent E. Gabrys
* CIS Address:  	72632,1024
*    Language:		Clipper - no 3rd party libraries
*     Purpose:    Share some common functions that can enhance the way you
*				      code and make a good looking interface for the user.
* 						The Sample function makes use of the features of this
*						code.  Just compile this module with '/m/n' switches to see demo.
*  					Please direct all comments and questions to me at my CIS
*  					address above.
*
*    						Copyright (c)1996  by SmooWare(c)
*		 Notice:    Please feel free to use and distribute blah, blah, blah...
*						at no charge.
*						Remember to give the author credit yadda, yadda, yadda...
*
*	Disclaimer:		You got here on your own, you're responsible for being here.
*						If you decide to use this code, you're responsible, be sure
*						to back up any important data files cuz in the end, you're
*						responsible.  If you got any lame ideas that use this code
*						to crash some government agency, YOU ARE responsible.
*						If this code somehow irreparably corrupts your data,
*						that really is too bad... but you are still responsible.
* 						In short, if you smash it, if you blow it up, crash it,
*  					sabatoge it, or in some way injure yourself because of the
*  					code herein, that's tough... you are responsible, but
*						because you're responsible and made the necessary backups,
*                 you got no worries! Right?
******************************************************************************

#include 'box.ch'
#include 'setcurs.ch'
#include 'inkey.ch'
memvar getlist

function sample()
	local cScreen, cScreen1, cColor, nCurs, lAns := .T.,;
		   cInput, lSave := .F.
	set scoreboard off
	set wrap on
	nCurs   := setcursor( SC_NONE )
	cScreen := savescreen( 0, 0, 24, 79 )
	cColor  := setcolor( 'w+/bg, n/w, g+' )

	Boarders( 'SmooWare Presents MsgBox, Boarders, and Shadow Functions', 'b/bg' )
	setcolor( 'r+/w' )
	cScreen1:= savescreen( 7, 15, 21, 52 )  //see comment on Shadow function
	Shadow( 7, 15, 20, 50 )                 //about saving screen areas
	@ 7, 15, 20, 50 box B_DOUBLE + ' '
	@ 9, 17 say 'This is a Shadow function call,'
	@ 10,17 say '2 screen calls, an @ ... box'
	@ 11,17 say 'and 9 @ ... say commands'
	@ 12,17 say 'and without figuring out'
	@ 13,17 say 'if these lines are centered,'
	@ 14,17 say 'just putting them on the screen'
	@ 15,17 say 'as best I can guess first try.'
	@ 16,17 say 'My MsgBox function can do this'
	@ 17,17 say 'right in one try. Press a key...'
	inkey( 0 )
	restscreen( 7, 15, 21, 52, cScreen1 )

	do while lAns == .T.
		MsgBox( 'This is a Mode 0 box at the top left', 0, '+g/rb', 3, 5 )
		MsgBox( 'This is also a Mode 0 box placed at the lower right', 0, '+gr/w', 14, 35 )
		MsgBox( 'This box has control and is making the program wait with mode 1.', 1, 'w+/bg' )
		Boarders( 'SmooWare Presents MsgBox, Boarders, and Shadow Functions', 'n/bg' )
		MsgBox( 'It was necessary to redraw the screen to clear the mode 0 boxes.  '+;
			   'This is another mode 1 box except that I am making the text go on'+;
				' for a while in order to make the function enlarge the box to a '+;
				"column with of sixty (60) characters and since I'm just about "+;
			  	'there, this sentence will soon end off with a toodle-loo!', 1, '+gr/b' )
		MsgBox( 'This program is composed almost entirely of Boarders and MsgBox'+;
				' routines to handle user input, and display instructions.  Next'+;
				' is a sample of a couple control loops.', 1, 'g+/bg' )
		do while ! lSave
			cInput := MsgBox( 'This box is Mode 4, waiting for a user input, maybe ' +;
			  "a file name, a customer name or just your dog's name. Type a short string...", 4, 'w+/g, r/w' )
			lSave := MsgBox( 'With mode 3, you get another type of true false return box.'+;
						' You typed ' + Upper( trim( cInput ) ) + '.  Select save'+;
						' to continue...', 3, 'b+/w, w+/b' )
		enddo
		Boarders( 'SmooWare Presents MsgBox, Boarders, and Shadow Functions', 'n+/w' )
		lAns := MsgBox( 'This box is Mode 2, a true/false return here as well.';
					+ '  What you do with ' + upper( trim( cInput ) ) +;
					' is your business...... would you like to loop through'+;
					' the demo again?', 2, 'gr+/r' )
	enddo
	setcolor( cColor )
	restscreen( 0, 0, 24, 79, cScreen )
	setcursor( nCurs )
return NIL
*******************************************************************************
*                           FUNCTION Boarder
*------------------------------------------------------------------------------
* Puts a Boarder around the screen and centers a Heading at the top of the
* screen.  There are 2 for/next loops that use the cBlocks variable to
* put a modified Norton Desktop down as the background in the working area of
* the screen.  Takes a Color argument to your preference.
*******************************************************************************
function Boarders( cHeader, cColor )
	Local n := 1, x, y,;
	      cBlocks := ""+;
						  ""
	SetColor( cColor )
   @  0,  0 clear to 24, 79
	@  0,  0, 24, 79 box B_DOUBLE + ' '  // Set screen color with a box
	@  2,  0 say  ""							 // Draw a line across box
   @  2,  1 say Replicate("",78)
	@  2, 79 say  ""

   @  1, ( 80 - len( cHeader ) ) / 2 say cHeader       // display header

	for x := 3 to 23						// enhance display area
	   for y := 1 to 78
	     @ x, y say substr( cBlocks, n, 1 )
	     if n > 78
	        n := 1
	     else
		     n++
		  endif
	   next
	next
return NIL

*****************************************************************************
*                           FUNCTION SHADOW
*-----------------------------------------------------------------------------
* Puts a shadow on the screen.  Feed the coordinates of the box you are
* drawing to this function BEFORE you draw the box. Shadow will automatically
* place a shadow on the screen below and to the right of the box you draw.
* If you use this, without redrawing the entire screen, be sure to save your
* screen 1 line below the bottom row coordinate and 2 lines right of the
* box right coordinate so that you can restore all areas.
******************************************************************************
function Shadow( nTop, nLeft, nBottom, nRight )
	local cScreen
	cScreen := savescreen( nTop + 1, nLeft + 2, nBottom + 1, nRight + 2 )
	if len( cScreen ) > 2048
	  cScreen := transform( substr( cScreen, 1, 2048), ;
					 replicate( 'x' + chr( 8 ), 1024 ) ) + ;
		     transform( substr( cScreen, 2049, len( cScreen ) - 2048 ),;
		     replicate( 'x' + chr( 8 ), ( len( cScreen ) - 2048) / 2))
	else
	   cScreen := transform( cScreen, replicate( 'x' + chr( 8 ),;
					  len( cScreen ) / 2 ) )
	endif
	restscreen( nTop + 1, nLeft + 2, nBottom + 1, nRight + 2, cScreen)
return NIL


*--------------------------------------------------------------------
*        function MsgBox( cMsg, nMode, cColor, nTRow, nTCol)
*--------------------------------------------------------------------
* MsgBox designed as simple way to display messages and get back
* simple true or false type answers. Modify the case statement for
* desired return values by adding another nMode value.
* Arguments taken:
*     cMsg:  A string passed to be displayed. In all cases, the
*            box size is determined by amount of text fed to the
*            function.  The text must not exceed 1,218 characters
*            to be displayed on the screen in full.
*     nMode: A numeric value passed that determines returned values,
*            and other characteristics as described in the below
*            section on Modes.
*     cColor:A typical color string that determines the text and
*            box colors in typical Clipper fashion. ( i.e.- '+w/b'
*            to get a blue box with brite white text.
*     nTRow: Presently only required for mode 0, with nTCol, it
*            determines the top left corner of the box being
*            displayed.
*     nTCol: See nTRow
*
* Current Modes Available:
*     MODE 0:  Displays text in a box on screen with a shadow. The
*              only mode to use all 5 arguments of the function.
*              Where nTRow is the Top Row and nTCol is the Left
*              Column.  Box width will be 40 or 60 Columns wide
*              depending on length of cMsg.  You must redraw the
*              screen to remove the displayed msg.
*              Mode 0 always returns a logical true.
*     MODE 1:  Displays text with a 'hit any key to continue' prompt
*              centered on the screen.  Always returns a logical .T.
*     MODE 2:  Displays text with a Yes or No prompt that will
*              accordingly return a .T. or a .F. as selected.
*     MODE 3:  Displays text with a Save or Try Again Prompt again
*              returning a T/F value for you to handle.
*     MODE 4:  Displays text (that should prompt the user) and
*              returns a character string.
*--------------------------------------------------------------------*

function MsgBox( cMsg, nMode, cColor, nTRow, nTCol )
	local cScreen, cSaveColor, xAnswer := .T., cString, nWidth, nPad,;
	      aStrings := {}, i, j, nCursor, nRow, nSaveRow, nChoice, lBlink

	lBlink := setblink( .T. )
	if empty( cColor )                      // set defaults if required
		cColor := '+b/w'
	endif
	if empty( nMode )
		nMode := 0
	endif
	if len( cMsg ) < 120
		nWidth := 40
	else
		nWidth := 60
	endif
	if len( cMsg ) > 0                                                                     // handle if no message was sent
     do while len( cMsg ) > 0
			cString := left( cMsg, nWidth - 4 )
			for j := nWidth - 4  to 1 step -1
			   if substr( cString, j, 1 ) == " " .OR. j > len( cString )
					aadd( aStrings, left( cMsg, j ) )
					cMsg := substr( cMsg, j + 1 )
					exit
				endif
			next
	   enddo
	   nRow := int( ( 25 - len( aStrings ) ) / 2 ) - 3
		nSaveRow := nRow
		nPad := 	( 80 - nWidth ) / 2
	   cScreen := savescreen( nSaveRow, nPad - 1, nSaveRow + len( aStrings ) + 5, nPad + nWidth + 2 )
	   cSaveColor  := setcolor( cColor )
		Shadow( nRow, nPad - 1, nRow + 4 + len( aStrings ), nPad + nWidth )
	   @  nRow, nPad - 1, nRow++ + 4 + len( aStrings ),;
			      nPad + nWidth box B_SINGLE + ' '
	   for i := 1 to len( aStrings )
		   @ nRow + i, nPad + 1 say padc( trim( aStrings[ i ] ), nWidth - 2 ) color cColor
	   next
	   nCursor := setcursor( SC_NONE )
	   do case
      case nMode == 0
        	restscreen( nSaveRow, nPad - 1, nSaveRow + len( aStrings ) + 5, nPad + nWidth + 2, cScreen )
      	Shadow( nTRow, nTCol - 1, nTRow + 4 + len( aStrings ), nTCol + nWidth )
       	@  nTRow, nTCol - 1, nTRow++ + 4 + len( aStrings ),;
         	     nTCol + nWidth box B_SINGLE + ' '
       	for i := 1 to len( aStrings )
         	@ nTRow + i, nTCol + 1 say padc( trim( aStrings[ i ] ), nWidth - 2 ) color cColor
	      next
        	xAnswer := .T.
      case nMode == 1
		   @ ++nRow + len( aStrings ), nPad + 2 say;
					padc( 'Press Any Key To Continue...', nWidth - 2 ) color cColor
		   inkey( 0 )
		   xAnswer := .T.
      case nMode == 2
		   @ ++nRow + len( aStrings ), 32 say 'Press "Y" or "N"' color cColor
		   @ nRow + len( aStrings ), 39 get  xAnswer       picture 'Y';
		      color stuff( cColor, 1, len( cColor ), '*' + cColor ) //flashing
		   read
      case nMode == 3
			@ ++nRow + len( aStrings ), 30 prompt 'Save'
			@   nRow + len( aStrings ), 40 prompt 'Try Again'
			menu to nChoice
			if nChoice == 1
				xAnswer := .T.
			else
				xAnswer := .F.
			endif
      case nMode == 4
			xAnswer := space( 32 )
			@ ++nRow + len( aStrings), 24 get xAnswer
			read
		endcase
	   setcursor( nCursor )
	endif
	setblink( lBlink )
	setcolor( cSaveColor )
	if nMode != 0
		restscreen( nSaveRow, nPad - 1, nSaveRow + len( aStrings ) + 5, nPad + nWidth + 2, cScreen )
	endif
return xAnswer

