comment /
DISKSPAC.ASM--get disk space on any drive--as a bonus, you can check
              for validity-readiness of drive.  Disk space is returned
              in Bytes if less then 65536 (with leading "B"), otherwise
              in Kbytes (no leading letter)
syntax:
load diskspac
memvar=spac(6) && for default, or
memvar="A     " && check drive A
call diskspac with memvar

returns:
"E     "        && you did not specify a CAPITAL letter    (ERROR)
"I     "        && invalid drive or drive not ready        (INVALID)
"B  999"        && disk drive has exactly 999 bytes free
"   999"        && disk drive has 999*1024 bytes available
               && (at least, amount smaller than 1K disregarded)


                  ******** WARNING **********
WILL TERMINATE WITH "DIVIDE OVERFLOW" (AND GO BACK TO DOS) IF AVAIL. DISK
SPACE IS GREATER THAN 65M.
I have not tested this extensively.  No guarantees or responsibility  taken.
Feedback appreciated.
R. Russell Freeland (Synergy Corp.) 305-792-1866 (voice)
Compuserve 76146,371

/
CODESEG SEGMENT BYTE PUBLIC 'CODE'
      assume cs:codeseg,es:codeseg

DISKSPAC PROC FAR


START:
        push    ax
        push    ds
        push    es
        push    dx
        push    cx
        push    bx
;first let's convert the drive letter to a number
        cmp     byte ptr [bx],20h
        je      default                 ;must be default drive, huh?
        sub     byte ptr [bx],40h       ;change CAPITAL letter to number
        cmp     byte ptr [bx],00h       ;check to see if it's a letter (lower)
        jna     error
        cmp     byte ptr [bx],1bh       ;(upper)
        jnb     error
        mov     dl,byte ptr [bx]        ;tell DOS what drive
        jmp     notdefault
default:
        mov     dl,0
notdefault:
        mov     ah,36h                  ;diskspace function call
        int     21h                     ;call DOS
        cmp     ax,65535                ;invalid drive?
        je      invalid
        ;--------------ax=sects/cluster
        ;--------------cx=bytes/sector
        ;--------------bx=available clusters
        ;--------------(dx=clusters/drive--next version??)
        mul     cx                      ;unsigned mult. bx*ax, result in dx/ax
                                        ;will give bytes/cluster, all in AX (now)
        mul     bx                      ;times available clusters
;test: jmp test
        pop     bx                      ;get back the pointer to memvar
        mov     byte ptr [bx],' '       ;clear out the converted drive number
checksize:
        cmp     dx,0
        jg      Kbytes                  ;calculate in Kbytes, it's big enough
        mov     byte ptr [bx],'B'
        jmp     Bytes

Kbytes:
        mov     si,1024d                ;let's get it in "K" this version, too
                                        ;much work to divide large numbers
        div     si
        ;xor    dx,dx                   ;clear the remainder

Bytes:
        ;-----------now convert number to a six-digit ASCII string
        add     bx,6                    ;we'll do it backwards
        mov     cx,6
        mov     si,10                   ;prepare to divide by 10
nexdgt: div     si                      ;divide dx:ax by si
        or      dx,30H                  ;convert remainder to ASCII digit
        dec     bx                      ;backup in string
        mov     [bx],dl                 ;store character
        xor     dx,dx                   ;clear remainder
        dec     cx
        or      ax,ax                   ;all done?
        jnz     nexdgt                  ;do next digit
        sub     bx,cx                   ;backup to right spot
        jmp     wrapit                  ;wrap it up
invalid:
        pop     bx                      ;get back pointer
        mov     byte ptr [bx],'I'       ;(INVALID)
        jmp     wrapit
error:
        pop     bx                      ;get back pointer
        mov     byte ptr [bx],'E'       ;(ERROR)
wrapit:
        pop     cx
        pop     dx
        pop     es                      ;pop the regs back
        pop     ds
        pop     ax
        ret
DISKSPAC ENDP
CODESEG ENDS
        END  START



