// dirstruc.c
// Author.....: Michael J. Primeaux
// Date.......: 25dec92
// Syntax.....: dirStruct( <starting directory> )
// Returns....: character array
// Sample.....: aDirectory := dirStruct( "\" )
// Compile....: bcc -c -ml -f- -a -r -B -O -Z dirstruc.c
// Note.......: compiled with Borland C++ v3.1

#include <alloc.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "extend.h"  // Clipper Extend Include File

#define MAX_DIR   512      // Maximum directories supported

// Directory sizing structure
typedef struct {
   char *name;             // Name of the directory
   long size;              // Cummulative size of all files in dir
   int files;              // Number of files in dir
} DOSDIR;

int sizedir(char *dname,int *dn,DOSDIR **direc,int slots,int *nlen, int recurse)
{
   // Directory search attriubte
   static const char srchattr = (FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH);

   char fspec[MAXPATH];    // Wildcard file spec for search
   struct ffblk fb;        // used in findfirst/next functions
   int done;               // end of directory check flag
   DOSDIR *dir;            // Alias of direc[dn] for code readability

   // Check to see that number of directories hasn't outgrown our array
   // of pointers.
   if (*dn > slots) return(-1);

   // Check and make sure the array of pointers has been allocated
   if (!direc) return(-1);

   // Allocate the totals directory
   if (*dn == 0) {
      dir = direc[0] = (DOSDIR *) malloc(sizeof(DOSDIR));
      if (!dir) return(-1);
      strcpy(fspec, "Totals");
      dir->name = (char *) malloc(strlen(fspec)+1);
      if (!dir->name) return(-1);
      strcpy(dir->name, fspec);
      direc[0]->files = 0;
      direc[0]->size = 0;
   }

   // Allocate the space for this directory
   (*dn)++;       // Add this directory to the directory counter

   dir = direc[*dn] = (DOSDIR *) malloc(sizeof(DOSDIR));
   if (!dir) return(-1);
   dir->name = (char *) malloc(strlen(dname)+1);
   if (!dir->name) return(-1);

   // Initialize the directory record
   strcpy(dir->name, dname);
   dir->size = 0;
   dir->files = 0;

   // Update maximum directory name length for output
   *nlen = max(*nlen, strlen(dir->name));

   // Add wildcard spec to the directory name
   strcpy(fspec, dir->name);
   strcat(fspec, "*.*");      // Look for all files

   // Scan the entire directory structure
   done = findfirst(fspec, &fb, srchattr);
   while (!done) {
      do {
         if (!strcmp(fb.ff_name,"."))  break;   // Skip curr/parent specs
         if (!strcmp(fb.ff_name,"..")) break;
         if ((fb.ff_attrib & FA_DIREC) && recurse) {
            strcpy(fspec, dname);
            strcat(fspec, fb.ff_name);
            strcat(fspec, "\\");                // RECURSE
            sizedir(fspec, dn, direc, slots, nlen, recurse);
         }
         else {                                 // File
            (dir->files)++;
            dir->size += fb.ff_fsize;

            (direc[0]->files)++;
            (direc[0]->size) += fb.ff_fsize;
         }
      } while (0);
      done = findnext(&fb);
   }
   return(*dn);
}

CLIPPER dirStruct( void )
{
   char startdir[MAXPATH]="\\";
   int numdirs=0;
   DOSDIR **direc=NULL;          // The directories array
   int nlen=63;                  // Maximum name length
   int recurse = 1;              // recurse by default

   char *path;
   register quant i;
   path = _parc(1);              // recieve path parameter

   strcpy(startdir, path);
   strupr(startdir);
   if (startdir[strlen(startdir)-1] != '\\')
      strcat(startdir, "\\");

   // Allocate the array of pointers
   direc = (DOSDIR **) calloc(MAX_DIR, sizeof(DOSDIR *));

   // Calculate the size of the directories
   sizedir(startdir, &numdirs, direc, MAX_DIR, &nlen, recurse);
   if (numdirs == -1) {
      _ret();
   }

#ifdef DEBUG
   // Print header
   printf("%-*s %5s %9s\n\n", nlen, "Dir Name", "Files", "Size");

   // Loop for each directory in the array
   for (i=1; i <= numdirs; i++) {
      printf("%-*s %5d %9ld\n", nlen, direc[i]->name, direc[i]->files,direc[i]->size);
   }
   // Display summary totals
   printf("\nA total of %d directories containing ", numdirs);
   printf("%d files, ", direc[0]->files);
   printf("Total bytes used %ld\n", direc[0]->size);
#endif
   _reta( numdirs );
   for (i=1; i <= numdirs; i++) {
      _storc( direc[i]->name, -1, i ); 
   }
}

// eof dirstruc.c
