

/*
 * File......   : RMDIRS.c
 * Author....   : Peter Kulek
 * Date......   : $Date:   02 Mar 1991  $
 * Revision..   : $Revision:   1.0  $
 * Log file..   : $Logfile:   c:\impala5\c\rmdirs.c  $
 * Compuserve ID: 100140,1220
 * 
 * This is an original work by Peter Kulek
 * Copyright (c) 1991  Peter Kulek 
 * You can use this code as you please but please keep 
 * copyright notice in code.
 *
 * compile with MSC 6
 * Modification history:
 * ---------------------
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     RMDIRS()
 *  $CATEGORY$
 *     DOS
 *  $ONELINER$
 *     Remove multi-level directories in a single call
 *  $SYNTAX$
 *     RMDIRS(cPath) -> nVal
 *  $ARGUMENTS$
 *     <cPath>       Drive and Path to remove
 *  $RETURNS$
 *     <nVal>        Dos error value
 *
 *  $DESCRIPTION$
 *      This function removes a multi-level directory in a single call
 *      If the path is not empty or an invalid path is specified 
 *      nothing will be removed.
 *  $EXAMPLES$
 *      cFileName := '\bum\ti\ti\bum\ti\ti\bum\ti.bum'
 *      if ! file(cFilename) // Check For Filename
 *           MKDIRS(pathsplit(cFileName,2)) // Get path From File
 *      endif
 *      RMDIRS(pathsplit(cFileName,2)) // remove directory
 *
 *  $END$
 */


#include "extend.api"

int rmdirs( char *);
int rmdir (char *) ;

#define OR ||



CLIPPER RMDIR() {
     _retni(-1);    
     if ISCHAR(1)
         _retni( rmdir(_parc(1)) );
}

CLIPPER RMDIRS() {
     _retni(-1);    
     if ISCHAR(1)
         _retni( rmdirs(_parc(1)) );
}

int rmdirs( char *path){
      int retval = -1 ;
      int i = strlen(path)+1 ;
      char subpath[128] = "";
      while ( i > 0 ) {
          if (path[i] == '\\' OR path[i] == '/' OR path[i] == '\0') {
              path[i] = '\0' ;
              retval = rmdir(path) ;
          }    
          i-- ;
      }
      return(retval);
}

int rmdir ( char *path){
   int iRetVal;
   _asm {
           push dx
           push ds
           mov ah, 0x3a
           lds dx, [path]
           int 21h
           mov iRetVal,0
           jnc mkdir1
           mov iRetVal,AX
       mkdir1:
           pop ds
           pop dx  
   } 
   return(iRetVal) ;
}

