TITLE fdatetm.asm - FDATETM
; Usage:
;
;       x_file = "\SUB1\MYFILE.EXT"
;       load fdatetm
;       call fdatetm with x_file
;
;       gets date and time file was last modified
;
PUSHALL   MACRO
          PUSH AX
          PUSH BX
          PUSH CX
          PUSH DX
          PUSH SI
          PUSH DI
          PUSH BP
          PUSH ES
          PUSH DS
ENDM

POPALL    MACRO
          POP  DS
          POP  ES
          POP  BP
          POP  DI
          POP  SI
          POP  DX
          POP  CX
          POP  BX
          POP  AX
ENDM

_PROG   SEGMENT   BYTE
        ASSUME    CS:_PROG

FDATETM PROC      FAR
        PUSHALL

        MOV DX,BX               ; Put address of variable in DX
        PUSH BX                 ; Save address of variable
        MOV AH,3Dh              ; DOS open file function
        MOV AL,40h              ; Deny none sharing mode
        INT 21h                 ; call DOS
        JNC OKAY                ; test carry flag
        POP BX                  ; Restore FoxPro variable address
        MOV [BX],AX             ; Return error code to FoxPro
        JMP DONE                ; Done

OKAY:   MOV AX,BX               ; Move file handle to AX
        MOV AH,57h              ; DOS file date/time function
        MOV AL,00h              ; Get file date and time
        INT 21h                 ; Call DOS
        MOV AH,3Eh              ; Close file function
        INT 21h                 ; Call DOS
        POP BX                  ; Restore FoxPro parameter address
        MOV [BX],DX             ; Date
        MOV [BX+1],CX           ; Time
        JMP DONE                ; Done

DONE:   POPALL
        RET

FDATETM ENDP
_PROG   ENDS
        END
