//
// fix_UE668() - version 2.0
//
// Used for "working around" a memory allocation "bug" or "incorrect
// allocation decision for some of us" in Clipper 5.0 - 5.2c (and probably
// later versions as well).
//
//

procedure fix_UE668(numlocvars)
  //
  // Causes a larger area of DGROUP to be allocated to to the Eval
  // Stack, which keeps it from being turned over to the VMM system
  // to be used as conventional memory.  This routine is used to prevent
  // the "Unrecoverable Error 668, Eval Stack Fault" error from happening.
  //
  // THIS ROUTINE DOES NOTHING TO HELP ANY OTHER ERROR, AND IN THE EVENT
  // THAT YOUR PROBLEM IS ANOTHER ERROR, THIS ROUTINE WILL PROBABLY MAKE
  // THINGS WORSE.
  //
  // This routine should be called as one of the first statements in your
  // program.  5.2 users may use rewrite this to use the INIT PROCEDURE
  // statement if they choose.
  //
  // This error occurs when the local variables for all currently executing
  // routines whose parameters and local variables are stored on the Eval
  // Stack fill the space allocated to them, and the VMM cannot release more
  // memory since the memory following the Eval Stack space has been
  // used for other purposes.
  //
  // parameter - numlocvars
  // This determines the number of local variables for which space is to 
  // be allocated on the Eval Stack.  600 has worked well for me so far,
  // but it might be a bit excessive.  Allocating for more than you will
  // need may lead to "Conventional Memory Exhausted".
  //
  // The first statement in your program should be a call to this
  // routine, which will eat up enough Eval Stack space for your
  // program to run, then allow it to be reclaimed.  But after the
  // call, the VMM will not reallocate this space to the conventional
  // memory pool since it will think that your program might use it
  // again later for local variables.
  //
  // All this program really does is create a whole mess of local
  // variables initialized to nil, then return.
  //
  // This routine accepts one parameter, indicating the number of local
  // variables for which space is to be allocated. This routine only
  // works for multiples of 50 variables.  The number you give is
  // rounded down to the nearest multiple of 50.
  //
  // If you get one of following unrecoverable errors after using this:
  //   1. UE 667 Eval Stack Fault (Eval Stack overrun of Memvar Table)
  //      You are allocating too much space with fix_UE668().  Reduce the
  //      number of variables to be allocated or eliminate the call to
  //      fix_UE668().  
  //   2. UE <whatever> conventional memory exhausted - similar to item #1.
  //   3. UE 668 Eval Stack Fault (Eval Stack attempted overrun of memory
  //      space which has been reallocated as conventional memory).
  //      Increase the number of variables to be allocated.
  //
  // If you still cannot solve your problem, keep yelling at CA <g>.
  //
  // Note that this is not a catch all solution.  There are many things
  // which eat up DGROUP, and many combinations which lead to peril:
  //   a. C and ASM static data.
  //   b. CPU stack.
  //   c. Eval Stack.
  //   d. Memvar Table.
  //   e. "last resort" conventional memory.
  // The total size of DGROUP is 64K.  It is configured so that the
  // Eval Stack grows toward the Memvar Table.  If it overruns it, you get
  // UE 667.  If there is a large piece of memory in between the Eval Stack
  // and the Memvar Table, and the VMM sees that after some time of program
  // execution that your program has not accessed this area, it will 
  // allocate it as conventional memory as a last resort. After that point,
  // if more local variables are instantiated, and the Eval Stack overruns
  // the VMM conventional memory, you get UE 668.
  //
  // If, at some point, the VMM attempts to allocate conventional memory,
  // and there is none left, you get "Conventional Memory Exhausted".
  //
  // Incidentially, UE 669 is what you get when the Memvar Tablecannot be
  // expanded for the same reason.  UE 650 processor stack fault, is caused
  // by the cpu call stack growing too large, its size can be controlled with
  // the linker /STACK command, or equivelent (SET PROCEDURE DEPTH, Etc.).
  //
  local p000, p001, p002, p003, p004, p005, p006, p007, p008, p009
  local p010, p011, p012, p013, p014, p015, p016, p017, p018, p019
  local p020, p021, p022, p023, p024, p025, p026, p027, p028, p029
  local p030, p031, p032, p033, p034, p035, p036, p037, p038, p039
  local p040, p041, p042, p043, p044, p045, p046, p047, p048, p049
  if numlocvars<>nil.and.numlocvars>50
    fix_UE668(numlocvars-50)
  endif
  return

