*:*********************************************************************
*:
*:        Program: DEV.PRG
*:
*:         System: CLIPPER DEVELOPMENT ENVIRONMENT
*:         Author: G PREFONTAINE
*:      Copyright (c) 1988, ALFRED E NEUMAN
*:  Last modified: 10/21/88     16:29
*:
*:  Procs & Fncts: PICKLIST()
*:               : MENU_UDF()
*:               : MBOX()
*:               : MAKEWIND()
*:               : KILLWIND()
*:               : GENVAL()
*:               : RYOUSURE()
*:
*:          Calls: PICKLIST()       (function  in DEV.PRG)
*:               : DEVACT.PRG
*:
*:   Memory Files: COLORS.MEM
*:               : C:\DEV.INI
*:
*:     Documented: 10/21/88 at 16:32                SNAP! version 3.11
*:*********************************************************************
CLEAR
SAVE SCREEN TO dosscr


* sets
SET KEY -1 TO picklist                  && f2
setcancel(.F.)
SET BELL OFF
SET SAFETY OFF
SET TALK OFF
SET STATUS OFF
SET SCOREBOARD OFF
SET CONFIRM OFF
SET Wrap ON
readexit(.T.)


* public variables
* set color variables
IF ISCOLOR() .AND. FILE("COLORS.MEM")
       RESTORE FROM colors.mem ADDIT
       * color variables restored are:
       * C_NORMCOL  = normal screen color i.e. "w/n,n/w,+gr/n"
       * C_POPCOL   = dialog box normal color
       * C_POPMENU  = dialog box menu color

       * you can use this scheme or hardcode the definitions,
       * half of one, six dozen of the other
ELSE
       C_NORMCOL  = "w/n,n/w"
       C_POPCOL   = "w/n,n/w"
       C_POPMENU  = "n/w,w/n"

ENDIF

* notice of authorship

makewind('whodidit',5,10,18,70)
@7,12 SAY "Written by  Garry A Prefontaine"
@8,12 SAY "920 N Washington"
@9,12 SAY "Edmond, OK, 73034"
@10,12 SAY "(405) 340-1449"
@17,12 SAY "Please turn caps lock key on"
INKEY(4)
killwind('whodidit',5,10,18,70)


* current development paramaters

IF FILE("c:\dev.ini")                      && always written to c:\
   RESTORE FROM C:\dev.ini ADDIT
ELSE                                    && if not there, start from scratch
   ini_edit = SPACE(55)            && edit command line
   ini_load = .F.                  && does editor load from command line ?
   ini_file = SPACE(12)            && current edit file
   ini_cmp  = SPACE(55)            && compiler command line
   ini_cmpf = SPACE(8)             && compile target file
   ini_link = SPACE(55)            && link command line
   ini_make = SPACE(55)            && make command line
   ini_run = SPACE(12)             && run command line
   ini_u1n = "(undefined)    "     && user defined menu item names
   ini_u2n = "(undefined)    "
   ini_u3n = "(undefined)    "
   ini_u4n = "(undefined)    "
   ini_u5n = "(undefined)    "
   ini_u6n = "(undefined)    "
   ini_u7n = "(undefined)    "
   ini_u8n = "(undefined)    "
   ini_u9n = "(undefined)    "
   ini_u10n ="(undefined)    "
   ini_u11n ="(undefined)    "
   ini_u12n ="(undefined)    "
   ini_u13n ="(undefined)    "
   ini_u14n ="(undefined)    "
   ini_u15n ="(undefined)    "
   ini_u1r = SPACE(55)             && user defined menu item command lines
   ini_u2r = SPACE(55)
   ini_u3r = SPACE(55)
   ini_u4r = SPACE(55)
   ini_u5r = SPACE(55)
   ini_u6r = SPACE(55)
   ini_u7r = SPACE(55)
   ini_u8r = SPACE(55)
   ini_u9r = SPACE(55)
   ini_u10r = SPACE(55)
   ini_u11r = SPACE(55)
   ini_u12r = SPACE(55)
   ini_u13r = SPACE(55)
   ini_u14r = SPACE(55)
   ini_u15r = SPACE(55)
ENDIF

PUBLIC para_chg                         && have the paramaters been changed
&& this session ?

* declare arrays for use in bar menus
* first menu
DECLARE menu1[6]
menu1[1] = "Edit"
menu1[2] = "Compile"
menu1[3] = "Link"
menu1[4] = "Make"
menu1[5] = "Run"
menu1[6] = "Quit"
menstr1 = "ECLMRQ"                      && string of first letters in menu
boxtit1 = "Operations"                  && title of menu

* second menu
DECLARE menu2[15]
menu2[1] = ini_u1n
menu2[2] = ini_u2n
menu2[3] = ini_u3n
menu2[4] = ini_u4n
menu2[5] = ini_u5n
menu2[6] = ini_u6n
menu2[7] = ini_u7n
menu2[8] = ini_u8n
menu2[9] = ini_u9n
menu2[10] = ini_u10n
menu2[11] = ini_u11n
menu2[12] = ini_u12n
menu2[13] = ini_u13n
menu2[14] = ini_u14n
menu2[15] = ini_u15n

menstr2 = ''
* this figures out what the current first letters of the menu are
FOR I = 1 TO 10
   menstr2 = menstr2+SUBST(menu2[i],1,1)
NEXT
boxtit2 = "User Programs"

* third menu
DECLARE menu3[6]
menu3[1] = "Editor Definition"
menu3[2] = "Compiler Definition"
menu3[3] = "Linker Definition"
menu3[4] = "Make Utility Definition"
menu3[5] = "Define User Programs"
menu3[6] = "Save Definitions "
menstr3 = "ECLMDS"
boxtit3 = "Definitions"


SET COLOR TO &c_normcol
CLEAR
@0,2 SAY boxtit1
@0,24 SAY boxtit2
@0,48 SAY boxtit3

lastmenu = 3                            && how many menus are there
mensel = 1                              && which menu is current menu
DO WHILE .T.                            && main loop of the program
   SET COLOR TO &c_normcol
   
   * a little info on current paramaters
   
   @18,1 SAY "Editing file   : "+ini_file
   @19,1 SAY "Run file       : "+ini_run
   @20,1 SAY "Compile file   : "+ini_cmpf
   @21,1 SAY "Compile command: "+ini_cmp
   @22,1 SAY "Link command   : "+ini_link
   @23,1 SAY "Make command   : "+ini_make
   @24,1 SAY "Edit command   : "+ini_edit
   
   DO CASE
   CASE mensel = 1                         && current menu is 1
      SET COLOR TO &c_popmenu         && make a menu box
      mstr = menstr1
      @0,2 SAY boxtit1
      amenu = savescreen(1,1,10,24)
      mbox(1,1,8,24)
      SELECT = achoice(2,2,9,23,menu1,0,'menu_udf')
      restscreen(1,1,10,24,amenu)
      SET COLOR TO &c_normcol
      @0,2 SAY boxtit1
   CASE mensel = 2                        && current menu is 2
      SET COLOR TO &c_popmenu        && make a menu box
      mstr = menstr2
      @0,24 SAY boxtit2
      amenu = savescreen(1,23,19,48)
      mbox(1,23,17,48)
      SELECT = achoice(2,24,18,47,menu2,0,'menu_udf')
      restscreen(1,23,19,48,amenu)
      SET COLOR TO &c_normcol
      @0,24 SAY boxtit2
   CASE mensel = 3                        && current menu is 3
      SET COLOR TO &c_popmenu        && make a menu box
      mstr = menstr3
      @0,48 SAY boxtit3
      amenu = savescreen(1,47,12,76)
      mbox(1,47,8,76)
      SELECT = achoice(2,48,11,75,menu3,0,'menu_udf')
      restscreen(1,47,12,76,amenu)
      SET COLOR TO &c_normcol
      @0,48 SAY boxtit3
   ENDCASE
   SET COLOR TO &c_normcol
   IF SELECT = 0                           && no selection
      IF LASTKEY() = 27               && if escape pressed,
         mensel = 1              && go back to first menu
         KEYBOARD "Q"            && quit
      ENDIF
      LOOP
   ELSE
      DO devact                       && must have made a selection
   ENDIF
ENDDO

********* end of the main program *****************


************
* HERE ARE THE UDFS.....
*************


*!*********************************************************************
*!
*!       Function: MENU_UDF()
*!
*!*********************************************************************
FUNCTION menu_udf                               && called by achoice()
PARA modep                                      && mode is all i care about
lkey = LASTKEY()                                && save lastkey()
IF lkey = 13                                    && enter key pressed
   RETURN 1                                && make selection
ENDIF
IF lkey = 27                                    && escape pressed
   RETURN 0                                && abort achoice()
ENDIF
IF lkey > 1 .AND. lkey < 255                    && its an ascii character
   IF UPPER(CHR(lkey)) $ mstr              && its part of the menu string
      KEYBOARD CHR(13)                && put a CR in the buffer
      RETURN 3                        && return a 'go to next element
   ENDIF                                   && whose first character matches
ENDIF                                           && this key...
&& (CR then processed as above)
DO CASE
CASE modep = 0                          && idle
   RETURN 2                        && carry on
CASE modep < 3                          && tried to sneak off the top
   && or off the bottom
   KEYBOARD IIF(modep=1,CHR(30),CHR(31) )
   && put a go-top or go-bot
   && in the buffer
   RETURN 2                        && and carry on
CASE modep = 3 .AND. (lkey = 4 .OR. lkey = 19)
   && left arrow/right arrow
   && select next/previous menu
   IF lkey = 4     && right
      mensel = IIF(mensel=lastmenu,1,mensel+1)
   ELSE            && left
      mensel = IIF(mensel=1,lastmenu,mensel-1)
   ENDIF
   RETURN 0                        && abort achoice()
OTHERWISE
   RETURN 2                        && carry on
ENDCASE
*********************************************************************

*!*********************************************************************
*!
*!       Function: PICKLIST()
*!
*!      Called by: DEV.PRG        
*!
*!*********************************************************************
FUNCTION picklist                               && picks a .prg file
PARAM MODU,lineno,varib                         && from an achoice() menu


DO CASE
CASE varib = 'INI_FILE'         && PRG FILE NAMES
   DECLARE prg_dir[ADIR('*.PRG')]
   adir('*.PRG',prg_dir)
   nbrof = adir('*.PRG')
   wsize = IIF(nbrof > 18,20,nbrof+1)
   makewind('PRGPICK',2,30,2+wsize,50)
   prgnum = achoice(3,31,2+wsize-1,49,prg_dir)
   prgfile = prg_dir[PRGNUM]
   killwind('PRGPICK',2,30,2+wsize,50)
   KEYBOARD prgfile
ENDCASE

***********************************************************************

*!*********************************************************************
*!
*!       Function: MBOX()
*!
*!*********************************************************************
FUNCTION mbox                                   && draws a box
PARA t,l,B,R

@ t,l,B,R BOX "ͻȺ "
RETURN ""

*************************************************************************

*!*********************************************************************
*!
*!       Function: MAKEWIND()
*!
*!*********************************************************************
FUNCTION makewind                               && draws a dialog box


PARAM w_name,wt,wr,wb,wl,wcolor
PUBLIC &w_name
old_color = 'c_'+w_name
PUBLIC &old_color
STORE setcolor() TO &old_color
STORE savescreen(wt,wr-1,wb+1,wl) TO &w_name
IF TYPE("C_POPCOL") = "U"
   c_popcol = "+W/R"
ENDIF

IF ! pcount()=6
   SET COLOR TO &c_popcol
ELSE
   SET COLOR TO &wcolor
ENDIF

mbox(wt,wr,wb,wl)
SET COLOR TO N,N,N,N,N
@ wt+1,wr-1 CLEAR TO wb+1,wr-1
@ wb+1,wr-1 SAY REPLICATE(' ', wl-wr)
IF ! pcount()=6
   SET COLOR TO &c_popcol
ELSE
   SET COLOR TO &wcolor
ENDIF

RETURN ''


*************************************************************************

*!*********************************************************************
*!
*!       Function: KILLWIND()
*!
*!*********************************************************************
FUNCTION killwind                               && releases a dialog box
&& placed on screen by
PARAM w_name,wt,wr,wb,wl                        && makewind()
old_color = 'c_'+w_name
restscreen(wt,wr-1,wb+1,wl,&w_name)
setcolor(&old_color)
RELEASE &w_name

RETURN ''

*************************************************************************


*!*********************************************************************
*!
*!       Function: GENVAL()
*!
*!*********************************************************************
FUNCTION genval                                 && generic validation check
PARAM condit,whatsay

r_val=.T.
IF .NOT. (&condit)                              && is the condition true
   r_val=.F.                                    && if not...
   lensay = LEN(RTRIM(whatsay))                 && figure out window size
   wrow = IIF(ROW()>=16,ROW()-4,ROW()+4)
   STORE (40 - lensay/2) TO wcol
   STORE (wrow+3) TO BROW
   STORE (wcol + lensay+ 2) TO ecol
   makewind('GVAL',wrow,wcol,BROW,ecol)         && make the window
   @wrow+1,wcol+1 SAY whatsay                   && say the message
   @wrow+2,wcol+1 SAY "PRESS A KEY.."
   INKEY(0)
   killwind('GVAL',wrow,wcol,BROW,ecol)         && kill the window
ENDIF

RETURN(r_val)                                   && returns .t. or .f.

*********************************************************************
*!*********************************************************************
*!
*!       Function: RYOUSURE()
*!
*!*********************************************************************
FUNCTION ryousure                               && pretty self explan.
makewind('YOUSURE',10,25,12,60)
myn = "N"
@11,32 SAY "ARE YOU SURE ? Y/N " GET myn VALID myn $ "YN"
READ
IF LASTKEY() = 27
   myn = "N"
ENDIF
killwind('YOUSURE',10,25,12,60)
RETURN IIF(myn = "Y",.T.,.F.)

*: EOF: DEV.PRG
