
**************************************************** DEBUG.PRG
* Test for unmatched clauses in command files, and correct * indents.
* Modified by R L Morgan Orlando Fl 1988
* Program was intended for use in DbaseIII+ and modified for CLIPPER
* with some Bells and Whistles. Bob M
SET TALK OFF
SET EXACT OFF
SET SAFETY OFF
CLEAR

IF .NOT. FILE("DEBUGDB.DBF")
   @ 22,0 SAY "Creating Database File ..."
   CREATE TMP_DBF.DBF

   APPEND BLANK
   REPLACE FIELD_NAME WITH "LINE"
   REPLACE FIELD_TYPE WITH "C"
   REPLACE FIELD_LEN  WITH 254
   REPLACE FIELD_DEC  WITH 0

   USE
   CREATE DEBUGDB.DBF FROM TMP_DBF.DBF

   ERASE TMP_DBF.DBF
   @ 22,0
ENDIF

CONTINUE = "Y"
DO WHILE CONTINUE = "Y"

   *------- Ask about printer
   PRINTER = SPACE(1)
   @ 10,20 say "Send a copy to printer(Y/N)" GET PRINTER
   PRINTER = UPPER(PRINTER)
   READ
   @ 10,0
   *------- Get name of program to debug.
   FileName = SPACE(12)
   @ 0,0
   RUN DIR *.PRG/W/P
   ?
   ?
   @ ROW(),15 SAY "Enter name of command file " GET FileName
   READ
   CLEAR
   ? "Working....."

   *------- Add .PRG extension if necessary.
   IF .NOT. "." $(FileName)
      FileName = TRIM(FileName) + ".PRG"
   ENDIF

   *------- Store FileName without extension to FName.
   FileName = UPPER(FileName)
   FName = SUBSTR(FileName,1,AT(".",FileName)-1)

   *------- Pull a copy of the program into DEBUGDB.DBF.
   USE DebugDB
   ZAP
   APPEND FROM &FileName SDF

   GO TOP

   * ------ Printer(Y/N)
   IF UPPER(PRINTER) = "Y"
      SET PRINT ON
      SET DEVICE TO PRINT
   ENDIF
   *------- Start counters for clause commands.
   STORE 0 TO Indent, Amt, DoWhile, If, DoCase, EndDo, EndIf, EndCase

   *------- Loop through each line of the command file.
   DO WHILE .NOT. EOF()
      MemVar = TRIM(Line)
      *------ Peel off leading blanks
      MemVar = LTRIM(MemVar)

      *------- Set flags to false.
      STORE .F. TO Increase, Decrease, NewElse, NewCase, Text

      *------- Check for clause commands: handle counters and indents.
      DO CASE

         CASE UPPER(Memvar) = "DO WHIL"
              DoWhile = DoWhile + 1
              Amt = 3
              Increase = .T.

         CASE UPPER(Memvar) = "IF "
              STORE If + 1 TO If
              Amt = 3
              Increase = .T.

         CASE UPPER(Memvar) = "DO CASE"
              DoCase = DoCase + 1
              Amt = 8
              Increase = .T.

         CASE UPPER(Memvar) = "CASE" .OR. Memvar = "OTHE"
              NewCase = .T.

         CASE UPPER(Memvar) = "ENDD"
              STORE EndDo + 1 TO EndDo
              Indent = Indent - 3

         CASE UPPER(Memvar) = "ENDI"
              STORE EndIf + 1 TO EndIf
              Indent = Indent - 3

         CASE UPPER(Memvar) = "ENDC"
              STORE EndCase + 1 TO EndCase
              Indent = Indent - 8

         CASE UPPER(Memvar) = "ELSE"
              NewElse = .T.

         CASE UPPER(Memvar) = "TEXT"
              Store .T. TO Text

      ENDCASE

      *------- Add new Indent to line.
      REPLACE Line WITH SPACE(Indent) + MemVar

      *------- If command was "ELSE", unindent the one line.
      IF NewElse
         Indent = Indent - Amt
         REPLACE Line WITH SPACE(Indent) + MemVar
         Indent = Indent + Amt
      ENDIF

      *------- If command was a CASE or OTHERWISE, unindent.
      IF NewCase
         Indent = Indent - 5
         REPLACE Line WITH SPACE(Indent) + MemVar
         Indent = Indent + 5
      ENDIF

      *------- If remaining lines to be Indented, increase Indent.
      IF Increase
         Indent = Indent + Amt
      ENDIF

      REPLACE Line WITH TRIM(Line)
      ? TRIM(Line)

      *------- Don't modify anything in TEXT...ENDTEXT block.
      IF Text
         SKIP
         DO WHILE .NOT. "ENDT" $ (UPPER(Line))
            ? TRIM(Line)
            SKIP
         ENDDO
         *------- Otherwise, skip to next line.
      ELSE
         SKIP
      ENDIF (memvar=text)

   ENDDO (while not eof)

   *------- Store original command file with .OLD as the extension.
   Oldname = FName + ".OLD"
   IF FILE(Oldname)
      ERASE &Oldname
   ENDIF
   RENAME &FileName TO &Oldname

   *------- Copy new version of program to original FileName.
   COPY TO &FIleName DELIM WITH BLANK
   CLOSE DATABASES

   *------- Display command file stats.
   CLEAR
   Whoops = "  <--- Whoops!  Unmatched pair."
   ? "Command File statistics:"
   ?

   *------- Print DO WHILE...ENDDO stats.
   ? "DO WHILE statements  :", DoWhile
   ? "ENDDO statements     :", EndDo
   IF DoWhile # ENDDO
      ?? Whoops
   ENDIF
   ?

   *------- Print IF...ENDIF stats.
   ? "IF statements        :", If
   ? "ENDIF statements     :", EndIf
   IF If # EndIf
      ?? Whoops
   ENDIF
   ?

   *------- Print DO CASE...ENDCASE stats.
   ? "DO CASE statements   :", DoCase
   ? "ENDCASE statements   :", EndCase
   IF DoCase # EndCase
      ?? Whoops
   ENDIF
   ?
   ?
   * ------ Set printer off if on
   IF UPPER(PRINTER) = "Y"
      EJECT
      SET PRINT OFF
      SET DEVICE TO SCREEN
   ENDIF
   *------- Print closing statements.
   ? "The original command file is now stored under &OldName"
   ?
   ? "The modified, indented version is stored under &FileName"
   ?
   @ 23,0
   WAIT "                   Do another program?(Y/N) " TO CONTINUE
   CONTINUE = UPPER(CONTINUE)
   *------- ask to do another prg
   IF UPPER(CONTINUE) = "Y"
      CLEAR
      LOOP
   ENDIF
   CLEAR

   * ----- ERASE DATABASE
   ERASE DEBUGDB.DBF

   SET COLOR TO W+
   @ 12,10 SAY "GOOD-BYE FROM THE SUNSHINE STATE         thanx Bob Morgan"
   SET COLOR TO
   ?
   ?
   ?
   ?
   ?
   ?
   ?
   *------- Done.
ENDDO

