***---FUNCTION dbltest
* To test this read ALL the following.  Decide what model you are going
* to try and act accordingly.
* 
* One way of experimenting with this function is to initial nKeyPress = 0
* and do something like:
*
*                   nKeyPress = 0
*                   test = SPACE(5)
*                   @ 2,2 GET test WHEN dbltest(@nKeyPress)
*                   read
*

FUNCTION dbltest
PARA nKeyPress
PRIVATE sy_talk
sy_talk = SET("TALK")
SET TALK OFF
CLEAR

*
* Initialize this variable so there is someplace to load the actual key
* that was pressed if it wasn't a DOUBLECLICK"
*

nKeyPress = 0

*
* The variable nKeyPress is passed by reference rather than value so
* it can be permanently changed inside the function.  Normally, depending
* on the setting of UDFPARMS, variables are set to procedures by reference 
* and to functions by value.
*
* 
*                        IF dblclick(@nKeyPress)       
*                             @ 2,3 SAY "You DOUBLECLICKED"
*                        ENDIF
* 
*
* Typically you would continue processing based on whether DOUBLECLICK 
* was detected.     
*
* The variable nKeyPress will contain the value of the key that was 
* actually if not a DOUBLECLICK and you could process based on it.





* I have included a second function, _keytest,  that will accept the
* value nKeyPress and KEYBOARD whatever event tripped dblclick().
*
* Below is an example of this
*
*
*                        IF dblclick(@nKeyPress)       
*                             @ 2,3 SAY "You DOUBLECLICKED"
*                        ELSE
*                        *
*                        * If other than DOUBLECLICK send whatever was
pressed 
*                        * to another function that keyboards the value.
*                        *
*                                  =    _keytest(nKeyPress)      
          
*                        ENDIF
*
* If you wish to try this, kill the bushes off the five lines of code 
* above. NOTE leave the bushes on the four cmment lines.
* Please read the notes with the function _keytest.  This function will
* not keyboard every key.
*

     



***---FUNCTION dblclick

* This function waits for a keypress or mouse click.  If the event is
* a single mouse click it idles waiting for another event.  If the event
* is some other keypress it returns .F. (indicating that the event was 
* not a DOUBLECLICK and loads the variable nKeyPress with the value of
* the event key.
* nKeyPress must be initialized prior and passed to this function by
* reference.

FUNCTION dblclick
PARA nKeyPress
PRIVATE sy_talk, sy_esc
*
* Save environment and set some thing the way we want it
*
sy_talk = SET("TALK")
SET TALK OFF
sy_esc = SET("ESCAPE")
SET ESCAPE OFF

*
* Main program loop
* It will sit in this loop until a DOUBLECLICK or other key event
*

DO WHILE .T.

     *
     * Test shut off the cursor, test INKEY() for a key event or mouse click.
     * By default, INKEY() ignores the mouse therefore we have to put the
     * character M to watch the rodent too.
      
     nInval1 = INKEY(.06,'HM') 
     
     *
     * If no events, sit in the loop
     *
     
     IF nInval1 = 0            
          LOOP
     ENDIF
     
     *
     * As soon as there is an event, test and see if it was a mouse click.
     *    If it was go into another loop to test for the second click.
     *
     
     IF nInval1 = 151          
     
          *
          * See if the second click came within the parameters of what the
system
          * is set for a DOUBLECLICK event.
          * See _DBLCLICK in Foxhelp.
           
          nTimeLimit = SECONDS() + _DBLCLICK 
          nInval2 = 0
          DO WHILE SECONDS() < nTimeLimit
               nInval2 = INKEY('HM')
               
               *
               * If there was a second click within the acceptable time frame
return
               * .T. after restoring the environment to what it was when we
started.
               *
               
               IF nInval2 = 151 
                    SET TALK &sy_talk
                    SET ESCAPE &sy_esc
                    RETURN .T.
               ENDIF
          ENDDO
     ELSE
     
     * If the event wasn't a mouse click load the value of whatever key was
     * pressed into nKeyPress and return .F. (no DOUBLECLICK) after restoring
     * the environment to what it was when we started.
     *
     
          nKeyPress = nInval1
          SET TALK &sy_talk        
          SET ESCAPE &sy_esc       
          RETURN .F.
     ENDIF
ENDDO     

*- EOF dblclik






***--- FUNCTION     _KeyTest

* This routine will KEYBOARD the key that is passed to it as a number.
* Be aware that not all keys have unique values therefore this will not
* work with some keys.
*
* A good example is HOME, SHIFT+HOME, and ALT+ENTER all return the same
* value through INKEY().
*


FUNCTION _Keytest
PARA nKeyPress
DO CASE
   CASE nKeyPress > 0 .AND. nKeyPress <= 127
     KEYBOARD CHR(nKeyPress)
   CASE nkeyPress = 28
     KEYBOARD "{F1}"
   CASE nkeyPress = -1
     KEYBOARD "{F2}"
   CASE nkeyPress = -2
     KEYBOARD "{F3}"
   CASE nkeyPress = -3
     KEYBOARD "{F4}"
   CASE nkeyPress = -4
     KEYBOARD "{F5}"
   CASE nkeyPress = -5
     KEYBOARD "{F6}"
   CASE nkeyPress = -6
     KEYBOARD "{F7}"
   CASE nkeyPress = -7
     KEYBOARD "{F8}"
   CASE nkeyPress = -8
     KEYBOARD "{F9}"
   CASE nkeyPress = -9
     KEYBOARD "{F10}"
   CASE nkeyPress = 133
     KEYBOARD "{F11}"
   CASE nkeyPress = 135
     KEYBOARD "{SHIFT+F11}"
   CASE nkeyPress = 137
     KEYBOARD "{CTRL+F11}"
   CASE nkeyPress = 139
     KEYBOARD "{ALT+F11}"
   CASE nkeyPress = 134
     KEYBOARD "{F12}"
   CASE nkeyPress = 136
     KEYBOARD "{SHIFT+F12}"
   CASE nkeyPress = 138
     KEYBOARD "{CTRL+F12}"
   CASE nkeyPress = 140
     KEYBOARD "{ALT+F12}"
   CASE nkeyPress = 141
     KEYBOARD "{CTRL+UPARROW}"
   CASE nkeyPress = 145
     KEYBOARD "{CTRL+DOWNARROW}"
   CASE nkeyPress = 146
     KEYBOARD "{CTRL+INS}"
   CASE nkeyPress = 147
     KEYBOARD "{CTRL+DEL}"
   CASE nkeyPress = 148
     KEYBOARD "{CTRL+TAB}"
   CASE nkeyPress = 151
     KEYBOARD "{ALT+HOME}"
   CASE nkeyPress = 152
     KEYBOARD "{ALT+UPARROW}"   
   CASE nkeyPress = 153
     KEYBOARD "{ALT+PGUP}"
   CASE nkeyPress = 155
     KEYBOARD "{ALT+LEFTARROW}"     
   CASE nkeyPress = 157
     KEYBOARD "{ALT+RIGHTARROW}"
   CASE nkeyPress = 159
     KEYBOARD "{ALT+END}"
   CASE nkeyPress = 160
     KEYBOARD "{ALT+DOWNARROW}"
   CASE nkeyPress = 161
     KEYBOARD "{ALT+PGDN}"
   CASE nkeyPress = 162
     KEYBOARD "{ALT+INS}"
   CASE nkeyPress = 163
     KEYBOARD "{ALT+DEL}"                       
   CASE nkeyPress = 165
     KEYBOARD "{ALT+TAB}"
ENDCASE

SET TALK &sy_talk   

*- EOF _keytest



