PAGE 60,132
TITLE Functions to save/rest/clear Debug watch and breakpoints

; DBG_FUNC.ASM
;
; Written by: Don Caton
;             DC MicroSystems
;             3017 N. Oakland Forest Dr. #304
;             Ft. Lauderdale, FL 33309
;             (305) 485-0221
;
;             CIS 71067,1350
;
;             01/05/90

PUBLIC          debug_save
PUBLIC          debug_rest
PUBLIC          debug_clr

EXTRN           __retc:FAR
EXTRN           __debug_active:FAR
EXTRN           __debug:FAR

DGROUP          GROUP    _DATA, CONST

_DATA           SEGMENT  PUBLIC 'DATA'
debug_code      DD      __debug                         ;entry point to debug
break_data      DD      __debug_active - 0ca2h          ;breakpoints data area
watch_data      DD      __debug_active - 89eh           ;watch expr. data area
_DATA           ENDS

CONST           SEGMENT PUBLIC 'CONST'
file_name       DB      "debug.sav",0
not_linked      DB      "Debugger not linked",0
bad_open        DB      "Error opening file debug.sav",0
bad_write       DB      "Error writing to file debug.sav",0
bad_read        DB      "Error reading from file debug.sav",0
good_save       DB      "Debug settings saved",0
good_restore    DB      "Debug settings restored",0
cleared_mesg    DB      "Debug settings cleared",0
CONST           ENDS

_PROG           SEGMENT 'CODE'
                ASSUME cs:_PROG, ds:DGROUP
debug_save      PROC    FAR
                push    bp
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di
                les     di,debug_code
                cmp     byte ptr es:[di],55h    ;1st byte of "real" debug code is 55h
                je      debug_present
                lea     dx,not_linked
                jmp     SHORT alldone
debug_present:  lea     dx,file_name
                mov     cx,0
                mov     ah,3ch          ;create file
                int     21h
                jnc     goodopen        ;bad open if cy=1
                lea     dx,bad_open
                JMP     SHORT alldone
goodopen:       mov     bx,ax           ;put handle in bx
                lds     dx,break_data   ;breakpoints data area
                mov     cx,996          ;996 bytes long
                mov     ah,40h          ;write to file
                int     21h
                cmp     cx,ax
                jne     badwrite
                lds     dx,watch_data   ;watch expressions data area
                mov     cx,546          ;546 bytes long
                mov     ah,40h
                int     21h
                cmp     cx,ax
                jne     badwrite
                mov     ah,3eh          ;close file
                int     21h
                lea     dx,good_save
                jmp     SHORT alldone
badwrite:       lea     dx,bad_write
alldone:        push    ds
                push    dx
                call    __retc
                add     sp,4
                pop     di
                pop     si
                pop     es
                pop     ds
                pop     bp
                RET
debug_save      ENDP

debug_rest      PROC    FAR
                push    bp
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di
                les     di,debug_code
                cmp     byte ptr es:[di],55h    ;1st byte of "real" debug code is 55h
                je      debug_present1
                lea     dx,not_linked
                jmp     SHORT alldone1
debug_present1: lea     dx,file_name
                mov     ax,3d00h        ;open file
                int     21h
                jnc     goodopen1       ;bad open if cy=1
                lea     dx,bad_open
                JMP     SHORT alldone1
goodopen1:      mov     bx,ax           ;put handle in bx
                lds     dx,break_data   ;breakpoints data area
                mov     cx,996          ;996 bytes long
                mov     ah,3fh          ;read file
                int     21h
                cmp     cx,ax
                jne     badread
                lds     dx,watch_data   ;watch expressions data area
                mov     cx,546          ;546 bytes long
                mov     ah,3fh          ;read file
                int     21h
                cmp     cx,ax
                jne     badwrite
                mov     ah,3eh          ;close file
                int     21h
                lea     dx,good_restore
                jmp     SHORT alldone1
badread:        lea     dx,bad_read
alldone1:       push    ds
                push    dx
                call    __retc
                add     sp,4
                pop     di
                pop     si
                pop     es
                pop     ds
                pop     bp
                RET
debug_rest      ENDP

debug_clr       PROC    FAR
                push    bp
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di
                les     di,debug_code
                cmp     byte ptr es:[di],55h    ;1st byte of "real" debug code is 55h
                je      debug_present2
                lea     dx,not_linked
                jmp     SHORT alldone2
debug_present2: les     di,break_data           ;breakpoints data area
                xor     ax,ax                   ;null character
                mov     cx,498                  ;498 words long
                rep     stosw                   ;fill with nulls
                les     di,watch_data           ;watch expressions data area
                mov     cx,273                  ;273 words long
                rep     stosw                   ;fill with nulls
                lea     dx,cleared_mesg
alldone2:       push    ds
                push    dx
                call    __retc
                add     sp,4
                pop     di
                pop     si
                pop     es
                pop     ds
                pop     bp
                RET
debug_clr       ENDP

_PROG           ENDS
                END

